module.exports = {

"[project]/node_modules/@cloudinary-util/util/dist/index.js [app-ssr] (ecmascript)": (({ r: __turbopack_require__, f: __turbopack_module_context__, i: __turbopack_import__, s: __turbopack_esm__, v: __turbopack_export_value__, n: __turbopack_export_namespace__, c: __turbopack_cache__, M: __turbopack_modules__, l: __turbopack_load__, j: __turbopack_dynamic__, P: __turbopack_resolve_absolute_path__, U: __turbopack_relative_url__, R: __turbopack_resolve_module_id_path__, g: global, __dirname, x: __turbopack_external_require__, y: __turbopack_external_import__ }) => (() => {
"use strict";

// src/lib/cloudinary.ts
__turbopack_esm__({
    "convertColorHexToRgb": ()=>convertColorHexToRgb,
    "encodeBase64": ()=>encodeBase64,
    "getFormat": ()=>getFormat,
    "getPublicId": ()=>getPublicId,
    "getTransformations": ()=>getTransformations,
    "objectHasKey": ()=>objectHasKey,
    "parseUrl": ()=>parseUrl,
    "pollForProcessingImage": ()=>pollForProcessingImage,
    "sortByKey": ()=>sortByKey,
    "testColorIsHex": ()=>testColorIsHex
});
var REGEX_VERSION = /\/v\d+\//;
var REGEX_FORMAT = /\.(ai|avif|gif|png|webp|bmp|bw|djvu|dng|ps|ept|eps|eps3|fbx|flif|gif|glb|gltf|heif|heic|ico|indd|jpg|jpe|jpeg|jp2|wdp|jxr|hdp|obj|pdf|ply|png|psd|arw|cr2|svg|tga|tif|tiff|u3ma|usdz|webp|3g2|3gp|avi|flv|m3u8|ts|m2ts|mts|mov|mkv|mp4|mpeg|mpd|mxf|ogv|webm|wmv)$/i;
var REGEX_URL = /https?:\/\/(?<host>[^/]+)\/(?<cloudName>[^/]+)?\/?(?<assetType>image|images|video|videos|raw|files)\/(?<deliveryType>upload|fetch|private|authenticated|sprite|facebook|twitter|youtube|vimeo)?\/?(?<signature>s--([a-zA-Z0-9_-]{8}|[a-zA-Z0-9_-]{32})--)?\/?(?<transformations>(?:[^_/]+_[^,/]+,?\/?)*\/)*(?<version>v\d+|\w{1,2})\/(?<publicId>[^\s]+)$/;
var ASSET_TYPES_SEO = [
    "images",
    "videos",
    "files"
];
var CLOUDINARY_DEFAULT_HOST = "res.cloudinary.com";
function parseUrl(src) {
    if (typeof src !== "string") {
        throw new Error(`Failed to parse URL - Invalid src: Is not a string`);
    }
    const hasVersion = REGEX_VERSION.test(src);
    if (!hasVersion) {
        throw new Error(`Failed to parse URL - Invalid src: Does not include version (Ex: /v1234/)`);
    }
    const [baseUrlWithExtension, queryString] = src.split("?");
    const format = getFormat(baseUrlWithExtension);
    let baseUrl = baseUrlWithExtension;
    if (format) {
        baseUrl = baseUrlWithExtension.replace(new RegExp(`${format}$`), "");
    }
    const results = baseUrl.match(REGEX_URL);
    const transformations = results?.groups?.transformations?.split("/").filter((t)=>!!t);
    const parts = {
        ...results?.groups,
        format,
        seoSuffix: void 0,
        transformations: transformations || [],
        queryParams: {},
        version: results?.groups?.version ? parseInt(results.groups.version.replace("v", "")) : void 0
    };
    if (parts.host === CLOUDINARY_DEFAULT_HOST && !parts.cloudName) {
        throw new Error("Failed to parse URL - Invalid src: Cloudinary URL delivered from res.cloudinary.com must include Cloud Name (ex: res.cloudinary.com/<Cloud Name>/image/...)");
    }
    if (queryString) {
        parts.queryParams = queryString.split("&").reduce((prev, curr)=>{
            const [key, value] = curr.split("=");
            prev[key] = value;
            return prev;
        }, {});
    }
    if (parts.assetType && ASSET_TYPES_SEO.includes(parts.assetType)) {
        const publicIdParts = parts.publicId?.split("/") || [];
        parts.seoSuffix = publicIdParts.pop();
        parts.publicId = publicIdParts.join("/");
    }
    if (parts.publicId) {
        parts.publicId = decodeURIComponent(parts.publicId);
    }
    return parts;
}
function getPublicId(src) {
    const { publicId } = parseUrl(src) || {};
    return publicId;
}
function getTransformations(src) {
    const { transformations = [] } = parseUrl(src) || {};
    return transformations.map((t)=>t.split(","));
}
function getFormat(src) {
    const matches = src.match(REGEX_FORMAT);
    if (matches === null) return;
    return matches[0];
}
async function pollForProcessingImage(options) {
    try {
        const response = await fetch(options.src);
        if (response.status === 423) {
            await new Promise((resolve)=>setTimeout(resolve, 500));
            return await pollForProcessingImage(options);
        }
        if (!response.ok) {
            return {
                success: false,
                status: response.status,
                error: response.headers.get("x-cld-error") || "Unknown error"
            };
        }
        return {
            success: true,
            status: response.status
        };
    } catch (error) {
        return {
            success: false,
            status: 500,
            error: error.message || "Network error"
        };
    }
}
// src/lib/colors.ts
function testColorIsHex(value) {
    if (typeof value !== "string") return false;
    return !!value.startsWith("#");
}
function convertColorHexToRgb(value) {
    return `rgb:${value.replace("#", "")}`;
}
// src/lib/util.ts
function encodeBase64(value) {
    if (typeof btoa === "function") {
        return btoa(value);
    }
    if (typeof Buffer !== "undefined") {
        return Buffer.from(value).toString("base64");
    }
}
function objectHasKey(obj, key) {
    return Object.prototype.hasOwnProperty.call(obj, key);
}
function sortByKey(array = [], key, type = "asc") {
    function compare(a, b) {
        let keyA = a[key];
        let keyB = b[key];
        if (typeof keyA === "string") {
            keyA = keyA.toLowerCase();
        }
        if (typeof keyB === "string") {
            keyB = keyB.toLowerCase();
        }
        if (keyA < keyB) return -1;
        if (keyA > keyB) return 1;
        return 0;
    }
    let newArray = [
        ...array
    ];
    if (typeof key !== "string") return newArray;
    newArray = newArray.sort(compare);
    if (type === "desc") {
        return newArray.reverse();
    }
    return newArray;
}
;

})()),
"[project]/node_modules/@cloudinary-util/url-loader/node_modules/@cloudinary-util/util/dist/index.js [app-ssr] (ecmascript)": (({ r: __turbopack_require__, f: __turbopack_module_context__, i: __turbopack_import__, s: __turbopack_esm__, v: __turbopack_export_value__, n: __turbopack_export_namespace__, c: __turbopack_cache__, M: __turbopack_modules__, l: __turbopack_load__, j: __turbopack_dynamic__, P: __turbopack_resolve_absolute_path__, U: __turbopack_relative_url__, R: __turbopack_resolve_module_id_path__, g: global, __dirname, x: __turbopack_external_require__, y: __turbopack_external_import__ }) => (() => {
"use strict";

// src/lib/cloudinary.ts
__turbopack_esm__({
    "convertColorHexToRgb": ()=>convertColorHexToRgb,
    "encodeBase64": ()=>encodeBase64,
    "getFormat": ()=>getFormat,
    "getPublicId": ()=>getPublicId,
    "getTransformations": ()=>getTransformations,
    "objectHasKey": ()=>objectHasKey,
    "parseUrl": ()=>parseUrl,
    "pollForProcessingImage": ()=>pollForProcessingImage,
    "sortByKey": ()=>sortByKey,
    "testColorIsHex": ()=>testColorIsHex
});
var REGEX_VERSION = /\/v\d+\//;
var REGEX_FORMAT = /\.(ai|avif|gif|png|webp|bmp|bw|djvu|dng|ps|ept|eps|eps3|fbx|flif|gif|glb|gltf|heif|heic|ico|indd|jpg|jpe|jpeg|jp2|wdp|jxr|hdp|obj|pdf|ply|png|psd|arw|cr2|svg|tga|tif|tiff|u3ma|usdz|webp|3g2|3gp|avi|flv|m3u8|ts|m2ts|mts|mov|mkv|mp4|mpeg|mpd|mxf|ogv|webm|wmv)$/i;
var REGEX_URL = /https?:\/\/(?<host>[^/]+)\/(?<cloudName>[^/]+)?\/?(?<assetType>image|images|video|videos|raw|files)\/(?<deliveryType>upload|fetch|private|authenticated|sprite|facebook|twitter|youtube|vimeo)?\/?(?<signature>s--([a-zA-Z0-9_-]{8}|[a-zA-Z0-9_-]{32})--)?\/?(?<transformations>(?:[^_/]+_[^,/]+,?\/?)*\/)*(?<version>v\d+|\w{1,2})\/(?<publicId>[^\s]+)$/;
var ASSET_TYPES_SEO = [
    "images",
    "videos",
    "files"
];
var CLOUDINARY_DEFAULT_HOST = "res.cloudinary.com";
function parseUrl(src) {
    if (typeof src !== "string") {
        throw new Error(`Failed to parse URL - Invalid src: Is not a string`);
    }
    const hasVersion = REGEX_VERSION.test(src);
    if (!hasVersion) {
        throw new Error(`Failed to parse URL - Invalid src: Does not include version (Ex: /v1234/)`);
    }
    const [baseUrlWithExtension, queryString] = src.split("?");
    const format = getFormat(baseUrlWithExtension);
    let baseUrl = baseUrlWithExtension;
    if (format) {
        baseUrl = baseUrlWithExtension.replace(new RegExp(`${format}$`), "");
    }
    const results = baseUrl.match(REGEX_URL);
    const transformations = results?.groups?.transformations?.split("/").filter((t)=>!!t);
    const parts = {
        ...results?.groups,
        format,
        seoSuffix: void 0,
        transformations: transformations || [],
        queryParams: {},
        version: results?.groups?.version ? parseInt(results.groups.version.replace("v", "")) : void 0
    };
    if (parts.host === CLOUDINARY_DEFAULT_HOST && !parts.cloudName) {
        throw new Error("Failed to parse URL - Invalid src: Cloudinary URL delivered from res.cloudinary.com must include Cloud Name (ex: res.cloudinary.com/<Cloud Name>/image/...)");
    }
    if (queryString) {
        parts.queryParams = queryString.split("&").reduce((prev, curr)=>{
            const [key, value] = curr.split("=");
            prev[key] = value;
            return prev;
        }, {});
    }
    if (parts.assetType && ASSET_TYPES_SEO.includes(parts.assetType)) {
        const publicIdParts = parts.publicId?.split("/") || [];
        parts.seoSuffix = publicIdParts.pop();
        parts.publicId = publicIdParts.join("/");
    }
    if (parts.publicId) {
        parts.publicId = decodeURIComponent(parts.publicId);
    }
    return parts;
}
function getPublicId(src) {
    const { publicId } = parseUrl(src) || {};
    return publicId;
}
function getTransformations(src) {
    const { transformations = [] } = parseUrl(src) || {};
    return transformations.map((t)=>t.split(","));
}
function getFormat(src) {
    const matches = src.match(REGEX_FORMAT);
    if (matches === null) return;
    return matches[0];
}
async function pollForProcessingImage(options) {
    try {
        const response = await fetch(options.src);
        if (response.status === 423) {
            await new Promise((resolve)=>setTimeout(resolve, 500));
            return await pollForProcessingImage(options);
        }
        return response.ok;
    } catch  {
        return false;
    }
}
// src/lib/colors.ts
function testColorIsHex(value) {
    if (typeof value !== "string") return false;
    return !!value.startsWith("#");
}
function convertColorHexToRgb(value) {
    return `rgb:${value.replace("#", "")}`;
}
// src/lib/util.ts
function encodeBase64(value) {
    if (typeof btoa === "function") {
        return btoa(value);
    }
    if (typeof Buffer !== "undefined") {
        return Buffer.from(value).toString("base64");
    }
}
function objectHasKey(obj, key) {
    return Object.prototype.hasOwnProperty.call(obj, key);
}
function sortByKey(array = [], key, type = "asc") {
    function compare(a, b) {
        let keyA = a[key];
        let keyB = b[key];
        if (typeof keyA === "string") {
            keyA = keyA.toLowerCase();
        }
        if (typeof keyB === "string") {
            keyB = keyB.toLowerCase();
        }
        if (keyA < keyB) {
            return -1;
        }
        if (keyA > keyB) {
            return 1;
        }
        return 0;
    }
    let newArray = [
        ...array
    ];
    if (typeof key !== "string") return newArray;
    newArray = newArray.sort(compare);
    if (type === "desc") {
        return newArray.reverse();
    }
    return newArray;
}
;

})()),
"[project]/node_modules/@cloudinary/transformation-builder-sdk/internal/qualifier/QualifierValue.js [app-ssr] (ecmascript)": (({ r: __turbopack_require__, f: __turbopack_module_context__, i: __turbopack_import__, s: __turbopack_esm__, v: __turbopack_export_value__, n: __turbopack_export_namespace__, c: __turbopack_cache__, M: __turbopack_modules__, l: __turbopack_load__, j: __turbopack_dynamic__, P: __turbopack_resolve_absolute_path__, U: __turbopack_relative_url__, R: __turbopack_resolve_module_id_path__, g: global, __dirname, x: __turbopack_external_require__, y: __turbopack_external_import__ }) => (() => {
"use strict";

/**
 * @summary SDK
 * @memberOf SDK
 */ __turbopack_esm__({
    "QualifierValue": ()=>QualifierValue
});
class QualifierValue {
    /**
     *
     * @param {QualifierValue | QualifierValue[] | any[] | string | number}qualifierValue
     */ constructor(qualifierValue){
        this.values = [];
        this.delimiter = ':'; // {value}{delimiter}{value}...
        if (this.hasValue(qualifierValue)) {
            this.addValue(qualifierValue);
        }
    }
    /**
     * @description Joins the provided values with the provided delimiter
     */ toString() {
        return this.values.join(this.delimiter);
    }
    /**
     * @description Checks if the provided argument has a value
     * @param {any} v
     * @private
     * @return {boolean}
     */ hasValue(v) {
        return typeof v !== 'undefined' && v !== null && v !== '';
    }
    /**
     * @desc Adds a value for the this qualifier instance
     * @param {any} value
     * @return {this}
     */ addValue(value) {
        // Append value or array of values
        if (Array.isArray(value)) {
            this.values = this.values.concat(value);
        } else {
            this.values.push(value);
        }
        // Remove falsy values
        this.values = this.values.filter((v)=>this.hasValue(v));
        return this;
    }
    /**
     * @description Sets the delimiter for this instance
     * @param delimiter
     */ setDelimiter(delimiter) {
        this.delimiter = delimiter;
        return this;
    }
}
;

})()),
"[project]/node_modules/@cloudinary/transformation-builder-sdk/internal/utils/unsupportedError.js [app-ssr] (ecmascript)": (({ r: __turbopack_require__, f: __turbopack_module_context__, i: __turbopack_import__, s: __turbopack_esm__, v: __turbopack_export_value__, n: __turbopack_export_namespace__, c: __turbopack_cache__, M: __turbopack_modules__, l: __turbopack_load__, j: __turbopack_dynamic__, P: __turbopack_resolve_absolute_path__, U: __turbopack_relative_url__, R: __turbopack_resolve_module_id_path__, g: global, __dirname, x: __turbopack_external_require__, y: __turbopack_external_import__ }) => (() => {
"use strict";

__turbopack_esm__({
    "UnsupportedError": ()=>UnsupportedError,
    "createUnsupportedError": ()=>createUnsupportedError
});
class UnsupportedError extends Error {
    constructor(message = 'Unsupported'){
        super(message);
    }
}
/**
 * Creates a new UnsupportedError
 * @param message
 */ function createUnsupportedError(message) {
    return new UnsupportedError(message);
}
;

})()),
"[project]/node_modules/@cloudinary/transformation-builder-sdk/internal/models/qualifierToJson.js [app-ssr] (ecmascript)": (({ r: __turbopack_require__, f: __turbopack_module_context__, i: __turbopack_import__, s: __turbopack_esm__, v: __turbopack_export_value__, n: __turbopack_export_namespace__, c: __turbopack_cache__, M: __turbopack_modules__, l: __turbopack_load__, j: __turbopack_dynamic__, P: __turbopack_resolve_absolute_path__, U: __turbopack_relative_url__, R: __turbopack_resolve_module_id_path__, g: global, __dirname, x: __turbopack_external_require__, y: __turbopack_external_import__ }) => (() => {
"use strict";

__turbopack_esm__({
    "qualifierToJson": ()=>qualifierToJson
});
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f40$cloudinary$2f$transformation$2d$builder$2d$sdk$2f$internal$2f$utils$2f$unsupportedError$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_import__("[project]/node_modules/@cloudinary/transformation-builder-sdk/internal/utils/unsupportedError.js [app-ssr] (ecmascript)");
"__TURBOPACK__ecmascript__hoisting__location__";
;
function qualifierToJson() {
    return this._qualifierModel || {
        error: (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f40$cloudinary$2f$transformation$2d$builder$2d$sdk$2f$internal$2f$utils$2f$unsupportedError$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["createUnsupportedError"])(`unsupported qualifier ${this.constructor.name}`)
    };
}

})()),
"[project]/node_modules/@cloudinary/transformation-builder-sdk/internal/models/QualifierModel.js [app-ssr] (ecmascript)": (({ r: __turbopack_require__, f: __turbopack_module_context__, i: __turbopack_import__, s: __turbopack_esm__, v: __turbopack_export_value__, n: __turbopack_export_namespace__, c: __turbopack_cache__, M: __turbopack_modules__, l: __turbopack_load__, j: __turbopack_dynamic__, P: __turbopack_resolve_absolute_path__, U: __turbopack_relative_url__, R: __turbopack_resolve_module_id_path__, g: global, __dirname, x: __turbopack_external_require__, y: __turbopack_external_import__ }) => (() => {
"use strict";

__turbopack_esm__({
    "QualifierModel": ()=>QualifierModel
});
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f40$cloudinary$2f$transformation$2d$builder$2d$sdk$2f$internal$2f$models$2f$qualifierToJson$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_import__("[project]/node_modules/@cloudinary/transformation-builder-sdk/internal/models/qualifierToJson.js [app-ssr] (ecmascript)");
"__TURBOPACK__ecmascript__hoisting__location__";
;
class QualifierModel {
    constructor(){
        this._qualifierModel = {};
    }
    toJson() {
        return __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f40$cloudinary$2f$transformation$2d$builder$2d$sdk$2f$internal$2f$models$2f$qualifierToJson$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["qualifierToJson"].apply(this);
    }
}

})()),
"[project]/node_modules/@cloudinary/transformation-builder-sdk/internal/qualifier/Qualifier.js [app-ssr] (ecmascript)": (({ r: __turbopack_require__, f: __turbopack_module_context__, i: __turbopack_import__, s: __turbopack_esm__, v: __turbopack_export_value__, n: __turbopack_export_namespace__, c: __turbopack_cache__, M: __turbopack_modules__, l: __turbopack_load__, j: __turbopack_dynamic__, P: __turbopack_resolve_absolute_path__, U: __turbopack_relative_url__, R: __turbopack_resolve_module_id_path__, g: global, __dirname, x: __turbopack_external_require__, y: __turbopack_external_import__ }) => (() => {
"use strict";

__turbopack_esm__({
    "Qualifier": ()=>Qualifier
});
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f40$cloudinary$2f$transformation$2d$builder$2d$sdk$2f$internal$2f$qualifier$2f$QualifierValue$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_import__("[project]/node_modules/@cloudinary/transformation-builder-sdk/internal/qualifier/QualifierValue.js [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f40$cloudinary$2f$transformation$2d$builder$2d$sdk$2f$internal$2f$models$2f$QualifierModel$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_import__("[project]/node_modules/@cloudinary/transformation-builder-sdk/internal/models/QualifierModel.js [app-ssr] (ecmascript)");
"__TURBOPACK__ecmascript__hoisting__location__";
;
;
/**
 * @summary SDK
 * @memberOf SDK
 */ class Qualifier extends __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f40$cloudinary$2f$transformation$2d$builder$2d$sdk$2f$internal$2f$models$2f$QualifierModel$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["QualifierModel"] {
    constructor(key, qualifierValue){
        super();
        this.delimiter = '_'; // {key}{delimiter}{qualifierValue}
        this.key = key;
        if (qualifierValue instanceof __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f40$cloudinary$2f$transformation$2d$builder$2d$sdk$2f$internal$2f$qualifier$2f$QualifierValue$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["QualifierValue"]) {
            this.qualifierValue = qualifierValue;
        } else {
            this.qualifierValue = new __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f40$cloudinary$2f$transformation$2d$builder$2d$sdk$2f$internal$2f$qualifier$2f$QualifierValue$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["QualifierValue"]();
            this.qualifierValue.addValue(qualifierValue);
        }
    }
    toString() {
        const { key, delimiter, qualifierValue } = this;
        return `${key}${delimiter}${qualifierValue.toString()}`;
    }
    addValue(value) {
        this.qualifierValue.addValue(value);
        return this;
    }
}
;

})()),
"[project]/node_modules/@cloudinary/transformation-builder-sdk/qualifiers/flag/FlagQualifier.js [app-ssr] (ecmascript)": (({ r: __turbopack_require__, f: __turbopack_module_context__, i: __turbopack_import__, s: __turbopack_esm__, v: __turbopack_export_value__, n: __turbopack_export_namespace__, c: __turbopack_cache__, M: __turbopack_modules__, l: __turbopack_load__, j: __turbopack_dynamic__, P: __turbopack_resolve_absolute_path__, U: __turbopack_relative_url__, R: __turbopack_resolve_module_id_path__, g: global, __dirname, x: __turbopack_external_require__, y: __turbopack_external_import__ }) => (() => {
"use strict";

__turbopack_esm__({
    "FlagQualifier": ()=>FlagQualifier
});
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f40$cloudinary$2f$transformation$2d$builder$2d$sdk$2f$internal$2f$qualifier$2f$QualifierValue$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_import__("[project]/node_modules/@cloudinary/transformation-builder-sdk/internal/qualifier/QualifierValue.js [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f40$cloudinary$2f$transformation$2d$builder$2d$sdk$2f$internal$2f$qualifier$2f$Qualifier$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_import__("[project]/node_modules/@cloudinary/transformation-builder-sdk/internal/qualifier/Qualifier.js [app-ssr] (ecmascript)");
"__TURBOPACK__ecmascript__hoisting__location__";
;
;
/**
 * @memberOf Qualifiers.Flag
 * @extends {SDK.Qualifier}
 * @description the FlagQualifier class
 */ class FlagQualifier extends __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f40$cloudinary$2f$transformation$2d$builder$2d$sdk$2f$internal$2f$qualifier$2f$Qualifier$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["Qualifier"] {
    constructor(flagType, flagValue){
        let qualifierValue;
        if (flagValue) {
            qualifierValue = new __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f40$cloudinary$2f$transformation$2d$builder$2d$sdk$2f$internal$2f$qualifier$2f$QualifierValue$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["QualifierValue"]([
                flagType,
                `${flagValue}`
            ]).setDelimiter(':');
        } else {
            qualifierValue = flagType;
        }
        super('fl', qualifierValue);
        this.flagValue = flagValue;
    }
    toString() {
        return super.toString().replace(/\./g, '%2E');
    }
    getFlagValue() {
        return this.flagValue;
    }
}
;

})()),
"[project]/node_modules/@cloudinary/transformation-builder-sdk/internal/utils/dataStructureUtils.js [app-ssr] (ecmascript)": (({ r: __turbopack_require__, f: __turbopack_module_context__, i: __turbopack_import__, s: __turbopack_esm__, v: __turbopack_export_value__, n: __turbopack_export_namespace__, c: __turbopack_cache__, M: __turbopack_modules__, l: __turbopack_load__, j: __turbopack_dynamic__, P: __turbopack_resolve_absolute_path__, U: __turbopack_relative_url__, R: __turbopack_resolve_module_id_path__, g: global, __dirname, x: __turbopack_external_require__, y: __turbopack_external_import__ }) => (() => {
"use strict";

/**
 * Sort a map by key
 * @private
 * @param map <string, any>
 * @Return array of map's values sorted by key
 */ __turbopack_esm__({
    "isString": ()=>isString,
    "mapToSortedArray": ()=>mapToSortedArray
});
function mapToSortedArray(map, flags) {
    const array = Array.from(map.entries());
    // objects from the Array.from() method above are stored in array of arrays:
    // [[qualifierKey, QualifierObj], [qualifierKey, QualifierObj]]
    // Flags is an array of FlagQualifierObj
    // We need to convert it to the same form: [flagQualifier] =>  ['fl', flagQualifier]
    flags.forEach((flag)=>{
        array.push([
            'fl',
            flag
        ]); // push ['fl', flagQualifier]
    });
    return array.sort().map((v)=>v[1]);
}
/**
 * Checks if `value` is a string.
 * @private
 * @param {*} value The value to check.
 * @return {boolean} `true` if `value` is a string, else `false`.
 */ function isString(value) {
    return typeof value === 'string' || value instanceof String;
}
;

})()),
"[project]/node_modules/@cloudinary/transformation-builder-sdk/internal/models/actionToJson.js [app-ssr] (ecmascript)": (({ r: __turbopack_require__, f: __turbopack_module_context__, i: __turbopack_import__, s: __turbopack_esm__, v: __turbopack_export_value__, n: __turbopack_export_namespace__, c: __turbopack_cache__, M: __turbopack_modules__, l: __turbopack_load__, j: __turbopack_dynamic__, P: __turbopack_resolve_absolute_path__, U: __turbopack_relative_url__, R: __turbopack_resolve_module_id_path__, g: global, __dirname, x: __turbopack_external_require__, y: __turbopack_external_import__ }) => (() => {
"use strict";

__turbopack_esm__({
    "actionToJson": ()=>actionToJson
});
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f40$cloudinary$2f$transformation$2d$builder$2d$sdk$2f$internal$2f$utils$2f$unsupportedError$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_import__("[project]/node_modules/@cloudinary/transformation-builder-sdk/internal/utils/unsupportedError.js [app-ssr] (ecmascript)");
"__TURBOPACK__ecmascript__hoisting__location__";
;
function actionToJson() {
    var _a, _b, _c;
    const actionModelIsNotEmpty = this._actionModel && Object.keys(this._actionModel).length;
    const sourceTransformationError = (_c = (_b = (_a = this._actionModel) === null || _a === void 0 ? void 0 : _a.source) === null || _b === void 0 ? void 0 : _b.transformation) === null || _c === void 0 ? void 0 : _c.error;
    // Should return error when there is unsupported transformation inside
    if (sourceTransformationError && sourceTransformationError instanceof Error) {
        return {
            error: sourceTransformationError
        };
    }
    if (actionModelIsNotEmpty) {
        return this._actionModel;
    }
    return {
        error: (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f40$cloudinary$2f$transformation$2d$builder$2d$sdk$2f$internal$2f$utils$2f$unsupportedError$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["createUnsupportedError"])(`unsupported action ${this.constructor.name}`)
    };
}

})()),
"[project]/node_modules/@cloudinary/transformation-builder-sdk/internal/models/ActionModel.js [app-ssr] (ecmascript)": (({ r: __turbopack_require__, f: __turbopack_module_context__, i: __turbopack_import__, s: __turbopack_esm__, v: __turbopack_export_value__, n: __turbopack_export_namespace__, c: __turbopack_cache__, M: __turbopack_modules__, l: __turbopack_load__, j: __turbopack_dynamic__, P: __turbopack_resolve_absolute_path__, U: __turbopack_relative_url__, R: __turbopack_resolve_module_id_path__, g: global, __dirname, x: __turbopack_external_require__, y: __turbopack_external_import__ }) => (() => {
"use strict";

__turbopack_esm__({
    "ActionModel": ()=>ActionModel
});
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f40$cloudinary$2f$transformation$2d$builder$2d$sdk$2f$internal$2f$models$2f$actionToJson$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_import__("[project]/node_modules/@cloudinary/transformation-builder-sdk/internal/models/actionToJson.js [app-ssr] (ecmascript)");
"__TURBOPACK__ecmascript__hoisting__location__";
;
class ActionModel {
    constructor(){
        this._actionModel = {};
    }
    toJson() {
        return __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f40$cloudinary$2f$transformation$2d$builder$2d$sdk$2f$internal$2f$models$2f$actionToJson$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["actionToJson"].apply(this);
    }
}

})()),
"[project]/node_modules/@cloudinary/transformation-builder-sdk/internal/Action.js [app-ssr] (ecmascript)": (({ r: __turbopack_require__, f: __turbopack_module_context__, i: __turbopack_import__, s: __turbopack_esm__, v: __turbopack_export_value__, n: __turbopack_export_namespace__, c: __turbopack_cache__, M: __turbopack_modules__, l: __turbopack_load__, j: __turbopack_dynamic__, P: __turbopack_resolve_absolute_path__, U: __turbopack_relative_url__, R: __turbopack_resolve_module_id_path__, g: global, __dirname, x: __turbopack_external_require__, y: __turbopack_external_import__ }) => (() => {
"use strict";

__turbopack_esm__({
    "Action": ()=>Action
});
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f40$cloudinary$2f$transformation$2d$builder$2d$sdk$2f$qualifiers$2f$flag$2f$FlagQualifier$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_import__("[project]/node_modules/@cloudinary/transformation-builder-sdk/qualifiers/flag/FlagQualifier.js [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f40$cloudinary$2f$transformation$2d$builder$2d$sdk$2f$internal$2f$qualifier$2f$Qualifier$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_import__("[project]/node_modules/@cloudinary/transformation-builder-sdk/internal/qualifier/Qualifier.js [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f40$cloudinary$2f$transformation$2d$builder$2d$sdk$2f$internal$2f$utils$2f$dataStructureUtils$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_import__("[project]/node_modules/@cloudinary/transformation-builder-sdk/internal/utils/dataStructureUtils.js [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f40$cloudinary$2f$transformation$2d$builder$2d$sdk$2f$internal$2f$models$2f$ActionModel$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_import__("[project]/node_modules/@cloudinary/transformation-builder-sdk/internal/models/ActionModel.js [app-ssr] (ecmascript)");
"__TURBOPACK__ecmascript__hoisting__location__";
;
;
;
;
/**
 * @summary SDK
 * @memberOf SDK
 * @description Defines the category of transformation to perform.
 */ class Action extends __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f40$cloudinary$2f$transformation$2d$builder$2d$sdk$2f$internal$2f$models$2f$ActionModel$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["ActionModel"] {
    constructor(){
        super(...arguments);
        // We're using map, to overwrite existing keys. for example:
        // addParam(w_100).addQualifier(w_200) should result in w_200. and not w_100,w_200
        this.qualifiers = new Map();
        // Unlike regular qualifiers, there can be multiple flags in each url component /fl_1,fl_2/
        // If the falgs are added to the qualifiers map, only a single flag could exist in a component (it's a map)
        // So flags are stored separately until the very end because of that reason
        this.flags = [];
        this.delimiter = ','; // {qualifier}{delimiter}{qualifier} for example: `${'w_100'}${','}${'c_fill'}`
        this.actionTag = ''; // A custom name tag to identify this action in the future
    }
    prepareQualifiers() {}
    /**
     * @description Returns the custom name tag that was given to this action
     * @return {string}
     */ getActionTag() {
        return this.actionTag;
    }
    /**
     * @description Sets the custom name tag for this action
     * @return {this}
     */ setActionTag(tag) {
        this.actionTag = tag;
        return this;
    }
    /**
     * @description Calls toString() on all child qualifiers (implicitly by using .join()).
     * @return {string}
     */ toString() {
        this.prepareQualifiers();
        return (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f40$cloudinary$2f$transformation$2d$builder$2d$sdk$2f$internal$2f$utils$2f$dataStructureUtils$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["mapToSortedArray"])(this.qualifiers, this.flags).join(this.delimiter);
    }
    /**
     * @description Adds the parameter to the action.
     * @param {SDK.Qualifier} qualifier
     * @return {this}
     */ addQualifier(qualifier) {
        // if string, find the key and value
        if (typeof qualifier === 'string') {
            const [key, value] = qualifier.toLowerCase().split('_');
            if (key === 'fl') {
                // if string qualifier is a flag, store it in the flags arrays
                this.flags.push(new __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f40$cloudinary$2f$transformation$2d$builder$2d$sdk$2f$qualifiers$2f$flag$2f$FlagQualifier$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["FlagQualifier"](value));
            } else {
                // if the string qualifier is not a flag, create a new qualifier from it
                this.qualifiers.set(key, new __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f40$cloudinary$2f$transformation$2d$builder$2d$sdk$2f$internal$2f$qualifier$2f$Qualifier$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["Qualifier"](key, value));
            }
        } else {
            // if a qualifier object, insert to the qualifiers map
            this.qualifiers.set(qualifier.key, qualifier);
        }
        return this;
    }
    /**
     * @description Adds a flag to the current action.
     * @param {Qualifiers.Flag} flag
     * @return {this}
     */ addFlag(flag) {
        if (typeof flag === 'string') {
            this.flags.push(new __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f40$cloudinary$2f$transformation$2d$builder$2d$sdk$2f$qualifiers$2f$flag$2f$FlagQualifier$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["FlagQualifier"](flag));
        } else {
            if (flag instanceof __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f40$cloudinary$2f$transformation$2d$builder$2d$sdk$2f$qualifiers$2f$flag$2f$FlagQualifier$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["FlagQualifier"]) {
                this.flags.push(flag);
            }
        }
        return this;
    }
    addValueToQualifier(qualifierKey, qualifierValue) {
        this.qualifiers.get(qualifierKey).addValue(qualifierValue);
        return this;
    }
}
;

})()),
"[project]/node_modules/@cloudinary/transformation-builder-sdk/internal/utils/prepareColor.js [app-ssr] (ecmascript)": (({ r: __turbopack_require__, f: __turbopack_module_context__, i: __turbopack_import__, s: __turbopack_esm__, v: __turbopack_export_value__, n: __turbopack_export_namespace__, c: __turbopack_cache__, M: __turbopack_modules__, l: __turbopack_load__, j: __turbopack_dynamic__, P: __turbopack_resolve_absolute_path__, U: __turbopack_relative_url__, R: __turbopack_resolve_module_id_path__, g: global, __dirname, x: __turbopack_external_require__, y: __turbopack_external_import__ }) => (() => {
"use strict";

/**
 * Returns RGB or Color
 * @private
 * @param color
 */ __turbopack_esm__({
    "prepareColor": ()=>prepareColor
});
function prepareColor(color) {
    if (color) {
        return color.match(/^#/) ? `rgb:${color.substr(1)}` : color;
    } else {
        return color;
    }
}

})()),
"[project]/node_modules/@cloudinary/transformation-builder-sdk/actions/background/actions/BackgroundColor.js [app-ssr] (ecmascript)": (({ r: __turbopack_require__, f: __turbopack_module_context__, i: __turbopack_import__, s: __turbopack_esm__, v: __turbopack_export_value__, n: __turbopack_export_namespace__, c: __turbopack_cache__, M: __turbopack_modules__, l: __turbopack_load__, j: __turbopack_dynamic__, P: __turbopack_resolve_absolute_path__, U: __turbopack_relative_url__, R: __turbopack_resolve_module_id_path__, g: global, __dirname, x: __turbopack_external_require__, y: __turbopack_external_import__ }) => (() => {
"use strict";

__turbopack_esm__({
    "BackgroundColor": ()=>BackgroundColor
});
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f40$cloudinary$2f$transformation$2d$builder$2d$sdk$2f$internal$2f$Action$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_import__("[project]/node_modules/@cloudinary/transformation-builder-sdk/internal/Action.js [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f40$cloudinary$2f$transformation$2d$builder$2d$sdk$2f$internal$2f$qualifier$2f$QualifierValue$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_import__("[project]/node_modules/@cloudinary/transformation-builder-sdk/internal/qualifier/QualifierValue.js [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f40$cloudinary$2f$transformation$2d$builder$2d$sdk$2f$internal$2f$qualifier$2f$Qualifier$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_import__("[project]/node_modules/@cloudinary/transformation-builder-sdk/internal/qualifier/Qualifier.js [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f40$cloudinary$2f$transformation$2d$builder$2d$sdk$2f$internal$2f$utils$2f$prepareColor$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_import__("[project]/node_modules/@cloudinary/transformation-builder-sdk/internal/utils/prepareColor.js [app-ssr] (ecmascript)");
"__TURBOPACK__ecmascript__hoisting__location__";
;
;
;
;
/**
 * @extends SDK.Action
 * @description A class for background transformations.
 */ class BackgroundColor extends __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f40$cloudinary$2f$transformation$2d$builder$2d$sdk$2f$internal$2f$Action$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["Action"] {
    constructor(color){
        super();
        this._actionModel = {};
        this.addQualifier(new __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f40$cloudinary$2f$transformation$2d$builder$2d$sdk$2f$internal$2f$qualifier$2f$Qualifier$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["Qualifier"]('b', new __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f40$cloudinary$2f$transformation$2d$builder$2d$sdk$2f$internal$2f$qualifier$2f$QualifierValue$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["QualifierValue"]((0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f40$cloudinary$2f$transformation$2d$builder$2d$sdk$2f$internal$2f$utils$2f$prepareColor$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["prepareColor"])(color)).setDelimiter('_')));
        this._actionModel.color = color;
        this._actionModel.actionType = 'backgroundColor';
    }
    static fromJson(actionModel) {
        const { color } = actionModel;
        // We are using this() to allow inheriting classes to use super.fromJson.apply(this, [actionModel])
        // This allows the inheriting classes to determine the class to be created
        const result = new this(color);
        return result;
    }
}
;

})()),
"[project]/node_modules/@cloudinary/transformation-builder-sdk/internal/RawAction.js [app-ssr] (ecmascript)": (({ r: __turbopack_require__, f: __turbopack_module_context__, i: __turbopack_import__, s: __turbopack_esm__, v: __turbopack_export_value__, n: __turbopack_export_namespace__, c: __turbopack_cache__, M: __turbopack_modules__, l: __turbopack_load__, j: __turbopack_dynamic__, P: __turbopack_resolve_absolute_path__, U: __turbopack_relative_url__, R: __turbopack_resolve_module_id_path__, g: global, __dirname, x: __turbopack_external_require__, y: __turbopack_external_import__ }) => (() => {
"use strict";

__turbopack_esm__({
    "RawAction": ()=>RawAction
});
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f40$cloudinary$2f$transformation$2d$builder$2d$sdk$2f$internal$2f$utils$2f$unsupportedError$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_import__("[project]/node_modules/@cloudinary/transformation-builder-sdk/internal/utils/unsupportedError.js [app-ssr] (ecmascript)");
"__TURBOPACK__ecmascript__hoisting__location__";
;
/**
 * @summary SDK
 * @memberOf SDK
 * @description Defines an action that's a string literal, no validations or manipulations are performed
 */ class RawAction {
    constructor(raw){
        this.raw = raw;
    }
    toString() {
        return this.raw;
    }
    toJson() {
        return {
            error: (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f40$cloudinary$2f$transformation$2d$builder$2d$sdk$2f$internal$2f$utils$2f$unsupportedError$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["createUnsupportedError"])(`unsupported action ${this.constructor.name}`)
        };
    }
}
;

})()),
"[project]/node_modules/@cloudinary/transformation-builder-sdk/internal/models/IErrorObject.js [app-ssr] (ecmascript)": (({ r: __turbopack_require__, f: __turbopack_module_context__, i: __turbopack_import__, s: __turbopack_esm__, v: __turbopack_export_value__, n: __turbopack_export_namespace__, c: __turbopack_cache__, M: __turbopack_modules__, l: __turbopack_load__, j: __turbopack_dynamic__, P: __turbopack_resolve_absolute_path__, U: __turbopack_relative_url__, R: __turbopack_resolve_module_id_path__, g: global, __dirname, x: __turbopack_external_require__, y: __turbopack_external_import__ }) => (() => {
"use strict";

/**
 * Validates obj is an instance of IErrorObject
 * @param obj
 */ __turbopack_esm__({
    "isErrorObject": ()=>isErrorObject
});
function isErrorObject(obj) {
    const errorObj = obj;
    return 'error' in errorObj && !!errorObj.error;
}
;

})()),
"[project]/node_modules/@cloudinary/transformation-builder-sdk/qualifiers/flag.js [app-ssr] (ecmascript)": (({ r: __turbopack_require__, f: __turbopack_module_context__, i: __turbopack_import__, s: __turbopack_esm__, v: __turbopack_export_value__, n: __turbopack_export_namespace__, c: __turbopack_cache__, M: __turbopack_modules__, l: __turbopack_load__, j: __turbopack_dynamic__, P: __turbopack_resolve_absolute_path__, U: __turbopack_relative_url__, R: __turbopack_resolve_module_id_path__, g: global, __dirname, x: __turbopack_external_require__, y: __turbopack_external_import__ }) => (() => {
"use strict";

/**
 * @description Defines flags that you can use to alter the default transformation behavior.
 * @namespace Flag
 * @memberOf Qualifiers
 */ __turbopack_esm__({
    "Flag": ()=>Flag,
    "animated": ()=>animated,
    "animatedPng": ()=>animatedPng,
    "animatedWebP": ()=>animatedWebP,
    "anyFormat": ()=>anyFormat,
    "attachment": ()=>attachment,
    "clip": ()=>clip,
    "clipEvenOdd": ()=>clipEvenOdd,
    "custom": ()=>custom,
    "forceIcc": ()=>forceIcc,
    "forceStrip": ()=>forceStrip,
    "getInfo": ()=>getInfo,
    "hlsv3": ()=>hlsv3,
    "ignoreInitialAspectRatio": ()=>ignoreInitialAspectRatio,
    "ignoreMaskChannels": ()=>ignoreMaskChannels,
    "immutableCache": ()=>immutableCache,
    "keepAttribution": ()=>keepAttribution,
    "keepDar": ()=>keepDar,
    "keepIptc": ()=>keepIptc,
    "layerApply": ()=>layerApply,
    "lossy": ()=>lossy,
    "mono": ()=>mono,
    "noOverflow": ()=>noOverflow,
    "noStream": ()=>noStream,
    "png24": ()=>png24,
    "png32": ()=>png32,
    "png8": ()=>png8,
    "preserveTransparency": ()=>preserveTransparency,
    "progressive": ()=>progressive,
    "rasterize": ()=>rasterize,
    "regionRelative": ()=>regionRelative,
    "relative": ()=>relative,
    "sanitize": ()=>sanitize,
    "splice": ()=>splice,
    "streamingAttachment": ()=>streamingAttachment,
    "stripProfile": ()=>stripProfile,
    "tiff8Lzw": ()=>tiff8Lzw,
    "tiled": ()=>tiled,
    "truncateTS": ()=>truncateTS,
    "waveform": ()=>waveform
});
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f40$cloudinary$2f$transformation$2d$builder$2d$sdk$2f$qualifiers$2f$flag$2f$FlagQualifier$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_import__("[project]/node_modules/@cloudinary/transformation-builder-sdk/qualifiers/flag/FlagQualifier.js [app-ssr] (ecmascript)");
"__TURBOPACK__ecmascript__hoisting__location__";
;
/**
 * @summary qualifier
 * @memberOf Qualifiers.Flag
 * @description Used when delivering a video file as an image format that supports animation, such as animated WebP.
 * Plays all frames rather than just delivering the first one as a static image.
 * Use this flag in addition to the flag or parameter controlling the delivery format,
 * for example f_auto or fl_awebp.

 * Note: When delivering a video in GIF format, it is delivered as an animated GIF by default and this flag is not
 * necessary. To deliver a single frame of a video in GIF format, use the page parameter.
 * @return {Qualifiers.Flag.FlagQualifier}
 */ function animated() {
    return new __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f40$cloudinary$2f$transformation$2d$builder$2d$sdk$2f$qualifiers$2f$flag$2f$FlagQualifier$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["FlagQualifier"]('animated');
}
/**
 * @summary qualifier
 * @memberOf Qualifiers.Flag
 * @description When converting animated images to WebP format, generate an animated WebP from all the frames in the
 * original
 * animated file instead of only from the first still frame.
 *
 * Note that animated WebPs are not supported in all browsers and versions.
 * @return {Qualifiers.Flag.FlagQualifier}
 */ function animatedWebP() {
    return new __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f40$cloudinary$2f$transformation$2d$builder$2d$sdk$2f$qualifiers$2f$flag$2f$FlagQualifier$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["FlagQualifier"]('awebp');
}
/**
 * @summary qualifier
 * @memberOf Qualifiers.Flag
 * @description When used together with automatic quality (q_auto):
 * allow switching to PNG8 encoding if the quality algorithm decides that it's more efficient.
 * @return {Qualifiers.Flag.FlagQualifier}
 */ function anyFormat() {
    return new __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f40$cloudinary$2f$transformation$2d$builder$2d$sdk$2f$qualifiers$2f$flag$2f$FlagQualifier$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["FlagQualifier"]('any_format');
}
/**
 * @summary qualifier
 * @memberOf Qualifiers.Flag
 * @description When converting animated images to PNG format, generates an animated PNG from all the frames in the
 * original
 * animated file instead of only from the first still frame.
 *
 * Note that animated PNGs are not supported in all browsers and versions.
 * @return {Qualifiers.Flag.FlagQualifier}
 */ function animatedPng() {
    return new __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f40$cloudinary$2f$transformation$2d$builder$2d$sdk$2f$qualifiers$2f$flag$2f$FlagQualifier$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["FlagQualifier"]('apng');
}
/**
 * @summary qualifier
 * @memberOf Qualifiers.Flag
 * @description Trims pixels according to a clipping path included in the original image
 * (e.g., manually created using PhotoShop).
 * @return {Qualifiers.Flag.FlagQualifier}
 */ function clip() {
    return new __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f40$cloudinary$2f$transformation$2d$builder$2d$sdk$2f$qualifiers$2f$flag$2f$FlagQualifier$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["FlagQualifier"]('clip');
}
/**
 * @summary qualifier
 * @memberOf Qualifiers.Flag
 * @description Trims pixels according to a clipping path included in the original image (e.g., manually created
 * using PhotoShop)
 * using an evenodd clipping rule.
 * @return {Qualifiers.Flag.FlagQualifier}
 */ function clipEvenOdd() {
    return new __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f40$cloudinary$2f$transformation$2d$builder$2d$sdk$2f$qualifiers$2f$flag$2f$FlagQualifier$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["FlagQualifier"]('clip_evenodd');
}
/**
 * @summary qualifier
 * @memberOf Qualifiers.Flag
 * @description Instructs Cloudinary to clear all image meta-data (IPTC, Exif and XMP) while applying an incoming
 * transformation.
 * @return {Qualifiers.Flag.FlagQualifier}
 */ function forceStrip() {
    return new __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f40$cloudinary$2f$transformation$2d$builder$2d$sdk$2f$qualifiers$2f$flag$2f$FlagQualifier$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["FlagQualifier"]('force_strip');
}
/**
 * @summary qualifier
 * @memberOf Qualifiers.Flag
 * @description Allows custom flag
 * @return {Qualifiers.Flag.FlagQualifier}
 */ function custom(value) {
    return new __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f40$cloudinary$2f$transformation$2d$builder$2d$sdk$2f$qualifiers$2f$flag$2f$FlagQualifier$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["FlagQualifier"](value);
}
/**
 * @summary qualifier
 * @memberOf Qualifiers.Flag
 * @description Adds ICC color space metadata to the image, even when the original image doesn't contain any ICC data.
 * @return {Qualifiers.Flag.FlagQualifier}
 */ function forceIcc() {
    return new __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f40$cloudinary$2f$transformation$2d$builder$2d$sdk$2f$qualifiers$2f$flag$2f$FlagQualifier$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["FlagQualifier"]('force_icc');
}
/**
 * @summary qualifier
 * @memberOf Qualifiers.Flag
 * @description Delivers the image as an attachment.
 * @param {string} filename The attachment's filename
 * @return {Qualifiers.Flag.FlagQualifier}
 */ function attachment(filename) {
    return new __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f40$cloudinary$2f$transformation$2d$builder$2d$sdk$2f$qualifiers$2f$flag$2f$FlagQualifier$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["FlagQualifier"]('attachment', filename);
}
/**
 * @summary qualifier
 * @memberOf Qualifiers.Flag
 * @description Returns metadata of the input asset and of the transformed output asset in JSON instead of the
 * transformed image.
 * @return {Qualifiers.Flag.FlagQualifier}
 */ function getInfo() {
    return new __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f40$cloudinary$2f$transformation$2d$builder$2d$sdk$2f$qualifiers$2f$flag$2f$FlagQualifier$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["FlagQualifier"]('getinfo');
}
/**
 * @summary qualifier
 * @memberOf Qualifiers.Flag
 * @description Deliver an HLS adaptive bitrate streaming file as HLS v3 instead of the default version (HLS v4).
 * Delivering in this format requires a private CDN configuration.
 * @return {Qualifiers.Flag.FlagQualifier}
 */ function hlsv3() {
    return new __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f40$cloudinary$2f$transformation$2d$builder$2d$sdk$2f$qualifiers$2f$flag$2f$FlagQualifier$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["FlagQualifier"]('hlsv3');
}
/**
 * @summary qualifier
 * @memberOf Qualifiers.Flag
 * @description Sets the cache-control to immutable for the asset.
 * @return {Qualifiers.Flag.FlagQualifier}
 */ function immutableCache() {
    return new __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f40$cloudinary$2f$transformation$2d$builder$2d$sdk$2f$qualifiers$2f$flag$2f$FlagQualifier$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["FlagQualifier"]('immutable_cache');
}
/**
 * @summary qualifier
 * @memberOf Qualifiers.Flag
 * @description * Allows specifying only either width or height so the value of the second axis remains as is, and is not
 * recalculated to maintain the aspect ratio of the original image.
 * @return {Qualifiers.Flag.FlagQualifier}
 */ function ignoreInitialAspectRatio() {
    return new __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f40$cloudinary$2f$transformation$2d$builder$2d$sdk$2f$qualifiers$2f$flag$2f$FlagQualifier$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["FlagQualifier"]('ignore_aspect_ratio');
}
/**
 * @summary qualifier
 * @memberOf Qualifiers.Flag
 * @description Keeps the copyright related fields when stripping meta-data.
 * @return {Qualifiers.Flag.FlagQualifier}
 */ function keepAttribution() {
    return new __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f40$cloudinary$2f$transformation$2d$builder$2d$sdk$2f$qualifiers$2f$flag$2f$FlagQualifier$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["FlagQualifier"]('keep_attribution');
}
/**
 * @summary qualifier
 * @memberOf Qualifiers.Flag
 * Keep the Display Aspect Ratio metadata of the uploaded video (if it’s different from the current video
 * dimensions).
 * @return {Qualifiers.Flag.FlagQualifier}
 */ function keepDar() {
    return new __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f40$cloudinary$2f$transformation$2d$builder$2d$sdk$2f$qualifiers$2f$flag$2f$FlagQualifier$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["FlagQualifier"]('keep_dar');
}
/**
 * @summary qualifier
 * @memberOf Qualifiers.Flag
 * @description Keeps all meta-data.
 * @return {Qualifiers.Flag.FlagQualifier}
 */ function keepIptc() {
    return new __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f40$cloudinary$2f$transformation$2d$builder$2d$sdk$2f$qualifiers$2f$flag$2f$FlagQualifier$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["FlagQualifier"]('keep_iptc');
}
/**
 * @summary qualifier
 * @memberOf Qualifiers.Flag
 * @description Applies all chained transformations, until a transformation component that includes this flag, on the last added
 * overlay or underlay instead of applying on the containing image.
 * @return {Qualifiers.Flag.FlagQualifier}
 */ function layerApply() {
    return new __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f40$cloudinary$2f$transformation$2d$builder$2d$sdk$2f$qualifiers$2f$flag$2f$FlagQualifier$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["FlagQualifier"]('layer_apply');
}
/**
 * @summary qualifier
 * @memberOf Qualifiers.Flag
 * @description Automatically use lossy compression when delivering animated GIF files.
 *
 * This flag can also be used as a conditional flag for delivering PNG files: it tells Cloudinary to deliver the
 * image in PNG format (as requested) unless there is no transparency channel - in which case deliver in JPEG
 * format.
 * @return {Qualifiers.Flag.FlagQualifier}
 */ function lossy() {
    return new __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f40$cloudinary$2f$transformation$2d$builder$2d$sdk$2f$qualifiers$2f$flag$2f$FlagQualifier$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["FlagQualifier"]('lossy');
}
/**
 * @summary qualifier
 * @memberOf Qualifiers.Flag
 * @description Convert the audio channel to mono
 * @return {Qualifiers.Flag.FlagQualifier}
 */ function mono() {
    return new __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f40$cloudinary$2f$transformation$2d$builder$2d$sdk$2f$qualifiers$2f$flag$2f$FlagQualifier$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["FlagQualifier"]('mono');
}
/**
 * @summary qualifier
 * @memberOf Qualifiers.Flag
 * @description Used internally by Position within an Overlay, this flag will tile the overlay across your image.
 *
 * <b>Learn more:</b> {@link https://cloudinary.com/documentation/transformation_reference#fl_no_overflow|Overflow in overlays}
 * @return {Qualifiers.Flag.FlagQualifier}
 */ function noOverflow() {
    return new __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f40$cloudinary$2f$transformation$2d$builder$2d$sdk$2f$qualifiers$2f$flag$2f$FlagQualifier$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["FlagQualifier"]('no_overflow');
}
/**
 * @summary qualifier
 * @memberOf Qualifiers.Flag
 * @description Don't stream a video that is currently being generated on the fly. Wait until the video is fully generated.
 * @return {Qualifiers.Flag.FlagQualifier}
 */ function noStream() {
    return new __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f40$cloudinary$2f$transformation$2d$builder$2d$sdk$2f$qualifiers$2f$flag$2f$FlagQualifier$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["FlagQualifier"]('no_stream');
}
/**
 * @summary qualifier
 * @memberOf Qualifiers.Flag
 * @description Generate PNG images in the png24 format.
 * @return {Qualifiers.Flag.FlagQualifier}
 */ function png24() {
    return new __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f40$cloudinary$2f$transformation$2d$builder$2d$sdk$2f$qualifiers$2f$flag$2f$FlagQualifier$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["FlagQualifier"]('png24');
}
/**
 * @summary qualifier
 * @memberOf Qualifiers.Flag
 * @description Generate PNG images in the png32 format.
 * @return {Qualifiers.Flag.FlagQualifier}
 */ function png32() {
    return new __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f40$cloudinary$2f$transformation$2d$builder$2d$sdk$2f$qualifiers$2f$flag$2f$FlagQualifier$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["FlagQualifier"]('png32');
}
/**
 * @summary qualifier
 * @memberOf Qualifiers.Flag
 * @description Generate PNG images in the PNG8 format.
 * @return {Qualifiers.Flag.FlagQualifier}
 */ function png8() {
    return new __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f40$cloudinary$2f$transformation$2d$builder$2d$sdk$2f$qualifiers$2f$flag$2f$FlagQualifier$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["FlagQualifier"]('png8');
}
/**
 * @summary qualifier
 * @memberOf Qualifiers.Flag
 * @description When used with automatic fetch_format (f_auto): ensures that images with a transparency channel will be
 * delivered in PNG format.
 * @return {Qualifiers.Flag.FlagQualifier}
 */ function preserveTransparency() {
    return new __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f40$cloudinary$2f$transformation$2d$builder$2d$sdk$2f$qualifiers$2f$flag$2f$FlagQualifier$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["FlagQualifier"]('preserve_transparency');
}
/**
 * @summary qualifier
 * @memberOf Qualifiers.Flag
 * @description Generates a JPG image using the progressive (interlaced) JPG format.
 *
 * This format allows the browser to quickly show a low-quality rendering of the image until the full-quality
 * image is loaded.
 *
 * @param {string} mode? The mode to determine a specific progressive outcome as follows:
 * * semi - A smart optimization of the decoding time, compression level and progressive rendering
 *          (less iterations). This is the default mode when using q_auto.
 * * steep - Delivers a preview very quickly, and in a single later phase improves the image to
 *           the required resolution.
 * * none  - Use this to deliver a non-progressive image. This is the default mode when setting
 *           a specific value for quality.
 * @return {Qualifiers.Flag.FlagQualifier}
 */ function progressive(mode) {
    return new __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f40$cloudinary$2f$transformation$2d$builder$2d$sdk$2f$qualifiers$2f$flag$2f$FlagQualifier$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["FlagQualifier"]('progressive', mode);
}
/**
 * @summary qualifier
 * @memberOf Qualifiers.Flag
 * @description Modifies percentage-based width & height parameters of overlays and underlays (e.g., 1.0) to be relative to the overlaid region
 * @return {Qualifiers.Flag.FlagQualifier}
 */ function regionRelative() {
    return new __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f40$cloudinary$2f$transformation$2d$builder$2d$sdk$2f$qualifiers$2f$flag$2f$FlagQualifier$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["FlagQualifier"]('region_relative');
}
/**
 * @summary qualifier
 * @memberOf Qualifiers.Flag
 * @description Reduces the image to one flat pixelated layer (as opposed to the default vector based graphic) in
 * order to enable
 * PDF resizing and overlay manipulations.
 * @return {Qualifiers.Flag.FlagQualifier}
 */ function rasterize() {
    return new __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f40$cloudinary$2f$transformation$2d$builder$2d$sdk$2f$qualifiers$2f$flag$2f$FlagQualifier$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["FlagQualifier"]('rasterize');
}
/**
 * @summary qualifier
 * @memberOf Qualifiers.Flag
 * @description Modifies percentage-based width & height parameters of overlays and underlays (e.g., 1.0) to be relative to the containing image instead of the added layer.
 * @return {Qualifiers.Flag.FlagQualifier}
 */ function relative() {
    return new __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f40$cloudinary$2f$transformation$2d$builder$2d$sdk$2f$qualifiers$2f$flag$2f$FlagQualifier$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["FlagQualifier"]('relative');
}
/**
 * @summary qualifier
 * @memberOf Qualifiers.Flag
 * @description Instructs Cloudinary to run a sanitizer on the image (relevant only for the SVG format).
 * @return {Qualifiers.Flag.FlagQualifier}
 */ function sanitize() {
    return new __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f40$cloudinary$2f$transformation$2d$builder$2d$sdk$2f$qualifiers$2f$flag$2f$FlagQualifier$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["FlagQualifier"]('sanitize');
}
/**
 * @summary qualifier
 * @memberOf Qualifiers.Flag
 * @description Splices the video stipulated as an overlay on to the end of the container video instead of adding it as an
 * overlay.
 * @return {Qualifiers.Flag.FlagQualifier}
 */ function splice() {
    return new __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f40$cloudinary$2f$transformation$2d$builder$2d$sdk$2f$qualifiers$2f$flag$2f$FlagQualifier$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["FlagQualifier"]('splice');
}
/**
 * @summary qualifier
 * @memberOf Qualifiers.Flag
 * @description Instructs Cloudinary to clear all ICC color profile data included with the image.
 * @return {Qualifiers.Flag.FlagQualifier}
 */ function stripProfile() {
    return new __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f40$cloudinary$2f$transformation$2d$builder$2d$sdk$2f$qualifiers$2f$flag$2f$FlagQualifier$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["FlagQualifier"]('strip_profile');
}
/**
 * @summary qualifier
 * @memberOf Qualifiers.Flag
 * @description If the requested video transformation has already been generated, this flag works identically to
 * Flag::attachment.
 *
 *  However, if the video transformation is being requested for the first time, this flag causes the video download
 * to begin immediately, streaming it as a fragmented video file.
 *
 * In contrast, if the regular fl_attachment flag is used when a user requests a new video transformation,
 * the download will begin only after the complete transformed video has been generated.
 *
 * Most standard video players successfully play fragmented video files without issue.
 *
 * @param {string} filename The attachment's filename
 * @return {Qualifiers.Flag.FlagQualifier}
 */ function streamingAttachment(filename) {
    return new __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f40$cloudinary$2f$transformation$2d$builder$2d$sdk$2f$qualifiers$2f$flag$2f$FlagQualifier$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["FlagQualifier"]('streaming_attachment', filename);
}
/**
 * @summary qualifier
 * @memberOf Qualifiers.Flag
 * @description Generates TIFF images using LZW compression and in the TIFF8 format.
 * @return {Qualifiers.Flag.FlagQualifier}
 */ function tiff8Lzw() {
    return new __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f40$cloudinary$2f$transformation$2d$builder$2d$sdk$2f$qualifiers$2f$flag$2f$FlagQualifier$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["FlagQualifier"]('tiff8_lzw');
}
/**
 * @summary qualifier
 * @memberOf Qualifiers.Flag
 * @description Used internally by Position within an Overlay, this flag will tile the overlay across your image.
 *
 * <b>Learn more:</b> {@link https://cloudinary.com/documentation/layers#automatic_tiling|Tiling overlay}
 * @return {Qualifiers.Flag.FlagQualifier}
 */ function tiled() {
    return new __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f40$cloudinary$2f$transformation$2d$builder$2d$sdk$2f$qualifiers$2f$flag$2f$FlagQualifier$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["FlagQualifier"]('tiled');
}
/**
 * @summary qualifier
 * @memberOf Qualifiers.Flag
 * @description Truncate (trim) a video file based on the start time defined in the metadata (relevant only where the metadata
 * includes a directive to play only a section of the video).
 * @return {Qualifiers.Flag.FlagQualifier}
 */ function truncateTS() {
    return new __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f40$cloudinary$2f$transformation$2d$builder$2d$sdk$2f$qualifiers$2f$flag$2f$FlagQualifier$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["FlagQualifier"]('truncate_ts');
}
/**
 * @summary qualifier
 * @memberOf Qualifiers.Flag
 * @description Create a waveform image (in the format specified by the file extension) from the audio or video file.
 * @return {Qualifiers.Flag.FlagQualifier}
 */ function waveform() {
    return new __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f40$cloudinary$2f$transformation$2d$builder$2d$sdk$2f$qualifiers$2f$flag$2f$FlagQualifier$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["FlagQualifier"]('waveform');
}
/**
 * @summary qualifier
 * @memberOf Qualifiers.Flag
 * @description A qualifier that ensures that an alpha channel is not applied to a TIFF image if it is a mask channel.
 * @return {Qualifiers.Flag.FlagQualifier}
 */ function ignoreMaskChannels() {
    return new __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f40$cloudinary$2f$transformation$2d$builder$2d$sdk$2f$qualifiers$2f$flag$2f$FlagQualifier$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["FlagQualifier"]('ignore_mask_channels');
}
const Flag = {
    animated,
    anyFormat,
    animatedPng,
    animatedWebP,
    clipEvenOdd,
    lossy,
    preserveTransparency,
    png8,
    png24,
    png32,
    progressive,
    rasterize,
    sanitize,
    stripProfile,
    tiff8Lzw,
    attachment,
    forceIcc,
    forceStrip,
    getInfo,
    immutableCache,
    keepAttribution,
    keepIptc,
    custom,
    streamingAttachment,
    hlsv3,
    keepDar,
    noStream,
    mono,
    layerApply,
    relative,
    regionRelative,
    splice,
    truncateTS,
    waveform,
    ignoreInitialAspectRatio,
    clip,
    tiled,
    noOverflow,
    ignoreMaskChannels
};
;

})()),
"[project]/node_modules/@cloudinary/transformation-builder-sdk/qualifiers/format/FormatQualifier.js [app-ssr] (ecmascript)": (({ r: __turbopack_require__, f: __turbopack_module_context__, i: __turbopack_import__, s: __turbopack_esm__, v: __turbopack_export_value__, n: __turbopack_export_namespace__, c: __turbopack_cache__, M: __turbopack_modules__, l: __turbopack_load__, j: __turbopack_dynamic__, P: __turbopack_resolve_absolute_path__, U: __turbopack_relative_url__, R: __turbopack_resolve_module_id_path__, g: global, __dirname, x: __turbopack_external_require__, y: __turbopack_external_import__ }) => (() => {
"use strict";

__turbopack_esm__({
    "FormatQualifier": ()=>FormatQualifier
});
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f40$cloudinary$2f$transformation$2d$builder$2d$sdk$2f$internal$2f$qualifier$2f$QualifierValue$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_import__("[project]/node_modules/@cloudinary/transformation-builder-sdk/internal/qualifier/QualifierValue.js [app-ssr] (ecmascript)");
"__TURBOPACK__ecmascript__hoisting__location__";
;
/**
 * @memberOf Qualifiers.Format
 * @extends {SDK.QualifierValue}
 */ class FormatQualifier extends __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f40$cloudinary$2f$transformation$2d$builder$2d$sdk$2f$internal$2f$qualifier$2f$QualifierValue$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["QualifierValue"] {
    constructor(val){
        super(val);
        this.val = val;
    }
    getValue() {
        return this.val;
    }
}
;

})()),
"[project]/node_modules/@cloudinary/transformation-builder-sdk/internal/utils/objectFlip.js [app-ssr] (ecmascript)": (({ r: __turbopack_require__, f: __turbopack_module_context__, i: __turbopack_import__, s: __turbopack_esm__, v: __turbopack_export_value__, n: __turbopack_export_namespace__, c: __turbopack_cache__, M: __turbopack_modules__, l: __turbopack_load__, j: __turbopack_dynamic__, P: __turbopack_resolve_absolute_path__, U: __turbopack_relative_url__, R: __turbopack_resolve_module_id_path__, g: global, __dirname, x: __turbopack_external_require__, y: __turbopack_external_import__ }) => (() => {
"use strict";

/**
 * Flip keys and values for given object
 * @param obj
 */ __turbopack_esm__({
    "objectFlip": ()=>objectFlip
});
function objectFlip(obj) {
    const result = {};
    Object.keys(obj).forEach((key)=>{
        result[obj[key]] = key;
    });
    return result;
}
;

})()),
"[project]/node_modules/@cloudinary/transformation-builder-sdk/internal/internalConstants.js [app-ssr] (ecmascript)": (({ r: __turbopack_require__, f: __turbopack_module_context__, i: __turbopack_import__, s: __turbopack_esm__, v: __turbopack_export_value__, n: __turbopack_export_namespace__, c: __turbopack_cache__, M: __turbopack_modules__, l: __turbopack_load__, j: __turbopack_dynamic__, P: __turbopack_resolve_absolute_path__, U: __turbopack_relative_url__, R: __turbopack_resolve_module_id_path__, g: global, __dirname, x: __turbopack_external_require__, y: __turbopack_external_import__ }) => (() => {
"use strict";

/**
 * This file is for internal constants only.
 * It is not intended for public use and is not part of the public API
 */ __turbopack_esm__({
    "ACTION_TYPE_TO_BLEND_MODE_MAP": ()=>ACTION_TYPE_TO_BLEND_MODE_MAP,
    "ACTION_TYPE_TO_CROP_MODE_MAP": ()=>ACTION_TYPE_TO_CROP_MODE_MAP,
    "ACTION_TYPE_TO_DELIVERY_MODE_MAP": ()=>ACTION_TYPE_TO_DELIVERY_MODE_MAP,
    "ACTION_TYPE_TO_EFFECT_MODE_MAP": ()=>ACTION_TYPE_TO_EFFECT_MODE_MAP,
    "ACTION_TYPE_TO_QUALITY_MODE_MAP": ()=>ACTION_TYPE_TO_QUALITY_MODE_MAP,
    "ACTION_TYPE_TO_STREAMING_PROFILE_MODE_MAP": ()=>ACTION_TYPE_TO_STREAMING_PROFILE_MODE_MAP,
    "CHROMA_MODEL_ENUM_TO_CHROMA_VALUE": ()=>CHROMA_MODEL_ENUM_TO_CHROMA_VALUE,
    "CHROMA_VALUE_TO_CHROMA_MODEL_ENUM": ()=>CHROMA_VALUE_TO_CHROMA_MODEL_ENUM,
    "COLOR_SPACE_MODEL_MODE_TO_COLOR_SPACE_MODE_MAP": ()=>COLOR_SPACE_MODEL_MODE_TO_COLOR_SPACE_MODE_MAP,
    "COLOR_SPACE_MODE_TO_COLOR_SPACE_MODEL_MODE_MAP": ()=>COLOR_SPACE_MODE_TO_COLOR_SPACE_MODEL_MODE_MAP,
    "CONDITIONAL_OPERATORS": ()=>CONDITIONAL_OPERATORS,
    "CROP_MODE_TO_ACTION_TYPE_MAP": ()=>CROP_MODE_TO_ACTION_TYPE_MAP,
    "DELIVERY_MODE_TO_ACTION_TYPE_MAP": ()=>DELIVERY_MODE_TO_ACTION_TYPE_MAP,
    "EFFECT_MODE_TO_ACTION_TYPE_MAP": ()=>EFFECT_MODE_TO_ACTION_TYPE_MAP,
    "QUALITY_MODE_TO_ACTION_TYPE_MAP": ()=>QUALITY_MODE_TO_ACTION_TYPE_MAP,
    "RESERVED_NAMES": ()=>RESERVED_NAMES,
    "STREAMING_PROFILE_TO_ACTION_TYPE_MAP": ()=>STREAMING_PROFILE_TO_ACTION_TYPE_MAP
});
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f40$cloudinary$2f$transformation$2d$builder$2d$sdk$2f$internal$2f$utils$2f$objectFlip$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_import__("[project]/node_modules/@cloudinary/transformation-builder-sdk/internal/utils/objectFlip.js [app-ssr] (ecmascript)");
"__TURBOPACK__ecmascript__hoisting__location__";
;
const CONDITIONAL_OPERATORS = {
    "=": "eq",
    "!=": "ne",
    "<": "lt",
    ">": "gt",
    "<=": "lte",
    ">=": "gte",
    "&&": "and",
    "||": "or",
    "*": "mul",
    "/": "div",
    "+": "add",
    "-": "sub",
    "^": "pow"
};
const RESERVED_NAMES = {
    "aspect_ratio": "ar",
    "aspectRatio": "ar",
    "current_page": "cp",
    "currentPage": "cp",
    "duration": "du",
    "face_count": "fc",
    "faceCount": "fc",
    "height": "h",
    "initial_aspect_ratio": "iar",
    "initial_height": "ih",
    "initial_width": "iw",
    "initialAspectRatio": "iar",
    "initialHeight": "ih",
    "initialWidth": "iw",
    "initial_duration": "idu",
    "initialDuration": "idu",
    "page_count": "pc",
    "page_x": "px",
    "page_y": "py",
    "pageCount": "pc",
    "pageX": "px",
    "pageY": "py",
    "tags": "tags",
    "width": "w",
    "trimmed_aspect_ratio": "tar",
    "current_public_id": "cpi",
    "initial_density": "idn",
    "page_names": "pgnames"
};
const ACTION_TYPE_TO_CROP_MODE_MAP = {
    limitFit: 'limit',
    limitFill: 'lfill',
    minimumFit: 'mfit',
    thumbnail: 'thumb',
    limitPad: 'lpad',
    minimumPad: 'mpad',
    autoPad: 'auto_pad'
};
const ACTION_TYPE_TO_DELIVERY_MODE_MAP = {
    colorSpace: 'cs',
    dpr: 'dpr',
    density: 'dn',
    defaultImage: 'd',
    format: 'f',
    quality: 'q'
};
const ACTION_TYPE_TO_EFFECT_MODE_MAP = {
    redEye: 'redeye',
    advancedRedEye: 'adv_redeye',
    oilPaint: 'oil_paint',
    unsharpMask: 'unsharp_mask',
    makeTransparent: 'make_transparent',
    generativeRestore: 'gen_restore',
    upscale: 'upscale'
};
const ACTION_TYPE_TO_QUALITY_MODE_MAP = {
    autoBest: 'auto:best',
    autoEco: 'auto:eco',
    autoGood: 'auto:good',
    autoLow: 'auto:low',
    jpegminiHigh: 'jpegmini:1',
    jpegminiMedium: 'jpegmini:2',
    jpegminiBest: 'jpegmini:0'
};
const ACTION_TYPE_TO_STREAMING_PROFILE_MODE_MAP = {
    fullHd: 'full_hd',
    fullHdWifi: 'full_hd_wifi',
    fullHdLean: 'full_hd_lean',
    hdLean: 'hd_lean'
};
const CHROMA_VALUE_TO_CHROMA_MODEL_ENUM = {
    444: "CHROMA_444",
    420: "CHROMA_420"
};
const COLOR_SPACE_MODEL_MODE_TO_COLOR_SPACE_MODE_MAP = {
    'noCmyk': 'no_cmyk',
    'keepCmyk': 'keep_cmyk',
    'tinySrgb': 'tinysrgb',
    'srgbTrueColor': 'srgb:truecolor'
};
const ACTION_TYPE_TO_BLEND_MODE_MAP = {
    'antiRemoval': 'anti_removal'
};
const CHROMA_MODEL_ENUM_TO_CHROMA_VALUE = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f40$cloudinary$2f$transformation$2d$builder$2d$sdk$2f$internal$2f$utils$2f$objectFlip$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["objectFlip"])(CHROMA_VALUE_TO_CHROMA_MODEL_ENUM);
const COLOR_SPACE_MODE_TO_COLOR_SPACE_MODEL_MODE_MAP = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f40$cloudinary$2f$transformation$2d$builder$2d$sdk$2f$internal$2f$utils$2f$objectFlip$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["objectFlip"])(COLOR_SPACE_MODEL_MODE_TO_COLOR_SPACE_MODE_MAP);
const CROP_MODE_TO_ACTION_TYPE_MAP = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f40$cloudinary$2f$transformation$2d$builder$2d$sdk$2f$internal$2f$utils$2f$objectFlip$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["objectFlip"])(ACTION_TYPE_TO_CROP_MODE_MAP);
const DELIVERY_MODE_TO_ACTION_TYPE_MAP = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f40$cloudinary$2f$transformation$2d$builder$2d$sdk$2f$internal$2f$utils$2f$objectFlip$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["objectFlip"])(ACTION_TYPE_TO_DELIVERY_MODE_MAP);
const EFFECT_MODE_TO_ACTION_TYPE_MAP = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f40$cloudinary$2f$transformation$2d$builder$2d$sdk$2f$internal$2f$utils$2f$objectFlip$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["objectFlip"])(ACTION_TYPE_TO_EFFECT_MODE_MAP);
const QUALITY_MODE_TO_ACTION_TYPE_MAP = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f40$cloudinary$2f$transformation$2d$builder$2d$sdk$2f$internal$2f$utils$2f$objectFlip$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["objectFlip"])(ACTION_TYPE_TO_QUALITY_MODE_MAP);
const STREAMING_PROFILE_TO_ACTION_TYPE_MAP = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f40$cloudinary$2f$transformation$2d$builder$2d$sdk$2f$internal$2f$utils$2f$objectFlip$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["objectFlip"])(ACTION_TYPE_TO_STREAMING_PROFILE_MODE_MAP);

})()),
"[project]/node_modules/@cloudinary/transformation-builder-sdk/actions/delivery/DeliveryAction.js [app-ssr] (ecmascript)": (({ r: __turbopack_require__, f: __turbopack_module_context__, i: __turbopack_import__, s: __turbopack_esm__, v: __turbopack_export_value__, n: __turbopack_export_namespace__, c: __turbopack_cache__, M: __turbopack_modules__, l: __turbopack_load__, j: __turbopack_dynamic__, P: __turbopack_resolve_absolute_path__, U: __turbopack_relative_url__, R: __turbopack_resolve_module_id_path__, g: global, __dirname, x: __turbopack_external_require__, y: __turbopack_external_import__ }) => (() => {
"use strict";

__turbopack_esm__({
    "DeliveryAction": ()=>DeliveryAction
});
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f40$cloudinary$2f$transformation$2d$builder$2d$sdk$2f$internal$2f$Action$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_import__("[project]/node_modules/@cloudinary/transformation-builder-sdk/internal/Action.js [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f40$cloudinary$2f$transformation$2d$builder$2d$sdk$2f$qualifiers$2f$format$2f$FormatQualifier$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_import__("[project]/node_modules/@cloudinary/transformation-builder-sdk/qualifiers/format/FormatQualifier.js [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f40$cloudinary$2f$transformation$2d$builder$2d$sdk$2f$internal$2f$qualifier$2f$Qualifier$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_import__("[project]/node_modules/@cloudinary/transformation-builder-sdk/internal/qualifier/Qualifier.js [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f40$cloudinary$2f$transformation$2d$builder$2d$sdk$2f$internal$2f$internalConstants$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_import__("[project]/node_modules/@cloudinary/transformation-builder-sdk/internal/internalConstants.js [app-ssr] (ecmascript)");
"__TURBOPACK__ecmascript__hoisting__location__";
;
;
;
;
/**
 * @description Qualifies the delivery of an asset.
 * @memberOf Actions.Delivery
 * @extends SDK.Action
 */ class DeliveryAction extends __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f40$cloudinary$2f$transformation$2d$builder$2d$sdk$2f$internal$2f$Action$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["Action"] {
    /**
     * @param {string} deliveryKey A generic Delivery Action Key (such as q, f, dn, etc.)
     * @param {string} deliveryType A Format Qualifiers for the action, such as Quality.auto()
     * @param {string} modelProperty internal model property of the action, for example quality uses `level` while dpr uses `density`
     * @see Visit {@link Actions.Delivery|Delivery} for an example
     */ constructor(deliveryKey, deliveryType, modelProperty){
        super();
        this._actionModel = {};
        let deliveryTypeValue;
        if (deliveryType instanceof __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f40$cloudinary$2f$transformation$2d$builder$2d$sdk$2f$qualifiers$2f$format$2f$FormatQualifier$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["FormatQualifier"]) {
            deliveryTypeValue = deliveryType.getValue();
        } else {
            deliveryTypeValue = deliveryType;
        }
        this._actionModel.actionType = __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f40$cloudinary$2f$transformation$2d$builder$2d$sdk$2f$internal$2f$internalConstants$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["DELIVERY_MODE_TO_ACTION_TYPE_MAP"][deliveryKey];
        this._actionModel[modelProperty] = deliveryTypeValue;
        this.addQualifier(new __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f40$cloudinary$2f$transformation$2d$builder$2d$sdk$2f$internal$2f$qualifier$2f$Qualifier$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["Qualifier"](deliveryKey, deliveryType));
    }
}
;

})()),
"[project]/node_modules/@cloudinary/transformation-builder-sdk/qualifiers/progressive.js [app-ssr] (ecmascript)": (({ r: __turbopack_require__, f: __turbopack_module_context__, i: __turbopack_import__, s: __turbopack_esm__, v: __turbopack_export_value__, n: __turbopack_export_namespace__, c: __turbopack_cache__, M: __turbopack_modules__, l: __turbopack_load__, j: __turbopack_dynamic__, P: __turbopack_resolve_absolute_path__, U: __turbopack_relative_url__, R: __turbopack_resolve_module_id_path__, g: global, __dirname, x: __turbopack_external_require__, y: __turbopack_external_import__ }) => (() => {
"use strict";

/**
 * @description Contains functions to select the mode when using a progressive format.
 * <b>Learn more</b>: {@link https://cloudinary.com/documentation/transformation_reference#fl_progressive|Progressive modes}
 * @memberOf Qualifiers
 * @namespace Progressive
 * @example
 * import {Cloudinary} from "@cloudinary/url-gen";
 * import {format} from "@cloudinary/url-gen/actions/delivery";
 * import {jpg} from "@cloudinary/url-gen/qualifiers/format";
 * import {steep} from "@cloudinary/url-gen/qualifiers/progressive";
 *
 * const yourCldInstance = new Cloudinary({cloud: {cloudName: 'demo'}});
 * const image = yourCldInstance.image('woman');
 * image.delivery(format(jpg()).progressive(steep()))
 */ __turbopack_esm__({
    "Progressive": ()=>Progressive,
    "ProgressiveQualifier": ()=>ProgressiveQualifier,
    "none": ()=>none,
    "progressive": ()=>progressive,
    "semi": ()=>semi,
    "steep": ()=>steep
});
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f40$cloudinary$2f$transformation$2d$builder$2d$sdk$2f$qualifiers$2f$flag$2f$FlagQualifier$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_import__("[project]/node_modules/@cloudinary/transformation-builder-sdk/qualifiers/flag/FlagQualifier.js [app-ssr] (ecmascript)");
"__TURBOPACK__ecmascript__hoisting__location__";
;
class ProgressiveQualifier extends __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f40$cloudinary$2f$transformation$2d$builder$2d$sdk$2f$qualifiers$2f$flag$2f$FlagQualifier$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["FlagQualifier"] {
    constructor(mode){
        super('progressive', mode);
    }
}
/**
 * @memberOf Qualifiers.Progressive
 */ function none() {
    return new ProgressiveQualifier('none');
}
/**
 * @memberOf Qualifiers.Progressive
 */ function semi() {
    return new ProgressiveQualifier('semi');
}
/**
 * @memberOf Qualifiers.Progressive
 */ function steep() {
    return new ProgressiveQualifier('steep');
}
/**
 * @memberOf Qualifiers.Progressive
 */ function progressive() {
    return new ProgressiveQualifier();
}
const Progressive = {
    semi,
    none,
    steep,
    progressive,
    ProgressiveQualifier
};
;

})()),
"[project]/node_modules/@cloudinary/transformation-builder-sdk/actions/delivery/DeliveryFormatAction.js [app-ssr] (ecmascript)": (({ r: __turbopack_require__, f: __turbopack_module_context__, i: __turbopack_import__, s: __turbopack_esm__, v: __turbopack_export_value__, n: __turbopack_export_namespace__, c: __turbopack_cache__, M: __turbopack_modules__, l: __turbopack_load__, j: __turbopack_dynamic__, P: __turbopack_resolve_absolute_path__, U: __turbopack_relative_url__, R: __turbopack_resolve_module_id_path__, g: global, __dirname, x: __turbopack_external_require__, y: __turbopack_external_import__ }) => (() => {
"use strict";

__turbopack_esm__({
    "DeliveryFormatAction": ()=>DeliveryFormatAction
});
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f40$cloudinary$2f$transformation$2d$builder$2d$sdk$2f$qualifiers$2f$flag$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_import__("[project]/node_modules/@cloudinary/transformation-builder-sdk/qualifiers/flag.js [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f40$cloudinary$2f$transformation$2d$builder$2d$sdk$2f$actions$2f$delivery$2f$DeliveryAction$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_import__("[project]/node_modules/@cloudinary/transformation-builder-sdk/actions/delivery/DeliveryAction.js [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f40$cloudinary$2f$transformation$2d$builder$2d$sdk$2f$qualifiers$2f$progressive$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_import__("[project]/node_modules/@cloudinary/transformation-builder-sdk/qualifiers/progressive.js [app-ssr] (ecmascript)");
"__TURBOPACK__ecmascript__hoisting__location__";
;
;
;
/**
 * @memberOf Actions.Delivery
 * @extends {Actions.Delivery.DeliveryAction}
 * @see Visit {@link Actions.Delivery|Delivery} for an example
 */ class DeliveryFormatAction extends __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f40$cloudinary$2f$transformation$2d$builder$2d$sdk$2f$actions$2f$delivery$2f$DeliveryAction$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["DeliveryAction"] {
    constructor(deliveryKey, deliveryType){
        super(deliveryKey, deliveryType, 'formatType');
    }
    /**
     * @description Uses lossy compression when delivering animated GIF files.
     * @return {this}
     */ lossy() {
        this._actionModel.lossy = true;
        this.addFlag((0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f40$cloudinary$2f$transformation$2d$builder$2d$sdk$2f$qualifiers$2f$flag$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["lossy"])());
        return this;
    }
    /**
     * @description Uses progressive compression when delivering JPG file format.
     * @return {this}
     */ progressive(mode) {
        if (mode instanceof __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f40$cloudinary$2f$transformation$2d$builder$2d$sdk$2f$qualifiers$2f$progressive$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["ProgressiveQualifier"]) {
            this._actionModel.progressive = {
                mode: mode.getFlagValue()
            };
            this.addFlag(mode);
        } else {
            this._actionModel.progressive = {
                mode: mode
            };
            this.addFlag((0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f40$cloudinary$2f$transformation$2d$builder$2d$sdk$2f$qualifiers$2f$flag$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["progressive"])(mode));
        }
        return this;
    }
    /**
     * @description Ensures that images with a transparency channel are delivered in PNG format.
     */ preserveTransparency() {
        this._actionModel.preserveTransparency = true;
        this.addFlag((0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f40$cloudinary$2f$transformation$2d$builder$2d$sdk$2f$qualifiers$2f$flag$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["preserveTransparency"])());
        return this;
    }
    static fromJson(actionModel) {
        const { formatType, lossy, progressive, preserveTransparency } = actionModel;
        let result;
        if (formatType) {
            result = new this('f', formatType);
        } else {
            result = new this('f');
        }
        if (progressive) {
            if (progressive.mode) {
                result.progressive(progressive.mode);
            } else {
                result.progressive();
            }
        }
        lossy && result.lossy();
        preserveTransparency && result.preserveTransparency();
        return result;
    }
}
;

})()),
"[project]/node_modules/@cloudinary/transformation-builder-sdk/transformation/Transformation.js [app-ssr] (ecmascript)": (({ r: __turbopack_require__, f: __turbopack_module_context__, i: __turbopack_import__, s: __turbopack_esm__, v: __turbopack_export_value__, n: __turbopack_export_namespace__, c: __turbopack_cache__, M: __turbopack_modules__, l: __turbopack_load__, j: __turbopack_dynamic__, P: __turbopack_resolve_absolute_path__, U: __turbopack_relative_url__, R: __turbopack_resolve_module_id_path__, g: global, __dirname, x: __turbopack_external_require__, y: __turbopack_external_import__ }) => (() => {
"use strict";

__turbopack_esm__({
    "Transformation": ()=>Transformation
});
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f40$cloudinary$2f$transformation$2d$builder$2d$sdk$2f$internal$2f$Action$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_import__("[project]/node_modules/@cloudinary/transformation-builder-sdk/internal/Action.js [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f40$cloudinary$2f$transformation$2d$builder$2d$sdk$2f$actions$2f$background$2f$actions$2f$BackgroundColor$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_import__("[project]/node_modules/@cloudinary/transformation-builder-sdk/actions/background/actions/BackgroundColor.js [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f40$cloudinary$2f$transformation$2d$builder$2d$sdk$2f$qualifiers$2f$flag$2f$FlagQualifier$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_import__("[project]/node_modules/@cloudinary/transformation-builder-sdk/qualifiers/flag/FlagQualifier.js [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f40$cloudinary$2f$transformation$2d$builder$2d$sdk$2f$internal$2f$RawAction$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_import__("[project]/node_modules/@cloudinary/transformation-builder-sdk/internal/RawAction.js [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f40$cloudinary$2f$transformation$2d$builder$2d$sdk$2f$internal$2f$models$2f$IErrorObject$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_import__("[project]/node_modules/@cloudinary/transformation-builder-sdk/internal/models/IErrorObject.js [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f40$cloudinary$2f$transformation$2d$builder$2d$sdk$2f$actions$2f$delivery$2f$DeliveryFormatAction$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_import__("[project]/node_modules/@cloudinary/transformation-builder-sdk/actions/delivery/DeliveryFormatAction.js [app-ssr] (ecmascript)");
"__TURBOPACK__ecmascript__hoisting__location__";
;
;
;
;
;
;
/**
 * @summary SDK
 * @description - Defines how to transform an asset
 * @memberOf SDK
 */ class Transformation {
    constructor(){
        this.actions = [];
    }
    /**
     * @param {SDK.Action | string} action
     * @return {this}
     */ addAction(action) {
        let actionToAdd;
        if (typeof action === 'string') {
            if (action.indexOf('/') >= 0) {
                throw 'addAction cannot accept a string with a forward slash in it - /, use .addTransformation() instead';
            } else {
                actionToAdd = new __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f40$cloudinary$2f$transformation$2d$builder$2d$sdk$2f$internal$2f$RawAction$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["RawAction"](action);
            }
        } else {
            actionToAdd = action;
        }
        this.actions.push(actionToAdd);
        return this;
    }
    /**
     * @description Allows the injection of a raw transformation as a string into the transformation, or a Transformation instance that was previously created
     * @param {string | SDK.Transformation} tx
     * @example
     * import {Transformation} from "@cloudinary/url-gen";
     *
     * const transformation = new Transformation();
     * transformation.addTransformation('w_100/w_200/w_300');
     * @return {this}
     */ addTransformation(tx) {
        if (tx instanceof Transformation) {
            // Concat the new actions into the existing actions
            this.actions = this.actions.concat(tx.actions);
        } else {
            this.actions.push(new __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f40$cloudinary$2f$transformation$2d$builder$2d$sdk$2f$internal$2f$RawAction$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["RawAction"](tx));
        }
        return this;
    }
    /**
     * @return {string}
     */ toString() {
        return this.actions.map((action)=>{
            return action.toString();
        }).filter((a)=>a).join('/');
    }
    /**
     * @description Delivers an animated GIF.
     * @param {AnimatedAction} animatedAction
     * @return {this}
     */ animated(animatedAction) {
        return this.addAction(animatedAction);
    }
    /**
     * @description Adds a border around the image.
     * @param {Border} borderAction
     * @return {this}
     */ border(borderAction) {
        return this.addAction(borderAction);
    }
    /**
     * @description Adjusts the shape of the delivered image. </br>
     * <b>Learn more:</b> {@link https://cloudinary.com/documentation/effects_and_artistic_enhancements#distort|Shape changes and distortion effects}
     * @param {IReshape} reshapeAction
     * @return {this}
     */ reshape(reshapeAction) {
        return this.addAction(reshapeAction);
    }
    /**
     * @description Resize the asset using provided resize action
     * @param {ResizeSimpleAction} resizeAction
     * @return {this}
     */ resize(resizeAction) {
        return this.addAction(resizeAction);
    }
    /**
     * @desc An alias to Action Delivery.quality
     * @param {string|number} quality
     * @return {this}
     */ quality(quality) {
        this.addAction(new __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f40$cloudinary$2f$transformation$2d$builder$2d$sdk$2f$actions$2f$delivery$2f$DeliveryFormatAction$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["DeliveryFormatAction"]('q', quality));
        return this;
    }
    /**
     * @desc An alias to Action Delivery.format
     * @param {string} format
     * @return {this}
     */ format(format) {
        this.addAction(new __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f40$cloudinary$2f$transformation$2d$builder$2d$sdk$2f$actions$2f$delivery$2f$DeliveryFormatAction$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["DeliveryFormatAction"]('f', format));
        return this;
    }
    /**
     * @description Rounds the specified corners of an image.
     * @param roundCornersAction
     * @return {this}
     */ roundCorners(roundCornersAction) {
        return this.addAction(roundCornersAction);
    }
    /**
     * @description Adds an overlay over the base image.
     * @param {LayerAction} overlayAction
     * @return {this}
     */ overlay(overlayAction) {
        return this.addAction(overlayAction);
    }
    /**
     * @description Adds an underlay under the base image.
     * @param {LayerAction} underlayAction
     * @return {this}
     */ underlay(underlayAction) {
        underlayAction.setLayerType('u');
        return this.addAction(underlayAction);
    }
    /**
     * @description Defines an new user variable.
     * @param {VariableAction} variableAction
     * @return {this}
     */ addVariable(variableAction) {
        return this.addAction(variableAction);
    }
    /**
     * @description Specifies a condition to be met before applying a transformation.
     * @param {ConditionalAction} conditionAction
     * @return {this}
     */ conditional(conditionAction) {
        return this.addAction(conditionAction);
    }
    /**
     * @description Applies a filter or an effect on an asset.
     * @param {SimpleEffectAction} effectAction
     * @return {this}
     */ effect(effectAction) {
        return this.addAction(effectAction);
    }
    /**
     * @description Applies adjustment effect on an asset.
     * @param action
     * @return {this}
     */ adjust(action) {
        return this.addAction(action);
    }
    /**
     * @description Rotates the asset by the given angle.
     * @param {RotateAction} rotateAction
     * @return {this}
     */ rotate(rotateAction) {
        return this.addAction(rotateAction);
    }
    /**
     * @description Applies a pre-defined named transformation of the given name.
     * @param {NamedTransformation} namedTransformation
     * @return {this}
     */ namedTransformation(namedTransformation) {
        return this.addAction(namedTransformation);
    }
    /**
     * @description Applies delivery action.
     * @param deliveryAction
     * @return {this}
     */ delivery(deliveryAction) {
        return this.addAction(deliveryAction);
    }
    /**
     * @description Sets the color of the background.
     * @param {Qualifiers.Color} color
     * @return {this}
     */ backgroundColor(color) {
        return this.addAction(new __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f40$cloudinary$2f$transformation$2d$builder$2d$sdk$2f$actions$2f$background$2f$actions$2f$BackgroundColor$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["BackgroundColor"](color));
    }
    /**
     * @description Adds a layer in a Photoshop document.
     * @param action
     * @return {this}
     */ psdTools(action) {
        return this.addAction(action);
    }
    /**
     * @description Extracts an image or a page using an index, a range, or a name from a layered media asset.
     * @param action
     * @return {this}
     */ extract(action) {
        return this.addAction(action);
    }
    /**
     * @description Adds a flag as a separate action.
     * @param {Qualifiers.Flag | string} flagQualifier
     * @return {this}
     */ addFlag(flagQualifier) {
        const action = new __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f40$cloudinary$2f$transformation$2d$builder$2d$sdk$2f$internal$2f$Action$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["Action"]();
        let flagToAdd = flagQualifier;
        if (typeof flagQualifier === 'string') {
            flagToAdd = new __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f40$cloudinary$2f$transformation$2d$builder$2d$sdk$2f$qualifiers$2f$flag$2f$FlagQualifier$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["FlagQualifier"](flagQualifier);
        }
        action.addQualifier(flagToAdd);
        return this.addAction(action);
    }
    /**
     * @description Inject a custom function into the image transformation pipeline.
     * @return {this}
     */ customFunction(customFunction) {
        return this.addAction(customFunction);
    }
    /**
     * Transcodes the video (or audio) to another format.
     * @param {Action} action
     * @return {this}
     */ transcode(action) {
        return this.addAction(action);
    }
    /**
     * Applies the specified video edit action.
     *
     * @param {videoEditType} action
     * @return {this}
     */ videoEdit(action) {
        return this.addAction(action);
    }
    toJson() {
        const actions = [];
        for (const action of this.actions){
            const json = action.toJson();
            if ((0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f40$cloudinary$2f$transformation$2d$builder$2d$sdk$2f$internal$2f$models$2f$IErrorObject$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["isErrorObject"])(json)) {
                // Fail early and return an IErrorObject
                return json;
            }
            actions.push(json);
        }
        return {
            actions
        };
    }
}
;

})()),
"[project]/node_modules/@cloudinary/transformation-builder-sdk/transformation/ImageTransformation.js [app-ssr] (ecmascript)": (({ r: __turbopack_require__, f: __turbopack_module_context__, i: __turbopack_import__, s: __turbopack_esm__, v: __turbopack_export_value__, n: __turbopack_export_namespace__, c: __turbopack_cache__, M: __turbopack_modules__, l: __turbopack_load__, j: __turbopack_dynamic__, P: __turbopack_resolve_absolute_path__, U: __turbopack_relative_url__, R: __turbopack_resolve_module_id_path__, g: global, __dirname, x: __turbopack_external_require__, y: __turbopack_external_import__ }) => (() => {
"use strict";

__turbopack_esm__({
    "ImageTransformation": ()=>ImageTransformation
});
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f40$cloudinary$2f$transformation$2d$builder$2d$sdk$2f$transformation$2f$Transformation$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_import__("[project]/node_modules/@cloudinary/transformation-builder-sdk/transformation/Transformation.js [app-ssr] (ecmascript)");
"__TURBOPACK__ecmascript__hoisting__location__";
;
/**
 * @summary SDK
 * @extends {SDK.Transformation}
 * @memberOf SDK
 */ class ImageTransformation extends __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f40$cloudinary$2f$transformation$2d$builder$2d$sdk$2f$transformation$2f$Transformation$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["Transformation"] {
}
;

})()),
"[project]/node_modules/@cloudinary/transformation-builder-sdk/transformation/VideoTransformation.js [app-ssr] (ecmascript)": (({ r: __turbopack_require__, f: __turbopack_module_context__, i: __turbopack_import__, s: __turbopack_esm__, v: __turbopack_export_value__, n: __turbopack_export_namespace__, c: __turbopack_cache__, M: __turbopack_modules__, l: __turbopack_load__, j: __turbopack_dynamic__, P: __turbopack_resolve_absolute_path__, U: __turbopack_relative_url__, R: __turbopack_resolve_module_id_path__, g: global, __dirname, x: __turbopack_external_require__, y: __turbopack_external_import__ }) => (() => {
"use strict";

__turbopack_esm__({
    "VideoTransformation": ()=>VideoTransformation
});
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f40$cloudinary$2f$transformation$2d$builder$2d$sdk$2f$transformation$2f$Transformation$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_import__("[project]/node_modules/@cloudinary/transformation-builder-sdk/transformation/Transformation.js [app-ssr] (ecmascript)");
"__TURBOPACK__ecmascript__hoisting__location__";
;
/**
 * @summary SDK
 * @extends {SDK.Transformation}
 * @memberOf SDK
 */ class VideoTransformation extends __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f40$cloudinary$2f$transformation$2d$builder$2d$sdk$2f$transformation$2f$Transformation$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["Transformation"] {
}
;

})()),
"[project]/node_modules/@cloudinary/url-gen/internal/url/urlUtils/isUrl.js [app-ssr] (ecmascript)": (({ r: __turbopack_require__, f: __turbopack_module_context__, i: __turbopack_import__, s: __turbopack_esm__, v: __turbopack_export_value__, n: __turbopack_export_namespace__, c: __turbopack_cache__, M: __turbopack_modules__, l: __turbopack_load__, j: __turbopack_dynamic__, P: __turbopack_resolve_absolute_path__, U: __turbopack_relative_url__, R: __turbopack_resolve_module_id_path__, g: global, __dirname, x: __turbopack_external_require__, y: __turbopack_external_import__ }) => (() => {
"use strict";

/**
 *
 * @param publicID
 */ __turbopack_esm__({
    "isUrl": ()=>isUrl
});
function isUrl(publicID) {
    return publicID.match(/^https?:\//);
}

})()),
"[project]/node_modules/@cloudinary/url-gen/internal/url/urlUtils/isFileName.js [app-ssr] (ecmascript)": (({ r: __turbopack_require__, f: __turbopack_module_context__, i: __turbopack_import__, s: __turbopack_esm__, v: __turbopack_export_value__, n: __turbopack_export_namespace__, c: __turbopack_cache__, M: __turbopack_modules__, l: __turbopack_load__, j: __turbopack_dynamic__, P: __turbopack_resolve_absolute_path__, U: __turbopack_relative_url__, R: __turbopack_resolve_module_id_path__, g: global, __dirname, x: __turbopack_external_require__, y: __turbopack_external_import__ }) => (() => {
"use strict";

/**
 *
 * @param publicID
 */ __turbopack_esm__({
    "isFileName": ()=>isFileName
});
function isFileName(publicID) {
    return publicID.indexOf('/') < 0;
}

})()),
"[project]/node_modules/@cloudinary/url-gen/internal/url/urlUtils/publicIDContainsVersion.js [app-ssr] (ecmascript)": (({ r: __turbopack_require__, f: __turbopack_module_context__, i: __turbopack_import__, s: __turbopack_esm__, v: __turbopack_export_value__, n: __turbopack_export_namespace__, c: __turbopack_cache__, M: __turbopack_modules__, l: __turbopack_load__, j: __turbopack_dynamic__, P: __turbopack_resolve_absolute_path__, U: __turbopack_relative_url__, R: __turbopack_resolve_module_id_path__, g: global, __dirname, x: __turbopack_external_require__, y: __turbopack_external_import__ }) => (() => {
"use strict";

/**
 *
 * @param publicID
 */ __turbopack_esm__({
    "publicIDContainsVersion": ()=>publicIDContainsVersion
});
function publicIDContainsVersion(publicID) {
    return publicID.match(/^v[0-9]+/);
}

})()),
"[project]/node_modules/@cloudinary/url-gen/internal/url/cloudinaryURL.js [app-ssr] (ecmascript)": (({ r: __turbopack_require__, f: __turbopack_module_context__, i: __turbopack_import__, s: __turbopack_esm__, v: __turbopack_export_value__, n: __turbopack_export_namespace__, c: __turbopack_cache__, M: __turbopack_modules__, l: __turbopack_load__, j: __turbopack_dynamic__, P: __turbopack_resolve_absolute_path__, U: __turbopack_relative_url__, R: __turbopack_resolve_module_id_path__, g: global, __dirname, x: __turbopack_external_require__, y: __turbopack_external_import__ }) => (() => {
"use strict";

__turbopack_esm__({
    "getUrlPrefix": ()=>getUrlPrefix,
    "getUrlVersion": ()=>getUrlVersion,
    "handleAssetType": ()=>handleAssetType,
    "handleDeliveryType": ()=>handleDeliveryType
});
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f40$cloudinary$2f$url$2d$gen$2f$internal$2f$url$2f$urlUtils$2f$isUrl$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_import__("[project]/node_modules/@cloudinary/url-gen/internal/url/urlUtils/isUrl.js [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f40$cloudinary$2f$url$2d$gen$2f$internal$2f$url$2f$urlUtils$2f$isFileName$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_import__("[project]/node_modules/@cloudinary/url-gen/internal/url/urlUtils/isFileName.js [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f40$cloudinary$2f$url$2d$gen$2f$internal$2f$url$2f$urlUtils$2f$publicIDContainsVersion$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_import__("[project]/node_modules/@cloudinary/url-gen/internal/url/urlUtils/publicIDContainsVersion.js [app-ssr] (ecmascript)");
"__TURBOPACK__ecmascript__hoisting__location__";
;
;
;
/**
 * Create the URL prefix for Cloudinary resources.
 * Available use cases
 * http://res.cloudinary.com/{cloudName}
 * https://res.cloudinary.com/{cloudName}
 * https://{cloudName}-res.cloudinary.com/
 * http://{domain}/${cloudName}
 * https://{domain}/${cloudName}
 * https://{domain}
 * @private
 *
 * @param {string} cloudName
 * @param {IURLConfig} urlConfig
 */ function getUrlPrefix(cloudName, urlConfig) {
    const secure = urlConfig.secure;
    const privateCDN = urlConfig.privateCdn;
    const cname = urlConfig.cname;
    const secureDistribution = urlConfig.secureDistribution;
    if (!secure && !cname) {
        return `http://res.cloudinary.com/${cloudName}`;
    }
    if (secure && !secureDistribution && privateCDN) {
        return `https://${cloudName}-res.cloudinary.com`;
    }
    if (secure && !secureDistribution) {
        return `https://res.cloudinary.com/${cloudName}`;
    }
    if (secure && secureDistribution && privateCDN) {
        return `https://${secureDistribution}`;
    }
    if (secure && secureDistribution) {
        return `https://${secureDistribution}/${cloudName}`;
    }
    if (!secure && cname) {
        return `http://${cname}/${cloudName}`;
    } else {
        return 'ERROR';
    }
}
/**
 * @private
 * @param assetType
 */ function handleAssetType(assetType) {
    //default to image
    if (!assetType) {
        return 'image';
    }
    return assetType;
}
/**
 * @private
 * @param deliveryType
 */ function handleDeliveryType(deliveryType) {
    //default to upload
    if (!deliveryType) {
        return 'upload';
    }
    return deliveryType;
}
/**
 *
 * @param {string} publicID
 * @param {number} version
 * @param {boolean} forceVersion
 */ function getUrlVersion(publicID, version, forceVersion) {
    const shouldForceVersion = forceVersion !== false;
    if (version) {
        return `v${version}`;
    }
    // In all these conditions we never force a version
    if ((0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f40$cloudinary$2f$url$2d$gen$2f$internal$2f$url$2f$urlUtils$2f$publicIDContainsVersion$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["publicIDContainsVersion"])(publicID) || (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f40$cloudinary$2f$url$2d$gen$2f$internal$2f$url$2f$urlUtils$2f$isUrl$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["isUrl"])(publicID) || (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f40$cloudinary$2f$url$2d$gen$2f$internal$2f$url$2f$urlUtils$2f$isFileName$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["isFileName"])(publicID)) {
        return '';
    }
    return shouldForceVersion ? 'v1' : '';
}
;

})()),
"[project]/node_modules/@cloudinary/url-gen/config/BaseConfig.js [app-ssr] (ecmascript)": (({ r: __turbopack_require__, f: __turbopack_module_context__, i: __turbopack_import__, s: __turbopack_esm__, v: __turbopack_export_value__, n: __turbopack_export_namespace__, c: __turbopack_cache__, M: __turbopack_modules__, l: __turbopack_load__, j: __turbopack_dynamic__, P: __turbopack_resolve_absolute_path__, U: __turbopack_relative_url__, R: __turbopack_resolve_module_id_path__, g: global, __dirname, x: __turbopack_external_require__, y: __turbopack_external_import__ }) => (() => {
"use strict";

/**
 *
 * @private
 * @param {any} a
 */ __turbopack_esm__({
    "default": ()=>__TURBOPACK__default__export__
});
function isObject(a) {
    if (typeof a !== 'object' || a instanceof Array) {
        return false;
    } else {
        return true;
    }
}
class Config {
    filterOutNonSupportedKeys(userProvidedConfig, validKeys) {
        const obj = Object.create({});
        if (isObject(userProvidedConfig)) {
            Object.keys(userProvidedConfig).forEach((key)=>{
                if (validKeys.indexOf(key) >= 0) {
                    obj[key] = userProvidedConfig[key];
                } else {
                    console.warn('Warning - unsupported key provided to configuration: ', key);
                }
            });
            return obj;
        } else {
            return Object.create({});
        }
    }
}
const __TURBOPACK__default__export__ = Config;

})()),
"[project]/node_modules/@cloudinary/url-gen/internal/internalConstants.js [app-ssr] (ecmascript)": (({ r: __turbopack_require__, f: __turbopack_module_context__, i: __turbopack_import__, s: __turbopack_esm__, v: __turbopack_export_value__, n: __turbopack_export_namespace__, c: __turbopack_cache__, M: __turbopack_modules__, l: __turbopack_load__, j: __turbopack_dynamic__, P: __turbopack_resolve_absolute_path__, U: __turbopack_relative_url__, R: __turbopack_resolve_module_id_path__, g: global, __dirname, x: __turbopack_external_require__, y: __turbopack_external_import__ }) => (() => {
"use strict";

/**
 * This file is for internal constants only.
 * It is not intended for public use and is not part of the public API
 */ /**
 * @private
 */ __turbopack_esm__({
    "ALLOWED_CLOUD_CONFIG": ()=>ALLOWED_CLOUD_CONFIG,
    "ALLOWED_URL_CONFIG": ()=>ALLOWED_URL_CONFIG
});
const ALLOWED_URL_CONFIG = [
    'cname',
    'secureDistribution',
    'privateCdn',
    'signUrl',
    'longUrlSignature',
    'shorten',
    'useRootPath',
    'secure',
    'forceVersion',
    'analytics',
    'queryParams'
];
const ALLOWED_CLOUD_CONFIG = [
    'cloudName',
    'apiKey',
    'apiSecret',
    'authToken'
];

})()),
"[project]/node_modules/@cloudinary/url-gen/config/URLConfig.js [app-ssr] (ecmascript)": (({ r: __turbopack_require__, f: __turbopack_module_context__, i: __turbopack_import__, s: __turbopack_esm__, v: __turbopack_export_value__, n: __turbopack_export_namespace__, c: __turbopack_cache__, M: __turbopack_modules__, l: __turbopack_load__, j: __turbopack_dynamic__, P: __turbopack_resolve_absolute_path__, U: __turbopack_relative_url__, R: __turbopack_resolve_module_id_path__, g: global, __dirname, x: __turbopack_external_require__, y: __turbopack_external_import__ }) => (() => {
"use strict";

__turbopack_esm__({
    "default": ()=>__TURBOPACK__default__export__
});
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f40$cloudinary$2f$url$2d$gen$2f$config$2f$BaseConfig$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_import__("[project]/node_modules/@cloudinary/url-gen/config/BaseConfig.js [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f40$cloudinary$2f$url$2d$gen$2f$internal$2f$internalConstants$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_import__("[project]/node_modules/@cloudinary/url-gen/internal/internalConstants.js [app-ssr] (ecmascript)");
"__TURBOPACK__ecmascript__hoisting__location__";
;
;
class URLConfig extends __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f40$cloudinary$2f$url$2d$gen$2f$config$2f$BaseConfig$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["default"] {
    /**
     * @param {IURLConfig} userURLConfig
     */ constructor(userURLConfig){
        super();
        const urlConfig = this.filterOutNonSupportedKeys(userURLConfig, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f40$cloudinary$2f$url$2d$gen$2f$internal$2f$internalConstants$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["ALLOWED_URL_CONFIG"]);
        Object.assign(this, {
            secure: true
        }, urlConfig);
    }
    extend(userURLConfig) {
        const urlConfig = this.filterOutNonSupportedKeys(userURLConfig, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f40$cloudinary$2f$url$2d$gen$2f$internal$2f$internalConstants$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["ALLOWED_URL_CONFIG"]);
        return new URLConfig(Object.assign({}, this, urlConfig));
    }
    /**
     * @param {string} value Sets the cname
     */ setCname(value) {
        this.cname = value;
        return this;
    }
    /**
     * @param {string} value Sets the secureDistribution
     */ setSecureDistribution(value) {
        this.secureDistribution = value;
        return this;
    }
    /**
     * @param {boolean} value Sets whether to use a private CDN (Removes cloudName from URL)
     */ setPrivateCdn(value) {
        this.privateCdn = value;
        return this;
    }
    /**
     * @param value Sets whether or not to sign the URL
     */ setSignUrl(value) {
        this.signUrl = value;
        return this;
    }
    /**
     * @param value Sets whether or not to use a long signature
     */ setLongUrlSignature(value) {
        this.longUrlSignature = value;
        return this;
    }
    /**
     * @param value Sets whether or not to shorten the URL
     */ setShorten(value) {
        this.shorten = value;
        return this;
    }
    /**
     * @param value Sets whether or not to use a root path
     */ setUseRootPath(value) {
        this.useRootPath = value;
        return this;
    }
    /**
     * @param value Sets whether or not to deliver the asset through https
     */ setSecure(value) {
        this.secure = value;
        return this;
    }
    /**
     * @param value Sets whether to force a version in the URL
     */ setForceVersion(value) {
        this.forceVersion = value;
        return this;
    }
    /**
     * @param params Sets additional params
     */ setQueryParams(params) {
        this.queryParams = params;
        return this;
    }
}
const __TURBOPACK__default__export__ = URLConfig;

})()),
"[project]/node_modules/@cloudinary/url-gen/sdkAnalytics/stringPad.js [app-ssr] (ecmascript)": (({ r: __turbopack_require__, f: __turbopack_module_context__, i: __turbopack_import__, s: __turbopack_esm__, v: __turbopack_export_value__, n: __turbopack_export_namespace__, c: __turbopack_cache__, M: __turbopack_modules__, l: __turbopack_load__, j: __turbopack_dynamic__, P: __turbopack_resolve_absolute_path__, U: __turbopack_relative_url__, R: __turbopack_resolve_module_id_path__, g: global, __dirname, x: __turbopack_external_require__, y: __turbopack_external_import__ }) => (() => {
"use strict";

/**
 * @private
 * @description Adds left padding to a string with the desired substring the provided number of times
 * @example stringPad(foo, 3, 'a'') // -> aaafoo
 * @param {string} value
 * @param {number} _targetLength
 * @param {string} _padString
 */ __turbopack_esm__({
    "stringPad": ()=>stringPad
});
function stringPad(value, _targetLength, _padString) {
    let targetLength = _targetLength >> 0; //truncate if number or convert non-number to 0;
    let padString = String(typeof _padString !== 'undefined' ? _padString : ' ');
    if (value.length > targetLength) {
        return String(value);
    } else {
        targetLength = targetLength - value.length;
        if (targetLength > padString.length) {
            padString += repeatStringNumTimes(padString, targetLength / padString.length);
        }
        return padString.slice(0, targetLength) + String(value);
    }
}
/**
 * @description Repeat a string multiple times, cross-browser-safe alternative to string.repeat()
 * @param string
 * @param _times
 */ function repeatStringNumTimes(string, _times) {
    let times = _times;
    let repeatedString = "";
    while(times > 0){
        repeatedString += string;
        times--;
    }
    return repeatedString;
}

})()),
"[project]/node_modules/@cloudinary/url-gen/sdkAnalytics/base64Map.js [app-ssr] (ecmascript)": (({ r: __turbopack_require__, f: __turbopack_module_context__, i: __turbopack_import__, s: __turbopack_esm__, v: __turbopack_export_value__, n: __turbopack_export_namespace__, c: __turbopack_cache__, M: __turbopack_modules__, l: __turbopack_load__, j: __turbopack_dynamic__, P: __turbopack_resolve_absolute_path__, U: __turbopack_relative_url__, R: __turbopack_resolve_module_id_path__, g: global, __dirname, x: __turbopack_external_require__, y: __turbopack_external_import__ }) => (() => {
"use strict";

__turbopack_esm__({
    "base64Map": ()=>base64Map
});
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f40$cloudinary$2f$url$2d$gen$2f$sdkAnalytics$2f$stringPad$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_import__("[project]/node_modules/@cloudinary/url-gen/sdkAnalytics/stringPad.js [app-ssr] (ecmascript)");
"__TURBOPACK__ecmascript__hoisting__location__";
;
/**
 * This file maps sequences of 6 bit binary digits to a character in base64.
 * 000000 -> A
 * 110011 -> Z
 * 111111 -> /
 */ const chars = 'ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/';
const base64Map = {};
let num = 0;
chars.split('').forEach((char)=>{
    let key = num.toString(2);
    key = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f40$cloudinary$2f$url$2d$gen$2f$sdkAnalytics$2f$stringPad$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["stringPad"])(key, 6, '0');
    base64Map[key] = char;
    num++;
});
;

})()),
"[project]/node_modules/@cloudinary/url-gen/sdkAnalytics/reverseVersion.js [app-ssr] (ecmascript)": (({ r: __turbopack_require__, f: __turbopack_module_context__, i: __turbopack_import__, s: __turbopack_esm__, v: __turbopack_export_value__, n: __turbopack_export_namespace__, c: __turbopack_cache__, M: __turbopack_modules__, l: __turbopack_load__, j: __turbopack_dynamic__, P: __turbopack_resolve_absolute_path__, U: __turbopack_relative_url__, R: __turbopack_resolve_module_id_path__, g: global, __dirname, x: __turbopack_external_require__, y: __turbopack_external_import__ }) => (() => {
"use strict";

__turbopack_esm__({
    "reverseVersion": ()=>reverseVersion
});
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f40$cloudinary$2f$url$2d$gen$2f$sdkAnalytics$2f$stringPad$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_import__("[project]/node_modules/@cloudinary/url-gen/sdkAnalytics/stringPad.js [app-ssr] (ecmascript)");
"__TURBOPACK__ecmascript__hoisting__location__";
;
function reverseVersion(semVer) {
    if (semVer.split('.').length < 2) {
        throw new Error('invalid semVer, must have at least two segments');
    }
    // Split by '.', reverse, create new array with padded values and concat it together
    return semVer.split('.').reverse().map((segment)=>{
        // try to cast to number
        const asNumber = +segment;
        if (isNaN(asNumber) || asNumber < 0) {
            throw 'Invalid version number provided';
        }
        return (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f40$cloudinary$2f$url$2d$gen$2f$sdkAnalytics$2f$stringPad$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["stringPad"])(segment, 2, '0');
    }).join('.');
}

})()),
"[project]/node_modules/@cloudinary/url-gen/sdkAnalytics/encodeVersion.js [app-ssr] (ecmascript)": (({ r: __turbopack_require__, f: __turbopack_module_context__, i: __turbopack_import__, s: __turbopack_esm__, v: __turbopack_export_value__, n: __turbopack_export_namespace__, c: __turbopack_cache__, M: __turbopack_modules__, l: __turbopack_load__, j: __turbopack_dynamic__, P: __turbopack_resolve_absolute_path__, U: __turbopack_relative_url__, R: __turbopack_resolve_module_id_path__, g: global, __dirname, x: __turbopack_external_require__, y: __turbopack_external_import__ }) => (() => {
"use strict";

__turbopack_esm__({
    "encodeVersion": ()=>encodeVersion
});
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f40$cloudinary$2f$url$2d$gen$2f$sdkAnalytics$2f$base64Map$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_import__("[project]/node_modules/@cloudinary/url-gen/sdkAnalytics/base64Map.js [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f40$cloudinary$2f$url$2d$gen$2f$sdkAnalytics$2f$stringPad$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_import__("[project]/node_modules/@cloudinary/url-gen/sdkAnalytics/stringPad.js [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f40$cloudinary$2f$url$2d$gen$2f$sdkAnalytics$2f$reverseVersion$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_import__("[project]/node_modules/@cloudinary/url-gen/sdkAnalytics/reverseVersion.js [app-ssr] (ecmascript)");
"__TURBOPACK__ecmascript__hoisting__location__";
;
;
;
function encodeVersion(semVer) {
    let strResult = '';
    // support x.y or x.y.z by using 'parts' as a variable
    const parts = semVer.split('.').length;
    const paddedStringLength = parts * 6; // we pad to either 12 or 18 characters
    // reverse (but don't mirror) the version. 1.5.15 -> 15.5.1
    // Pad to two spaces, 15.5.1 -> 15.05.01
    const paddedReversedSemver = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f40$cloudinary$2f$url$2d$gen$2f$sdkAnalytics$2f$reverseVersion$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["reverseVersion"])(semVer);
    // turn 15.05.01 to a string '150501' then to a number 150501
    const num = parseInt(paddedReversedSemver.split('.').join(''));
    // Represent as binary, add left padding to 12 or 18 characters.
    // 150,501 -> 100100101111100101
    let paddedBinary = num.toString(2);
    paddedBinary = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f40$cloudinary$2f$url$2d$gen$2f$sdkAnalytics$2f$stringPad$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["stringPad"])(paddedBinary, paddedStringLength, '0');
    // Stop in case an invalid version number was provided
    // paddedBinary must be built from sections of 6 bits
    if (paddedBinary.length % 6 !== 0) {
        throw 'Version must be smaller than 43.21.26)';
    }
    // turn every 6 bits into a character using the base64Map
    paddedBinary.match(/.{1,6}/g).forEach((bitString)=>{
        // console.log(bitString);
        strResult += __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f40$cloudinary$2f$url$2d$gen$2f$sdkAnalytics$2f$base64Map$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["base64Map"][bitString];
    });
    return strResult;
}

})()),
"[project]/node_modules/@cloudinary/url-gen/sdkAnalytics/getAnalyticsOptions.js [app-ssr] (ecmascript)": (({ r: __turbopack_require__, f: __turbopack_module_context__, i: __turbopack_import__, s: __turbopack_esm__, v: __turbopack_export_value__, n: __turbopack_export_namespace__, c: __turbopack_cache__, M: __turbopack_modules__, l: __turbopack_load__, j: __turbopack_dynamic__, P: __turbopack_resolve_absolute_path__, U: __turbopack_relative_url__, R: __turbopack_resolve_module_id_path__, g: global, __dirname, x: __turbopack_external_require__, y: __turbopack_external_import__ }) => (() => {
"use strict";

/**
 * @private
 * @description Gets the analyticsOptions from options- should include sdkSemver, techVersion, sdkCode, and feature
 * @param {ITrackedPropertiesThroughAnalytics} options
 * @returns {IAnalyticsOptions}
 */ __turbopack_esm__({
    "getAnalyticsOptions": ()=>getAnalyticsOptions
});
function getAnalyticsOptions(options) {
    const analyticsOptions = {
        sdkSemver: options.sdkSemver,
        techVersion: options.techVersion,
        sdkCode: options.sdkCode,
        product: options.product,
        feature: '0'
    };
    if (options.accessibility) {
        analyticsOptions.feature = 'D';
    }
    if (options.lazyload) {
        analyticsOptions.feature = 'C';
    }
    if (options.responsive) {
        analyticsOptions.feature = 'A';
    }
    if (options.placeholder) {
        analyticsOptions.feature = 'B';
    }
    return analyticsOptions;
}

})()),
"[project]/node_modules/@cloudinary/url-gen/internal/utils/packageVersion.js [app-ssr] (ecmascript)": (({ r: __turbopack_require__, f: __turbopack_module_context__, i: __turbopack_import__, s: __turbopack_esm__, v: __turbopack_export_value__, n: __turbopack_export_namespace__, c: __turbopack_cache__, M: __turbopack_modules__, l: __turbopack_load__, j: __turbopack_dynamic__, P: __turbopack_resolve_absolute_path__, U: __turbopack_relative_url__, R: __turbopack_resolve_module_id_path__, g: global, __dirname, x: __turbopack_external_require__, y: __turbopack_external_import__ }) => (() => {
"use strict";

__turbopack_esm__({
    "packageVersion": ()=>packageVersion
});
const packageVersion = '1.15.0';
;

})()),
"[project]/node_modules/@cloudinary/url-gen/sdkAnalytics/getSDKAnalyticsSignature.js [app-ssr] (ecmascript)": (({ r: __turbopack_require__, f: __turbopack_module_context__, i: __turbopack_import__, s: __turbopack_esm__, v: __turbopack_export_value__, n: __turbopack_export_namespace__, c: __turbopack_cache__, M: __turbopack_modules__, l: __turbopack_load__, j: __turbopack_dynamic__, P: __turbopack_resolve_absolute_path__, U: __turbopack_relative_url__, R: __turbopack_resolve_module_id_path__, g: global, __dirname, x: __turbopack_external_require__, y: __turbopack_external_import__ }) => (() => {
"use strict";

__turbopack_esm__({
    "getSDKAnalyticsSignature": ()=>getSDKAnalyticsSignature
});
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f40$cloudinary$2f$url$2d$gen$2f$sdkAnalytics$2f$encodeVersion$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_import__("[project]/node_modules/@cloudinary/url-gen/sdkAnalytics/encodeVersion.js [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f40$cloudinary$2f$url$2d$gen$2f$sdkAnalytics$2f$getAnalyticsOptions$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_import__("[project]/node_modules/@cloudinary/url-gen/sdkAnalytics/getAnalyticsOptions.js [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f40$cloudinary$2f$url$2d$gen$2f$internal$2f$utils$2f$packageVersion$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_import__("[project]/node_modules/@cloudinary/url-gen/internal/utils/packageVersion.js [app-ssr] (ecmascript)");
"__TURBOPACK__ecmascript__hoisting__location__";
;
;
;
/**
 * @private
 * @description Try to get the node version out of process, if browser just return 0.0.0
 */ function getNodeVersion() {
    const failedVersion = '0.0.0';
    if (typeof window !== 'undefined') {
        return failedVersion;
    } else {
        // node env
        try {
            return process.versions.node || failedVersion;
        } catch (e) {
            return failedVersion;
        }
    }
}
/**
 * @private
 * @description Ensure that all values ITrackedPropertiesThroughAnalytics are populated.
 * Accept a partial map of values and returns the complete interface of ITrackedPropertiesThroughAnalytics
 * @param {ITrackedPropertiesThroughAnalytics} trackedAnalytics
 * @param {ITrackedPropertiesThroughAnalytics} trackedAnalytics
 */ function ensureShapeOfTrackedProperties(trackedAnalytics) {
    // try to get the process version from node, but if we're on the client return 0.0.0
    const defaults = {
        techVersion: getNodeVersion(),
        sdkCode: 'T',
        sdkSemver: __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f40$cloudinary$2f$url$2d$gen$2f$internal$2f$utils$2f$packageVersion$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["packageVersion"].split('-')[0],
        product: 'A',
        responsive: false,
        placeholder: false,
        lazyload: false,
        accessibility: false
    };
    if (!trackedAnalytics) {
        return defaults;
    } else {
        return Object.assign(Object.assign({}, defaults), trackedAnalytics);
    }
}
function getSDKAnalyticsSignature(_trackedAnalytics) {
    const trackedAnalytics = ensureShapeOfTrackedProperties(_trackedAnalytics);
    const analyticsOptions = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f40$cloudinary$2f$url$2d$gen$2f$sdkAnalytics$2f$getAnalyticsOptions$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["getAnalyticsOptions"])(trackedAnalytics);
    try {
        const twoPartVersion = removePatchFromSemver(analyticsOptions.techVersion);
        const encodedSDKVersion = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f40$cloudinary$2f$url$2d$gen$2f$sdkAnalytics$2f$encodeVersion$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["encodeVersion"])(analyticsOptions.sdkSemver);
        const encodedTechVersion = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f40$cloudinary$2f$url$2d$gen$2f$sdkAnalytics$2f$encodeVersion$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["encodeVersion"])(twoPartVersion);
        const featureCode = analyticsOptions.feature;
        const SDKCode = analyticsOptions.sdkCode;
        const product = analyticsOptions.product;
        const algoVersion = 'B'; // The algo version is determined here, it should not be an argument
        return `${algoVersion}${product}${SDKCode}${encodedSDKVersion}${encodedTechVersion}${featureCode}`;
    } catch (e) {
        // Either SDK or Node versions were unparsable
        return 'E';
    }
}
/**
 * @private
 * @description Removes patch version from the semver if it exists
 *              Turns x.y.z OR x.y into x.y
 * @param {'x.y.z' | 'x.y' | string} semVerStr
 */ function removePatchFromSemver(semVerStr) {
    const parts = semVerStr.split('.');
    return `${parts[0]}.${parts[1]}`;
}

})()),
"[project]/node_modules/@cloudinary/url-gen/assets/CloudinaryFile.js [app-ssr] (ecmascript)": (({ r: __turbopack_require__, f: __turbopack_module_context__, i: __turbopack_import__, s: __turbopack_esm__, v: __turbopack_export_value__, n: __turbopack_export_namespace__, c: __turbopack_cache__, M: __turbopack_modules__, l: __turbopack_load__, j: __turbopack_dynamic__, P: __turbopack_resolve_absolute_path__, U: __turbopack_relative_url__, R: __turbopack_resolve_module_id_path__, g: global, __dirname, x: __turbopack_external_require__, y: __turbopack_external_import__ }) => (() => {
"use strict";

__turbopack_esm__({
    "CloudinaryFile": ()=>CloudinaryFile,
    "SEO_TYPES": ()=>SEO_TYPES
});
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f40$cloudinary$2f$url$2d$gen$2f$internal$2f$url$2f$cloudinaryURL$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_import__("[project]/node_modules/@cloudinary/url-gen/internal/url/cloudinaryURL.js [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f40$cloudinary$2f$url$2d$gen$2f$config$2f$URLConfig$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_import__("[project]/node_modules/@cloudinary/url-gen/config/URLConfig.js [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f40$cloudinary$2f$url$2d$gen$2f$sdkAnalytics$2f$getSDKAnalyticsSignature$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_import__("[project]/node_modules/@cloudinary/url-gen/sdkAnalytics/getSDKAnalyticsSignature.js [app-ssr] (ecmascript)");
"__TURBOPACK__ecmascript__hoisting__location__";
;
;
;
const SEO_TYPES = {
    "image/upload": "images",
    "image/private": "private_images",
    "image/authenticated": "authenticated_images",
    "raw/upload": "files",
    "video/upload": "videos"
};
/**
 * @description Cloudinary file without a transformation
 * @summary SDK
 * @memberOf SDK
 */ class CloudinaryFile {
    constructor(publicID, cloudConfig = {}, urlConfig){
        this.setPublicID(publicID);
        this.setCloudConfig(cloudConfig);
        this.setURLConfig(urlConfig);
    }
    /**
     * @description Sets the URL Config for this asset
     * @param urlConfig
     * @return {this}
     */ setURLConfig(urlConfig) {
        this.urlConfig = new __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f40$cloudinary$2f$url$2d$gen$2f$config$2f$URLConfig$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["default"](urlConfig);
        return this;
    }
    /**
     * @description Sets the Cloud Config for this asset
     * @param urlConfig
     * @return {this}
     */ setCloudConfig(cloudConfig) {
        this.cloudName = cloudConfig.cloudName;
        this.apiKey = cloudConfig.apiKey;
        this.apiSecret = cloudConfig.apiSecret;
        this.authToken = cloudConfig.authToken;
        return this;
    }
    /**
     * @description Sets the public ID of the asset.
     * @param {string} publicID The public ID of the asset.
     * @return {this}
     */ setPublicID(publicID) {
        // PublicID must be a string!
        this.publicID = publicID ? publicID.toString() : '';
        return this;
    }
    /**
     * @description Sets the delivery type of the asset.
     * @param {DELIVERY_TYPE | string} newType The type of the asset.
     * @return {this}
     */ setDeliveryType(newType) {
        this.deliveryType = newType;
        return this;
    }
    /**
     * @description Sets the URL SEO suffix of the asset.
     * @param {string} newSuffix The SEO suffix.
     * @return {this}
     */ setSuffix(newSuffix) {
        this.suffix = newSuffix;
        return this;
    }
    /**
     * @description Sets the signature of the asset.
     * @param {string} signature The signature.
     * @return {this}
     */ setSignature(signature) {
        this.signature = signature;
        return this;
    }
    /**
     * @description Sets the version of the asset.
     * @param {string} newVersion The version of the asset.
     * @return {this}
     */ setVersion(newVersion) {
        if (newVersion) {
            this.version = newVersion;
        }
        return this;
    }
    /**
     * @description Sets the asset type.
     * @param {string} newType The type of the asset.
     * @return {this}
     */ setAssetType(newType) {
        if (newType) {
            this.assetType = newType;
        }
        return this;
    }
    sign() {
        return this;
    }
    /**
     * @description Serializes to URL string
     * @param overwriteOptions
     */ toURL(overwriteOptions = {}) {
        return this.createCloudinaryURL(null, overwriteOptions.trackedAnalytics);
    }
    /**
     * @description Validate various options before attempting to create a URL
     * The function will throw in case a violation
     * @throws Validation errors
     */ validateAssetForURLCreation() {
        if (typeof this.cloudName === 'undefined') {
            throw 'You must supply a cloudName when initializing the asset';
        }
        const suffixContainsDot = this.suffix && this.suffix.indexOf('.') >= 0;
        const suffixContainsSlash = this.suffix && this.suffix.indexOf('/') >= 0;
        if (suffixContainsDot || suffixContainsSlash) {
            throw '`suffix`` should not include . or /';
        }
    }
    /**
     * @description return an SEO friendly name for a combination of asset/delivery, some examples:
     * * image/upload -> images
     * * video/upload -> videos
     * If no match is found, return `{asset}/{delivery}`
     */ getResourceType() {
        const assetType = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f40$cloudinary$2f$url$2d$gen$2f$internal$2f$url$2f$cloudinaryURL$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["handleAssetType"])(this.assetType);
        const deliveryType = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f40$cloudinary$2f$url$2d$gen$2f$internal$2f$url$2f$cloudinaryURL$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["handleDeliveryType"])(this.deliveryType);
        const hasSuffix = !!this.suffix;
        const regularSEOType = `${assetType}/${deliveryType}`;
        const shortSEOType = SEO_TYPES[`${assetType}/${deliveryType}`];
        const useRootPath = this.urlConfig.useRootPath;
        const shorten = this.urlConfig.shorten;
        // Quick exit incase of useRootPath
        if (useRootPath) {
            if (regularSEOType === 'image/upload') {
                return ''; // For image/upload we're done, just return nothing
            } else {
                throw new Error(`useRootPath can only be used with assetType: 'image' and deliveryType: 'upload'. Provided: ${regularSEOType} instead`);
            }
        }
        if (shorten && regularSEOType === 'image/upload') {
            return 'iu';
        }
        if (hasSuffix) {
            if (shortSEOType) {
                return shortSEOType;
            } else {
                throw new Error(`URL Suffix only supported for ${Object.keys(SEO_TYPES).join(', ')}, Provided: ${regularSEOType} instead`);
            }
        }
        // If all else fails, return the regular image/upload combination (asset/delivery)
        return regularSEOType;
    }
    getSignature() {
        if (this.signature) {
            return `s--${this.signature}--`;
        } else {
            return '';
        }
    }
    /**
     *
     * @description Creates a fully qualified CloudinaryURL
     * @return {string} CloudinaryURL
     * @throws Validation Errors
     */ createCloudinaryURL(transformation, trackedAnalytics) {
        // In accordance with the existing implementation, if no publicID exists we should return nothing.
        if (!this.publicID) {
            return '';
        }
        // Throws if some options are mis-configured
        // See the function for more information on when it throws
        this.validateAssetForURLCreation();
        const prefix = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f40$cloudinary$2f$url$2d$gen$2f$internal$2f$url$2f$cloudinaryURL$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["getUrlPrefix"])(this.cloudName, this.urlConfig);
        const transformationString = transformation ? transformation.toString() : '';
        const version = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f40$cloudinary$2f$url$2d$gen$2f$internal$2f$url$2f$cloudinaryURL$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["getUrlVersion"])(this.publicID, this.version, this.urlConfig.forceVersion);
        const publicID = this.publicID;
        if (typeof transformation === 'string') {
            const url = [
                prefix,
                this.getResourceType(),
                this.getSignature(),
                transformationString,
                version,
                publicID.replace(/,/g, '%2C'),
                this.suffix
            ].filter((a)=>a).join('/');
            return url;
        } else {
            // Avoid applying encodeURI on entire string in case where we have transformations with comma (i.e. f_auto,q_auto)
            // Since encodeURI does not encode commas we replace commas *only* on the publicID
            const safeURL = [
                encodeURI(prefix),
                this.getResourceType(),
                this.getSignature(),
                encodeURI(transformationString),
                version,
                encodeURI(publicID).replace(/,/g, '%2C'),
                this.suffix && encodeURI(this.suffix)
            ].filter((a)=>a).join('/').replace(/\?/g, '%3F').replace(/=/g, '%3D');
            const shouldAddAnalytics = this.urlConfig.analytics !== false && !publicID.includes('?');
            let queryParamsString = '';
            if (typeof this.urlConfig.queryParams === 'object') {
                try {
                    const queryParams = new URLSearchParams(this.urlConfig.queryParams);
                    if (shouldAddAnalytics) {
                        queryParams.set("_a", (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f40$cloudinary$2f$url$2d$gen$2f$sdkAnalytics$2f$getSDKAnalyticsSignature$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["getSDKAnalyticsSignature"])(trackedAnalytics));
                    }
                    queryParamsString = queryParams.toString();
                } catch (err) {
                    console.error('Error: URLSearchParams is not available so the queryParams object cannot be parsed, please try passing as an already parsed string');
                }
            } else {
                queryParamsString = this.urlConfig.queryParams || '';
                if (shouldAddAnalytics) {
                    queryParamsString += `${queryParamsString.length > 0 ? '&' : ''}_a=${(0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f40$cloudinary$2f$url$2d$gen$2f$sdkAnalytics$2f$getSDKAnalyticsSignature$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["getSDKAnalyticsSignature"])(trackedAnalytics)}`;
                }
            }
            if (queryParamsString) {
                return `${safeURL}?${queryParamsString}`;
            } else {
                return safeURL;
            }
        }
    }
}
;

})()),
"[project]/node_modules/@cloudinary/url-gen/assets/CloudinaryTransformable.js [app-ssr] (ecmascript)": (({ r: __turbopack_require__, f: __turbopack_module_context__, i: __turbopack_import__, s: __turbopack_esm__, v: __turbopack_export_value__, n: __turbopack_export_namespace__, c: __turbopack_cache__, M: __turbopack_modules__, l: __turbopack_load__, j: __turbopack_dynamic__, P: __turbopack_resolve_absolute_path__, U: __turbopack_relative_url__, R: __turbopack_resolve_module_id_path__, g: global, __dirname, x: __turbopack_external_require__, y: __turbopack_external_import__ }) => (() => {
"use strict";

__turbopack_esm__({
    "CloudinaryTransformable": ()=>CloudinaryTransformable
});
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f40$cloudinary$2f$url$2d$gen$2f$assets$2f$CloudinaryFile$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_import__("[project]/node_modules/@cloudinary/url-gen/assets/CloudinaryFile.js [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f40$cloudinary$2f$transformation$2d$builder$2d$sdk$2f$actions$2f$delivery$2f$DeliveryFormatAction$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_import__("[project]/node_modules/@cloudinary/transformation-builder-sdk/actions/delivery/DeliveryFormatAction.js [app-ssr] (ecmascript)");
"__TURBOPACK__ecmascript__hoisting__location__";
;
;
/**
 * @desc Cloudinary Transformable interface, extended by any class that needs a Transformation Interface
 * @summary SDK
 * @memberOf SDK
 */ class CloudinaryTransformable extends __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f40$cloudinary$2f$url$2d$gen$2f$assets$2f$CloudinaryFile$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["CloudinaryFile"] {
    constructor(publicID, cloudConfig, urlConfig, transformation){
        /* istanbul ignore next */ super(publicID, cloudConfig, urlConfig);
        this.transformation = transformation;
    }
    /**
     * @desc A proxy to {@link SDK.Transformation| Transformation} - Calls the same method contained in this.transformation
     * @param {Actions.Animated} animated
     * @return {this}
     */ animated(animated) {
        this.transformation.animated(animated);
        return this;
    }
    /**
     * @desc A proxy to {@link SDK.Transformation| Transformation} - Calls the same method contained in this.transformation
     * @param {Actions.Border} border
     * @return {this}
     */ border(border) {
        this.transformation.border(border);
        return this;
    }
    /**
     * @desc A proxy to {@link SDK.Transformation| Transformation} - Calls the same method contained in this.transformation
     * @param {Actions.Reshape} reshape
     * @return {this}
     */ reshape(reshape) {
        this.transformation.reshape(reshape);
        return this;
    }
    /**
     * @desc A proxy to {@link SDK.Transformation| Transformation} - Calls the same method contained in this.transformation
     * @param {Actions.Resize} resize
     * @return {this}
     */ resize(resize) {
        this.transformation.resize(resize);
        return this;
    }
    /**
     * @desc An alias to Action Delivery.quality
     * @param {string|number} quality
     * @return {this}
     */ quality(quality) {
        this.addAction(new __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f40$cloudinary$2f$transformation$2d$builder$2d$sdk$2f$actions$2f$delivery$2f$DeliveryFormatAction$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["DeliveryFormatAction"]('q', quality));
        return this;
    }
    /**
     * @desc An alias to Action Delivery.format
     * @param {string} format
     * @return {this}
     */ format(format) {
        this.addAction(new __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f40$cloudinary$2f$transformation$2d$builder$2d$sdk$2f$actions$2f$delivery$2f$DeliveryFormatAction$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["DeliveryFormatAction"]('f', format));
        return this;
    }
    /**
     * @desc A proxy to {@link SDK.Transformation| Transformation} - Calls the same method contained in this.transformation
     * @param {Actions.RoundCorners} roundCorners
     * @return {this}
     */ roundCorners(roundCorners) {
        this.transformation.roundCorners(roundCorners);
        return this;
    }
    /**
     * @desc A proxy to {@link SDK.Transformation| Transformation} - Calls the same method contained in this.transformation
     * @return {this}
     */ overlay(overlayAction) {
        this.transformation.overlay(overlayAction);
        return this;
    }
    /**
     * @desc A proxy to {@link SDK.Transformation| Transformation} - Calls the same method contained in this.transformation
     * @param {Actions.Variable} variableAction
     * @return {this}
     */ addVariable(variableAction) {
        this.transformation.addVariable(variableAction);
        return this;
    }
    /**
     * @desc A proxy to {@link SDK.Transformation| Transformation} - Calls the same method contained in this.transformation
     * @param {Actions.Condition} conditionalAction
     * @return {this}
     */ conditional(conditionalAction) {
        this.transformation.conditional(conditionalAction);
        return this;
    }
    /**
     * @desc A proxy to {@link SDK.Transformation| Transformation} - Calls the same method contained in this.transformation
     * @param {Actions.Effect} effect
     * @return {this}
     */ effect(effect) {
        this.transformation.effect(effect);
        return this;
    }
    /**
     * @desc A proxy to {@link SDK.Transformation| Transformation} - Calls the same method contained in this.transformation
     * @param {Actions.Adjust} action
     * @return {this}
     */ adjust(action) {
        this.transformation.adjust(action);
        return this;
    }
    /**
     * @desc A proxy to {@link SDK.Transformation| Transformation} - Calls the same method contained in this.transformation
     * @param {Actions.Rotate} rotate
     * @return {this}
     */ rotate(rotate) {
        this.transformation.rotate(rotate);
        return this;
    }
    /**
     * @desc A proxy to {@link SDK.Transformation| Transformation} - Calls the same method contained in this.transformation
     * @param {Actions.NamedTransformation} namedTransformation
     * @return {this}
     */ namedTransformation(namedTransformation) {
        this.transformation.namedTransformation(namedTransformation);
        return this;
    }
    /**
     * @desc A proxy to {@link SDK.Transformation| Transformation} - Calls the same method contained in this.transformation
     * @param {Actions.Delivery} deliveryAction
     * @return {this}
     */ delivery(deliveryAction) {
        this.transformation.delivery(deliveryAction);
        return this;
    }
    /**
     * @desc A proxy to {@link SDK.Transformation| Transformation} - Calls the same method contained in this.transformation
     * @param {Qualifiers.color} color
     * @return {this}
     */ backgroundColor(color) {
        this.transformation.backgroundColor(color);
        return this;
    }
    /**
     * @desc A proxy to {@link SDK.Transformation| Transformation} - Calls the same method contained in this.transformation
     * @param {Actions.PSDTools} action
     * @return {this}
     */ psdTools(action) {
        this.transformation.psdTools(action);
        return this;
    }
    /**
     * @desc A proxy to {@link SDK.Transformation| Transformation} - Calls the same method contained in this.transformation
     * @param {Actions.Extract} action
     * @return {this}
     */ extract(action) {
        this.transformation.extract(action);
        return this;
    }
    /**
     * @desc A proxy to {@link SDK.Transformation| Transformation} - Calls the same method contained in this.transformation
     * @param {Qualifiers.Flag | string} flagQualifier
     * @return {this}
     */ addFlag(flagQualifier) {
        this.transformation.addFlag(flagQualifier);
        return this;
    }
    /**
     * @desc A proxy to {@link SDK.Transformation| Transformation} - Calls the same method contained in this.transformation
     * @param {Actions.CustomFunction} customFunction
     * @return {this}
     */ customFunction(customFunction) {
        this.transformation.customFunction(customFunction);
        return this;
    }
    /**
     * @desc A proxy to {@link SDK.Transformation| Transformation} - Calls the same method contained in this.transformation
     * @param {SDK.Action | string} action
     * @return {this}
     */ addAction(action) {
        this.transformation.addAction(action);
        return this;
    }
    /**
     * @description Extend your transformation with another transformation
     * @param { string | SDK.Transformation } tx
     */ addTransformation(tx) {
        this.transformation.addTransformation(tx);
        return this;
    }
    /**
     * @desc A proxy to {@link SDK.Transformation| Transformation} - Calls the same method contained in this.transformation
     * @return {string}
     */ toString() {
        return this.transformation.toString();
    }
    /**
     * @desc A proxy to {@link SDK.Transformation| Transformation} - Calls the same method contained in this.transformation
     * @return {this}
     */ underlay(underlayAction) {
        this.transformation.underlay(underlayAction);
        return this;
    }
    toURL(overwriteOptions = {}) {
        return this.createCloudinaryURL(this.transformation, overwriteOptions === null || overwriteOptions === void 0 ? void 0 : overwriteOptions.trackedAnalytics);
    }
}
;

})()),
"[project]/node_modules/@cloudinary/url-gen/assets/CloudinaryImage.js [app-ssr] (ecmascript)": (({ r: __turbopack_require__, f: __turbopack_module_context__, i: __turbopack_import__, s: __turbopack_esm__, v: __turbopack_export_value__, n: __turbopack_export_namespace__, c: __turbopack_cache__, M: __turbopack_modules__, l: __turbopack_load__, j: __turbopack_dynamic__, P: __turbopack_resolve_absolute_path__, U: __turbopack_relative_url__, R: __turbopack_resolve_module_id_path__, g: global, __dirname, x: __turbopack_external_require__, y: __turbopack_external_import__ }) => (() => {
"use strict";

__turbopack_esm__({
    "CloudinaryImage": ()=>CloudinaryImage
});
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f40$cloudinary$2f$transformation$2d$builder$2d$sdk$2f$transformation$2f$ImageTransformation$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_import__("[project]/node_modules/@cloudinary/transformation-builder-sdk/transformation/ImageTransformation.js [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f40$cloudinary$2f$url$2d$gen$2f$assets$2f$CloudinaryTransformable$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_import__("[project]/node_modules/@cloudinary/url-gen/assets/CloudinaryTransformable.js [app-ssr] (ecmascript)");
"__TURBOPACK__ecmascript__hoisting__location__";
;
;
/**
 * @desc Cloudinary image asset, with image-related transformations
 * @summary SDK
 * @memberOf SDK
 */ class CloudinaryImage extends __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f40$cloudinary$2f$url$2d$gen$2f$assets$2f$CloudinaryTransformable$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["CloudinaryTransformable"] {
    constructor(publicID, cloudConfig, urlConfig){
        /* istanbul ignore next */ super(publicID, cloudConfig, urlConfig, new __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f40$cloudinary$2f$transformation$2d$builder$2d$sdk$2f$transformation$2f$ImageTransformation$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["ImageTransformation"]());
    }
}
;

})()),
"[project]/node_modules/@cloudinary/url-gen/assets/CloudinaryVideo.js [app-ssr] (ecmascript)": (({ r: __turbopack_require__, f: __turbopack_module_context__, i: __turbopack_import__, s: __turbopack_esm__, v: __turbopack_export_value__, n: __turbopack_export_namespace__, c: __turbopack_cache__, M: __turbopack_modules__, l: __turbopack_load__, j: __turbopack_dynamic__, P: __turbopack_resolve_absolute_path__, U: __turbopack_relative_url__, R: __turbopack_resolve_module_id_path__, g: global, __dirname, x: __turbopack_external_require__, y: __turbopack_external_import__ }) => (() => {
"use strict";

__turbopack_esm__({
    "CloudinaryVideo": ()=>CloudinaryVideo
});
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f40$cloudinary$2f$url$2d$gen$2f$assets$2f$CloudinaryTransformable$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_import__("[project]/node_modules/@cloudinary/url-gen/assets/CloudinaryTransformable.js [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f40$cloudinary$2f$transformation$2d$builder$2d$sdk$2f$transformation$2f$VideoTransformation$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_import__("[project]/node_modules/@cloudinary/transformation-builder-sdk/transformation/VideoTransformation.js [app-ssr] (ecmascript)");
"__TURBOPACK__ecmascript__hoisting__location__";
;
;
/**
 * @desc Cloudinary video asset, with video-related transformations
 * @summary SDK
 * @memberOf SDK
 */ class CloudinaryVideo extends __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f40$cloudinary$2f$url$2d$gen$2f$assets$2f$CloudinaryTransformable$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["CloudinaryTransformable"] {
    constructor(publicID, cloudConfig, urlConfig){
        /* istanbul ignore next */ super(publicID, cloudConfig, urlConfig, new __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f40$cloudinary$2f$transformation$2d$builder$2d$sdk$2f$transformation$2f$VideoTransformation$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["VideoTransformation"]());
        this.assetType = 'video';
    }
    /**
     * @desc A proxy to {@link SDK.Transformation| Transformation} - Calls the same method contained in this.transformation
     * @param {Actions.Transcode} action
     * @return {this}
     */ transcode(action) {
        this.transformation.transcode(action);
        return this;
    }
    /**
     * @desc A proxy to {@link SDK.Transformation| Transformation} - Calls the same method contained in this.transformation
     * @param {Actions.VideoEdit} action
     * @return {this}
     */ videoEdit(action) {
        this.transformation.videoEdit(action);
        return this;
    }
}
;

})()),
"[project]/node_modules/@cloudinary/url-gen/instance/Cloudinary.js [app-ssr] (ecmascript)": (({ r: __turbopack_require__, f: __turbopack_module_context__, i: __turbopack_import__, s: __turbopack_esm__, v: __turbopack_export_value__, n: __turbopack_export_namespace__, c: __turbopack_cache__, M: __turbopack_modules__, l: __turbopack_load__, j: __turbopack_dynamic__, P: __turbopack_resolve_absolute_path__, U: __turbopack_relative_url__, R: __turbopack_resolve_module_id_path__, g: global, __dirname, x: __turbopack_external_require__, y: __turbopack_external_import__ }) => (() => {
"use strict";

__turbopack_esm__({
    "Cloudinary": ()=>Cloudinary
});
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f40$cloudinary$2f$url$2d$gen$2f$assets$2f$CloudinaryImage$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_import__("[project]/node_modules/@cloudinary/url-gen/assets/CloudinaryImage.js [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f40$cloudinary$2f$url$2d$gen$2f$assets$2f$CloudinaryVideo$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_import__("[project]/node_modules/@cloudinary/url-gen/assets/CloudinaryVideo.js [app-ssr] (ecmascript)");
"__TURBOPACK__ecmascript__hoisting__location__";
;
;
class Cloudinary {
    constructor(cloudinaryConfig){
        if (cloudinaryConfig) {
            this.cloudinaryConfig = cloudinaryConfig;
        }
    }
    image(publicID) {
        return new __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f40$cloudinary$2f$url$2d$gen$2f$assets$2f$CloudinaryImage$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["CloudinaryImage"](publicID, this.cloudinaryConfig.cloud, this.cloudinaryConfig.url);
    }
    video(publicID) {
        return new __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f40$cloudinary$2f$url$2d$gen$2f$assets$2f$CloudinaryVideo$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["CloudinaryVideo"](publicID, this.cloudinaryConfig.cloud, this.cloudinaryConfig.url);
    }
    setConfig(cloudinaryConfig) {
        this.cloudinaryConfig = cloudinaryConfig;
        return this;
    }
    getConfig() {
        return this.cloudinaryConfig;
    }
    extendConfig() {
    // Future implementation
    }
}
;

})()),
"[project]/node_modules/next-cloudinary/dist/index.mjs [app-ssr] (ecmascript)": (({ r: __turbopack_require__, f: __turbopack_module_context__, i: __turbopack_import__, s: __turbopack_esm__, v: __turbopack_export_value__, n: __turbopack_export_namespace__, c: __turbopack_cache__, M: __turbopack_modules__, l: __turbopack_load__, j: __turbopack_dynamic__, P: __turbopack_resolve_absolute_path__, U: __turbopack_relative_url__, R: __turbopack_resolve_module_id_path__, g: global, __dirname, x: __turbopack_external_require__, y: __turbopack_external_import__ }) => (() => {
"use strict";

__turbopack_esm__({
    "CldImage": ()=>ae,
    "CldOgImage": ()=>le,
    "CldUploadButton": ()=>ue,
    "CldUploadWidget": ()=>z,
    "CldVideoPlayer": ()=>Ce,
    "cloudinaryLoader": ()=>q,
    "getCldImageUrl": ()=>T,
    "getCldOgImageUrl": ()=>X,
    "getCldVideoUrl": ()=>He
});
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$server$2f$future$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_import__("[project]/node_modules/next/dist/server/future/route-modules/app-page/vendored/ssr/react.js [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$image$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_import__("[project]/node_modules/next/image.js [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f40$cloudinary$2d$util$2f$util$2f$dist$2f$index$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_import__("[project]/node_modules/@cloudinary-util/util/dist/index.js [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f40$cloudinary$2d$util$2f$url$2d$loader$2f$dist$2f$chunk$2d$L3YIXMGG$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_import__("[project]/node_modules/@cloudinary-util/url-loader/dist/chunk-L3YIXMGG.js [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$package$2e$json__$28$json$29$__ = __turbopack_import__("[project]/node_modules/next/package.json (json)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$client$2f$components$2f$noop$2d$head$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_import__("[project]/node_modules/next/dist/client/components/noop-head.js [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$script$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_import__("[project]/node_modules/next/script.js [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f40$cloudinary$2d$util$2f$url$2d$loader$2f$dist$2f$index$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__$3c$locals$3e$__ = __turbopack_import__("[project]/node_modules/@cloudinary-util/url-loader/dist/index.js [app-ssr] (ecmascript) <locals>");
"__TURBOPACK__ecmascript__hoisting__location__";
;
;
;
;
;
;
var ee = {
    name: "next-cloudinary",
    version: "6.17.5",
    license: "MIT",
    main: "./dist/index.js",
    module: "./dist/index.mjs",
    types: "./dist/index.d.ts",
    source: "src/index.ts",
    scripts: {
        build: "tsup",
        dev: "tsup --watch",
        prepublishOnly: "cp ../README.md . && cp ../LICENSE . && pnpm build",
        postpublish: "rm ./README.md && rm ./LICENSE",
        test: "vitest run",
        "test:app": 'NEXT_PUBLIC_CLOUDINARY_CLOUD_NAME="test" pnpm build && cd tests/nextjs-app && npm install && npm run build',
        "test:watch": "vitest"
    },
    dependencies: {
        "@cloudinary-util/types": "1.5.10",
        "@cloudinary-util/url-loader": "5.10.4",
        "@cloudinary-util/util": "4.0.0"
    },
    devDependencies: {
        "@babel/core": "^7.25.2",
        "@babel/preset-env": "^7.25.3",
        "@tsconfig/recommended": "^1.0.7",
        "@types/node": "^22.0.2",
        "@types/react": "^18.3.3",
        "@types/react-dom": "^18.3.0",
        dotenv: "^16.4.5",
        mkdirp: "^3.0.1",
        tsup: "^8.2.3",
        typescript: "^5.5.4",
        vitest: "^2.0.5"
    },
    peerDependencies: {
        next: "^12 || ^13 || ^14 || >=15.0.0-rc || ^15",
        react: "^17 || ^18 || >=19.0.0-beta || ^19"
    }
};
var te = "A", oe = "V", re = ie(__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$package$2e$json__$28$json$29$__["default"].version), ne = ie(ee.version);
function ie(e) {
    let t = e;
    return t.includes("-") && (t = t.split("-")[0]), t;
}
function w(e) {
    let t = e?.cloud?.cloudName ?? ("TURBOPACK compile-time value", "adaired");
    if (!t) throw new Error("A Cloudinary Cloud name is required, please make sure NEXT_PUBLIC_CLOUDINARY_CLOUD_NAME is set and configured in your environment.");
    let d = e?.cloud?.apiKey ?? process.env.NEXT_PUBLIC_CLOUDINARY_API_KEY, a = e?.url?.secureDistribution ?? process.env.NEXT_PUBLIC_CLOUDINARY_SECURE_DISTRIBUTION, o = e?.url?.privateCdn ?? process.env.NEXT_PUBLIC_CLOUDINARY_PRIVATE_CDN;
    return Object.assign({
        cloud: {
            ...e?.cloud,
            apiKey: d,
            cloudName: t
        },
        url: {
            ...e?.url,
            secureDistribution: a,
            privateCdn: o
        }
    }, e);
}
function H(e) {
    return Object.assign({
        product: te,
        sdkCode: oe,
        sdkSemver: ne,
        techVersion: re,
        feature: ""
    }, e);
}
function T(e, t, d) {
    return (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f40$cloudinary$2d$util$2f$url$2d$loader$2f$dist$2f$chunk$2d$L3YIXMGG$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["constructCloudinaryUrl"])({
        options: e,
        config: w(t),
        analytics: H(d)
    });
}
function q({ loaderOptions: e, imageProps: t, cldOptions: d, cldConfig: a = {} }) {
    let o = {
        ...t,
        ...d
    };
    if (o.width = typeof o.width == "string" ? parseInt(o.width) : o.width, o.height = typeof o.height == "string" ? parseInt(o.height) : o.height, typeof e?.width == "number" && typeof o.width == "number" && e.width !== o.width) {
        let n = e.width / o.width;
        o.width = e.width, typeof o.height == "number" && (o.height = Math.floor(o.height * n));
    } else typeof e?.width == "number" && typeof o?.width != "number" && (o.width = e?.width);
    return T(o, a);
}
var xe = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$server$2f$future$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["forwardRef"])(function(t, d) {
    let a = !1, o = [
        "assetType",
        "config",
        "deliveryType",
        "strictTransformations"
    ];
    __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f40$cloudinary$2d$util$2f$url$2d$loader$2f$dist$2f$chunk$2d$L3YIXMGG$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["transformationPlugins"].forEach(({ props: r })=>{
        Object.keys(r).forEach((f)=>{
            if (o.includes(f)) throw new Error(`Option ${f} already exists!`);
            o.push(f);
        });
    });
    let n = {
        alt: t.alt,
        src: t.src
    };
    Object.keys(t).filter((r)=>typeof r == "string" && !o.includes(r)).forEach((r)=>n[r] = t[r]);
    let s = Object.keys(n).map((r)=>`${r}:${n[r]}`).join(";"), [C, m] = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$server$2f$future$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["useState"])(s), p = {};
    o.forEach((r)=>{
        let g = t[r];
        g && (p[r] = g);
    });
    let I = ("TURBOPACK compile-time value", JSON.parse('{"deviceSizes":[640,750,828,1080,1200,1920,2048,3840],"imageSizes":[16,32,48,64,96,128,256,384],"path":"/_next/image","loader":"default","dangerouslyAllowSVG":false,"unoptimized":false,"domains":[],"remotePatterns":[{"protocol":"https","hostname":"randomuser.me","pathname":"/api/portraits/**"},{"protocol":"https","hostname":"cloudflare-ipfs.com","pathname":"/ipfs/**"},{"protocol":"https","hostname":"avatars.githubusercontent.com","pathname":"/u/**"},{"protocol":"https","hostname":"picsum.photos"},{"protocol":"https","hostname":"flagcdn.com"},{"protocol":"https","hostname":"utfs.io"},{"protocol":"https","hostname":"images.unsplash.com"},{"protocol":"https","hostname":"s3.amazonaws.com","pathname":"/redqteam.com/isomorphic-furyroad/public/**"},{"protocol":"https","hostname":"isomorphic-furyroad.s3.amazonaws.com"},{"protocol":"https","hostname":"isomorphic-furyroad.vercel.app"},{"protocol":"https","hostname":"api.microlink.io","port":"","pathname":"**"},{"protocol":"https","hostname":"example.com","port":"","pathname":"**"},{"protocol":"https","hostname":"res.cloudinary.com","port":"","pathname":"**"},{"protocol":"https","hostname":"demo.adaired.com","port":"","pathname":"**"},{"protocol":"https","hostname":"api.dicebear.com","port":"","pathname":"**"},{"protocol":"https","hostname":"lh3.googleusercontent.com"}]}')) || {};
    (t.unoptimized === !0 || I?.unoptimized === !0) && (n.src = T({
        ...p,
        width: n.width,
        height: n.height,
        src: n.src,
        format: "default",
        quality: "default"
    }, t.config));
    async function l(r) {
        let g = !0;
        if (a) return;
        if (a = !0, typeof t.onError == "function") {
            let P = t.onError(r);
            typeof P == "boolean" && P === !1 && (g = !1);
        } else typeof t.onError == "boolean" && t.onError === !1 && (g = !1);
        if (g === !1) return;
        let f = r.target, O = await (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f40$cloudinary$2d$util$2f$util$2f$dist$2f$index$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["pollForProcessingImage"])({
            src: f.src
        });
        typeof O.error == "string" && ("TURBOPACK compile-time value", "development") === "development" && console.error(`[CldImage] Failed to load image ${t.src}: ${O.error}`), O.success && m(`${s};${Date.now()}`);
    }
    let A = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$server$2f$future$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["useCallback"])(l, [
        __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f40$cloudinary$2d$util$2f$util$2f$dist$2f$index$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["pollForProcessingImage"],
        s
    ]), h = __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$image$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["default"];
    return "default" in h && (h = h.default), __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$server$2f$future$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["default"].createElement(h, {
        key: C,
        ...n,
        loader: (r)=>q({
                loaderOptions: r,
                imageProps: n,
                cldOptions: p,
                cldConfig: t.config
            }),
        onError: A,
        ref: d
    });
}), ae = xe;
;
;
function X(e) {
    return T({
        ...e,
        format: e.format || "jpg",
        width: e.width || 1200,
        height: e.height || 627,
        crop: e.crop || {
            type: "fill",
            gravity: "center",
            source: !0
        }
    });
}
var be = "summary_large_image", ve = ({ excludeTags: e = [], twitterTitle: t, keys: d = {}, ...a })=>{
    let { alt: o } = a, { width: n = 1200, height: s = 627 } = a;
    n = typeof n == "string" ? parseInt(n) : n, s = typeof s == "string" ? parseInt(s) : s;
    let C = X({
        ...a,
        width: n,
        height: s
    }), m = X({
        ...a,
        width: n,
        height: s,
        format: a.format || "webp"
    }), p = {
        "og:image": "og-image",
        "og:image:secure_url": "og-image-secureurl",
        "og:image:width": "og-image-width",
        "og:image:height": "og-image-height",
        "og:image:alt": "og-image-alt",
        "twitter:title": "twitter-title",
        "twitter:card": "twitter-card",
        "twitter:image": "twitter-image",
        ...d
    };
    return __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$server$2f$future$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["default"].createElement(__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$client$2f$components$2f$noop$2d$head$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["default"], null, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$server$2f$future$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["default"].createElement("meta", {
        key: p["og:image"],
        property: "og:image",
        content: C
    }), __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$server$2f$future$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["default"].createElement("meta", {
        key: p["og:image:secure_url"],
        property: "og:image:secure_url",
        content: C
    }), __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$server$2f$future$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["default"].createElement("meta", {
        key: p["og:image:width"],
        property: "og:image:width",
        content: `${n}`
    }), __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$server$2f$future$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["default"].createElement("meta", {
        key: p["og:image:height"],
        property: "og:image:height",
        content: `${s}`
    }), o && __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$server$2f$future$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["default"].createElement("meta", {
        key: p["og:image:alt"],
        property: "og:image:alt",
        content: o
    }), !e.includes("twitter:title") && __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$server$2f$future$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["default"].createElement("meta", {
        key: p["twitter:title"],
        property: "twitter:title",
        content: t || " "
    }), __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$server$2f$future$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["default"].createElement("meta", {
        key: p["twitter:card"],
        property: "twitter:card",
        content: be
    }), __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$server$2f$future$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["default"].createElement("meta", {
        key: p["twitter:image"],
        property: "twitter:image",
        content: m
    }));
}, le = ve;
;
;
;
;
function se(e) {
    return window && "requestIdleCallback" in window ? requestIdleCallback(e) : setTimeout(()=>e(), 1);
}
var Se = ()=>{
    let e = __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$server$2f$future$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["default"].useId?.() ?? null, t = __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$server$2f$future$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["default"].useRef(Math.floor(Math.random() * 100)).current;
    return `cloudinary-uploadwidget-${e ? e.replace(/:/g, "") : t}`;
}, Ve = ({ children: e, config: t, onError: d, onOpen: a, onUpload: o, options: n, signatureEndpoint: s, uploadPreset: C, ...m })=>{
    let p = Se(), I = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$server$2f$future$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["useRef"])(), l = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$server$2f$future$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["useRef"])(), [A, h] = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$server$2f$future$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["useState"])(void 0), [r, g] = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$server$2f$future$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["useState"])(void 0), [f, O] = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$server$2f$future$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["useState"])(!0), P = w(t), W = s && (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f40$cloudinary$2d$util$2f$url$2d$loader$2f$dist$2f$index$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__$3c$locals$3e$__["generateSignatureCallback"])({
        signatureEndpoint: String(s),
        fetch
    }), V = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f40$cloudinary$2d$util$2f$url$2d$loader$2f$dist$2f$index$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__$3c$locals$3e$__["getUploadWidgetOptions"])({
        uploadPreset: C || process.env.NEXT_PUBLIC_CLOUDINARY_UPLOAD_PRESET,
        uploadSignature: W,
        ...n
    }, P), M = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f40$cloudinary$2d$util$2f$url$2d$loader$2f$dist$2f$index$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__$3c$locals$3e$__["generateUploadWidgetResultCallback"])({
        onError: (i)=>{
            h(i), typeof d == "function" && d(i, {
                widget: l.current,
                ...u
            });
        },
        onResult: (i)=>{
            if (typeof i?.event != "string") return;
            g(i);
            let U = __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f40$cloudinary$2d$util$2f$url$2d$loader$2f$dist$2f$index$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__$3c$locals$3e$__["UPLOAD_WIDGET_EVENTS"][i.event];
            if (typeof U == "string" && typeof m[U] == "function") {
                let S = m[U];
                S(i, {
                    widget: l.current,
                    ...u
                });
            }
            let Y = `${U}Action`;
            if (Y && typeof m[Y] == "function") {
                let S = m[Y];
                S(i);
            }
        }
    });
    (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$server$2f$future$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["useEffect"])(()=>{
        if (typeof r > "u") return;
        r.event === "success" && typeof o == "function" && (("TURBOPACK compile-time value", "development") === "development" && console.warn("The onUpload callback is deprecated. Please use onSuccess instead."), o(r, l.current));
    }, [
        r
    ]);
    function k() {
        O(!1), I.current || (I.current = window.cloudinary), se(()=>{
            l.current || (l.current = v());
        });
    }
    (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$server$2f$future$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["useEffect"])(()=>()=>{
            l.current?.destroy(), l.current = void 0;
        }, []);
    function c(i, U = []) {
        if (l.current || (l.current = v()), typeof l?.current[i] == "function") return l.current[i](...U);
    }
    function G(i) {
        c("close", [
            i
        ]);
    }
    function y(i) {
        return c("destroy", [
            i
        ]);
    }
    function _() {
        c("hide");
    }
    function x() {
        return c("isDestroyed");
    }
    function L() {
        return c("isMinimized");
    }
    function R() {
        return c("isShowing");
    }
    function D() {
        c("minimize");
    }
    function b(i, U) {
        c("open", [
            i,
            U
        ]), typeof a == "function" && a(l.current);
    }
    function j() {
        c("show");
    }
    function B() {
        c("update");
    }
    let u = {
        close: G,
        destroy: y,
        hide: _,
        isDestroyed: x,
        isMinimized: L,
        isShowing: R,
        minimize: D,
        open: b,
        show: j,
        update: B
    };
    function v() {
        return I.current?.createUploadWidget(V, M);
    }
    return __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$server$2f$future$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["default"].createElement(__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$server$2f$future$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["default"].Fragment, null, typeof e == "function" && e({
        cloudinary: I.current,
        widget: l.current,
        results: r,
        error: A,
        isLoading: f,
        ...u
    }), __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$server$2f$future$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["default"].createElement(__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$script$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["default"], {
        id: p,
        src: "https://upload-widget.cloudinary.com/global/all.js",
        onLoad: k,
        onError: (i)=>console.error(`Failed to load Cloudinary Upload Widget: ${i.message}`)
    }));
}, z = Ve;
var ke = ({ className: e, children: t, onClick: d, onError: a, onOpen: o, onUpload: n, onAbort: s, onBatchCancelled: C, onClose: m, onDisplayChanged: p, onPublicId: I, onQueuesEnd: l, onQueuesStart: A, onRetry: h, onShowCompleted: r, onSourceChanged: g, onSuccess: f, onTags: O, onUploadAdded: P, options: W, signatureEndpoint: V, uploadPreset: M, onAbortAction: k, onBatchCancelledAction: c, onCloseAction: G, onDisplayChangedAction: y, onPublicIdAction: _, onQueuesEndAction: x, onQueuesStartAction: L, onRetryAction: R, onShowCompletedAction: D, onSourceChangedAction: b, onSuccessAction: j, onTagsAction: B, onUploadAddedAction: u, ...v })=>__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$server$2f$future$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["default"].createElement(__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$server$2f$future$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["default"].Fragment, null, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$server$2f$future$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["default"].createElement(z, {
        onError: a,
        onOpen: o,
        onUpload: n,
        onAbort: s,
        onBatchCancelled: C,
        onClose: m,
        onDisplayChanged: p,
        onPublicId: I,
        onQueuesEnd: l,
        onQueuesStart: A,
        onRetry: h,
        onShowCompleted: r,
        onSourceChanged: g,
        onSuccess: f,
        onTags: O,
        onUploadAdded: P,
        options: W,
        signatureEndpoint: V,
        uploadPreset: M,
        onAbortAction: k,
        onBatchCancelledAction: c,
        onCloseAction: G,
        onDisplayChangedAction: y,
        onPublicIdAction: _,
        onQueuesEndAction: x,
        onQueuesStartAction: L,
        onRetryAction: R,
        onShowCompletedAction: D,
        onSourceChangedAction: b,
        onSuccessAction: j,
        onTagsAction: B,
        onUploadAddedAction: u
    }, ({ open: i, isLoading: U })=>{
        function Y(S) {
            S.preventDefault(), i(), typeof d == "function" && d(S);
        }
        return __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$server$2f$future$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["default"].createElement("button", {
            ...v,
            className: e || "",
            onClick: Y,
            disabled: U
        }, t || "Upload");
    })), ue = ke;
;
;
;
;
var me = [], ye = "1.11.1", Ye = (e)=>{
    let { className: t, config: d, disableRemotePlayback: a, height: o, id: n, onDataLoad: s, onError: C, onMetadataLoad: m, onPause: p, onPlay: I, onEnded: l, width: A } = e, h = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$server$2f$future$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["useId"])(), [r, g] = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$server$2f$future$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["useState"])(!1), [f, O] = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$server$2f$future$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["useState"])(!1), P = w(d), W = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f40$cloudinary$2d$util$2f$url$2d$loader$2f$dist$2f$index$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__$3c$locals$3e$__["getVideoPlayerOptions"])(e, P), { publicId: V } = W;
    if (typeof V > "u") throw new Error("Video Player requires a Public ID or Cloudinary URL - please specify a src prop");
    let M = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$server$2f$future$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["useRef"])(), k = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$server$2f$future$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["useRef"])(), c = e.videoRef || k, G = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$server$2f$future$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["useRef"])(), y = e.playerRef || G, _ = n || `player-${h.replace(/:/g, "")}`, x = "cld-video-player cld-fluid";
    t && (x = `${x} ${t}`);
    let L = {
        error: C,
        loadeddata: s,
        loadedmetadata: m,
        pause: p,
        play: I,
        ended: l
    };
    function R(u) {
        let v = L[u.type];
        typeof v == "function" && v(B());
    }
    let D = ()=>{
        y.current?.videojs?.cloudinary && y.current.videojs.cloudinary.dispose(), me = me.filter((u)=>u !== _), y.current = null, O(!1);
    }, b = ()=>{
        typeof window < "u" && "cloudinary" in window && c.current && !f && (M.current = window.cloudinary, y.current && D(), y.current = M.current.videoPlayer(c.current, W), O(!0), Object.keys(L).forEach((u)=>{
            typeof L[u] == "function" && y.current?.on(u, R);
        }));
    };
    function j() {
        g(!0), "cloudinary" in window && b();
    }
    (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$server$2f$future$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["useEffect"])(()=>(r && typeof window < "u" && "cloudinary" in window && b(), ()=>{
            D();
        }), []), (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$server$2f$future$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["useEffect"])(()=>{
        r && !f && typeof window < "u" && "cloudinary" in window && b();
    }, [
        r,
        f
    ]);
    function B() {
        return {
            player: y.current,
            video: c.current
        };
    }
    return __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$server$2f$future$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["default"].createElement(__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$server$2f$future$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["default"].Fragment, null, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$server$2f$future$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["default"].createElement(__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$client$2f$components$2f$noop$2d$head$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["default"], null, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$server$2f$future$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["default"].createElement("link", {
        href: `https://unpkg.com/cloudinary-video-player@${ye}/dist/cld-video-player.min.css`,
        rel: "stylesheet"
    })), __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$server$2f$future$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["default"].createElement("div", {
        style: {
            width: "100%"
        }
    }, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$server$2f$future$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["default"].createElement("video", {
        ref: c,
        id: _,
        className: x,
        width: A,
        height: o,
        disableRemotePlayback: a
    }), __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$server$2f$future$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["default"].createElement(__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$script$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["default"], {
        id: `cloudinary-videoplayer-${_}`,
        src: `https://unpkg.com/cloudinary-video-player@${ye}/dist/cld-video-player.min.js`,
        onLoad: j,
        onError: (u)=>console.error(`Failed to load Cloudinary Video Player: ${u.message}`)
    })));
}, Ce = Ye;
;
function He(e, t, d) {
    return (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f40$cloudinary$2d$util$2f$url$2d$loader$2f$dist$2f$chunk$2d$L3YIXMGG$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["constructCloudinaryUrl"])({
        options: {
            assetType: "video",
            format: "auto:video",
            ...e
        },
        config: w(t),
        analytics: H(d)
    });
}
;
 //# sourceMappingURL=index.mjs.map

})()),
"[project]/node_modules/@radix-ui/react-compose-refs/dist/index.mjs [app-ssr] (ecmascript)": (({ r: __turbopack_require__, f: __turbopack_module_context__, i: __turbopack_import__, s: __turbopack_esm__, v: __turbopack_export_value__, n: __turbopack_export_namespace__, c: __turbopack_cache__, M: __turbopack_modules__, l: __turbopack_load__, j: __turbopack_dynamic__, P: __turbopack_resolve_absolute_path__, U: __turbopack_relative_url__, R: __turbopack_resolve_module_id_path__, g: global, __dirname, x: __turbopack_external_require__, y: __turbopack_external_import__ }) => (() => {
"use strict";

// packages/react/compose-refs/src/compose-refs.tsx
__turbopack_esm__({
    "composeRefs": ()=>composeRefs,
    "useComposedRefs": ()=>useComposedRefs
});
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$server$2f$future$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_import__("[project]/node_modules/next/dist/server/future/route-modules/app-page/vendored/ssr/react.js [app-ssr] (ecmascript)");
"__TURBOPACK__ecmascript__hoisting__location__";
;
function setRef(ref, value) {
    if (typeof ref === "function") {
        return ref(value);
    } else if (ref !== null && ref !== void 0) {
        ref.current = value;
    }
}
function composeRefs(...refs) {
    return (node)=>{
        let hasCleanup = false;
        const cleanups = refs.map((ref)=>{
            const cleanup = setRef(ref, node);
            if (!hasCleanup && typeof cleanup == "function") {
                hasCleanup = true;
            }
            return cleanup;
        });
        if (hasCleanup) {
            return ()=>{
                for(let i = 0; i < cleanups.length; i++){
                    const cleanup = cleanups[i];
                    if (typeof cleanup == "function") {
                        cleanup();
                    } else {
                        setRef(refs[i], null);
                    }
                }
            };
        }
    };
}
function useComposedRefs(...refs) {
    return __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$server$2f$future$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__.useCallback(composeRefs(...refs), refs);
}
;
 //# sourceMappingURL=index.mjs.map

})()),
"[project]/node_modules/@radix-ui/react-slot/dist/index.mjs [app-ssr] (ecmascript)": (({ r: __turbopack_require__, f: __turbopack_module_context__, i: __turbopack_import__, s: __turbopack_esm__, v: __turbopack_export_value__, n: __turbopack_export_namespace__, c: __turbopack_cache__, M: __turbopack_modules__, l: __turbopack_load__, j: __turbopack_dynamic__, P: __turbopack_resolve_absolute_path__, U: __turbopack_relative_url__, R: __turbopack_resolve_module_id_path__, g: global, __dirname, x: __turbopack_external_require__, y: __turbopack_external_import__ }) => (() => {
"use strict";

// src/slot.tsx
__turbopack_esm__({
    "Root": ()=>Slot,
    "Slot": ()=>Slot,
    "Slottable": ()=>Slottable,
    "createSlot": ()=>createSlot,
    "createSlottable": ()=>createSlottable
});
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$server$2f$future$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_import__("[project]/node_modules/next/dist/server/future/route-modules/app-page/vendored/ssr/react.js [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f40$radix$2d$ui$2f$react$2d$compose$2d$refs$2f$dist$2f$index$2e$mjs__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_import__("[project]/node_modules/@radix-ui/react-compose-refs/dist/index.mjs [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$server$2f$future$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2d$jsx$2d$runtime$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_import__("[project]/node_modules/next/dist/server/future/route-modules/app-page/vendored/ssr/react-jsx-runtime.js [app-ssr] (ecmascript)");
"__TURBOPACK__ecmascript__hoisting__location__";
;
;
;
var REACT_LAZY_TYPE = Symbol.for("react.lazy");
var use = __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$server$2f$future$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__[" use ".trim().toString()];
function isPromiseLike(value) {
    return typeof value === "object" && value !== null && "then" in value;
}
function isLazyComponent(element) {
    return element != null && typeof element === "object" && "$$typeof" in element && element.$$typeof === REACT_LAZY_TYPE && "_payload" in element && isPromiseLike(element._payload);
}
// @__NO_SIDE_EFFECTS__
function createSlot(ownerName) {
    const SlotClone = /* @__PURE__ */ createSlotClone(ownerName);
    const Slot2 = __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$server$2f$future$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__.forwardRef((props, forwardedRef)=>{
        let { children, ...slotProps } = props;
        if (isLazyComponent(children) && typeof use === "function") {
            children = use(children._payload);
        }
        const childrenArray = __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$server$2f$future$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__.Children.toArray(children);
        const slottable = childrenArray.find(isSlottable);
        if (slottable) {
            const newElement = slottable.props.children;
            const newChildren = childrenArray.map((child)=>{
                if (child === slottable) {
                    if (__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$server$2f$future$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__.Children.count(newElement) > 1) return __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$server$2f$future$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__.Children.only(null);
                    return __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$server$2f$future$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__.isValidElement(newElement) ? newElement.props.children : null;
                } else {
                    return child;
                }
            });
            return /* @__PURE__ */ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$server$2f$future$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2d$jsx$2d$runtime$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["jsx"])(SlotClone, {
                ...slotProps,
                ref: forwardedRef,
                children: __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$server$2f$future$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__.isValidElement(newElement) ? __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$server$2f$future$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__.cloneElement(newElement, void 0, newChildren) : null
            });
        }
        return /* @__PURE__ */ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$server$2f$future$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2d$jsx$2d$runtime$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["jsx"])(SlotClone, {
            ...slotProps,
            ref: forwardedRef,
            children
        });
    });
    Slot2.displayName = `${ownerName}.Slot`;
    return Slot2;
}
var Slot = /* @__PURE__ */ createSlot("Slot");
// @__NO_SIDE_EFFECTS__
function createSlotClone(ownerName) {
    const SlotClone = __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$server$2f$future$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__.forwardRef((props, forwardedRef)=>{
        let { children, ...slotProps } = props;
        if (isLazyComponent(children) && typeof use === "function") {
            children = use(children._payload);
        }
        if (__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$server$2f$future$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__.isValidElement(children)) {
            const childrenRef = getElementRef(children);
            const props2 = mergeProps(slotProps, children.props);
            if (children.type !== __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$server$2f$future$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__.Fragment) {
                props2.ref = forwardedRef ? (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f40$radix$2d$ui$2f$react$2d$compose$2d$refs$2f$dist$2f$index$2e$mjs__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["composeRefs"])(forwardedRef, childrenRef) : childrenRef;
            }
            return __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$server$2f$future$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__.cloneElement(children, props2);
        }
        return __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$server$2f$future$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__.Children.count(children) > 1 ? __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$server$2f$future$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__.Children.only(null) : null;
    });
    SlotClone.displayName = `${ownerName}.SlotClone`;
    return SlotClone;
}
var SLOTTABLE_IDENTIFIER = Symbol("radix.slottable");
// @__NO_SIDE_EFFECTS__
function createSlottable(ownerName) {
    const Slottable2 = ({ children })=>{
        return /* @__PURE__ */ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$server$2f$future$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2d$jsx$2d$runtime$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["jsx"])(__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$server$2f$future$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2d$jsx$2d$runtime$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["Fragment"], {
            children
        });
    };
    Slottable2.displayName = `${ownerName}.Slottable`;
    Slottable2.__radixId = SLOTTABLE_IDENTIFIER;
    return Slottable2;
}
var Slottable = /* @__PURE__ */ createSlottable("Slottable");
function isSlottable(child) {
    return __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$server$2f$future$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__.isValidElement(child) && typeof child.type === "function" && "__radixId" in child.type && child.type.__radixId === SLOTTABLE_IDENTIFIER;
}
function mergeProps(slotProps, childProps) {
    const overrideProps = {
        ...childProps
    };
    for(const propName in childProps){
        const slotPropValue = slotProps[propName];
        const childPropValue = childProps[propName];
        const isHandler = /^on[A-Z]/.test(propName);
        if (isHandler) {
            if (slotPropValue && childPropValue) {
                overrideProps[propName] = (...args)=>{
                    const result = childPropValue(...args);
                    slotPropValue(...args);
                    return result;
                };
            } else if (slotPropValue) {
                overrideProps[propName] = slotPropValue;
            }
        } else if (propName === "style") {
            overrideProps[propName] = {
                ...slotPropValue,
                ...childPropValue
            };
        } else if (propName === "className") {
            overrideProps[propName] = [
                slotPropValue,
                childPropValue
            ].filter(Boolean).join(" ");
        }
    }
    return {
        ...slotProps,
        ...overrideProps
    };
}
function getElementRef(element) {
    let getter = Object.getOwnPropertyDescriptor(element.props, "ref")?.get;
    let mayWarn = getter && "isReactWarning" in getter && getter.isReactWarning;
    if (mayWarn) {
        return element.ref;
    }
    getter = Object.getOwnPropertyDescriptor(element, "ref")?.get;
    mayWarn = getter && "isReactWarning" in getter && getter.isReactWarning;
    if (mayWarn) {
        return element.props.ref;
    }
    return element.props.ref || element.ref;
}
;
 //# sourceMappingURL=index.mjs.map

})()),
"[project]/node_modules/@radix-ui/react-separator/node_modules/@radix-ui/react-primitive/dist/index.mjs [app-ssr] (ecmascript)": (({ r: __turbopack_require__, f: __turbopack_module_context__, i: __turbopack_import__, s: __turbopack_esm__, v: __turbopack_export_value__, n: __turbopack_export_namespace__, c: __turbopack_cache__, M: __turbopack_modules__, l: __turbopack_load__, j: __turbopack_dynamic__, P: __turbopack_resolve_absolute_path__, U: __turbopack_relative_url__, R: __turbopack_resolve_module_id_path__, g: global, __dirname, x: __turbopack_external_require__, y: __turbopack_external_import__ }) => (() => {
"use strict";

// src/primitive.tsx
__turbopack_esm__({
    "Primitive": ()=>Primitive,
    "Root": ()=>Root,
    "dispatchDiscreteCustomEvent": ()=>dispatchDiscreteCustomEvent
});
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$server$2f$future$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_import__("[project]/node_modules/next/dist/server/future/route-modules/app-page/vendored/ssr/react.js [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$server$2f$future$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2d$dom$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_import__("[project]/node_modules/next/dist/server/future/route-modules/app-page/vendored/ssr/react-dom.js [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f40$radix$2d$ui$2f$react$2d$slot$2f$dist$2f$index$2e$mjs__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_import__("[project]/node_modules/@radix-ui/react-slot/dist/index.mjs [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$server$2f$future$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2d$jsx$2d$runtime$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_import__("[project]/node_modules/next/dist/server/future/route-modules/app-page/vendored/ssr/react-jsx-runtime.js [app-ssr] (ecmascript)");
"__TURBOPACK__ecmascript__hoisting__location__";
;
;
;
;
var NODES = [
    "a",
    "button",
    "div",
    "form",
    "h2",
    "h3",
    "img",
    "input",
    "label",
    "li",
    "nav",
    "ol",
    "p",
    "select",
    "span",
    "svg",
    "ul"
];
var Primitive = NODES.reduce((primitive, node)=>{
    const Slot = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f40$radix$2d$ui$2f$react$2d$slot$2f$dist$2f$index$2e$mjs__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["createSlot"])(`Primitive.${node}`);
    const Node = __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$server$2f$future$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__.forwardRef((props, forwardedRef)=>{
        const { asChild, ...primitiveProps } = props;
        const Comp = asChild ? Slot : node;
        if (typeof window !== "undefined") {
            window[Symbol.for("radix-ui")] = true;
        }
        return /* @__PURE__ */ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$server$2f$future$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2d$jsx$2d$runtime$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["jsx"])(Comp, {
            ...primitiveProps,
            ref: forwardedRef
        });
    });
    Node.displayName = `Primitive.${node}`;
    return {
        ...primitive,
        [node]: Node
    };
}, {});
function dispatchDiscreteCustomEvent(target, event) {
    if (target) __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$server$2f$future$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2d$dom$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__.flushSync(()=>target.dispatchEvent(event));
}
var Root = Primitive;
;
 //# sourceMappingURL=index.mjs.map

})()),
"[project]/node_modules/@radix-ui/react-separator/dist/index.mjs [app-ssr] (ecmascript)": (({ r: __turbopack_require__, f: __turbopack_module_context__, i: __turbopack_import__, s: __turbopack_esm__, v: __turbopack_export_value__, n: __turbopack_export_namespace__, c: __turbopack_cache__, M: __turbopack_modules__, l: __turbopack_load__, j: __turbopack_dynamic__, P: __turbopack_resolve_absolute_path__, U: __turbopack_relative_url__, R: __turbopack_resolve_module_id_path__, g: global, __dirname, x: __turbopack_external_require__, y: __turbopack_external_import__ }) => (() => {
"use strict";

// src/separator.tsx
__turbopack_esm__({
    "Root": ()=>Root,
    "Separator": ()=>Separator
});
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$server$2f$future$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_import__("[project]/node_modules/next/dist/server/future/route-modules/app-page/vendored/ssr/react.js [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f40$radix$2d$ui$2f$react$2d$separator$2f$node_modules$2f40$radix$2d$ui$2f$react$2d$primitive$2f$dist$2f$index$2e$mjs__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_import__("[project]/node_modules/@radix-ui/react-separator/node_modules/@radix-ui/react-primitive/dist/index.mjs [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$server$2f$future$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2d$jsx$2d$runtime$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_import__("[project]/node_modules/next/dist/server/future/route-modules/app-page/vendored/ssr/react-jsx-runtime.js [app-ssr] (ecmascript)");
"__TURBOPACK__ecmascript__hoisting__location__";
;
;
;
var NAME = "Separator";
var DEFAULT_ORIENTATION = "horizontal";
var ORIENTATIONS = [
    "horizontal",
    "vertical"
];
var Separator = __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$server$2f$future$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__.forwardRef((props, forwardedRef)=>{
    const { decorative, orientation: orientationProp = DEFAULT_ORIENTATION, ...domProps } = props;
    const orientation = isValidOrientation(orientationProp) ? orientationProp : DEFAULT_ORIENTATION;
    const ariaOrientation = orientation === "vertical" ? orientation : void 0;
    const semanticProps = decorative ? {
        role: "none"
    } : {
        "aria-orientation": ariaOrientation,
        role: "separator"
    };
    return /* @__PURE__ */ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$server$2f$future$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2d$jsx$2d$runtime$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["jsx"])(__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f40$radix$2d$ui$2f$react$2d$separator$2f$node_modules$2f40$radix$2d$ui$2f$react$2d$primitive$2f$dist$2f$index$2e$mjs__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["Primitive"].div, {
        "data-orientation": orientation,
        ...semanticProps,
        ...domProps,
        ref: forwardedRef
    });
});
Separator.displayName = NAME;
function isValidOrientation(orientation) {
    return ORIENTATIONS.includes(orientation);
}
var Root = Separator;
;
 //# sourceMappingURL=index.mjs.map

})()),
"[project]/node_modules/lodash/isObject.js [app-ssr] (ecmascript)": (function({ r: __turbopack_require__, f: __turbopack_module_context__, i: __turbopack_import__, s: __turbopack_esm__, v: __turbopack_export_value__, n: __turbopack_export_namespace__, c: __turbopack_cache__, M: __turbopack_modules__, l: __turbopack_load__, j: __turbopack_dynamic__, P: __turbopack_resolve_absolute_path__, U: __turbopack_relative_url__, R: __turbopack_resolve_module_id_path__, g: global, __dirname, x: __turbopack_external_require__, y: __turbopack_external_import__, m: module, e: exports, t: require }) { !function() {

/**
 * Checks if `value` is the
 * [language type](http://www.ecma-international.org/ecma-262/7.0/#sec-ecmascript-language-types)
 * of `Object`. (e.g. arrays, functions, objects, regexes, `new Number(0)`, and `new String('')`)
 *
 * @static
 * @memberOf _
 * @since 0.1.0
 * @category Lang
 * @param {*} value The value to check.
 * @returns {boolean} Returns `true` if `value` is an object, else `false`.
 * @example
 *
 * _.isObject({});
 * // => true
 *
 * _.isObject([1, 2, 3]);
 * // => true
 *
 * _.isObject(_.noop);
 * // => true
 *
 * _.isObject(null);
 * // => false
 */ function isObject(value) {
    var type = typeof value;
    return value != null && (type == 'object' || type == 'function');
}
module.exports = isObject;

}.call(this) }),
"[project]/node_modules/lodash/_freeGlobal.js [app-ssr] (ecmascript)": (function({ r: __turbopack_require__, f: __turbopack_module_context__, i: __turbopack_import__, s: __turbopack_esm__, v: __turbopack_export_value__, n: __turbopack_export_namespace__, c: __turbopack_cache__, M: __turbopack_modules__, l: __turbopack_load__, j: __turbopack_dynamic__, P: __turbopack_resolve_absolute_path__, U: __turbopack_relative_url__, R: __turbopack_resolve_module_id_path__, g: global, __dirname, x: __turbopack_external_require__, y: __turbopack_external_import__, m: module, e: exports, t: require }) { !function() {

/** Detect free variable `global` from Node.js. */ var freeGlobal = typeof global == 'object' && global && global.Object === Object && global;
module.exports = freeGlobal;

}.call(this) }),
"[project]/node_modules/lodash/_root.js [app-ssr] (ecmascript)": (function({ r: __turbopack_require__, f: __turbopack_module_context__, i: __turbopack_import__, s: __turbopack_esm__, v: __turbopack_export_value__, n: __turbopack_export_namespace__, c: __turbopack_cache__, M: __turbopack_modules__, l: __turbopack_load__, j: __turbopack_dynamic__, P: __turbopack_resolve_absolute_path__, U: __turbopack_relative_url__, R: __turbopack_resolve_module_id_path__, g: global, __dirname, x: __turbopack_external_require__, y: __turbopack_external_import__, m: module, e: exports, t: require }) { !function() {

var freeGlobal = __turbopack_require__("[project]/node_modules/lodash/_freeGlobal.js [app-ssr] (ecmascript)");
/** Detect free variable `self`. */ var freeSelf = typeof self == 'object' && self && self.Object === Object && self;
/** Used as a reference to the global object. */ var root = freeGlobal || freeSelf || Function('return this')();
module.exports = root;

}.call(this) }),
"[project]/node_modules/lodash/now.js [app-ssr] (ecmascript)": (function({ r: __turbopack_require__, f: __turbopack_module_context__, i: __turbopack_import__, s: __turbopack_esm__, v: __turbopack_export_value__, n: __turbopack_export_namespace__, c: __turbopack_cache__, M: __turbopack_modules__, l: __turbopack_load__, j: __turbopack_dynamic__, P: __turbopack_resolve_absolute_path__, U: __turbopack_relative_url__, R: __turbopack_resolve_module_id_path__, g: global, __dirname, x: __turbopack_external_require__, y: __turbopack_external_import__, m: module, e: exports, t: require }) { !function() {

var root = __turbopack_require__("[project]/node_modules/lodash/_root.js [app-ssr] (ecmascript)");
/**
 * Gets the timestamp of the number of milliseconds that have elapsed since
 * the Unix epoch (1 January 1970 00:00:00 UTC).
 *
 * @static
 * @memberOf _
 * @since 2.4.0
 * @category Date
 * @returns {number} Returns the timestamp.
 * @example
 *
 * _.defer(function(stamp) {
 *   console.log(_.now() - stamp);
 * }, _.now());
 * // => Logs the number of milliseconds it took for the deferred invocation.
 */ var now = function() {
    return root.Date.now();
};
module.exports = now;

}.call(this) }),
"[project]/node_modules/lodash/_trimmedEndIndex.js [app-ssr] (ecmascript)": (function({ r: __turbopack_require__, f: __turbopack_module_context__, i: __turbopack_import__, s: __turbopack_esm__, v: __turbopack_export_value__, n: __turbopack_export_namespace__, c: __turbopack_cache__, M: __turbopack_modules__, l: __turbopack_load__, j: __turbopack_dynamic__, P: __turbopack_resolve_absolute_path__, U: __turbopack_relative_url__, R: __turbopack_resolve_module_id_path__, g: global, __dirname, x: __turbopack_external_require__, y: __turbopack_external_import__, m: module, e: exports, t: require }) { !function() {

/** Used to match a single whitespace character. */ var reWhitespace = /\s/;
/**
 * Used by `_.trim` and `_.trimEnd` to get the index of the last non-whitespace
 * character of `string`.
 *
 * @private
 * @param {string} string The string to inspect.
 * @returns {number} Returns the index of the last non-whitespace character.
 */ function trimmedEndIndex(string) {
    var index = string.length;
    while(index-- && reWhitespace.test(string.charAt(index))){}
    return index;
}
module.exports = trimmedEndIndex;

}.call(this) }),
"[project]/node_modules/lodash/_baseTrim.js [app-ssr] (ecmascript)": (function({ r: __turbopack_require__, f: __turbopack_module_context__, i: __turbopack_import__, s: __turbopack_esm__, v: __turbopack_export_value__, n: __turbopack_export_namespace__, c: __turbopack_cache__, M: __turbopack_modules__, l: __turbopack_load__, j: __turbopack_dynamic__, P: __turbopack_resolve_absolute_path__, U: __turbopack_relative_url__, R: __turbopack_resolve_module_id_path__, g: global, __dirname, x: __turbopack_external_require__, y: __turbopack_external_import__, m: module, e: exports, t: require }) { !function() {

var trimmedEndIndex = __turbopack_require__("[project]/node_modules/lodash/_trimmedEndIndex.js [app-ssr] (ecmascript)");
/** Used to match leading whitespace. */ var reTrimStart = /^\s+/;
/**
 * The base implementation of `_.trim`.
 *
 * @private
 * @param {string} string The string to trim.
 * @returns {string} Returns the trimmed string.
 */ function baseTrim(string) {
    return string ? string.slice(0, trimmedEndIndex(string) + 1).replace(reTrimStart, '') : string;
}
module.exports = baseTrim;

}.call(this) }),
"[project]/node_modules/lodash/_Symbol.js [app-ssr] (ecmascript)": (function({ r: __turbopack_require__, f: __turbopack_module_context__, i: __turbopack_import__, s: __turbopack_esm__, v: __turbopack_export_value__, n: __turbopack_export_namespace__, c: __turbopack_cache__, M: __turbopack_modules__, l: __turbopack_load__, j: __turbopack_dynamic__, P: __turbopack_resolve_absolute_path__, U: __turbopack_relative_url__, R: __turbopack_resolve_module_id_path__, g: global, __dirname, x: __turbopack_external_require__, y: __turbopack_external_import__, m: module, e: exports, t: require }) { !function() {

var root = __turbopack_require__("[project]/node_modules/lodash/_root.js [app-ssr] (ecmascript)");
/** Built-in value references. */ var Symbol = root.Symbol;
module.exports = Symbol;

}.call(this) }),
"[project]/node_modules/lodash/_getRawTag.js [app-ssr] (ecmascript)": (function({ r: __turbopack_require__, f: __turbopack_module_context__, i: __turbopack_import__, s: __turbopack_esm__, v: __turbopack_export_value__, n: __turbopack_export_namespace__, c: __turbopack_cache__, M: __turbopack_modules__, l: __turbopack_load__, j: __turbopack_dynamic__, P: __turbopack_resolve_absolute_path__, U: __turbopack_relative_url__, R: __turbopack_resolve_module_id_path__, g: global, __dirname, x: __turbopack_external_require__, y: __turbopack_external_import__, m: module, e: exports, t: require }) { !function() {

var Symbol = __turbopack_require__("[project]/node_modules/lodash/_Symbol.js [app-ssr] (ecmascript)");
/** Used for built-in method references. */ var objectProto = Object.prototype;
/** Used to check objects for own properties. */ var hasOwnProperty = objectProto.hasOwnProperty;
/**
 * Used to resolve the
 * [`toStringTag`](http://ecma-international.org/ecma-262/7.0/#sec-object.prototype.tostring)
 * of values.
 */ var nativeObjectToString = objectProto.toString;
/** Built-in value references. */ var symToStringTag = Symbol ? Symbol.toStringTag : undefined;
/**
 * A specialized version of `baseGetTag` which ignores `Symbol.toStringTag` values.
 *
 * @private
 * @param {*} value The value to query.
 * @returns {string} Returns the raw `toStringTag`.
 */ function getRawTag(value) {
    var isOwn = hasOwnProperty.call(value, symToStringTag), tag = value[symToStringTag];
    try {
        value[symToStringTag] = undefined;
        var unmasked = true;
    } catch (e) {}
    var result = nativeObjectToString.call(value);
    if ("TURBOPACK compile-time truthy", 1) {
        if (isOwn) {
            value[symToStringTag] = tag;
        } else {
            delete value[symToStringTag];
        }
    }
    return result;
}
module.exports = getRawTag;

}.call(this) }),
"[project]/node_modules/lodash/_objectToString.js [app-ssr] (ecmascript)": (function({ r: __turbopack_require__, f: __turbopack_module_context__, i: __turbopack_import__, s: __turbopack_esm__, v: __turbopack_export_value__, n: __turbopack_export_namespace__, c: __turbopack_cache__, M: __turbopack_modules__, l: __turbopack_load__, j: __turbopack_dynamic__, P: __turbopack_resolve_absolute_path__, U: __turbopack_relative_url__, R: __turbopack_resolve_module_id_path__, g: global, __dirname, x: __turbopack_external_require__, y: __turbopack_external_import__, m: module, e: exports, t: require }) { !function() {

/** Used for built-in method references. */ var objectProto = Object.prototype;
/**
 * Used to resolve the
 * [`toStringTag`](http://ecma-international.org/ecma-262/7.0/#sec-object.prototype.tostring)
 * of values.
 */ var nativeObjectToString = objectProto.toString;
/**
 * Converts `value` to a string using `Object.prototype.toString`.
 *
 * @private
 * @param {*} value The value to convert.
 * @returns {string} Returns the converted string.
 */ function objectToString(value) {
    return nativeObjectToString.call(value);
}
module.exports = objectToString;

}.call(this) }),
"[project]/node_modules/lodash/_baseGetTag.js [app-ssr] (ecmascript)": (function({ r: __turbopack_require__, f: __turbopack_module_context__, i: __turbopack_import__, s: __turbopack_esm__, v: __turbopack_export_value__, n: __turbopack_export_namespace__, c: __turbopack_cache__, M: __turbopack_modules__, l: __turbopack_load__, j: __turbopack_dynamic__, P: __turbopack_resolve_absolute_path__, U: __turbopack_relative_url__, R: __turbopack_resolve_module_id_path__, g: global, __dirname, x: __turbopack_external_require__, y: __turbopack_external_import__, m: module, e: exports, t: require }) { !function() {

var Symbol = __turbopack_require__("[project]/node_modules/lodash/_Symbol.js [app-ssr] (ecmascript)"), getRawTag = __turbopack_require__("[project]/node_modules/lodash/_getRawTag.js [app-ssr] (ecmascript)"), objectToString = __turbopack_require__("[project]/node_modules/lodash/_objectToString.js [app-ssr] (ecmascript)");
/** `Object#toString` result references. */ var nullTag = '[object Null]', undefinedTag = '[object Undefined]';
/** Built-in value references. */ var symToStringTag = Symbol ? Symbol.toStringTag : undefined;
/**
 * The base implementation of `getTag` without fallbacks for buggy environments.
 *
 * @private
 * @param {*} value The value to query.
 * @returns {string} Returns the `toStringTag`.
 */ function baseGetTag(value) {
    if (value == null) {
        return value === undefined ? undefinedTag : nullTag;
    }
    return symToStringTag && symToStringTag in Object(value) ? getRawTag(value) : objectToString(value);
}
module.exports = baseGetTag;

}.call(this) }),
"[project]/node_modules/lodash/isObjectLike.js [app-ssr] (ecmascript)": (function({ r: __turbopack_require__, f: __turbopack_module_context__, i: __turbopack_import__, s: __turbopack_esm__, v: __turbopack_export_value__, n: __turbopack_export_namespace__, c: __turbopack_cache__, M: __turbopack_modules__, l: __turbopack_load__, j: __turbopack_dynamic__, P: __turbopack_resolve_absolute_path__, U: __turbopack_relative_url__, R: __turbopack_resolve_module_id_path__, g: global, __dirname, x: __turbopack_external_require__, y: __turbopack_external_import__, m: module, e: exports, t: require }) { !function() {

/**
 * Checks if `value` is object-like. A value is object-like if it's not `null`
 * and has a `typeof` result of "object".
 *
 * @static
 * @memberOf _
 * @since 4.0.0
 * @category Lang
 * @param {*} value The value to check.
 * @returns {boolean} Returns `true` if `value` is object-like, else `false`.
 * @example
 *
 * _.isObjectLike({});
 * // => true
 *
 * _.isObjectLike([1, 2, 3]);
 * // => true
 *
 * _.isObjectLike(_.noop);
 * // => false
 *
 * _.isObjectLike(null);
 * // => false
 */ function isObjectLike(value) {
    return value != null && typeof value == 'object';
}
module.exports = isObjectLike;

}.call(this) }),
"[project]/node_modules/lodash/isSymbol.js [app-ssr] (ecmascript)": (function({ r: __turbopack_require__, f: __turbopack_module_context__, i: __turbopack_import__, s: __turbopack_esm__, v: __turbopack_export_value__, n: __turbopack_export_namespace__, c: __turbopack_cache__, M: __turbopack_modules__, l: __turbopack_load__, j: __turbopack_dynamic__, P: __turbopack_resolve_absolute_path__, U: __turbopack_relative_url__, R: __turbopack_resolve_module_id_path__, g: global, __dirname, x: __turbopack_external_require__, y: __turbopack_external_import__, m: module, e: exports, t: require }) { !function() {

var baseGetTag = __turbopack_require__("[project]/node_modules/lodash/_baseGetTag.js [app-ssr] (ecmascript)"), isObjectLike = __turbopack_require__("[project]/node_modules/lodash/isObjectLike.js [app-ssr] (ecmascript)");
/** `Object#toString` result references. */ var symbolTag = '[object Symbol]';
/**
 * Checks if `value` is classified as a `Symbol` primitive or object.
 *
 * @static
 * @memberOf _
 * @since 4.0.0
 * @category Lang
 * @param {*} value The value to check.
 * @returns {boolean} Returns `true` if `value` is a symbol, else `false`.
 * @example
 *
 * _.isSymbol(Symbol.iterator);
 * // => true
 *
 * _.isSymbol('abc');
 * // => false
 */ function isSymbol(value) {
    return typeof value == 'symbol' || isObjectLike(value) && baseGetTag(value) == symbolTag;
}
module.exports = isSymbol;

}.call(this) }),
"[project]/node_modules/lodash/toNumber.js [app-ssr] (ecmascript)": (function({ r: __turbopack_require__, f: __turbopack_module_context__, i: __turbopack_import__, s: __turbopack_esm__, v: __turbopack_export_value__, n: __turbopack_export_namespace__, c: __turbopack_cache__, M: __turbopack_modules__, l: __turbopack_load__, j: __turbopack_dynamic__, P: __turbopack_resolve_absolute_path__, U: __turbopack_relative_url__, R: __turbopack_resolve_module_id_path__, g: global, __dirname, x: __turbopack_external_require__, y: __turbopack_external_import__, m: module, e: exports, t: require }) { !function() {

var baseTrim = __turbopack_require__("[project]/node_modules/lodash/_baseTrim.js [app-ssr] (ecmascript)"), isObject = __turbopack_require__("[project]/node_modules/lodash/isObject.js [app-ssr] (ecmascript)"), isSymbol = __turbopack_require__("[project]/node_modules/lodash/isSymbol.js [app-ssr] (ecmascript)");
/** Used as references for various `Number` constants. */ var NAN = 0 / 0;
/** Used to detect bad signed hexadecimal string values. */ var reIsBadHex = /^[-+]0x[0-9a-f]+$/i;
/** Used to detect binary string values. */ var reIsBinary = /^0b[01]+$/i;
/** Used to detect octal string values. */ var reIsOctal = /^0o[0-7]+$/i;
/** Built-in method references without a dependency on `root`. */ var freeParseInt = parseInt;
/**
 * Converts `value` to a number.
 *
 * @static
 * @memberOf _
 * @since 4.0.0
 * @category Lang
 * @param {*} value The value to process.
 * @returns {number} Returns the number.
 * @example
 *
 * _.toNumber(3.2);
 * // => 3.2
 *
 * _.toNumber(Number.MIN_VALUE);
 * // => 5e-324
 *
 * _.toNumber(Infinity);
 * // => Infinity
 *
 * _.toNumber('3.2');
 * // => 3.2
 */ function toNumber(value) {
    if (typeof value == 'number') {
        return value;
    }
    if (isSymbol(value)) {
        return NAN;
    }
    if (isObject(value)) {
        var other = typeof value.valueOf == 'function' ? value.valueOf() : value;
        value = isObject(other) ? other + '' : other;
    }
    if (typeof value != 'string') {
        return value === 0 ? value : +value;
    }
    value = baseTrim(value);
    var isBinary = reIsBinary.test(value);
    return isBinary || reIsOctal.test(value) ? freeParseInt(value.slice(2), isBinary ? 2 : 8) : reIsBadHex.test(value) ? NAN : +value;
}
module.exports = toNumber;

}.call(this) }),
"[project]/node_modules/lodash/debounce.js [app-ssr] (ecmascript)": (function({ r: __turbopack_require__, f: __turbopack_module_context__, i: __turbopack_import__, s: __turbopack_esm__, v: __turbopack_export_value__, n: __turbopack_export_namespace__, c: __turbopack_cache__, M: __turbopack_modules__, l: __turbopack_load__, j: __turbopack_dynamic__, P: __turbopack_resolve_absolute_path__, U: __turbopack_relative_url__, R: __turbopack_resolve_module_id_path__, g: global, __dirname, x: __turbopack_external_require__, y: __turbopack_external_import__, m: module, e: exports, t: require }) { !function() {

var isObject = __turbopack_require__("[project]/node_modules/lodash/isObject.js [app-ssr] (ecmascript)"), now = __turbopack_require__("[project]/node_modules/lodash/now.js [app-ssr] (ecmascript)"), toNumber = __turbopack_require__("[project]/node_modules/lodash/toNumber.js [app-ssr] (ecmascript)");
/** Error message constants. */ var FUNC_ERROR_TEXT = 'Expected a function';
/* Built-in method references for those with the same name as other `lodash` methods. */ var nativeMax = Math.max, nativeMin = Math.min;
/**
 * Creates a debounced function that delays invoking `func` until after `wait`
 * milliseconds have elapsed since the last time the debounced function was
 * invoked. The debounced function comes with a `cancel` method to cancel
 * delayed `func` invocations and a `flush` method to immediately invoke them.
 * Provide `options` to indicate whether `func` should be invoked on the
 * leading and/or trailing edge of the `wait` timeout. The `func` is invoked
 * with the last arguments provided to the debounced function. Subsequent
 * calls to the debounced function return the result of the last `func`
 * invocation.
 *
 * **Note:** If `leading` and `trailing` options are `true`, `func` is
 * invoked on the trailing edge of the timeout only if the debounced function
 * is invoked more than once during the `wait` timeout.
 *
 * If `wait` is `0` and `leading` is `false`, `func` invocation is deferred
 * until to the next tick, similar to `setTimeout` with a timeout of `0`.
 *
 * See [David Corbacho's article](https://css-tricks.com/debouncing-throttling-explained-examples/)
 * for details over the differences between `_.debounce` and `_.throttle`.
 *
 * @static
 * @memberOf _
 * @since 0.1.0
 * @category Function
 * @param {Function} func The function to debounce.
 * @param {number} [wait=0] The number of milliseconds to delay.
 * @param {Object} [options={}] The options object.
 * @param {boolean} [options.leading=false]
 *  Specify invoking on the leading edge of the timeout.
 * @param {number} [options.maxWait]
 *  The maximum time `func` is allowed to be delayed before it's invoked.
 * @param {boolean} [options.trailing=true]
 *  Specify invoking on the trailing edge of the timeout.
 * @returns {Function} Returns the new debounced function.
 * @example
 *
 * // Avoid costly calculations while the window size is in flux.
 * jQuery(window).on('resize', _.debounce(calculateLayout, 150));
 *
 * // Invoke `sendMail` when clicked, debouncing subsequent calls.
 * jQuery(element).on('click', _.debounce(sendMail, 300, {
 *   'leading': true,
 *   'trailing': false
 * }));
 *
 * // Ensure `batchLog` is invoked once after 1 second of debounced calls.
 * var debounced = _.debounce(batchLog, 250, { 'maxWait': 1000 });
 * var source = new EventSource('/stream');
 * jQuery(source).on('message', debounced);
 *
 * // Cancel the trailing debounced invocation.
 * jQuery(window).on('popstate', debounced.cancel);
 */ function debounce(func, wait, options) {
    var lastArgs, lastThis, maxWait, result, timerId, lastCallTime, lastInvokeTime = 0, leading = false, maxing = false, trailing = true;
    if (typeof func != 'function') {
        throw new TypeError(FUNC_ERROR_TEXT);
    }
    wait = toNumber(wait) || 0;
    if (isObject(options)) {
        leading = !!options.leading;
        maxing = 'maxWait' in options;
        maxWait = maxing ? nativeMax(toNumber(options.maxWait) || 0, wait) : maxWait;
        trailing = 'trailing' in options ? !!options.trailing : trailing;
    }
    function invokeFunc(time) {
        var args = lastArgs, thisArg = lastThis;
        lastArgs = lastThis = undefined;
        lastInvokeTime = time;
        result = func.apply(thisArg, args);
        return result;
    }
    function leadingEdge(time) {
        // Reset any `maxWait` timer.
        lastInvokeTime = time;
        // Start the timer for the trailing edge.
        timerId = setTimeout(timerExpired, wait);
        // Invoke the leading edge.
        return leading ? invokeFunc(time) : result;
    }
    function remainingWait(time) {
        var timeSinceLastCall = time - lastCallTime, timeSinceLastInvoke = time - lastInvokeTime, timeWaiting = wait - timeSinceLastCall;
        return maxing ? nativeMin(timeWaiting, maxWait - timeSinceLastInvoke) : timeWaiting;
    }
    function shouldInvoke(time) {
        var timeSinceLastCall = time - lastCallTime, timeSinceLastInvoke = time - lastInvokeTime;
        // Either this is the first call, activity has stopped and we're at the
        // trailing edge, the system time has gone backwards and we're treating
        // it as the trailing edge, or we've hit the `maxWait` limit.
        return lastCallTime === undefined || timeSinceLastCall >= wait || timeSinceLastCall < 0 || maxing && timeSinceLastInvoke >= maxWait;
    }
    function timerExpired() {
        var time = now();
        if (shouldInvoke(time)) {
            return trailingEdge(time);
        }
        // Restart the timer.
        timerId = setTimeout(timerExpired, remainingWait(time));
    }
    function trailingEdge(time) {
        timerId = undefined;
        // Only invoke if we have `lastArgs` which means `func` has been
        // debounced at least once.
        if (trailing && lastArgs) {
            return invokeFunc(time);
        }
        lastArgs = lastThis = undefined;
        return result;
    }
    function cancel() {
        if (timerId !== undefined) {
            clearTimeout(timerId);
        }
        lastInvokeTime = 0;
        lastArgs = lastCallTime = lastThis = timerId = undefined;
    }
    function flush() {
        return timerId === undefined ? result : trailingEdge(now());
    }
    function debounced() {
        var time = now(), isInvoking = shouldInvoke(time);
        lastArgs = arguments;
        lastThis = this;
        lastCallTime = time;
        if (isInvoking) {
            if (timerId === undefined) {
                return leadingEdge(lastCallTime);
            }
            if (maxing) {
                // Handle invocations in a tight loop.
                clearTimeout(timerId);
                timerId = setTimeout(timerExpired, wait);
                return invokeFunc(lastCallTime);
            }
        }
        if (timerId === undefined) {
            timerId = setTimeout(timerExpired, wait);
        }
        return result;
    }
    debounced.cancel = cancel;
    debounced.flush = flush;
    return debounced;
}
module.exports = debounce;

}.call(this) }),
"[project]/node_modules/@auth/core/errors.js [app-ssr] (ecmascript)": (({ r: __turbopack_require__, f: __turbopack_module_context__, i: __turbopack_import__, s: __turbopack_esm__, v: __turbopack_export_value__, n: __turbopack_export_namespace__, c: __turbopack_cache__, M: __turbopack_modules__, l: __turbopack_load__, j: __turbopack_dynamic__, P: __turbopack_resolve_absolute_path__, U: __turbopack_relative_url__, R: __turbopack_resolve_module_id_path__, g: global, __dirname, x: __turbopack_external_require__, y: __turbopack_external_import__ }) => (() => {
"use strict";

/**
 * Base error class for all Auth.js errors.
 * It's optimized to be printed in the server logs in a nicely formatted way
 * via the [`logger.error`](https://authjs.dev/reference/core#logger) option.
 */ __turbopack_esm__({
    "AccessDenied": ()=>AccessDenied,
    "AccountNotLinked": ()=>AccountNotLinked,
    "AdapterError": ()=>AdapterError,
    "AuthError": ()=>AuthError,
    "CallbackRouteError": ()=>CallbackRouteError,
    "CredentialsSignin": ()=>CredentialsSignin,
    "DuplicateConditionalUI": ()=>DuplicateConditionalUI,
    "EmailSignInError": ()=>EmailSignInError,
    "ErrorPageLoop": ()=>ErrorPageLoop,
    "EventError": ()=>EventError,
    "ExperimentalFeatureNotEnabled": ()=>ExperimentalFeatureNotEnabled,
    "InvalidCallbackUrl": ()=>InvalidCallbackUrl,
    "InvalidCheck": ()=>InvalidCheck,
    "InvalidEndpoints": ()=>InvalidEndpoints,
    "InvalidProvider": ()=>InvalidProvider,
    "JWTSessionError": ()=>JWTSessionError,
    "MissingAdapter": ()=>MissingAdapter,
    "MissingAdapterMethods": ()=>MissingAdapterMethods,
    "MissingAuthorize": ()=>MissingAuthorize,
    "MissingCSRF": ()=>MissingCSRF,
    "MissingSecret": ()=>MissingSecret,
    "MissingWebAuthnAutocomplete": ()=>MissingWebAuthnAutocomplete,
    "OAuthAccountNotLinked": ()=>OAuthAccountNotLinked,
    "OAuthCallbackError": ()=>OAuthCallbackError,
    "OAuthProfileParseError": ()=>OAuthProfileParseError,
    "OAuthSignInError": ()=>OAuthSignInError,
    "SessionTokenError": ()=>SessionTokenError,
    "SignInError": ()=>SignInError,
    "SignOutError": ()=>SignOutError,
    "UnknownAction": ()=>UnknownAction,
    "UnsupportedStrategy": ()=>UnsupportedStrategy,
    "UntrustedHost": ()=>UntrustedHost,
    "Verification": ()=>Verification,
    "WebAuthnVerificationError": ()=>WebAuthnVerificationError,
    "isClientError": ()=>isClientError
});
class AuthError extends Error {
    constructor(message, errorOptions){
        if (message instanceof Error) {
            super(undefined, {
                cause: {
                    err: message,
                    ...message.cause,
                    ...errorOptions
                }
            });
        } else if (typeof message === "string") {
            if (errorOptions instanceof Error) {
                errorOptions = {
                    err: errorOptions,
                    ...errorOptions.cause
                };
            }
            super(message, errorOptions);
        } else {
            super(undefined, message);
        }
        this.name = this.constructor.name;
        // @ts-expect-error https://github.com/microsoft/TypeScript/issues/3841
        this.type = this.constructor.type ?? "AuthError";
        // @ts-expect-error https://github.com/microsoft/TypeScript/issues/3841
        this.kind = this.constructor.kind ?? "error";
        Error.captureStackTrace?.(this, this.constructor);
        const url = `https://errors.authjs.dev#${this.type.toLowerCase()}`;
        this.message += `${this.message ? ". " : ""}Read more at ${url}`;
    }
}
class SignInError extends AuthError {
}
SignInError.kind = "signIn";
class AdapterError extends AuthError {
}
AdapterError.type = "AdapterError";
class AccessDenied extends AuthError {
}
AccessDenied.type = "AccessDenied";
class CallbackRouteError extends AuthError {
}
CallbackRouteError.type = "CallbackRouteError";
class ErrorPageLoop extends AuthError {
}
ErrorPageLoop.type = "ErrorPageLoop";
class EventError extends AuthError {
}
EventError.type = "EventError";
class InvalidCallbackUrl extends AuthError {
}
InvalidCallbackUrl.type = "InvalidCallbackUrl";
class CredentialsSignin extends SignInError {
    constructor(){
        super(...arguments);
        /**
         * The error code that is set in the `code` query parameter of the redirect URL.
         *
         *
         * ⚠ NOTE: This property is going to be included in the URL, so make sure it does not hint at sensitive errors.
         *
         * The full error is always logged on the server, if you need to debug.
         *
         * Generally, we don't recommend hinting specifically if the user had either a wrong username or password specifically,
         * try rather something like "Invalid credentials".
         */ this.code = "credentials";
    }
}
CredentialsSignin.type = "CredentialsSignin";
class InvalidEndpoints extends AuthError {
}
InvalidEndpoints.type = "InvalidEndpoints";
class InvalidCheck extends AuthError {
}
InvalidCheck.type = "InvalidCheck";
class JWTSessionError extends AuthError {
}
JWTSessionError.type = "JWTSessionError";
class MissingAdapter extends AuthError {
}
MissingAdapter.type = "MissingAdapter";
class MissingAdapterMethods extends AuthError {
}
MissingAdapterMethods.type = "MissingAdapterMethods";
class MissingAuthorize extends AuthError {
}
MissingAuthorize.type = "MissingAuthorize";
class MissingSecret extends AuthError {
}
MissingSecret.type = "MissingSecret";
class OAuthAccountNotLinked extends SignInError {
}
OAuthAccountNotLinked.type = "OAuthAccountNotLinked";
class OAuthCallbackError extends SignInError {
}
OAuthCallbackError.type = "OAuthCallbackError";
class OAuthProfileParseError extends AuthError {
}
OAuthProfileParseError.type = "OAuthProfileParseError";
class SessionTokenError extends AuthError {
}
SessionTokenError.type = "SessionTokenError";
class OAuthSignInError extends SignInError {
}
OAuthSignInError.type = "OAuthSignInError";
class EmailSignInError extends SignInError {
}
EmailSignInError.type = "EmailSignInError";
class SignOutError extends AuthError {
}
SignOutError.type = "SignOutError";
class UnknownAction extends AuthError {
}
UnknownAction.type = "UnknownAction";
class UnsupportedStrategy extends AuthError {
}
UnsupportedStrategy.type = "UnsupportedStrategy";
class InvalidProvider extends AuthError {
}
InvalidProvider.type = "InvalidProvider";
class UntrustedHost extends AuthError {
}
UntrustedHost.type = "UntrustedHost";
class Verification extends AuthError {
}
Verification.type = "Verification";
class MissingCSRF extends SignInError {
}
MissingCSRF.type = "MissingCSRF";
const clientErrors = new Set([
    "CredentialsSignin",
    "OAuthAccountNotLinked",
    "OAuthCallbackError",
    "AccessDenied",
    "Verification",
    "MissingCSRF",
    "AccountNotLinked",
    "WebAuthnVerificationError"
]);
function isClientError(error) {
    if (error instanceof AuthError) return clientErrors.has(error.type);
    return false;
}
class DuplicateConditionalUI extends AuthError {
}
DuplicateConditionalUI.type = "DuplicateConditionalUI";
class MissingWebAuthnAutocomplete extends AuthError {
}
MissingWebAuthnAutocomplete.type = "MissingWebAuthnAutocomplete";
class WebAuthnVerificationError extends AuthError {
}
WebAuthnVerificationError.type = "WebAuthnVerificationError";
class AccountNotLinked extends SignInError {
}
AccountNotLinked.type = "AccountNotLinked";
class ExperimentalFeatureNotEnabled extends AuthError {
}
ExperimentalFeatureNotEnabled.type = "ExperimentalFeatureNotEnabled";

})()),
"[project]/node_modules/next-auth/lib/client.js [app-ssr] (ecmascript)": (({ r: __turbopack_require__, f: __turbopack_module_context__, i: __turbopack_import__, s: __turbopack_esm__, v: __turbopack_export_value__, n: __turbopack_export_namespace__, c: __turbopack_cache__, M: __turbopack_modules__, l: __turbopack_load__, j: __turbopack_dynamic__, P: __turbopack_resolve_absolute_path__, U: __turbopack_relative_url__, R: __turbopack_resolve_module_id_path__, g: global, __dirname, x: __turbopack_external_require__, y: __turbopack_external_import__ }) => (() => {
"use strict";

__turbopack_esm__({
    "ClientSessionError": ()=>ClientSessionError,
    "apiBaseUrl": ()=>apiBaseUrl,
    "fetchData": ()=>fetchData,
    "now": ()=>now,
    "parseUrl": ()=>parseUrl,
    "useOnline": ()=>useOnline
});
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$server$2f$future$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_import__("[project]/node_modules/next/dist/server/future/route-modules/app-page/vendored/ssr/react.js [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f40$auth$2f$core$2f$errors$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_import__("[project]/node_modules/@auth/core/errors.js [app-ssr] (ecmascript)");
"__TURBOPACK__ecmascript__hoisting__location__";
"use client";
;
;
/** @todo */ class ClientFetchError extends __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f40$auth$2f$core$2f$errors$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["AuthError"] {
}
class ClientSessionError extends __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f40$auth$2f$core$2f$errors$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["AuthError"] {
}
async function fetchData(path, __NEXTAUTH, logger, req = {}) {
    const url = `${apiBaseUrl(__NEXTAUTH)}/${path}`;
    try {
        const options = {
            headers: {
                "Content-Type": "application/json",
                ...req?.headers?.cookie ? {
                    cookie: req.headers.cookie
                } : {}
            }
        };
        if (req?.body) {
            options.body = JSON.stringify(req.body);
            options.method = "POST";
        }
        const res = await fetch(url, options);
        const data = await res.json();
        if (!res.ok) throw data;
        return data;
    } catch (error) {
        logger.error(new ClientFetchError(error.message, error));
        return null;
    }
}
function apiBaseUrl(__NEXTAUTH) {
    if (typeof window === "undefined") {
        // Return absolute path when called server side
        return `${__NEXTAUTH.baseUrlServer}${__NEXTAUTH.basePathServer}`;
    }
    // Return relative path when called client side
    return __NEXTAUTH.basePath;
}
function useOnline() {
    const [isOnline, setIsOnline] = __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$server$2f$future$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__.useState(typeof navigator !== "undefined" ? navigator.onLine : false);
    const setOnline = ()=>setIsOnline(true);
    const setOffline = ()=>setIsOnline(false);
    __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$server$2f$future$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__.useEffect(()=>{
        window.addEventListener("online", setOnline);
        window.addEventListener("offline", setOffline);
        return ()=>{
            window.removeEventListener("online", setOnline);
            window.removeEventListener("offline", setOffline);
        };
    }, []);
    return isOnline;
}
function now() {
    return Math.floor(Date.now() / 1000);
}
function parseUrl(url) {
    const defaultUrl = new URL("http://localhost:3000/api/auth");
    if (url && !url.startsWith("http")) {
        url = `https://${url}`;
    }
    const _url = new URL(url || defaultUrl);
    const path = (_url.pathname === "/" ? defaultUrl.pathname : _url.pathname)// Remove trailing slash
    .replace(/\/$/, "");
    const base = `${_url.origin}${path}`;
    return {
        origin: _url.origin,
        host: _url.host,
        path,
        base,
        toString: ()=>base
    };
}

})()),
"[project]/node_modules/next-auth/react.js [app-ssr] (ecmascript)": (({ r: __turbopack_require__, f: __turbopack_module_context__, i: __turbopack_import__, s: __turbopack_esm__, v: __turbopack_export_value__, n: __turbopack_export_namespace__, c: __turbopack_cache__, M: __turbopack_modules__, l: __turbopack_load__, j: __turbopack_dynamic__, P: __turbopack_resolve_absolute_path__, U: __turbopack_relative_url__, R: __turbopack_resolve_module_id_path__, g: global, __dirname, x: __turbopack_external_require__, y: __turbopack_external_import__ }) => (() => {
"use strict";

/**
 *
 * NextAuth.js is the official integration of Auth.js for Next.js applications. It supports both
 * [Client Components](https://nextjs.org/docs/app/building-your-application/rendering/client-components) and the
 * [Pages Router](https://nextjs.org/docs/pages). It includes methods for signing in, signing out, hooks, and a React
 * Context provider to wrap your application and make session data available anywhere.
 *
 * For use in [Server Actions](https://nextjs.org/docs/app/api-reference/functions/server-actions), check out [these methods](https://authjs.dev/guides/upgrade-to-v5#methods)
 *
 * @module react
 */ __turbopack_esm__({
    "SessionContext": ()=>SessionContext,
    "SessionProvider": ()=>SessionProvider,
    "__NEXTAUTH": ()=>__NEXTAUTH,
    "getCsrfToken": ()=>getCsrfToken,
    "getProviders": ()=>getProviders,
    "getSession": ()=>getSession,
    "signIn": ()=>signIn,
    "signOut": ()=>signOut,
    "useSession": ()=>useSession
});
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$server$2f$future$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2d$jsx$2d$runtime$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_import__("[project]/node_modules/next/dist/server/future/route-modules/app-page/vendored/ssr/react-jsx-runtime.js [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$server$2f$future$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_import__("[project]/node_modules/next/dist/server/future/route-modules/app-page/vendored/ssr/react.js [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2d$auth$2f$lib$2f$client$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_import__("[project]/node_modules/next-auth/lib/client.js [app-ssr] (ecmascript)");
"__TURBOPACK__ecmascript__hoisting__location__";
"use client";
;
;
;
const __NEXTAUTH = {
    baseUrl: (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2d$auth$2f$lib$2f$client$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["parseUrl"])(process.env.NEXTAUTH_URL ?? process.env.VERCEL_URL).origin,
    basePath: (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2d$auth$2f$lib$2f$client$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["parseUrl"])(process.env.NEXTAUTH_URL).path,
    baseUrlServer: (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2d$auth$2f$lib$2f$client$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["parseUrl"])(process.env.NEXTAUTH_URL_INTERNAL ?? process.env.NEXTAUTH_URL ?? process.env.VERCEL_URL).origin,
    basePathServer: (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2d$auth$2f$lib$2f$client$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["parseUrl"])(process.env.NEXTAUTH_URL_INTERNAL ?? process.env.NEXTAUTH_URL).path,
    _lastSync: 0,
    _session: undefined,
    _getSession: ()=>{}
};
let broadcastChannel = null;
function getNewBroadcastChannel() {
    return new BroadcastChannel("next-auth");
}
function broadcast() {
    if (typeof BroadcastChannel === "undefined") {
        return {
            postMessage: ()=>{},
            addEventListener: ()=>{},
            removeEventListener: ()=>{}
        };
    }
    if (broadcastChannel === null) {
        broadcastChannel = getNewBroadcastChannel();
    }
    return broadcastChannel;
}
// TODO:
const logger = {
    debug: console.debug,
    error: console.error,
    warn: console.warn
};
const SessionContext = __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$server$2f$future$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__.createContext?.(undefined);
function useSession(options) {
    if (!SessionContext) {
        throw new Error("React Context is unavailable in Server Components");
    }
    // @ts-expect-error Satisfy TS if branch on line below
    const value = __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$server$2f$future$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__.useContext(SessionContext);
    if (!value && ("TURBOPACK compile-time value", "development") !== "production") {
        throw new Error("[next-auth]: `useSession` must be wrapped in a <SessionProvider />");
    }
    const { required, onUnauthenticated } = options ?? {};
    const requiredAndNotLoading = required && value.status === "unauthenticated";
    __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$server$2f$future$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__.useEffect(()=>{
        if (requiredAndNotLoading) {
            const url = `${__NEXTAUTH.basePath}/signin?${new URLSearchParams({
                error: "SessionRequired",
                callbackUrl: window.location.href
            })}`;
            if (onUnauthenticated) onUnauthenticated();
            else window.location.href = url;
        }
    }, [
        requiredAndNotLoading,
        onUnauthenticated
    ]);
    if (requiredAndNotLoading) {
        return {
            data: value.data,
            update: value.update,
            status: "loading"
        };
    }
    return value;
}
async function getSession(params) {
    const session = await (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2d$auth$2f$lib$2f$client$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["fetchData"])("session", __NEXTAUTH, logger, params);
    if (params?.broadcast ?? true) {
        const broadcastChannel = getNewBroadcastChannel();
        broadcastChannel.postMessage({
            event: "session",
            data: {
                trigger: "getSession"
            }
        });
    }
    return session;
}
async function getCsrfToken() {
    const response = await (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2d$auth$2f$lib$2f$client$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["fetchData"])("csrf", __NEXTAUTH, logger);
    return response?.csrfToken ?? "";
}
async function getProviders() {
    return (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2d$auth$2f$lib$2f$client$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["fetchData"])("providers", __NEXTAUTH, logger);
}
async function signIn(provider, options, authorizationParams) {
    const { redirect = true } = options ?? {};
    const redirectTo = options?.redirectTo ?? options?.callbackUrl ?? window.location.href;
    const baseUrl = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2d$auth$2f$lib$2f$client$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["apiBaseUrl"])(__NEXTAUTH);
    const providers = await getProviders();
    if (!providers) {
        window.location.href = `${baseUrl}/error`;
        return;
    }
    if (!provider || !(provider in providers)) {
        window.location.href = `${baseUrl}/signin?${new URLSearchParams({
            callbackUrl: redirectTo
        })}`;
        return;
    }
    const isCredentials = providers[provider].type === "credentials";
    const isEmail = providers[provider].type === "email";
    const isSupportingReturn = isCredentials || isEmail;
    const signInUrl = `${baseUrl}/${isCredentials ? "callback" : "signin"}/${provider}`;
    const csrfToken = await getCsrfToken();
    const res = await fetch(`${signInUrl}?${new URLSearchParams(authorizationParams)}`, {
        method: "post",
        headers: {
            "Content-Type": "application/x-www-form-urlencoded",
            "X-Auth-Return-Redirect": "1"
        },
        // @ts-expect-error
        body: new URLSearchParams({
            ...options,
            csrfToken,
            callbackUrl: redirectTo
        })
    });
    const data = await res.json();
    // TODO: Do not redirect for Credentials and Email providers by default in next major
    if (redirect || !isSupportingReturn) {
        const url = data.url ?? redirectTo;
        window.location.href = url;
        // If url contains a hash, the browser does not reload the page. We reload manually
        if (url.includes("#")) window.location.reload();
        return;
    }
    const error = new URL(data.url).searchParams.get("error");
    const code = new URL(data.url).searchParams.get("code");
    if (res.ok) {
        await __NEXTAUTH._getSession({
            event: "storage"
        });
    }
    return {
        error,
        code,
        status: res.status,
        ok: res.ok,
        url: error ? null : data.url
    };
}
async function signOut(options) {
    const redirectTo = options?.redirectTo ?? options?.callbackUrl ?? window.location.href;
    const baseUrl = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2d$auth$2f$lib$2f$client$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["apiBaseUrl"])(__NEXTAUTH);
    const csrfToken = await getCsrfToken();
    const res = await fetch(`${baseUrl}/signout`, {
        method: "post",
        headers: {
            "Content-Type": "application/x-www-form-urlencoded",
            "X-Auth-Return-Redirect": "1"
        },
        body: new URLSearchParams({
            csrfToken,
            callbackUrl: redirectTo
        })
    });
    const data = await res.json();
    broadcast().postMessage({
        event: "session",
        data: {
            trigger: "signout"
        }
    });
    if (options?.redirect ?? true) {
        const url = data.url ?? redirectTo;
        window.location.href = url;
        // If url contains a hash, the browser does not reload the page. We reload manually
        if (url.includes("#")) window.location.reload();
        // @ts-expect-error
        return;
    }
    await __NEXTAUTH._getSession({
        event: "storage"
    });
    return data;
}
function SessionProvider(props) {
    if (!SessionContext) {
        throw new Error("React Context is unavailable in Server Components");
    }
    const { children, basePath, refetchInterval, refetchWhenOffline } = props;
    if (basePath) __NEXTAUTH.basePath = basePath;
    /**
     * If session was `null`, there was an attempt to fetch it,
     * but it failed, but we still treat it as a valid initial value.
     */ const hasInitialSession = props.session !== undefined;
    /** If session was passed, initialize as already synced */ __NEXTAUTH._lastSync = hasInitialSession ? (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2d$auth$2f$lib$2f$client$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["now"])() : 0;
    const [session, setSession] = __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$server$2f$future$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__.useState(()=>{
        if (hasInitialSession) __NEXTAUTH._session = props.session;
        return props.session;
    });
    /** If session was passed, initialize as not loading */ const [loading, setLoading] = __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$server$2f$future$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__.useState(!hasInitialSession);
    __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$server$2f$future$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__.useEffect(()=>{
        __NEXTAUTH._getSession = async ({ event } = {})=>{
            try {
                const storageEvent = event === "storage";
                // We should always update if we don't have a client session yet
                // or if there are events from other tabs/windows
                if (storageEvent || __NEXTAUTH._session === undefined) {
                    __NEXTAUTH._lastSync = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2d$auth$2f$lib$2f$client$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["now"])();
                    __NEXTAUTH._session = await getSession({
                        broadcast: !storageEvent
                    });
                    setSession(__NEXTAUTH._session);
                    return;
                }
                if (// If there is no time defined for when a session should be considered
                // stale, then it's okay to use the value we have until an event is
                // triggered which updates it
                !event || // If the client doesn't have a session then we don't need to call
                // the server to check if it does (if they have signed in via another
                // tab or window that will come through as a "stroage" event
                // event anyway)
                __NEXTAUTH._session === null || // Bail out early if the client session is not stale yet
                (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2d$auth$2f$lib$2f$client$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["now"])() < __NEXTAUTH._lastSync) {
                    return;
                }
                // An event or session staleness occurred, update the client session.
                __NEXTAUTH._lastSync = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2d$auth$2f$lib$2f$client$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["now"])();
                __NEXTAUTH._session = await getSession();
                setSession(__NEXTAUTH._session);
            } catch (error) {
                logger.error(new __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2d$auth$2f$lib$2f$client$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["ClientSessionError"](error.message, error));
            } finally{
                setLoading(false);
            }
        };
        __NEXTAUTH._getSession();
        return ()=>{
            __NEXTAUTH._lastSync = 0;
            __NEXTAUTH._session = undefined;
            __NEXTAUTH._getSession = ()=>{};
        };
    }, []);
    __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$server$2f$future$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__.useEffect(()=>{
        const handle = ()=>__NEXTAUTH._getSession({
                event: "storage"
            });
        // Listen for storage events and update session if event fired from
        // another window (but suppress firing another event to avoid a loop)
        // Fetch new session data but tell it to not to fire another event to
        // avoid an infinite loop.
        // Note: We could pass session data through and do something like
        // `setData(message.data)` but that can cause problems depending
        // on how the session object is being used in the client; it is
        // more robust to have each window/tab fetch it's own copy of the
        // session object rather than share it across instances.
        broadcast().addEventListener("message", handle);
        return ()=>broadcast().removeEventListener("message", handle);
    }, []);
    __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$server$2f$future$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__.useEffect(()=>{
        const { refetchOnWindowFocus = true } = props;
        // Listen for when the page is visible, if the user switches tabs
        // and makes our tab visible again, re-fetch the session, but only if
        // this feature is not disabled.
        const visibilityHandler = ()=>{
            if (refetchOnWindowFocus && document.visibilityState === "visible") __NEXTAUTH._getSession({
                event: "visibilitychange"
            });
        };
        document.addEventListener("visibilitychange", visibilityHandler, false);
        return ()=>document.removeEventListener("visibilitychange", visibilityHandler, false);
    }, [
        props.refetchOnWindowFocus
    ]);
    const isOnline = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2d$auth$2f$lib$2f$client$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["useOnline"])();
    // TODO: Flip this behavior in next major version
    const shouldRefetch = refetchWhenOffline !== false || isOnline;
    __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$server$2f$future$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__.useEffect(()=>{
        if (refetchInterval && shouldRefetch) {
            const refetchIntervalTimer = setInterval(()=>{
                if (__NEXTAUTH._session) {
                    __NEXTAUTH._getSession({
                        event: "poll"
                    });
                }
            }, refetchInterval * 1000);
            return ()=>clearInterval(refetchIntervalTimer);
        }
    }, [
        refetchInterval,
        shouldRefetch
    ]);
    const value = __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$server$2f$future$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__.useMemo(()=>({
            data: session,
            status: loading ? "loading" : session ? "authenticated" : "unauthenticated",
            async update (data) {
                if (loading) return;
                setLoading(true);
                const newSession = await (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2d$auth$2f$lib$2f$client$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["fetchData"])("session", __NEXTAUTH, logger, typeof data === "undefined" ? undefined : {
                    body: {
                        csrfToken: await getCsrfToken(),
                        data
                    }
                });
                setLoading(false);
                if (newSession) {
                    setSession(newSession);
                    broadcast().postMessage({
                        event: "session",
                        data: {
                            trigger: "getSession"
                        }
                    });
                }
                return newSession;
            }
        }), [
        session,
        loading
    ]);
    return(// @ts-expect-error
    (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$server$2f$future$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2d$jsx$2d$runtime$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["jsx"])(SessionContext.Provider, {
        value: value,
        children: children
    }));
}

})()),
"[project]/node_modules/@emotion/memoize/dist/emotion-memoize.esm.js [app-ssr] (ecmascript)": (({ r: __turbopack_require__, f: __turbopack_module_context__, i: __turbopack_import__, s: __turbopack_esm__, v: __turbopack_export_value__, n: __turbopack_export_namespace__, c: __turbopack_cache__, M: __turbopack_modules__, l: __turbopack_load__, j: __turbopack_dynamic__, P: __turbopack_resolve_absolute_path__, U: __turbopack_relative_url__, R: __turbopack_resolve_module_id_path__, g: global, __dirname, x: __turbopack_external_require__, y: __turbopack_external_import__ }) => (() => {
"use strict";

__turbopack_esm__({
    "default": ()=>memoize
});
function memoize(fn) {
    var cache = Object.create(null);
    return function(arg) {
        if (cache[arg] === undefined) cache[arg] = fn(arg);
        return cache[arg];
    };
}
;

})()),
"[project]/node_modules/@emotion/is-prop-valid/dist/emotion-is-prop-valid.esm.js [app-ssr] (ecmascript)": (({ r: __turbopack_require__, f: __turbopack_module_context__, i: __turbopack_import__, s: __turbopack_esm__, v: __turbopack_export_value__, n: __turbopack_export_namespace__, c: __turbopack_cache__, M: __turbopack_modules__, l: __turbopack_load__, j: __turbopack_dynamic__, P: __turbopack_resolve_absolute_path__, U: __turbopack_relative_url__, R: __turbopack_resolve_module_id_path__, g: global, __dirname, x: __turbopack_external_require__, y: __turbopack_external_import__ }) => (() => {
"use strict";

__turbopack_esm__({
    "default": ()=>isPropValid
});
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f40$emotion$2f$memoize$2f$dist$2f$emotion$2d$memoize$2e$esm$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_import__("[project]/node_modules/@emotion/memoize/dist/emotion-memoize.esm.js [app-ssr] (ecmascript)");
"__TURBOPACK__ecmascript__hoisting__location__";
;
// eslint-disable-next-line no-undef
var reactPropsRegex = /^((children|dangerouslySetInnerHTML|key|ref|autoFocus|defaultValue|defaultChecked|innerHTML|suppressContentEditableWarning|suppressHydrationWarning|valueLink|abbr|accept|acceptCharset|accessKey|action|allow|allowUserMedia|allowPaymentRequest|allowFullScreen|allowTransparency|alt|async|autoComplete|autoPlay|capture|cellPadding|cellSpacing|challenge|charSet|checked|cite|classID|className|cols|colSpan|content|contentEditable|contextMenu|controls|controlsList|coords|crossOrigin|data|dateTime|decoding|default|defer|dir|disabled|disablePictureInPicture|disableRemotePlayback|download|draggable|encType|enterKeyHint|fetchpriority|fetchPriority|form|formAction|formEncType|formMethod|formNoValidate|formTarget|frameBorder|headers|height|hidden|high|href|hrefLang|htmlFor|httpEquiv|id|inputMode|integrity|is|keyParams|keyType|kind|label|lang|list|loading|loop|low|marginHeight|marginWidth|max|maxLength|media|mediaGroup|method|min|minLength|multiple|muted|name|nonce|noValidate|open|optimum|pattern|placeholder|playsInline|popover|popoverTarget|popoverTargetAction|poster|preload|profile|radioGroup|readOnly|referrerPolicy|rel|required|reversed|role|rows|rowSpan|sandbox|scope|scoped|scrolling|seamless|selected|shape|size|sizes|slot|span|spellCheck|src|srcDoc|srcLang|srcSet|start|step|style|summary|tabIndex|target|title|translate|type|useMap|value|width|wmode|wrap|about|datatype|inlist|prefix|property|resource|typeof|vocab|autoCapitalize|autoCorrect|autoSave|color|incremental|fallback|inert|itemProp|itemScope|itemType|itemID|itemRef|on|option|results|security|unselectable|accentHeight|accumulate|additive|alignmentBaseline|allowReorder|alphabetic|amplitude|arabicForm|ascent|attributeName|attributeType|autoReverse|azimuth|baseFrequency|baselineShift|baseProfile|bbox|begin|bias|by|calcMode|capHeight|clip|clipPathUnits|clipPath|clipRule|colorInterpolation|colorInterpolationFilters|colorProfile|colorRendering|contentScriptType|contentStyleType|cursor|cx|cy|d|decelerate|descent|diffuseConstant|direction|display|divisor|dominantBaseline|dur|dx|dy|edgeMode|elevation|enableBackground|end|exponent|externalResourcesRequired|fill|fillOpacity|fillRule|filter|filterRes|filterUnits|floodColor|floodOpacity|focusable|fontFamily|fontSize|fontSizeAdjust|fontStretch|fontStyle|fontVariant|fontWeight|format|from|fr|fx|fy|g1|g2|glyphName|glyphOrientationHorizontal|glyphOrientationVertical|glyphRef|gradientTransform|gradientUnits|hanging|horizAdvX|horizOriginX|ideographic|imageRendering|in|in2|intercept|k|k1|k2|k3|k4|kernelMatrix|kernelUnitLength|kerning|keyPoints|keySplines|keyTimes|lengthAdjust|letterSpacing|lightingColor|limitingConeAngle|local|markerEnd|markerMid|markerStart|markerHeight|markerUnits|markerWidth|mask|maskContentUnits|maskUnits|mathematical|mode|numOctaves|offset|opacity|operator|order|orient|orientation|origin|overflow|overlinePosition|overlineThickness|panose1|paintOrder|pathLength|patternContentUnits|patternTransform|patternUnits|pointerEvents|points|pointsAtX|pointsAtY|pointsAtZ|preserveAlpha|preserveAspectRatio|primitiveUnits|r|radius|refX|refY|renderingIntent|repeatCount|repeatDur|requiredExtensions|requiredFeatures|restart|result|rotate|rx|ry|scale|seed|shapeRendering|slope|spacing|specularConstant|specularExponent|speed|spreadMethod|startOffset|stdDeviation|stemh|stemv|stitchTiles|stopColor|stopOpacity|strikethroughPosition|strikethroughThickness|string|stroke|strokeDasharray|strokeDashoffset|strokeLinecap|strokeLinejoin|strokeMiterlimit|strokeOpacity|strokeWidth|surfaceScale|systemLanguage|tableValues|targetX|targetY|textAnchor|textDecoration|textRendering|textLength|to|transform|u1|u2|underlinePosition|underlineThickness|unicode|unicodeBidi|unicodeRange|unitsPerEm|vAlphabetic|vHanging|vIdeographic|vMathematical|values|vectorEffect|version|vertAdvY|vertOriginX|vertOriginY|viewBox|viewTarget|visibility|widths|wordSpacing|writingMode|x|xHeight|x1|x2|xChannelSelector|xlinkActuate|xlinkArcrole|xlinkHref|xlinkRole|xlinkShow|xlinkTitle|xlinkType|xmlBase|xmlns|xmlnsXlink|xmlLang|xmlSpace|y|y1|y2|yChannelSelector|z|zoomAndPan|for|class|autofocus)|(([Dd][Aa][Tt][Aa]|[Aa][Rr][Ii][Aa]|x)-.*))$/; // https://esbench.com/bench/5bfee68a4cd7e6009ef61d23
var isPropValid = /* #__PURE__ */ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f40$emotion$2f$memoize$2f$dist$2f$emotion$2d$memoize$2e$esm$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["default"])(function(prop) {
    return reactPropsRegex.test(prop) || prop.charCodeAt(0) === 111 && prop.charCodeAt(1) === 110 && prop.charCodeAt(2) < 91;
});
;

})()),
"[project]/node_modules/lenis/dist/lenis.mjs [app-ssr] (ecmascript)": (({ r: __turbopack_require__, f: __turbopack_module_context__, i: __turbopack_import__, s: __turbopack_esm__, v: __turbopack_export_value__, n: __turbopack_export_namespace__, c: __turbopack_cache__, M: __turbopack_modules__, l: __turbopack_load__, j: __turbopack_dynamic__, P: __turbopack_resolve_absolute_path__, U: __turbopack_relative_url__, R: __turbopack_resolve_module_id_path__, g: global, __dirname, x: __turbopack_external_require__, y: __turbopack_external_import__ }) => (() => {
"use strict";

// package.json
__turbopack_esm__({
    "default": ()=>Lenis
});
var version = "1.3.15";
// packages/core/src/maths.ts
function clamp(min, input, max) {
    return Math.max(min, Math.min(input, max));
}
function lerp(x, y, t) {
    return (1 - t) * x + t * y;
}
function damp(x, y, lambda, deltaTime) {
    return lerp(x, y, 1 - Math.exp(-lambda * deltaTime));
}
function modulo(n, d) {
    return (n % d + d) % d;
}
// packages/core/src/animate.ts
var Animate = class {
    isRunning = false;
    value = 0;
    from = 0;
    to = 0;
    currentTime = 0;
    // These are instanciated in the fromTo method
    lerp;
    duration;
    easing;
    onUpdate;
    /**
   * Advance the animation by the given delta time
   *
   * @param deltaTime - The time in seconds to advance the animation
   */ advance(deltaTime) {
        if (!this.isRunning) return;
        let completed = false;
        if (this.duration && this.easing) {
            this.currentTime += deltaTime;
            const linearProgress = clamp(0, this.currentTime / this.duration, 1);
            completed = linearProgress >= 1;
            const easedProgress = completed ? 1 : this.easing(linearProgress);
            this.value = this.from + (this.to - this.from) * easedProgress;
        } else if (this.lerp) {
            this.value = damp(this.value, this.to, this.lerp * 60, deltaTime);
            if (Math.round(this.value) === this.to) {
                this.value = this.to;
                completed = true;
            }
        } else {
            this.value = this.to;
            completed = true;
        }
        if (completed) {
            this.stop();
        }
        this.onUpdate?.(this.value, completed);
    }
    /** Stop the animation */ stop() {
        this.isRunning = false;
    }
    /**
   * Set up the animation from a starting value to an ending value
   * with optional parameters for lerping, duration, easing, and onUpdate callback
   *
   * @param from - The starting value
   * @param to - The ending value
   * @param options - Options for the animation
   */ fromTo(from, to, { lerp: lerp2, duration, easing, onStart, onUpdate }) {
        this.from = this.value = from;
        this.to = to;
        this.lerp = lerp2;
        this.duration = duration;
        this.easing = easing;
        this.currentTime = 0;
        this.isRunning = true;
        onStart?.();
        this.onUpdate = onUpdate;
    }
};
// packages/core/src/debounce.ts
function debounce(callback, delay) {
    let timer;
    return function(...args) {
        let context = this;
        clearTimeout(timer);
        timer = setTimeout(()=>{
            timer = void 0;
            callback.apply(context, args);
        }, delay);
    };
}
// packages/core/src/dimensions.ts
var Dimensions = class {
    constructor(wrapper, content, { autoResize = true, debounce: debounceValue = 250 } = {}){
        this.wrapper = wrapper;
        this.content = content;
        if (autoResize) {
            this.debouncedResize = debounce(this.resize, debounceValue);
            if (this.wrapper instanceof Window) {
                window.addEventListener("resize", this.debouncedResize, false);
            } else {
                this.wrapperResizeObserver = new ResizeObserver(this.debouncedResize);
                this.wrapperResizeObserver.observe(this.wrapper);
            }
            this.contentResizeObserver = new ResizeObserver(this.debouncedResize);
            this.contentResizeObserver.observe(this.content);
        }
        this.resize();
    }
    width = 0;
    height = 0;
    scrollHeight = 0;
    scrollWidth = 0;
    // These are instanciated in the constructor as they need information from the options
    debouncedResize;
    wrapperResizeObserver;
    contentResizeObserver;
    destroy() {
        this.wrapperResizeObserver?.disconnect();
        this.contentResizeObserver?.disconnect();
        if (this.wrapper === window && this.debouncedResize) {
            window.removeEventListener("resize", this.debouncedResize, false);
        }
    }
    resize = ()=>{
        this.onWrapperResize();
        this.onContentResize();
    };
    onWrapperResize = ()=>{
        if (this.wrapper instanceof Window) {
            this.width = window.innerWidth;
            this.height = window.innerHeight;
        } else {
            this.width = this.wrapper.clientWidth;
            this.height = this.wrapper.clientHeight;
        }
    };
    onContentResize = ()=>{
        if (this.wrapper instanceof Window) {
            this.scrollHeight = this.content.scrollHeight;
            this.scrollWidth = this.content.scrollWidth;
        } else {
            this.scrollHeight = this.wrapper.scrollHeight;
            this.scrollWidth = this.wrapper.scrollWidth;
        }
    };
    get limit() {
        return {
            x: this.scrollWidth - this.width,
            y: this.scrollHeight - this.height
        };
    }
};
// packages/core/src/emitter.ts
var Emitter = class {
    events = {};
    /**
   * Emit an event with the given data
   * @param event Event name
   * @param args Data to pass to the event handlers
   */ emit(event, ...args) {
        let callbacks = this.events[event] || [];
        for(let i = 0, length = callbacks.length; i < length; i++){
            callbacks[i]?.(...args);
        }
    }
    /**
   * Add a callback to the event
   * @param event Event name
   * @param cb Callback function
   * @returns Unsubscribe function
   */ on(event, cb) {
        this.events[event]?.push(cb) || (this.events[event] = [
            cb
        ]);
        return ()=>{
            this.events[event] = this.events[event]?.filter((i)=>cb !== i);
        };
    }
    /**
   * Remove a callback from the event
   * @param event Event name
   * @param callback Callback function
   */ off(event, callback) {
        this.events[event] = this.events[event]?.filter((i)=>callback !== i);
    }
    /**
   * Remove all event listeners and clean up
   */ destroy() {
        this.events = {};
    }
};
// packages/core/src/virtual-scroll.ts
var LINE_HEIGHT = 100 / 6;
var listenerOptions = {
    passive: false
};
var VirtualScroll = class {
    constructor(element, options = {
        wheelMultiplier: 1,
        touchMultiplier: 1
    }){
        this.element = element;
        this.options = options;
        window.addEventListener("resize", this.onWindowResize, false);
        this.onWindowResize();
        this.element.addEventListener("wheel", this.onWheel, listenerOptions);
        this.element.addEventListener("touchstart", this.onTouchStart, listenerOptions);
        this.element.addEventListener("touchmove", this.onTouchMove, listenerOptions);
        this.element.addEventListener("touchend", this.onTouchEnd, listenerOptions);
    }
    touchStart = {
        x: 0,
        y: 0
    };
    lastDelta = {
        x: 0,
        y: 0
    };
    window = {
        width: 0,
        height: 0
    };
    emitter = new Emitter();
    /**
   * Add an event listener for the given event and callback
   *
   * @param event Event name
   * @param callback Callback function
   */ on(event, callback) {
        return this.emitter.on(event, callback);
    }
    /** Remove all event listeners and clean up */ destroy() {
        this.emitter.destroy();
        window.removeEventListener("resize", this.onWindowResize, false);
        this.element.removeEventListener("wheel", this.onWheel, listenerOptions);
        this.element.removeEventListener("touchstart", this.onTouchStart, listenerOptions);
        this.element.removeEventListener("touchmove", this.onTouchMove, listenerOptions);
        this.element.removeEventListener("touchend", this.onTouchEnd, listenerOptions);
    }
    /**
   * Event handler for 'touchstart' event
   *
   * @param event Touch event
   */ onTouchStart = (event)=>{
        const { clientX, clientY } = event.targetTouches ? event.targetTouches[0] : event;
        this.touchStart.x = clientX;
        this.touchStart.y = clientY;
        this.lastDelta = {
            x: 0,
            y: 0
        };
        this.emitter.emit("scroll", {
            deltaX: 0,
            deltaY: 0,
            event
        });
    };
    /** Event handler for 'touchmove' event */ onTouchMove = (event)=>{
        const { clientX, clientY } = event.targetTouches ? event.targetTouches[0] : event;
        const deltaX = -(clientX - this.touchStart.x) * this.options.touchMultiplier;
        const deltaY = -(clientY - this.touchStart.y) * this.options.touchMultiplier;
        this.touchStart.x = clientX;
        this.touchStart.y = clientY;
        this.lastDelta = {
            x: deltaX,
            y: deltaY
        };
        this.emitter.emit("scroll", {
            deltaX,
            deltaY,
            event
        });
    };
    onTouchEnd = (event)=>{
        this.emitter.emit("scroll", {
            deltaX: this.lastDelta.x,
            deltaY: this.lastDelta.y,
            event
        });
    };
    /** Event handler for 'wheel' event */ onWheel = (event)=>{
        let { deltaX, deltaY, deltaMode } = event;
        const multiplierX = deltaMode === 1 ? LINE_HEIGHT : deltaMode === 2 ? this.window.width : 1;
        const multiplierY = deltaMode === 1 ? LINE_HEIGHT : deltaMode === 2 ? this.window.height : 1;
        deltaX *= multiplierX;
        deltaY *= multiplierY;
        deltaX *= this.options.wheelMultiplier;
        deltaY *= this.options.wheelMultiplier;
        this.emitter.emit("scroll", {
            deltaX,
            deltaY,
            event
        });
    };
    onWindowResize = ()=>{
        this.window = {
            width: window.innerWidth,
            height: window.innerHeight
        };
    };
};
// packages/core/src/lenis.ts
var defaultEasing = (t)=>Math.min(1, 1.001 - Math.pow(2, -10 * t));
var Lenis = class {
    _isScrolling = false;
    // true when scroll is animating
    _isStopped = false;
    // true if user should not be able to scroll - enable/disable programmatically
    _isLocked = false;
    // same as isStopped but enabled/disabled when scroll reaches target
    _preventNextNativeScrollEvent = false;
    _resetVelocityTimeout = null;
    __rafID = null;
    /**
   * Whether or not the user is touching the screen
   */ isTouching;
    /**
   * The time in ms since the lenis instance was created
   */ time = 0;
    /**
   * User data that will be forwarded through the scroll event
   *
   * @example
   * lenis.scrollTo(100, {
   *   userData: {
   *     foo: 'bar'
   *   }
   * })
   */ userData = {};
    /**
   * The last velocity of the scroll
   */ lastVelocity = 0;
    /**
   * The current velocity of the scroll
   */ velocity = 0;
    /**
   * The direction of the scroll
   */ direction = 0;
    /**
   * The options passed to the lenis instance
   */ options;
    /**
   * The target scroll value
   */ targetScroll;
    /**
   * The animated scroll value
   */ animatedScroll;
    // These are instanciated here as they don't need information from the options
    animate = new Animate();
    emitter = new Emitter();
    // These are instanciated in the constructor as they need information from the options
    dimensions;
    // This is not private because it's used in the Snap class
    virtualScroll;
    constructor({ wrapper = window, content = document.documentElement, eventsTarget = wrapper, smoothWheel = true, syncTouch = false, syncTouchLerp = 0.075, touchInertiaExponent = 1.7, duration, // in seconds
    easing, lerp: lerp2 = 0.1, infinite = false, orientation = "vertical", // vertical, horizontal
    gestureOrientation = orientation === "horizontal" ? "both" : "vertical", // vertical, horizontal, both
    touchMultiplier = 1, wheelMultiplier = 1, autoResize = true, prevent, virtualScroll, overscroll = true, autoRaf = false, anchors = false, autoToggle = false, // https://caniuse.com/?search=transition-behavior
    allowNestedScroll = false, __experimental__naiveDimensions = false } = {}){
        window.lenisVersion = version;
        if (!wrapper || wrapper === document.documentElement) {
            wrapper = window;
        }
        if (typeof duration === "number" && typeof easing !== "function") {
            easing = defaultEasing;
        } else if (typeof easing === "function" && typeof duration !== "number") {
            duration = 1;
        }
        this.options = {
            wrapper,
            content,
            eventsTarget,
            smoothWheel,
            syncTouch,
            syncTouchLerp,
            touchInertiaExponent,
            duration,
            easing,
            lerp: lerp2,
            infinite,
            gestureOrientation,
            orientation,
            touchMultiplier,
            wheelMultiplier,
            autoResize,
            prevent,
            virtualScroll,
            overscroll,
            autoRaf,
            anchors,
            autoToggle,
            allowNestedScroll,
            __experimental__naiveDimensions
        };
        this.dimensions = new Dimensions(wrapper, content, {
            autoResize
        });
        this.updateClassName();
        this.targetScroll = this.animatedScroll = this.actualScroll;
        this.options.wrapper.addEventListener("scroll", this.onNativeScroll, false);
        this.options.wrapper.addEventListener("scrollend", this.onScrollEnd, {
            capture: true
        });
        if (this.options.anchors && this.options.wrapper === window) {
            this.options.wrapper.addEventListener("click", this.onClick, false);
        }
        this.options.wrapper.addEventListener("pointerdown", this.onPointerDown, false);
        this.virtualScroll = new VirtualScroll(eventsTarget, {
            touchMultiplier,
            wheelMultiplier
        });
        this.virtualScroll.on("scroll", this.onVirtualScroll);
        if (this.options.autoToggle) {
            this.rootElement.addEventListener("transitionend", this.onTransitionEnd, {
                passive: true
            });
        }
        if (this.options.autoRaf) {
            this.__rafID = requestAnimationFrame(this.raf);
        }
    }
    /**
   * Destroy the lenis instance, remove all event listeners and clean up the class name
   */ destroy() {
        this.emitter.destroy();
        this.options.wrapper.removeEventListener("scroll", this.onNativeScroll, false);
        this.options.wrapper.removeEventListener("scrollend", this.onScrollEnd, {
            capture: true
        });
        this.options.wrapper.removeEventListener("pointerdown", this.onPointerDown, false);
        if (this.options.anchors && this.options.wrapper === window) {
            this.options.wrapper.removeEventListener("click", this.onClick, false);
        }
        this.virtualScroll.destroy();
        this.dimensions.destroy();
        this.cleanUpClassName();
        if (this.__rafID) {
            cancelAnimationFrame(this.__rafID);
        }
    }
    on(event, callback) {
        return this.emitter.on(event, callback);
    }
    off(event, callback) {
        return this.emitter.off(event, callback);
    }
    onScrollEnd = (e)=>{
        if (!(e instanceof CustomEvent)) {
            if (this.isScrolling === "smooth" || this.isScrolling === false) {
                e.stopPropagation();
            }
        }
    };
    dispatchScrollendEvent = ()=>{
        this.options.wrapper.dispatchEvent(new CustomEvent("scrollend", {
            bubbles: this.options.wrapper === window,
            // cancelable: false,
            detail: {
                lenisScrollEnd: true
            }
        }));
    };
    onTransitionEnd = (event)=>{
        if (event.propertyName.includes("overflow")) {
            const property = this.isHorizontal ? "overflow-x" : "overflow-y";
            const overflow = getComputedStyle(this.rootElement)[property];
            if ([
                "hidden",
                "clip"
            ].includes(overflow)) {
                this.internalStop();
            } else {
                this.internalStart();
            }
        }
    };
    setScroll(scroll) {
        if (this.isHorizontal) {
            this.options.wrapper.scrollTo({
                left: scroll,
                behavior: "instant"
            });
        } else {
            this.options.wrapper.scrollTo({
                top: scroll,
                behavior: "instant"
            });
        }
    }
    onClick = (event)=>{
        const path = event.composedPath();
        const anchor = path.find((node)=>node instanceof HTMLAnchorElement && node.getAttribute("href")?.includes("#"));
        if (anchor) {
            const href = anchor.getAttribute("href");
            if (href) {
                const options = typeof this.options.anchors === "object" && this.options.anchors ? this.options.anchors : void 0;
                const target = `#${href.split("#")[1]}`;
                this.scrollTo(target, options);
            }
        }
    };
    onPointerDown = (event)=>{
        if (event.button === 1) {
            this.reset();
        }
    };
    onVirtualScroll = (data)=>{
        if (typeof this.options.virtualScroll === "function" && this.options.virtualScroll(data) === false) return;
        const { deltaX, deltaY, event } = data;
        this.emitter.emit("virtual-scroll", {
            deltaX,
            deltaY,
            event
        });
        if (event.ctrlKey) return;
        if (event.lenisStopPropagation) return;
        const isTouch = event.type.includes("touch");
        const isWheel = event.type.includes("wheel");
        this.isTouching = event.type === "touchstart" || event.type === "touchmove";
        const isClickOrTap = deltaX === 0 && deltaY === 0;
        const isTapToStop = this.options.syncTouch && isTouch && event.type === "touchstart" && isClickOrTap && !this.isStopped && !this.isLocked;
        if (isTapToStop) {
            this.reset();
            return;
        }
        const isUnknownGesture = this.options.gestureOrientation === "vertical" && deltaY === 0 || this.options.gestureOrientation === "horizontal" && deltaX === 0;
        if (isClickOrTap || isUnknownGesture) {
            return;
        }
        let composedPath = event.composedPath();
        composedPath = composedPath.slice(0, composedPath.indexOf(this.rootElement));
        const prevent = this.options.prevent;
        if (!!composedPath.find((node)=>node instanceof HTMLElement && (typeof prevent === "function" && prevent?.(node) || node.hasAttribute?.("data-lenis-prevent") || isTouch && node.hasAttribute?.("data-lenis-prevent-touch") || isWheel && node.hasAttribute?.("data-lenis-prevent-wheel") || this.options.allowNestedScroll && this.checkNestedScroll(node, {
                deltaX,
                deltaY
            })))) return;
        if (this.isStopped || this.isLocked) {
            if (event.cancelable) {
                event.preventDefault();
            }
            return;
        }
        const isSmooth = this.options.syncTouch && isTouch || this.options.smoothWheel && isWheel;
        if (!isSmooth) {
            this.isScrolling = "native";
            this.animate.stop();
            event.lenisStopPropagation = true;
            return;
        }
        let delta = deltaY;
        if (this.options.gestureOrientation === "both") {
            delta = Math.abs(deltaY) > Math.abs(deltaX) ? deltaY : deltaX;
        } else if (this.options.gestureOrientation === "horizontal") {
            delta = deltaX;
        }
        if (!this.options.overscroll || this.options.infinite || this.options.wrapper !== window && this.limit > 0 && (this.animatedScroll > 0 && this.animatedScroll < this.limit || this.animatedScroll === 0 && deltaY > 0 || this.animatedScroll === this.limit && deltaY < 0)) {
            event.lenisStopPropagation = true;
        }
        if (event.cancelable) {
            event.preventDefault();
        }
        const isSyncTouch = isTouch && this.options.syncTouch;
        const isTouchEnd = isTouch && event.type === "touchend";
        const hasTouchInertia = isTouchEnd;
        if (hasTouchInertia) {
            delta = Math.sign(this.velocity) * Math.pow(Math.abs(this.velocity), this.options.touchInertiaExponent);
        }
        this.scrollTo(this.targetScroll + delta, {
            programmatic: false,
            ...isSyncTouch ? {
                lerp: hasTouchInertia ? this.options.syncTouchLerp : 1
            } : {
                lerp: this.options.lerp,
                duration: this.options.duration,
                easing: this.options.easing
            }
        });
    };
    /**
   * Force lenis to recalculate the dimensions
   */ resize() {
        this.dimensions.resize();
        this.animatedScroll = this.targetScroll = this.actualScroll;
        this.emit();
    }
    emit() {
        this.emitter.emit("scroll", this);
    }
    onNativeScroll = ()=>{
        if (this._resetVelocityTimeout !== null) {
            clearTimeout(this._resetVelocityTimeout);
            this._resetVelocityTimeout = null;
        }
        if (this._preventNextNativeScrollEvent) {
            this._preventNextNativeScrollEvent = false;
            return;
        }
        if (this.isScrolling === false || this.isScrolling === "native") {
            const lastScroll = this.animatedScroll;
            this.animatedScroll = this.targetScroll = this.actualScroll;
            this.lastVelocity = this.velocity;
            this.velocity = this.animatedScroll - lastScroll;
            this.direction = Math.sign(this.animatedScroll - lastScroll);
            if (!this.isStopped) {
                this.isScrolling = "native";
            }
            this.emit();
            if (this.velocity !== 0) {
                this._resetVelocityTimeout = setTimeout(()=>{
                    this.lastVelocity = this.velocity;
                    this.velocity = 0;
                    this.isScrolling = false;
                    this.emit();
                }, 400);
            }
        }
    };
    reset() {
        this.isLocked = false;
        this.isScrolling = false;
        this.animatedScroll = this.targetScroll = this.actualScroll;
        this.lastVelocity = this.velocity = 0;
        this.animate.stop();
    }
    /**
   * Start lenis scroll after it has been stopped
   */ start() {
        if (!this.isStopped) return;
        if (this.options.autoToggle) {
            this.rootElement.style.removeProperty("overflow");
            return;
        }
        this.internalStart();
    }
    internalStart() {
        if (!this.isStopped) return;
        this.reset();
        this.isStopped = false;
        this.emit();
    }
    /**
   * Stop lenis scroll
   */ stop() {
        if (this.isStopped) return;
        if (this.options.autoToggle) {
            this.rootElement.style.setProperty("overflow", "clip");
            return;
        }
        this.internalStop();
    }
    internalStop() {
        if (this.isStopped) return;
        this.reset();
        this.isStopped = true;
        this.emit();
    }
    /**
   * RequestAnimationFrame for lenis
   *
   * @param time The time in ms from an external clock like `requestAnimationFrame` or Tempus
   */ raf = (time)=>{
        const deltaTime = time - (this.time || time);
        this.time = time;
        this.animate.advance(deltaTime * 1e-3);
        if (this.options.autoRaf) {
            this.__rafID = requestAnimationFrame(this.raf);
        }
    };
    /**
   * Scroll to a target value
   *
   * @param target The target value to scroll to
   * @param options The options for the scroll
   *
   * @example
   * lenis.scrollTo(100, {
   *   offset: 100,
   *   duration: 1,
   *   easing: (t) => 1 - Math.cos((t * Math.PI) / 2),
   *   lerp: 0.1,
   *   onStart: () => {
   *     console.log('onStart')
   *   },
   *   onComplete: () => {
   *     console.log('onComplete')
   *   },
   * })
   */ scrollTo(target, { offset = 0, immediate = false, lock = false, duration = this.options.duration, easing = this.options.easing, lerp: lerp2 = this.options.lerp, onStart, onComplete, force = false, // scroll even if stopped
    programmatic = true, // called from outside of the class
    userData } = {}) {
        if ((this.isStopped || this.isLocked) && !force) return;
        if (typeof target === "string" && [
            "top",
            "left",
            "start",
            "#"
        ].includes(target)) {
            target = 0;
        } else if (typeof target === "string" && [
            "bottom",
            "right",
            "end"
        ].includes(target)) {
            target = this.limit;
        } else {
            let node;
            if (typeof target === "string") {
                node = document.querySelector(target);
                if (!node) {
                    if (target === "#top") {
                        target = 0;
                    } else {
                        console.warn("Lenis: Target not found", target);
                    }
                }
            } else if (target instanceof HTMLElement && target?.nodeType) {
                node = target;
            }
            if (node) {
                if (this.options.wrapper !== window) {
                    const wrapperRect = this.rootElement.getBoundingClientRect();
                    offset -= this.isHorizontal ? wrapperRect.left : wrapperRect.top;
                }
                const rect = node.getBoundingClientRect();
                target = (this.isHorizontal ? rect.left : rect.top) + this.animatedScroll;
            }
        }
        if (typeof target !== "number") return;
        target += offset;
        target = Math.round(target);
        if (this.options.infinite) {
            if (programmatic) {
                this.targetScroll = this.animatedScroll = this.scroll;
                const distance = target - this.animatedScroll;
                if (distance > this.limit / 2) {
                    target = target - this.limit;
                } else if (distance < -this.limit / 2) {
                    target = target + this.limit;
                }
            }
        } else {
            target = clamp(0, target, this.limit);
        }
        if (target === this.targetScroll) {
            onStart?.(this);
            onComplete?.(this);
            return;
        }
        this.userData = userData ?? {};
        if (immediate) {
            this.animatedScroll = this.targetScroll = target;
            this.setScroll(this.scroll);
            this.reset();
            this.preventNextNativeScrollEvent();
            this.emit();
            onComplete?.(this);
            this.userData = {};
            requestAnimationFrame(()=>{
                this.dispatchScrollendEvent();
            });
            return;
        }
        if (!programmatic) {
            this.targetScroll = target;
        }
        if (typeof duration === "number" && typeof easing !== "function") {
            easing = defaultEasing;
        } else if (typeof easing === "function" && typeof duration !== "number") {
            duration = 1;
        }
        this.animate.fromTo(this.animatedScroll, target, {
            duration,
            easing,
            lerp: lerp2,
            onStart: ()=>{
                if (lock) this.isLocked = true;
                this.isScrolling = "smooth";
                onStart?.(this);
            },
            onUpdate: (value, completed)=>{
                this.isScrolling = "smooth";
                this.lastVelocity = this.velocity;
                this.velocity = value - this.animatedScroll;
                this.direction = Math.sign(this.velocity);
                this.animatedScroll = value;
                this.setScroll(this.scroll);
                if (programmatic) {
                    this.targetScroll = value;
                }
                if (!completed) this.emit();
                if (completed) {
                    this.reset();
                    this.emit();
                    onComplete?.(this);
                    this.userData = {};
                    requestAnimationFrame(()=>{
                        this.dispatchScrollendEvent();
                    });
                    this.preventNextNativeScrollEvent();
                }
            }
        });
    }
    preventNextNativeScrollEvent() {
        this._preventNextNativeScrollEvent = true;
        requestAnimationFrame(()=>{
            this._preventNextNativeScrollEvent = false;
        });
    }
    checkNestedScroll(node, { deltaX, deltaY }) {
        const time = Date.now();
        const cache = node._lenis ??= {};
        let hasOverflowX, hasOverflowY, isScrollableX, isScrollableY, scrollWidth, scrollHeight, clientWidth, clientHeight;
        const gestureOrientation = this.options.gestureOrientation;
        if (time - (cache.time ?? 0) > 2e3) {
            cache.time = Date.now();
            const computedStyle = window.getComputedStyle(node);
            cache.computedStyle = computedStyle;
            const overflowXString = computedStyle.overflowX;
            const overflowYString = computedStyle.overflowY;
            hasOverflowX = [
                "auto",
                "overlay",
                "scroll"
            ].includes(overflowXString);
            hasOverflowY = [
                "auto",
                "overlay",
                "scroll"
            ].includes(overflowYString);
            cache.hasOverflowX = hasOverflowX;
            cache.hasOverflowY = hasOverflowY;
            if (!hasOverflowX && !hasOverflowY) return false;
            if (gestureOrientation === "vertical" && !hasOverflowY) return false;
            if (gestureOrientation === "horizontal" && !hasOverflowX) return false;
            scrollWidth = node.scrollWidth;
            scrollHeight = node.scrollHeight;
            clientWidth = node.clientWidth;
            clientHeight = node.clientHeight;
            isScrollableX = scrollWidth > clientWidth;
            isScrollableY = scrollHeight > clientHeight;
            cache.isScrollableX = isScrollableX;
            cache.isScrollableY = isScrollableY;
            cache.scrollWidth = scrollWidth;
            cache.scrollHeight = scrollHeight;
            cache.clientWidth = clientWidth;
            cache.clientHeight = clientHeight;
        } else {
            isScrollableX = cache.isScrollableX;
            isScrollableY = cache.isScrollableY;
            hasOverflowX = cache.hasOverflowX;
            hasOverflowY = cache.hasOverflowY;
            scrollWidth = cache.scrollWidth;
            scrollHeight = cache.scrollHeight;
            clientWidth = cache.clientWidth;
            clientHeight = cache.clientHeight;
        }
        if (!hasOverflowX && !hasOverflowY || !isScrollableX && !isScrollableY) {
            return false;
        }
        if (gestureOrientation === "vertical" && (!hasOverflowY || !isScrollableY)) return false;
        if (gestureOrientation === "horizontal" && (!hasOverflowX || !isScrollableX)) return false;
        let orientation;
        if (gestureOrientation === "horizontal") {
            orientation = "x";
        } else if (gestureOrientation === "vertical") {
            orientation = "y";
        } else {
            const isScrollingX = deltaX !== 0;
            const isScrollingY = deltaY !== 0;
            if (isScrollingX && hasOverflowX && isScrollableX) {
                orientation = "x";
            }
            if (isScrollingY && hasOverflowY && isScrollableY) {
                orientation = "y";
            }
        }
        if (!orientation) return false;
        let scroll, maxScroll, delta, hasOverflow, isScrollable;
        if (orientation === "x") {
            scroll = node.scrollLeft;
            maxScroll = scrollWidth - clientWidth;
            delta = deltaX;
            hasOverflow = hasOverflowX;
            isScrollable = isScrollableX;
        } else if (orientation === "y") {
            scroll = node.scrollTop;
            maxScroll = scrollHeight - clientHeight;
            delta = deltaY;
            hasOverflow = hasOverflowY;
            isScrollable = isScrollableY;
        } else {
            return false;
        }
        const willScroll = delta > 0 ? scroll < maxScroll : scroll > 0;
        return willScroll && hasOverflow && isScrollable;
    }
    /**
   * The root element on which lenis is instanced
   */ get rootElement() {
        return this.options.wrapper === window ? document.documentElement : this.options.wrapper;
    }
    /**
   * The limit which is the maximum scroll value
   */ get limit() {
        if (this.options.__experimental__naiveDimensions) {
            if (this.isHorizontal) {
                return this.rootElement.scrollWidth - this.rootElement.clientWidth;
            } else {
                return this.rootElement.scrollHeight - this.rootElement.clientHeight;
            }
        } else {
            return this.dimensions.limit[this.isHorizontal ? "x" : "y"];
        }
    }
    /**
   * Whether or not the scroll is horizontal
   */ get isHorizontal() {
        return this.options.orientation === "horizontal";
    }
    /**
   * The actual scroll value
   */ get actualScroll() {
        const wrapper = this.options.wrapper;
        return this.isHorizontal ? wrapper.scrollX ?? wrapper.scrollLeft : wrapper.scrollY ?? wrapper.scrollTop;
    }
    /**
   * The current scroll value
   */ get scroll() {
        return this.options.infinite ? modulo(this.animatedScroll, this.limit) : this.animatedScroll;
    }
    /**
   * The progress of the scroll relative to the limit
   */ get progress() {
        return this.limit === 0 ? 1 : this.scroll / this.limit;
    }
    /**
   * Current scroll state
   */ get isScrolling() {
        return this._isScrolling;
    }
    set isScrolling(value) {
        if (this._isScrolling !== value) {
            this._isScrolling = value;
            this.updateClassName();
        }
    }
    /**
   * Check if lenis is stopped
   */ get isStopped() {
        return this._isStopped;
    }
    set isStopped(value) {
        if (this._isStopped !== value) {
            this._isStopped = value;
            this.updateClassName();
        }
    }
    /**
   * Check if lenis is locked
   */ get isLocked() {
        return this._isLocked;
    }
    set isLocked(value) {
        if (this._isLocked !== value) {
            this._isLocked = value;
            this.updateClassName();
        }
    }
    /**
   * Check if lenis is smooth scrolling
   */ get isSmooth() {
        return this.isScrolling === "smooth";
    }
    /**
   * The class name applied to the wrapper element
   */ get className() {
        let className = "lenis";
        if (this.options.autoToggle) className += " lenis-autoToggle";
        if (this.isStopped) className += " lenis-stopped";
        if (this.isLocked) className += " lenis-locked";
        if (this.isScrolling) className += " lenis-scrolling";
        if (this.isScrolling === "smooth") className += " lenis-smooth";
        return className;
    }
    updateClassName() {
        this.cleanUpClassName();
        this.rootElement.className = `${this.rootElement.className} ${this.className}`.trim();
    }
    cleanUpClassName() {
        this.rootElement.className = this.rootElement.className.replace(/lenis(-\w+)?/g, "").trim();
    }
};
;
 //# sourceMappingURL=lenis.mjs.map

})()),
"[project]/node_modules/lenis/dist/lenis-react.mjs [app-ssr] (ecmascript)": (({ r: __turbopack_require__, f: __turbopack_module_context__, i: __turbopack_import__, s: __turbopack_esm__, v: __turbopack_export_value__, n: __turbopack_export_namespace__, c: __turbopack_cache__, M: __turbopack_modules__, l: __turbopack_load__, j: __turbopack_dynamic__, P: __turbopack_resolve_absolute_path__, U: __turbopack_relative_url__, R: __turbopack_resolve_module_id_path__, g: global, __dirname, x: __turbopack_external_require__, y: __turbopack_external_import__ }) => (() => {
"use strict";

__turbopack_esm__({
    "Lenis": ()=>ReactLenis,
    "LenisContext": ()=>LenisContext,
    "ReactLenis": ()=>ReactLenis,
    "default": ()=>ReactLenis,
    "useLenis": ()=>useLenis
});
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$lenis$2f$dist$2f$lenis$2e$mjs__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_import__("[project]/node_modules/lenis/dist/lenis.mjs [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$server$2f$future$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_import__("[project]/node_modules/next/dist/server/future/route-modules/app-page/vendored/ssr/react.js [app-ssr] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$server$2f$future$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2d$jsx$2d$runtime$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__ = __turbopack_import__("[project]/node_modules/next/dist/server/future/route-modules/app-page/vendored/ssr/react-jsx-runtime.js [app-ssr] (ecmascript)");
"__TURBOPACK__ecmascript__hoisting__location__";
"use client";
;
;
;
var Store = class {
    constructor(state){
        this.state = state;
    }
    listeners = [];
    set(state) {
        this.state = state;
        for (let listener of this.listeners){
            listener(this.state);
        }
    }
    subscribe(listener) {
        this.listeners = [
            ...this.listeners,
            listener
        ];
        return ()=>{
            this.listeners = this.listeners.filter((l)=>l !== listener);
        };
    }
    get() {
        return this.state;
    }
};
function useStore(store) {
    const [state, setState] = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$server$2f$future$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["useState"])(store.get());
    (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$server$2f$future$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["useEffect"])(()=>{
        return store.subscribe((state2)=>setState(state2));
    }, [
        store
    ]);
    return state;
}
;
var LenisContext = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$server$2f$future$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["createContext"])(null);
var rootLenisContextStore = new Store(null);
var ReactLenis = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$server$2f$future$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["forwardRef"])(({ children, root = false, options = {}, autoRaf = true, ...props }, ref)=>{
    const wrapperRef = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$server$2f$future$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["useRef"])(null);
    const contentRef = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$server$2f$future$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["useRef"])(null);
    const [lenis, setLenis] = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$server$2f$future$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["useState"])(void 0);
    (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$server$2f$future$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["useImperativeHandle"])(ref, ()=>({
            wrapper: wrapperRef.current,
            content: contentRef.current,
            lenis
        }), [
        lenis
    ]);
    (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$server$2f$future$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["useEffect"])(()=>{
        const lenis2 = new __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$lenis$2f$dist$2f$lenis$2e$mjs__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["default"]({
            ...options,
            ...wrapperRef.current && contentRef.current && {
                wrapper: wrapperRef.current,
                content: contentRef.current
            },
            autoRaf: options?.autoRaf ?? autoRaf
        });
        setLenis(lenis2);
        return ()=>{
            lenis2.destroy();
            setLenis(void 0);
        };
    }, [
        root,
        JSON.stringify({
            ...options,
            wrapper: null,
            content: null
        })
    ]);
    const callbacksRefs = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$server$2f$future$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["useRef"])([]);
    const addCallback = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$server$2f$future$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["useCallback"])((callback, priority)=>{
        callbacksRefs.current.push({
            callback,
            priority
        });
        callbacksRefs.current.sort((a, b)=>a.priority - b.priority);
    }, []);
    const removeCallback = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$server$2f$future$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["useCallback"])((callback)=>{
        callbacksRefs.current = callbacksRefs.current.filter((cb)=>cb.callback !== callback);
    }, []);
    (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$server$2f$future$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["useEffect"])(()=>{
        if (root && lenis) {
            rootLenisContextStore.set({
                lenis,
                addCallback,
                removeCallback
            });
            return ()=>rootLenisContextStore.set(null);
        }
    }, [
        root,
        lenis,
        addCallback,
        removeCallback
    ]);
    (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$server$2f$future$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["useEffect"])(()=>{
        if (!lenis) return;
        const onScroll = (data)=>{
            for(let i = 0; i < callbacksRefs.current.length; i++){
                callbacksRefs.current[i]?.callback(data);
            }
        };
        lenis.on("scroll", onScroll);
        return ()=>{
            lenis.off("scroll", onScroll);
        };
    }, [
        lenis
    ]);
    if (!children) return null;
    return /* @__PURE__ */ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$server$2f$future$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2d$jsx$2d$runtime$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["jsx"])(LenisContext.Provider, {
        value: {
            lenis,
            addCallback,
            removeCallback
        },
        children: root && root !== "asChild" ? children : /* @__PURE__ */ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$server$2f$future$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2d$jsx$2d$runtime$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["jsx"])("div", {
            ref: wrapperRef,
            ...props,
            children: /* @__PURE__ */ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$server$2f$future$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2d$jsx$2d$runtime$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["jsx"])("div", {
                ref: contentRef,
                children
            })
        })
    });
});
;
var fallbackContext = {};
function useLenis(callback, deps = [], priority = 0) {
    const localContext = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$server$2f$future$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["useContext"])(LenisContext);
    const rootContext = useStore(rootLenisContextStore);
    const currentContext = localContext ?? rootContext ?? fallbackContext;
    const { lenis, addCallback, removeCallback } = currentContext;
    (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$server$2f$future$2f$route$2d$modules$2f$app$2d$page$2f$vendored$2f$ssr$2f$react$2e$js__$5b$app$2d$ssr$5d$__$28$ecmascript$29$__["useEffect"])(()=>{
        if (!callback || !addCallback || !removeCallback || !lenis) return;
        addCallback(callback, priority);
        callback(lenis);
        return ()=>{
            removeCallback(callback);
        };
    }, [
        lenis,
        addCallback,
        removeCallback,
        priority,
        ...deps
    ]);
    return lenis;
}
;
 //# sourceMappingURL=lenis-react.mjs.map

})()),
"[project]/node_modules/vanilla-cookieconsent/dist/cookieconsent.esm.js [app-ssr] (ecmascript)": (({ r: __turbopack_require__, f: __turbopack_module_context__, i: __turbopack_import__, s: __turbopack_esm__, v: __turbopack_export_value__, n: __turbopack_export_namespace__, c: __turbopack_cache__, M: __turbopack_modules__, l: __turbopack_load__, j: __turbopack_dynamic__, P: __turbopack_resolve_absolute_path__, U: __turbopack_relative_url__, R: __turbopack_resolve_module_id_path__, g: global, __dirname, x: __turbopack_external_require__, y: __turbopack_external_import__ }) => (() => {
"use strict";

/*!
* CookieConsent 3.1.0
* https://github.com/orestbida/cookieconsent
* Author Orest Bida
* Released under the MIT License
*/ __turbopack_esm__({
    "acceptCategory": ()=>Ve,
    "acceptService": ()=>Le,
    "acceptedCategory": ()=>Ie,
    "acceptedService": ()=>je,
    "eraseCookies": ()=>Pe,
    "getConfig": ()=>Qe,
    "getCookie": ()=>Ke,
    "getUserPreferences": ()=>Ue,
    "hide": ()=>Re,
    "hidePreferences": ()=>$e,
    "loadScript": ()=>ze,
    "reset": ()=>Ye,
    "run": ()=>Xe,
    "setCookieData": ()=>qe,
    "setLanguage": ()=>Je,
    "show": ()=>Oe,
    "showPreferences": ()=>Be,
    "validConsent": ()=>We,
    "validCookie": ()=>Fe
});
const e = 'opt-in', t = 'opt-out', o = 'show--consent', n = 'show--preferences', a = 'disable--interaction', s = 'data-category', c = 'div', r = 'button', i = 'aria-hidden', l = 'btn-group', d = 'click', f = 'data-role', _ = 'consentModal', u = 'preferencesModal';
class p {
    constructor(){
        this.t = {
            mode: e,
            revision: 0,
            autoShow: !0,
            lazyHtmlGeneration: !0,
            autoClearCookies: !0,
            manageScriptTags: !0,
            hideFromBots: !0,
            cookie: {
                name: 'cc_cookie',
                expiresAfterDays: 182,
                domain: '',
                path: '/',
                secure: !0,
                sameSite: 'Lax'
            }
        }, this.o = {
            i: {},
            l: '',
            _: {},
            u: {},
            p: {},
            m: [],
            v: !1,
            h: null,
            C: null,
            S: null,
            M: '',
            D: !0,
            T: !1,
            k: !1,
            A: !1,
            N: !1,
            H: [],
            V: !1,
            I: !0,
            L: [],
            j: !1,
            F: '',
            P: !1,
            O: [],
            R: [],
            B: [],
            $: [],
            G: !1,
            J: !1,
            U: !1,
            q: [],
            K: [],
            W: [],
            X: {},
            Y: {},
            Z: {},
            ee: {},
            te: {},
            oe: []
        }, this.ne = {
            ae: {},
            se: {}
        }, this.ce = {}, this.re = {
            ie: 'cc:onFirstConsent',
            le: 'cc:onConsent',
            de: 'cc:onChange',
            fe: 'cc:onModalShow',
            _e: 'cc:onModalHide',
            ue: 'cc:onModalReady'
        };
    }
}
const g = new p, m = (e, t)=>e.indexOf(t), b = (e, t)=>-1 !== m(e, t), v = (e)=>Array.isArray(e), y = (e)=>'string' == typeof e, h = (e)=>!!e && 'object' == typeof e && !v(e), C = (e)=>'function' == typeof e, w = (e)=>Object.keys(e), S = (e)=>Array.from(new Set(e)), x = ()=>document.activeElement, M = (e)=>e.preventDefault(), D = (e, t)=>e.querySelectorAll(t), T = (e)=>e.dispatchEvent(new Event('change')), k = (e)=>{
    const t = document.createElement(e);
    return e === r && (t.type = e), t;
}, E = (e, t, o)=>e.setAttribute(t, o), A = (e, t, o)=>{
    e.removeAttribute(o ? 'data-' + t : t);
}, N = (e, t, o)=>e.getAttribute(o ? 'data-' + t : t), H = (e, t)=>e.appendChild(t), V = (e, t)=>e.classList.add(t), I = (e, t)=>V(e, 'cm__' + t), L = (e, t)=>V(e, 'pm__' + t), j = (e, t)=>e.classList.remove(t), F = (e)=>{
    if ('object' != typeof e) return e;
    if (e instanceof Date) return new Date(e.getTime());
    let t = Array.isArray(e) ? [] : {};
    for(let o in e){
        let n = e[o];
        t[o] = F(n);
    }
    return t;
}, P = ()=>{
    const e = {}, { O: t, X: o, Y: n } = g.o;
    for (const a of t)e[a] = $(n[a], w(o[a]));
    return e;
}, O = (e, t)=>dispatchEvent(new CustomEvent(e, {
        detail: t
    })), R = (e, t, o, n)=>{
    e.addEventListener(t, o), n && g.o.m.push({
        pe: e,
        ge: t,
        me: o
    });
}, B = ()=>{
    const e = g.t.cookie.expiresAfterDays;
    return C(e) ? e(g.o.F) : e;
}, $ = (e, t)=>{
    const o = e || [], n = t || [];
    return o.filter((e)=>!b(n, e)).concat(n.filter((e)=>!b(o, e)));
}, G = (e)=>{
    g.o.R = S(e), g.o.F = (()=>{
        let e = 'custom';
        const { R: t, O: o, B: n } = g.o, a = t.length;
        return a === o.length ? e = 'all' : a === n.length && (e = 'necessary'), e;
    })();
}, J = (e, t, o, n)=>{
    const a = 'accept-', { show: s, showPreferences: c, hide: r, hidePreferences: i, acceptCategory: l } = t, f = e || document, _ = (e)=>D(f, `[data-cc="${e}"]`), u = (e, t)=>{
        M(e), l(t), i(), r();
    }, p = _('show-preferencesModal'), m = _('show-consentModal'), b = _(a + 'all'), v = _(a + 'necessary'), y = _(a + 'custom'), h = g.t.lazyHtmlGeneration;
    for (const e of p)E(e, 'aria-haspopup', 'dialog'), R(e, d, (e)=>{
        M(e), c();
    }), h && (R(e, 'mouseenter', (e)=>{
        M(e), g.o.N || o(t, n);
    }, !0), R(e, 'focus', ()=>{
        g.o.N || o(t, n);
    }));
    for (let e of m)E(e, 'aria-haspopup', 'dialog'), R(e, d, (e)=>{
        M(e), s(!0);
    }, !0);
    for (let e of b)R(e, d, (e)=>{
        u(e, 'all');
    }, !0);
    for (let e of y)R(e, d, (e)=>{
        u(e);
    }, !0);
    for (let e of v)R(e, d, (e)=>{
        u(e, []);
    }, !0);
}, U = (e, t)=>{
    e && (t && (e.tabIndex = -1), e.focus(), t && e.removeAttribute('tabindex'));
}, z = (e, t)=>{
    const o = (n)=>{
        n.target.removeEventListener('transitionend', o), 'opacity' === n.propertyName && '1' === getComputedStyle(e).opacity && U(((e)=>1 === e ? g.ne.be : g.ne.ve)(t));
    };
    R(e, 'transitionend', o);
};
let q;
const K = (e)=>{
    clearTimeout(q), e ? V(g.ne.ye, a) : q = setTimeout(()=>{
        j(g.ne.ye, a);
    }, 500);
}, Q = [
    'M 19.5 4.5 L 4.5 19.5 M 4.5 4.501 L 19.5 19.5',
    'M 3.572 13.406 L 8.281 18.115 L 20.428 5.885',
    'M 21.999 6.94 L 11.639 17.18 L 2.001 6.82 '
], W = (e = 0, t = 1.5)=>`<svg viewBox="0 0 24 24" stroke-width="${t}"><path d="${Q[e]}"/></svg>`, X = (e)=>{
    const t = g.ne, o = g.o;
    ((e)=>{
        const n = e === t.he, a = o.i.disablePageInteraction ? t.ye : n ? t.Ce : t.ye;
        R(a, 'keydown', (t)=>{
            if ('Tab' !== t.key || !(n ? o.k && !o.A : o.A)) return;
            const a = x(), s = n ? o.q : o.K;
            0 !== s.length && (t.shiftKey ? a !== s[0] && e.contains(a) || (M(t), U(s[1])) : a !== s[1] && e.contains(a) || (M(t), U(s[0])));
        }, !0);
    })(e);
}, Y = [
    '[href]',
    r,
    'input',
    'details',
    '[tabindex]'
].map((e)=>e + ':not([tabindex="-1"])').join(','), Z = (e)=>{
    const { o: t, ne: o } = g, n = (e, t)=>{
        const o = D(e, Y);
        t[0] = o[0], t[1] = o[o.length - 1];
    };
    1 === e && t.T && n(o.he, t.q), 2 === e && t.N && n(o.we, t.K);
}, ee = (e, t, o)=>{
    const { de: n, le: a, ie: s, _e: c, ue: r, fe: i } = g.ce, l = g.re;
    if (t) {
        const n = {
            modalName: t
        };
        return e === l.fe ? C(i) && i(n) : e === l._e ? C(c) && c(n) : (n.modal = o, C(r) && r(n)), O(e, n);
    }
    const d = {
        cookie: g.o.p
    };
    e === l.ie ? C(s) && s(F(d)) : e === l.le ? C(a) && a(F(d)) : (d.changedCategories = g.o.L, d.changedServices = g.o.ee, C(n) && n(F(d))), O(e, F(d));
}, te = (e, t)=>{
    try {
        return e();
    } catch (e) {
        return !t && console.warn('CookieConsent:', e), !1;
    }
}, oe = (e)=>{
    const { Y: t, ee: o, O: n, X: a, oe: c, p: r, L: i } = g.o;
    for (const e of n){
        const n = o[e] || t[e] || [];
        for (const o of n){
            const n = a[e][o];
            if (!n) continue;
            const { onAccept: s, onReject: c } = n;
            !n.Se && b(t[e], o) ? (n.Se = !0, C(s) && s()) : n.Se && !b(t[e], o) && (n.Se = !1, C(c) && c());
        }
    }
    if (!g.t.manageScriptTags) return;
    const l = c, d = e || r.categories || [], f = (e, n)=>{
        if (n >= e.length) return;
        const a = c[n];
        if (a.xe) return f(e, n + 1);
        const r = a.Me, l = a.De, _ = a.Te, u = b(d, l), p = !!_ && b(t[l], _);
        if (!_ && !a.ke && u || !_ && a.ke && !u && b(i, l) || _ && !a.ke && p || _ && a.ke && !p && b(o[l] || [], _)) {
            a.xe = !0;
            const t = N(r, 'type', !0);
            A(r, 'type', !!t), A(r, s);
            let o = N(r, 'src', !0);
            o && A(r, 'src', !0);
            const c = k('script');
            c.textContent = r.innerHTML;
            for (const { nodeName: e } of r.attributes)E(c, e, r[e] || N(r, e));
            t && (c.type = t), o ? c.src = o : o = r.src;
            const i = !!o && (!t || [
                'text/javascript',
                'module'
            ].includes(t));
            if (i && (c.onload = c.onerror = ()=>{
                f(e, ++n);
            }), r.replaceWith(c), i) return;
        }
        f(e, ++n);
    };
    f(l, 0);
}, ne = 'bottom', ae = 'left', se = 'center', ce = 'right', re = 'inline', ie = 'wide', le = 'pm--', de = [
    'middle',
    'top',
    ne
], fe = [
    ae,
    se,
    ce
], _e = {
    box: {
        Ee: [
            ie,
            re
        ],
        Ae: de,
        Ne: fe,
        He: ne,
        Ve: ce
    },
    cloud: {
        Ee: [
            re
        ],
        Ae: de,
        Ne: fe,
        He: ne,
        Ve: se
    },
    bar: {
        Ee: [
            re
        ],
        Ae: de.slice(1),
        Ne: [],
        He: ne,
        Ve: ''
    }
}, ue = {
    box: {
        Ee: [],
        Ae: [],
        Ne: [],
        He: '',
        Ve: ''
    },
    bar: {
        Ee: [
            ie
        ],
        Ae: [],
        Ne: [
            ae,
            ce
        ],
        He: '',
        Ve: ae
    }
}, pe = (e)=>{
    const t = g.o.i.guiOptions, o = t && t.consentModal, n = t && t.preferencesModal;
    0 === e && ge(g.ne.he, _e, o, 'cm--', 'box', 'cm'), 1 === e && ge(g.ne.we, ue, n, le, 'box', 'pm');
}, ge = (e, t, o, n, a, s)=>{
    e.className = s;
    const c = o && o.layout, r = o && o.position, i = o && o.flipButtons, l = !o || !1 !== o.equalWeightButtons, d = c && c.split(' ') || [], f = d[0], _ = d[1], u = f in t ? f : a, p = t[u], m = b(p.Ee, _) && _, v = r && r.split(' ') || [], y = v[0], h = n === le ? v[0] : v[1], C = b(p.Ae, y) ? y : p.He, w = b(p.Ne, h) ? h : p.Ve, S = (t)=>{
        t && V(e, n + t);
    };
    S(u), S(m), S(C), S(w), i && S('flip');
    const x = s + '__btn--secondary';
    if ('cm' === s) {
        const { Ie: e, Le: t } = g.ne;
        e && (l ? j(e, x) : V(e, x)), t && (l ? j(t, x) : V(t, x));
    } else {
        const { je: e } = g.ne;
        e && (l ? j(e, x) : V(e, x));
    }
}, me = (e, t)=>{
    const o = g.o, n = g.ne, { hide: a, hidePreferences: s, acceptCategory: _ } = e, p = (e)=>{
        _(e), s(), a();
    }, m = o.u && o.u.preferencesModal;
    if (!m) return;
    const b = m.title, v = m.closeIconLabel, C = m.acceptAllBtn, S = m.acceptNecessaryBtn, x = m.savePreferencesBtn, M = m.sections || [], D = C || S || x;
    if (n.Fe) n.Pe = k(c), L(n.Pe, 'body');
    else {
        n.Fe = k(c), V(n.Fe, 'pm-wrapper');
        const e = k('div');
        V(e, 'pm-overlay'), H(n.Fe, e), R(e, d, s), n.we = k(c), V(n.we, 'pm'), E(n.we, 'role', 'dialog'), E(n.we, i, !0), E(n.we, 'aria-modal', !0), E(n.we, 'aria-labelledby', 'pm__title'), R(n.ye, 'keydown', (e)=>{
            27 === e.keyCode && s();
        }, !0), n.Oe = k(c), L(n.Oe, 'header'), n.Re = k('h2'), L(n.Re, 'title'), n.Re.id = 'pm__title', n.Be = k(r), L(n.Be, 'close-btn'), E(n.Be, 'aria-label', m.closeIconLabel || ''), R(n.Be, d, s), n.$e = k('span'), n.$e.innerHTML = W(), H(n.Be, n.$e), n.Ge = k(c), L(n.Ge, 'body'), n.Je = k(c), L(n.Je, 'footer');
        var T = k(c);
        V(T, 'btns');
        var A = k(c), N = k(c);
        L(A, l), L(N, l), H(n.Je, A), H(n.Je, N), H(n.Oe, n.Re), H(n.Oe, n.Be), n.ve = k(c), E(n.ve, 'tabIndex', -1), H(n.we, n.ve), H(n.we, n.Oe), H(n.we, n.Ge), D && H(n.we, n.Je), H(n.Fe, n.we);
    }
    let I;
    b && (n.Re.innerHTML = b, v && E(n.Be, 'aria-label', v)), M.forEach((e, t)=>{
        const a = e.title, s = e.description, l = e.linkedCategory, f = l && o.P[l], _ = e.cookieTable, u = _ && _.body, p = _ && _.caption, g = u && u.length > 0, b = !!f, v = b && o.X[l], C = h(v) && w(v) || [], S = b && (!!s || !!g || w(v).length > 0);
        var x = k(c);
        if (L(x, 'section'), S || s) {
            var M = k(c);
            L(M, 'section-desc-wrapper');
        }
        let D = C.length;
        if (S && D > 0) {
            const e = k(c);
            L(e, 'section-services');
            for (const t of C){
                const o = v[t], n = o && o.label || t, a = k(c), s = k(c), r = k(c), i = k(c);
                L(a, 'service'), L(i, 'service-title'), L(s, 'service-header'), L(r, 'service-icon');
                const d = be(n, t, f, !0, l);
                i.innerHTML = n, H(s, r), H(s, i), H(a, s), H(a, d), H(e, a);
            }
            H(M, e);
        }
        if (a) {
            var T = k(c), A = k(b ? r : c);
            if (L(T, 'section-title-wrapper'), L(A, 'section-title'), A.innerHTML = a, H(T, A), b) {
                const e = k('span');
                e.innerHTML = W(2, 3.5), L(e, 'section-arrow'), H(T, e), x.className += '--toggle';
                const t = be(a, l, f);
                let o = m.serviceCounterLabel;
                if (D > 0 && y(o)) {
                    let e = k('span');
                    L(e, 'badge'), L(e, 'service-counter'), E(e, i, !0), E(e, 'data-servicecounter', D), o && (o = o.split('|'), o = o.length > 1 && D > 1 ? o[1] : o[0], E(e, 'data-counterlabel', o)), e.innerHTML = D + (o ? ' ' + o : ''), H(A, e);
                }
                if (S) {
                    L(x, 'section--expandable');
                    var N = l + '-desc';
                    E(A, 'aria-expanded', !1), E(A, 'aria-controls', N);
                }
                H(T, t);
            } else E(A, 'role', 'heading'), E(A, 'aria-level', '3');
            H(x, T);
        }
        if (s) {
            var F = k('p');
            L(F, 'section-desc'), F.innerHTML = s, H(M, F);
        }
        if (S && (E(M, i, 'true'), M.id = N, ((e, t, o)=>{
            R(A, d, ()=>{
                t.classList.contains('is-expanded') ? (j(t, 'is-expanded'), E(o, 'aria-expanded', 'false'), E(e, i, 'true')) : (V(t, 'is-expanded'), E(o, 'aria-expanded', 'true'), E(e, i, 'false'));
            });
        })(M, x, A), g)) {
            const e = k('table'), o = k('thead'), a = k('tbody');
            if (p) {
                const t = k('caption');
                L(t, 'table-caption'), t.innerHTML = p, e.appendChild(t);
            }
            L(e, 'section-table'), L(o, 'table-head'), L(a, 'table-body');
            const s = _.headers, r = w(s), i = n.Ue.createDocumentFragment(), l = k('tr');
            for (const e of r){
                const o = s[e], n = k('th');
                n.id = 'cc__row-' + o + t, E(n, 'scope', 'col'), L(n, 'table-th'), n.innerHTML = o, H(i, n);
            }
            H(l, i), H(o, l);
            const d = n.Ue.createDocumentFragment();
            for (const e of u){
                const o = k('tr');
                L(o, 'table-tr');
                for (const n of r){
                    const a = s[n], r = e[n], i = k('td'), l = k(c);
                    L(i, 'table-td'), E(i, 'data-column', a), E(i, 'headers', 'cc__row-' + a + t), l.insertAdjacentHTML('beforeend', r), H(i, l), H(o, i);
                }
                H(d, o);
            }
            H(a, d), H(e, o), H(e, a), H(M, e);
        }
        (S || s) && H(x, M);
        const P = n.Pe || n.Ge;
        b ? (I || (I = k(c), L(I, 'section-toggles')), I.appendChild(x)) : I = null, H(P, I || x);
    }), C && (n.ze || (n.ze = k(r), L(n.ze, 'btn'), E(n.ze, f, 'all'), H(A, n.ze), R(n.ze, d, ()=>p('all'))), n.ze.innerHTML = C), S && (n.je || (n.je = k(r), L(n.je, 'btn'), E(n.je, f, 'necessary'), H(A, n.je), R(n.je, d, ()=>p([]))), n.je.innerHTML = S), x && (n.qe || (n.qe = k(r), L(n.qe, 'btn'), L(n.qe, 'btn--secondary'), E(n.qe, f, 'save'), H(N, n.qe), R(n.qe, d, ()=>p())), n.qe.innerHTML = x), n.Pe && (n.we.replaceChild(n.Pe, n.Ge), n.Ge = n.Pe), pe(1), o.N || (o.N = !0, ee(g.re.ue, u, n.we), t(e), H(n.Ce, n.Fe), X(n.we), setTimeout(()=>V(n.Fe, 'cc--anim'), 100)), Z(2);
};
function be(e, t, o, n, a) {
    const c = g.o, r = g.ne, l = k('label'), f = k('input'), _ = k('span'), u = k('span'), p = k('span'), m = k('span'), v = k('span');
    if (m.innerHTML = W(1, 3), v.innerHTML = W(0, 3), f.type = 'checkbox', V(l, 'section__toggle-wrapper'), V(f, 'section__toggle'), V(m, 'toggle__icon-on'), V(v, 'toggle__icon-off'), V(_, 'toggle__icon'), V(u, 'toggle__icon-circle'), V(p, 'toggle__label'), E(_, i, 'true'), n ? (V(l, 'toggle-service'), E(f, s, a), r.se[a][t] = f) : r.ae[t] = f, n ? ((e)=>{
        R(f, 'change', ()=>{
            const t = r.se[e], o = r.ae[e];
            c.Z[e] = [];
            for(let o in t){
                const n = t[o];
                n.checked && c.Z[e].push(n.value);
            }
            o.checked = c.Z[e].length > 0;
        });
    })(a) : ((e)=>{
        R(f, d, ()=>{
            const t = r.se[e], o = f.checked;
            c.Z[e] = [];
            for(let n in t)t[n].checked = o, o && c.Z[e].push(n);
        });
    })(t), f.value = t, p.textContent = e.replace(/<.*>.*<\/.*>/gm, ''), H(u, v), H(u, m), H(_, u), c.D) (o.readOnly || o.enabled) && (f.checked = !0);
    else if (n) {
        const e = c.Y[a];
        f.checked = o.readOnly || b(e, t);
    } else b(c.R, t) && (f.checked = !0);
    return o.readOnly && (f.disabled = !0), H(l, f), H(l, _), H(l, p), l;
}
const ve = ()=>{
    const e = k('span');
    return g.ne.Ke || (g.ne.Ke = e), e;
}, ye = (e, t)=>{
    const o = g.o, n = g.ne, { hide: a, showPreferences: s, acceptCategory: u } = e, p = o.u && o.u.consentModal;
    if (!p) return;
    const m = p.acceptAllBtn, b = p.acceptNecessaryBtn, v = p.showPreferencesBtn, y = p.closeIconLabel, h = p.footer, C = p.label, w = p.title, S = (e)=>{
        a(), u(e);
    };
    if (!n.Qe) {
        n.Qe = k(c), n.he = k(c), n.We = k(c), n.Xe = k(c), n.Ye = k(c), V(n.Qe, 'cm-wrapper'), V(n.he, 'cm'), I(n.We, 'body'), I(n.Xe, 'texts'), I(n.Ye, 'btns'), E(n.he, 'role', 'dialog'), E(n.he, 'aria-modal', 'true'), E(n.he, i, 'false'), E(n.he, 'aria-describedby', 'cm__desc'), C ? E(n.he, 'aria-label', C) : w && E(n.he, 'aria-labelledby', 'cm__title');
        const e = 'box', t = o.i.guiOptions, a = t && t.consentModal, s = (a && a.layout || e).split(' ')[0] === e;
        w && y && s && (n.Le || (n.Le = k(r), n.Le.innerHTML = W(), I(n.Le, 'btn'), I(n.Le, 'btn--close'), R(n.Le, d, ()=>{
            S([]);
        }), H(n.We, n.Le)), E(n.Le, 'aria-label', y)), H(n.We, n.Xe), (m || b || v) && H(n.We, n.Ye), n.be = k(c), E(n.be, 'tabIndex', -1), H(n.he, n.be), H(n.he, n.We), H(n.Qe, n.he);
    }
    w && (n.Ze || (n.Ze = k('h2'), n.Ze.className = n.Ze.id = 'cm__title', H(n.Xe, n.Ze)), n.Ze.innerHTML = w);
    let x = p.description;
    if (x && (o.V && (x = x.replace('{{revisionMessage}}', o.I ? '' : p.revisionMessage || '')), n.et || (n.et = k('p'), n.et.className = n.et.id = 'cm__desc', H(n.Xe, n.et)), n.et.innerHTML = x), m && (n.tt || (n.tt = k(r), H(n.tt, ve()), I(n.tt, 'btn'), E(n.tt, f, 'all'), R(n.tt, d, ()=>{
        S('all');
    })), n.tt.firstElementChild.innerHTML = m), b && (n.Ie || (n.Ie = k(r), H(n.Ie, ve()), I(n.Ie, 'btn'), E(n.Ie, f, 'necessary'), R(n.Ie, d, ()=>{
        S([]);
    })), n.Ie.firstElementChild.innerHTML = b), v && (n.ot || (n.ot = k(r), H(n.ot, ve()), I(n.ot, 'btn'), I(n.ot, 'btn--secondary'), E(n.ot, f, 'show'), R(n.ot, 'mouseenter', ()=>{
        o.N || me(e, t);
    }), R(n.ot, d, s)), n.ot.firstElementChild.innerHTML = v), n.nt || (n.nt = k(c), I(n.nt, l), m && H(n.nt, n.tt), b && H(n.nt, n.Ie), (m || b) && H(n.We, n.nt), H(n.Ye, n.nt)), n.ot && !n.st && (n.st = k(c), n.Ie && n.tt ? (I(n.st, l), H(n.st, n.ot), H(n.Ye, n.st)) : (H(n.nt, n.ot), I(n.nt, l + '--uneven'))), h) {
        if (!n.ct) {
            let e = k(c), t = k(c);
            n.ct = k(c), I(e, 'footer'), I(t, 'links'), I(n.ct, 'link-group'), H(t, n.ct), H(e, t), H(n.he, e);
        }
        n.ct.innerHTML = h;
    }
    pe(0), o.T || (o.T = !0, ee(g.re.ue, _, n.he), t(e), H(n.Ce, n.Qe), X(n.he), setTimeout(()=>V(n.Qe, 'cc--anim'), 100)), Z(1), J(n.We, e, me, t);
}, he = (e)=>{
    if (!y(e)) return null;
    if (e in g.o._) return e;
    let t = e.slice(0, 2);
    return t in g.o._ ? t : null;
}, Ce = ()=>g.o.l || g.o.i.language.default, we = (e)=>{
    e && (g.o.l = e);
}, Se = async (e)=>{
    const t = g.o;
    let o = he(e) ? e : Ce(), n = t._[o];
    if (y(n) ? n = await (async (e)=>{
        try {
            const t = await fetch(e);
            return await t.json();
        } catch (e) {
            return console.error(e), !1;
        }
    })(n) : C(n) && (n = await n()), !n) throw `Could not load translation for the '${o}' language`;
    return t.u = n, we(o), !0;
}, xe = ()=>{
    let e = g.o.i.language.rtl, t = g.ne.Ce;
    e && t && (v(e) || (e = [
        e
    ]), b(e, g.o.l) ? V(t, 'cc--rtl') : j(t, 'cc--rtl'));
}, Me = ()=>{
    const e = g.ne;
    if (e.Ce) return;
    e.Ce = k(c), e.Ce.id = 'cc-main', e.Ce.setAttribute('data-nosnippet', ''), xe();
    let t = g.o.i.root;
    t && y(t) && (t = document.querySelector(t)), (t || e.Ue.body).appendChild(e.Ce);
}, De = (e)=>te(()=>localStorage.removeItem(e)), Te = (e, t)=>{
    if (t instanceof RegExp) return e.filter((e)=>t.test(e));
    {
        const o = m(e, t);
        return o > -1 ? [
            e[o]
        ] : [];
    }
}, ke = (e)=>{
    const { hostname: t, protocol: o } = location, { name: n, path: a, domain: s, sameSite: c, useLocalStorage: r, secure: i } = g.t.cookie, l = e ? (()=>{
        const e = g.o.S, t = e ? new Date - e : 0;
        return 864e5 * B() - t;
    })() : 864e5 * B(), d = new Date;
    d.setTime(d.getTime() + l), g.o.p.expirationTime = d.getTime();
    const f = JSON.stringify(g.o.p);
    let _ = n + '=' + encodeURIComponent(f) + (0 !== l ? '; expires=' + d.toUTCString() : '') + '; Path=' + a + '; SameSite=' + c;
    b(t, '.') && (_ += '; Domain=' + s), i && 'https:' === o && (_ += '; Secure'), r ? ((e, t)=>{
        te(()=>localStorage.setItem(e, t));
    })(n, f) : document.cookie = _, g.o.p;
}, Ee = (e, t, o)=>{
    if (0 === e.length) return;
    const n = o || g.t.cookie.domain, a = t || g.t.cookie.path, s = 'www.' === n.slice(0, 4), c = s && n.substring(4), r = (e, t)=>{
        t && '.' !== t.slice(0, 1) && (t = '.' + t), document.cookie = e + '=; path=' + a + (t ? '; domain=' + t : '') + '; expires=Thu, 01 Jan 1970 00:00:01 GMT;';
    };
    for (const t of e)r(t, o), o || r(t, n), s && r(t, c);
}, Ae = (e)=>{
    const t = e || g.t.cookie.name, o = g.t.cookie.useLocalStorage;
    return ((e, t)=>{
        let o;
        return o = te(()=>JSON.parse(t ? e : decodeURIComponent(e)), !0) || {}, o;
    })(o ? (n = t, te(()=>localStorage.getItem(n)) || '') : Ne(t, !0), o);
    var n;
}, Ne = (e, t)=>{
    const o = document.cookie.match('(^|;)\\s*' + e + '\\s*=\\s*([^;]+)');
    return o ? t ? o.pop() : e : '';
}, He = (e)=>{
    const t = document.cookie.split(/;\s*/), o = [];
    for (const n of t){
        let t = n.split('=')[0];
        e ? te(()=>{
            e.test(t) && o.push(t);
        }) : o.push(t);
    }
    return o;
}, Ve = (o, n = [])=>{
    ((e, t)=>{
        const { O: o, R: n, B: a, N: s, Z: c, $: r, X: i } = g.o;
        let l = [];
        if (e) {
            v(e) ? l.push(...e) : y(e) && (l = 'all' === e ? o : [
                e
            ]);
            for (const e of o)c[e] = b(l, e) ? w(i[e]) : [];
        } else l = [
            ...n,
            ...r
        ], s && (l = (()=>{
            const e = g.ne.ae;
            if (!e) return [];
            let t = [];
            for(let o in e)e[o].checked && t.push(o);
            return t;
        })());
        l = l.filter((e)=>!b(o, e) || !b(t, e)), l.push(...a), G(l);
    })(o, n), (()=>{
        const e = g.o, { Z: t, B: o, Y: n, X: a, O: s } = e, c = s;
        e.te = F(n);
        for (const s of c){
            const c = a[s], r = w(c), i = t[s] && t[s].length > 0, l = b(o, s);
            if (0 !== r.length) {
                if (n[s] = [], l) n[s].push(...r);
                else if (i) {
                    const e = t[s];
                    n[s].push(...e);
                } else n[s] = e.Z[s];
                n[s] = S(n[s]);
            }
        }
    })(), (()=>{
        const o = g.o;
        o.L = g.t.mode === t && o.D ? $(o.$, o.R) : $(o.R, o.p.categories);
        let n = o.L.length > 0, a = !1;
        for (const e of o.O)o.ee[e] = $(o.Y[e], o.te[e]), o.ee[e].length > 0 && (a = !0);
        const s = g.ne.ae;
        for(const e in s)s[e].checked = b(o.R, e);
        for (const e of o.O){
            const t = g.ne.se[e], n = o.Y[e];
            for(const e in t)t[e].checked = b(n, e);
        }
        o.C || (o.C = new Date), o.M || (o.M = ([
            1e7
        ] + -1e3 + -4e3 + -8e3 + -1e11).replace(/[018]/g, (e)=>(e ^ crypto.getRandomValues(new Uint8Array(1))[0] & 15 >> e / 4).toString(16))), o.p = {
            categories: F(o.R),
            revision: g.t.revision,
            data: o.h,
            consentTimestamp: o.C.toISOString(),
            consentId: o.M,
            services: F(o.Y),
            languageCode: g.o.l
        }, o.S && (o.p.lastConsentTimestamp = o.S.toISOString());
        let c = !1;
        const r = n || a;
        (o.D || r) && (o.D && (o.D = !1, c = !0), o.S = o.S ? new Date : o.C, o.p.lastConsentTimestamp = o.S.toISOString(), ke(), g.t.autoClearCookies && (c || r) && ((e)=>{
            const t = g.o, o = He(), n = ((e)=>{
                const t = g.o;
                return (e ? t.O : t.L).filter((e)=>{
                    const o = t.P[e];
                    return !!o && !o.readOnly && !!o.autoClear;
                });
            })(e);
            for(const e in t.ee)for (const n of t.ee[e]){
                const a = t.X[e][n].cookies;
                if (!b(t.Y[e], n) && a) for (const e of a){
                    const t = Te(o, e.name);
                    Ee(t, e.path, e.domain);
                }
            }
            for (const a of n){
                const n = t.P[a].autoClear, s = n && n.cookies || [], c = b(t.L, a), r = !b(t.R, a), i = c && r;
                if (e ? r : i) {
                    n.reloadPage && i && (t.j = !0);
                    for (const e of s){
                        const t = Te(o, e.name);
                        Ee(t, e.path, e.domain);
                    }
                }
            }
        })(c), oe()), c && (ee(g.re.ie), ee(g.re.le), g.t.mode === e) || (r && ee(g.re.de), o.j && (o.j = !1, location.reload()));
    })();
}, Ie = (e)=>{
    const t = g.o.D ? [] : g.o.R;
    return b(t, e);
}, Le = (e, t)=>{
    const { O: o, X: n } = g.o;
    if (!(e && t && y(t) && b(o, t) && 0 !== w(n[t]).length)) return !1;
    ((e, t)=>{
        const o = g.o, { X: n, Z: a, N: s } = o, c = g.ne.se[t] || {}, r = g.ne.ae[t] || {}, i = w(n[t]);
        if (a[t] = [], y(e)) {
            if ('all' === e) {
                if (a[t].push(...i), s) for(let e in c)c[e].checked = !0, T(c[e]);
            } else if (b(i, e) && a[t].push(e), s) for(let t in c)c[t].checked = e === t, T(c[t]);
        } else if (v(e)) for (let o of i){
            const n = b(e, o);
            n && a[t].push(o), s && (c[o].checked = n, T(c[o]));
        }
        const l = 0 === a[t].length;
        o.R = l ? o.R.filter((e)=>e !== t) : S([
            ...o.R,
            t
        ]), s && (r.checked = !l, T(r));
    })(e, t), Ve();
}, je = (e, t)=>{
    const o = g.o.D ? [] : g.o.Y[t] || [];
    return b(o, e);
}, Fe = (e)=>'' !== Ne(e, !0), Pe = (e, t, o)=>{
    let n = [];
    const a = (e)=>{
        if (y(e)) {
            let t = Ne(e);
            '' !== t && n.push(t);
        } else n.push(...He(e));
    };
    if (v(e)) for (let t of e)a(t);
    else a(e);
    Ee(n, t, o);
}, Oe = (e)=>{
    const { ne: t, o: n } = g;
    if (!n.k) {
        if (!n.T) {
            if (!e) return;
            ye(Ge, Me);
        }
        n.k = !0, n.J = x(), n.v && K(!0), z(t.he, 1), V(t.ye, o), E(t.he, i, 'false'), setTimeout(()=>{
            U(g.ne.be);
        }, 100), ee(g.re.fe, _);
    }
}, Re = ()=>{
    const { ne: e, o: t, re: n } = g;
    t.k && (t.k = !1, t.v && K(), U(e.Ke, !0), j(e.ye, o), E(e.he, i, 'true'), U(t.J), t.J = null, ee(n._e, _));
}, Be = ()=>{
    const e = g.o;
    e.A || (e.N || me(Ge, Me), e.A = !0, e.k ? e.U = x() : e.J = x(), z(g.ne.we, 2), V(g.ne.ye, n), E(g.ne.we, i, 'false'), setTimeout(()=>{
        U(g.ne.ve);
    }, 100), ee(g.re.fe, u));
}, $e = ()=>{
    const e = g.o;
    e.A && (e.A = !1, (()=>{
        const e = We(), t = g.o.P, o = g.ne.ae, n = g.ne.se, a = (e)=>b(g.o.$, e);
        for(const s in o){
            const c = !!t[s].readOnly;
            o[s].checked = c || (e ? Ie(s) : a(s));
            for(const t in n[s])n[s][t].checked = c || (e ? je(t, s) : a(s));
        }
    })(), U(g.ne.$e, !0), j(g.ne.ye, n), E(g.ne.we, i, 'true'), e.k ? (U(e.U), e.U = null) : (U(e.J), e.J = null), ee(g.re._e, u));
};
var Ge = {
    show: Oe,
    hide: Re,
    showPreferences: Be,
    hidePreferences: $e,
    acceptCategory: Ve
};
const Je = async (e, t)=>{
    if (!he(e)) return !1;
    const o = g.o;
    return !(e === Ce() && !0 !== t || !await Se(e) || (we(e), o.T && ye(Ge, Me), o.N && me(Ge, Me), xe(), 0));
}, Ue = ()=>{
    const { F: e, Y: t } = g.o, { accepted: o, rejected: n } = (()=>{
        const { D: e, R: t, O: o } = g.o;
        return {
            accepted: t,
            rejected: e ? [] : o.filter((e)=>!b(t, e))
        };
    })();
    return F({
        acceptType: e,
        acceptedCategories: o,
        rejectedCategories: n,
        acceptedServices: t,
        rejectedServices: P()
    });
}, ze = (e, t)=>{
    let o = document.querySelector('script[src="' + e + '"]');
    return new Promise((n)=>{
        if (o) return n(!0);
        if (o = k('script'), h(t)) for(const e in t)E(o, e, t[e]);
        o.onload = ()=>n(!0), o.onerror = ()=>{
            o.remove(), n(!1);
        }, o.src = e, H(document.head, o);
    });
}, qe = (e)=>{
    let t, o = e.value, n = e.mode, a = !1;
    const s = g.o;
    if ('update' === n) {
        s.h = t = Ke('data');
        const e = typeof t == typeof o;
        if (e && 'object' == typeof t) {
            !t && (t = {});
            for(let e in o)t[e] !== o[e] && (t[e] = o[e], a = !0);
        } else !e && t || t === o || (t = o, a = !0);
    } else t = o, a = !0;
    return a && (s.h = t, s.p.data = t, ke(!0)), a;
}, Ke = (e, t)=>{
    const o = Ae(t);
    return e ? o[e] : o;
}, Qe = (e)=>{
    const t = g.t, o = g.o.i;
    return e ? t[e] || o[e] : {
        ...t,
        ...o,
        cookie: {
            ...t.cookie
        }
    };
}, We = ()=>!g.o.D, Xe = async (e)=>{
    const { o: o, t: n, re: a } = g, c = window;
    if (!c._ccRun) {
        if (c._ccRun = !0, ((e)=>{
            const { ne: o, t: n, o: a } = g, c = n, r = a, { cookie: i } = c, l = g.ce, d = e.cookie, f = e.categories, _ = w(f) || [], u = navigator, p = document;
            o.Ue = p, o.ye = p.documentElement, i.domain = location.hostname, r.i = e, r.P = f, r.O = _, r._ = e.language.translations, r.v = !!e.disablePageInteraction, l.ie = e.onFirstConsent, l.le = e.onConsent, l.de = e.onChange, l._e = e.onModalHide, l.fe = e.onModalShow, l.ue = e.onModalReady;
            const { mode: m, autoShow: v, lazyHtmlGeneration: y, autoClearCookies: C, revision: S, manageScriptTags: x, hideFromBots: M } = e;
            m === t && (c.mode = m), 'boolean' == typeof C && (c.autoClearCookies = C), 'boolean' == typeof x && (c.manageScriptTags = x), 'number' == typeof S && S >= 0 && (c.revision = S, r.V = !0), 'boolean' == typeof v && (c.autoShow = v), 'boolean' == typeof y && (c.lazyHtmlGeneration = y), !1 === M && (c.hideFromBots = !1), !0 === c.hideFromBots && u && (r.G = u.userAgent && /bot|crawl|spider|slurp|teoma/i.test(u.userAgent) || u.webdriver), h(d) && (c.cookie = {
                ...i,
                ...d
            }), c.autoClearCookies, r.V, c.manageScriptTags, ((e)=>{
                const { P: t, X: o, Y: n, Z: a, B: s } = g.o;
                for (let c of e){
                    const e = t[c], r = e.services || {}, i = h(r) && w(r) || [];
                    o[c] = {}, n[c] = [], a[c] = [], e.readOnly && (s.push(c), n[c] = i), g.ne.se[c] = {};
                    for (let e of i){
                        const t = r[e];
                        t.Se = !1, o[c][e] = t;
                    }
                }
            })(_), (()=>{
                if (!g.t.manageScriptTags) return;
                const e = g.o, t = D(document, 'script[' + s + ']');
                for (const o of t){
                    let t = N(o, s), n = o.dataset.service || '', a = !1;
                    if (t && '!' === t.charAt(0) && (t = t.slice(1), a = !0), '!' === n.charAt(0) && (n = n.slice(1), a = !0), b(e.O, t) && (e.oe.push({
                        Me: o,
                        xe: !1,
                        ke: a,
                        De: t,
                        Te: n
                    }), n)) {
                        const o = e.X[t];
                        o[n] || (o[n] = {
                            Se: !1
                        });
                    }
                }
            })(), we((()=>{
                const e = g.o.i.language.autoDetect;
                if (e) {
                    const t = {
                        browser: navigator.language,
                        document: document.documentElement.lang
                    }, o = he(t[e]);
                    if (o) return o;
                }
                return Ce();
            })());
        })(e), o.G) return;
        (()=>{
            const e = g.o, o = g.t, n = Ae(), { categories: a, services: s, consentId: c, consentTimestamp: r, lastConsentTimestamp: i, data: l, revision: d } = n, f = v(a);
            e.p = n, e.M = c;
            const _ = !!c && y(c);
            e.C = r, e.C && (e.C = new Date(r)), e.S = i, e.S && (e.S = new Date(i)), e.h = void 0 !== l ? l : null, e.V && _ && d !== o.revision && (e.I = !1), e.D = !(_ && e.I && e.C && e.S && f), o.cookie.useLocalStorage && !e.D && (e.D = (new Date).getTime() > (n.expirationTime || 0), e.D && De(o.cookie.name)), e.D, (()=>{
                const e = g.o;
                for (const o of e.O){
                    const n = e.P[o];
                    if (n.readOnly || n.enabled) {
                        e.$.push(o);
                        const n = e.X[o] || {};
                        for(let a in n)e.Z[o].push(a), e.i.mode === t && e.Y[o].push(a);
                    }
                }
            })(), e.D ? o.mode === t && (e.R = [
                ...e.$
            ]) : (e.Y = {
                ...e.Y,
                ...s
            }, e.Z = {
                ...e.Y
            }, G([
                ...e.B,
                ...a
            ]));
        })();
        const i = We();
        if (!await Se()) return !1;
        if (J(null, r = Ge, me, Me), g.o.D && ye(r, Me), g.t.lazyHtmlGeneration || me(r, Me), n.autoShow && !i && Oe(!0), i) return oe(), ee(a.le);
        n.mode === t && oe(o.$);
    }
    var r;
}, Ye = (e)=>{
    const { Ce: t, ye: s } = g.ne, { name: c, path: r, domain: i, useLocalStorage: l } = g.t.cookie;
    e && (l ? De(c) : Pe(c, r, i));
    for (const { pe: e, ge: t, me: o } of g.o.m)e.removeEventListener(t, o);
    t && t.remove(), s && s.classList.remove(a, n, o);
    const d = new p;
    for(const e in g)g[e] = d[e];
    window._ccRun = !1;
};
;

})()),

};

//# sourceMappingURL=node_modules_7993a0._.js.map