'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

var tslib_es6 = require('../../tslib.es6-7a681263.cjs');
var internal_Action = require('../../internal/Action.cjs');
var internal_qualifier_Qualifier = require('../../internal/qualifier/Qualifier.cjs');
require('../../qualifiers/flag/FlagQualifier.cjs');
require('../../internal/qualifier/QualifierValue.cjs');
require('../../internal/models/QualifierModel.cjs');
require('../../internal/models/qualifierToJson.cjs');
require('../../internal/utils/unsupportedError.cjs');
require('../../internal/utils/dataStructureUtils.cjs');
require('../../internal/models/ActionModel.cjs');
require('../../internal/models/actionToJson.cjs');

/**
 * @description Distorts the image to an arc shape.
 *
 * <b>Learn more:</b> {@link https://cloudinary.com/documentation/transformation_reference#e_distort|Distorting images}</br>
 * <b>Learn more:</b> {@link https://cloudinary.com/documentation/effects_and_artistic_enhancements#distort|Distortion effects}
 * @param {number} degrees The degrees to arc the image
 * @extends SDK.Action
 * @memberOf Actions.Reshape
 * @see Visit {@link Actions.Reshape| Reshape} for examples
 */
var DistortArcAction = /** @class */ (function (_super) {
    tslib_es6.__extends(DistortArcAction, _super);
    function DistortArcAction(degrees) {
        var _this = _super.call(this) || this;
        _this._actionModel = {
            actionType: 'distortArc',
            degrees: degrees
        };
        _this.addQualifier(new internal_qualifier_Qualifier.Qualifier('e', "distort:arc:" + degrees));
        return _this;
    }
    DistortArcAction.fromJson = function (actionModel) {
        var degrees = actionModel.degrees;
        return new DistortArcAction(degrees);
    };
    return DistortArcAction;
}(internal_Action.Action));

exports.DistortArcAction = DistortArcAction;
