import { Action } from "../../internal/Action.js";
/**
 * @description Skews the image according to the two specified values in degrees.
 * @extends SDK.Action
 * @memberOf Actions.Reshape
 * @see Visit {@link Actions.Reshape| Reshape} for examples
 */
class ShearAction extends Action {
    constructor(x, y) {
        super();
        this._actionModel = {
            actionType: 'shear',
            skewX: x,
            skewY: y
        };
        this.skewX(x);
        this.skewY(y);
    }
    /**
     * @param {number} x Skews the image according to the two specified values in degrees. (X and Y)
     */
    skewX(x) {
        this._x = x;
        this._actionModel.skewX = x;
        return this;
    }
    /**
     * @param {number} y Skews the image according to the two specified values in degrees. (X and Y)
     */
    skewY(y) {
        this._y = y;
        this._actionModel.skewY = y;
        return this;
    }
    static fromJson(actionModel) {
        const { skewX, skewY } = actionModel;
        return new ShearAction(skewX, skewY);
    }
    toString() {
        return [
            'e_shear',
            this._x,
            this._y
        ].filter((a) => a !== undefined && a !== null).join(':');
    }
}
export { ShearAction };
