'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

var qualifiers_animatedFormat_AnimatedFormatQualifierValue = require('./animatedFormat/AnimatedFormatQualifierValue.cjs');
require('../tslib.es6-7a681263.cjs');
require('../internal/qualifier/QualifierValue.cjs');

/**
 * @description Contains methods to specify the animated format
 * @namespace AnimatedFormat
 * @memberOf Qualifiers
 * @see Visit {@link Actions.Transcode|Transcode} for an example
 */
/**
 * @description Automatically sets the animated format
 * @summary qualifier
 * @memberOf Qualifiers.AnimatedFormat
 * @return {Qualifiers.AnimatedFormatQualifierValue}
 */
function auto() {
    return new qualifiers_animatedFormat_AnimatedFormatQualifierValue.AnimatedFormatQualifierValue('auto');
}
/**
 * @summary qualifier
 * @memberOf Qualifiers.AnimatedFormat
 * @return {Qualifiers.AnimatedFormatQualifierValue}
 */
function gif() {
    return new qualifiers_animatedFormat_AnimatedFormatQualifierValue.AnimatedFormatQualifierValue('gif');
}
/**
 * @summary qualifier
 * @memberOf Qualifiers.AnimatedFormat
 * @return {Qualifiers.AnimatedFormatQualifierValue}
 */
function webp() {
    return new qualifiers_animatedFormat_AnimatedFormatQualifierValue.AnimatedFormatQualifierValue('webp');
}
/**
 * @summary qualifier
 * @memberOf Qualifiers.AnimatedFormat
 * @return {Qualifiers.AnimatedFormatQualifierValue}
 */
function png() {
    return new qualifiers_animatedFormat_AnimatedFormatQualifierValue.AnimatedFormatQualifierValue('png');
}
var AnimatedFormat = { auto: auto, gif: gif, webp: webp, png: png };

exports.AnimatedFormat = AnimatedFormat;
exports.auto = auto;
exports.gif = gif;
exports.png = png;
exports.webp = webp;
