'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

/**
 * @description Contains methods to specify the type of artistic filter </br>
 * Learn more: {@link https://cloudinary.com/documentation/effects_and_artistic_enhancements#artistic_filter_effects|Artistic Filter}
 * @namespace ArtisticFilter
 * @memberOf Qualifiers
 * @see Visit {@link Actions.Effect|Effect} for an example
 */
/**
 * @summary qualifier
 * @memberOf Qualifiers.ArtisticFilter
 */
function alDente() {
    return 'al_dente';
}
/**
 * @summary qualifier
 * @memberOf Qualifiers.ArtisticFilter
 */
function athena() {
    return 'athena';
}
/**
 * @summary qualifier
 * @memberOf Qualifiers.ArtisticFilter
 */
function audrey() {
    return 'audrey';
}
/**
 * @summary qualifier
 * @memberOf Qualifiers.ArtisticFilter
 */
function aurora() {
    return 'aurora';
}
/**
 * @summary qualifier
 * @memberOf Qualifiers.ArtisticFilter
 */
function daguerre() {
    return 'daguerre';
}
/**
 * @summary qualifier
 * @memberOf Qualifiers.ArtisticFilter
 */
function eucalyptus() {
    return 'eucalyptus';
}
/**
 * @summary qualifier
 * @memberOf Qualifiers.ArtisticFilter
 */
function fes() {
    return 'fes';
}
/**
 * @summary qualifier
 * @memberOf Qualifiers.ArtisticFilter
 */
function frost() {
    return 'frost';
}
/**
 * @summary qualifier
 * @memberOf Qualifiers.ArtisticFilter
 */
function hairspray() {
    return 'hairspray';
}
/**
 * @summary qualifier
 * @memberOf Qualifiers.ArtisticFilter
 */
function hokusai() {
    return 'hokusai';
}
/**
 * @summary qualifier
 * @memberOf Qualifiers.ArtisticFilter
 */
function incognito() {
    return 'incognito';
}
/**
 * @summary qualifier
 * @memberOf Qualifiers.ArtisticFilter
 */
function linen() {
    return 'linen';
}
/**
 * @summary qualifier
 * @memberOf Qualifiers.ArtisticFilter
 */
function peacock() {
    return 'peacock';
}
/**
 * @summary qualifier
 * @memberOf Qualifiers.ArtisticFilter
 */
function primavera() {
    return 'primavera';
}
/**
 * @summary qualifier
 * @memberOf Qualifiers.ArtisticFilter
 */
function quartz() {
    return 'quartz';
}
/**
 * @summary qualifier
 * @memberOf Qualifiers.ArtisticFilter
 */
function redRock() {
    return 'red_rock';
}
/**
 * @summary qualifier
 * @memberOf Qualifiers.ArtisticFilter
 */
function refresh() {
    return 'refresh';
}
/**
 * @summary qualifier
 * @memberOf Qualifiers.ArtisticFilter
 */
function sizzle() {
    return 'sizzle';
}
/**
 * @summary qualifier
 * @memberOf Qualifiers.ArtisticFilter
 */
function sonnet() {
    return 'sonnet';
}
/**
 * @summary qualifier
 * @memberOf Qualifiers.ArtisticFilter
 */
function ukulele() {
    return 'ukulele';
}
/**
 * @summary qualifier
 * @memberOf Qualifiers.ArtisticFilter
 */
function zorro() {
    return 'zorro';
}
var ArtisticFilter = {
    alDente: alDente,
    athena: athena,
    audrey: audrey,
    aurora: aurora,
    daguerre: daguerre,
    eucalyptus: eucalyptus,
    hairspray: hairspray,
    hokusai: hokusai,
    peacock: peacock,
    primavera: primavera,
    quartz: quartz,
    incognito: incognito,
    redRock: redRock,
    sizzle: sizzle,
    fes: fes,
    linen: linen,
    refresh: refresh,
    sonnet: sonnet,
    ukulele: ukulele,
    frost: frost,
    zorro: zorro
};

exports.ArtisticFilter = ArtisticFilter;
exports.alDente = alDente;
exports.athena = athena;
exports.audrey = audrey;
exports.aurora = aurora;
exports.daguerre = daguerre;
exports.eucalyptus = eucalyptus;
exports.fes = fes;
exports.frost = frost;
exports.hairspray = hairspray;
exports.hokusai = hokusai;
exports.incognito = incognito;
exports.linen = linen;
exports.peacock = peacock;
exports.primavera = primavera;
exports.quartz = quartz;
exports.redRock = redRock;
exports.refresh = refresh;
exports.sizzle = sizzle;
exports.sonnet = sonnet;
exports.ukulele = ukulele;
exports.zorro = zorro;
