/**
 * @description Contains functions to select the color space mode.
 * @namespace ColorSpace
 * @memberOf Qualifiers
 * @see Visit {@link Actions.Delivery.colorSpace|Delivery Color Space} for an example
 */
/**
 * @summary qualifier
 * @memberOf Qualifiers.ColorSpace
 */
function srgb() {
    return 'srgb';
}
/**
 * @summary qualifier
 * @memberOf Qualifiers.ColorSpace
 */
function trueColor() {
    return 'srgb:truecolor';
}
/**
 * @summary qualifier
 * @memberOf Qualifiers.ColorSpace
 */
function tinySrgb() {
    return 'tinysrgb';
}
/**
 * @summary qualifier
 * @memberOf Qualifiers.ColorSpace
 */
function cmyk() {
    return 'cmyk';
}
/**
 * @summary qualifier
 * @memberOf Qualifiers.ColorSpace
 */
function noCmyk() {
    return 'no_cmyk';
}
/**
 * @summary qualifier
 * @memberOf Qualifiers.ColorSpace
 */
function keepCmyk() {
    return 'keep_cmyk';
}
const ColorSpace = {
    cmyk,
    keepCmyk,
    noCmyk,
    srgb,
    tinySrgb,
    trueColor
};
export { ColorSpace, cmyk, keepCmyk, noCmyk, srgb, tinySrgb, trueColor };
