'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

var qualifiers_gravity_qualifiers_focusOn_FocusOnValue = require('./gravity/qualifiers/focusOn/FocusOnValue.cjs');
require('../tslib.es6-7a681263.cjs');
require('../internal/qualifier/QualifierValue.cjs');

/**
 * @summary qualifier
 * @memberOf Qualifiers.FocusOn
 * @description Detects birds
 * @return {Qualifiers.FocusOn.FocusOnValue} FocusOnValue
 */
function bird() {
    return new qualifiers_gravity_qualifiers_focusOn_FocusOnValue.FocusOnValue('bird');
}
/**
 * @summary qualifier
 * @description Detects dogs
 * @return {Qualifiers.FocusOn.FocusOnValue} FocusOnValue
 */
function dog() {
    return new qualifiers_gravity_qualifiers_focusOn_FocusOnValue.FocusOnValue('dog');
}
/**
 * @summary qualifier
 * @memberOf Qualifiers.FocusOn
 * @description Detects cats
 * @return {Qualifiers.FocusOn.FocusOnValue} FocusOnValue
 */
function cat() {
    return new qualifiers_gravity_qualifiers_focusOn_FocusOnValue.FocusOnValue('cat');
}
/**
 * @summary qualifier
 * @memberOf Qualifiers.FocusOn
 * @description Detects microwaves
 * @return {Qualifiers.FocusOn.FocusOnValue} FocusOnValue
 */
function microwave() {
    return new qualifiers_gravity_qualifiers_focusOn_FocusOnValue.FocusOnValue('microwave');
}
/**
 * @summary qualifier
 * @memberOf Qualifiers.FocusOn
 * @description Detects refrigerators
 * @return {Qualifiers.FocusOn.FocusOnValue} FocusOnValue
 */
function refrigerator() {
    return new qualifiers_gravity_qualifiers_focusOn_FocusOnValue.FocusOnValue('refrigerator');
}
/**
 * @summary qualifier
 * @memberOf Qualifiers.FocusOn
 * @description Detects bottles
 * @return {Qualifiers.FocusOn.FocusOnValue} FocusOnValue
 */
function bottle() {
    return new qualifiers_gravity_qualifiers_focusOn_FocusOnValue.FocusOnValue('bottle');
}
/**
 * @summary qualifier
 * @memberOf Qualifiers.FocusOn
 * @description Detects sinks
 * @return {Qualifiers.FocusOn.FocusOnValue} FocusOnValue
 */
function sink() {
    return new qualifiers_gravity_qualifiers_focusOn_FocusOnValue.FocusOnValue('sink');
}
/**
 * @summary qualifier
 * @memberOf Qualifiers.FocusOn
 * @description Detects skateboards
 * @return {Qualifiers.FocusOn.FocusOnValue} FocusOnValue
 */
function skateboard() {
    return new qualifiers_gravity_qualifiers_focusOn_FocusOnValue.FocusOnValue('skateboard');
}
/**
 * @summary qualifier
 * @memberOf Qualifiers.FocusOn
 * @description Detects people
 * @return {Qualifiers.FocusOn.FocusOnValue} FocusOnValue
 */
function person() {
    return new qualifiers_gravity_qualifiers_focusOn_FocusOnValue.FocusOnValue('person');
}
/**
 * @summary qualifier
 * @memberOf Qualifiers.FocusOn
 * @description Detects the largest face in an image with the Advanced Facial Attribute Detection add-on and makes it the focus of the transformation.
 * @return {Qualifiers.FocusOn.FocusOnValue} FocusOnValue
 */
function advancedFace() {
    return new qualifiers_gravity_qualifiers_focusOn_FocusOnValue.FocusOnValue('adv_face');
}
/**
 * @summary qualifier
 * @memberOf Qualifiers.FocusOn
 * @description Detects all faces in an image with the Advanced Facial Attribute Detection add-on and makes them the focus of the transformation.
 * @return {Qualifiers.FocusOn.FocusOnValue} FocusOnValue
 */
function advancedFaces() {
    return new qualifiers_gravity_qualifiers_focusOn_FocusOnValue.FocusOnValue('adv_faces');
}
/**
 * @summary qualifier
 * @memberOf Qualifiers.FocusOn
 * @description Detects all eyes in an image with the Advanced Facial Attribute Detection add-on and makes them the focus of the transformation.
 * @return {Qualifiers.FocusOn.FocusOnValue} FocusOnValue
 */
function advancedEyes() {
    return new qualifiers_gravity_qualifiers_focusOn_FocusOnValue.FocusOnValue('adv_eyes');
}
/**
 * @summary qualifier
 * @memberOf Qualifiers.FocusOn
 * @description Detects the largest face in the asset and makes it the focus of the transformation.
 * @return {Qualifiers.FocusOn.FocusOnValue} FocusOnValue
 */
function face() {
    return new qualifiers_gravity_qualifiers_focusOn_FocusOnValue.FocusOnValue('face');
}
/**
 * @summary qualifier
 * @memberOf Qualifiers.FocusOn
 * @description Detects all the faces in the asset and makes them the focus of the transformation.
 * @return {Qualifiers.FocusOn.FocusOnValue} FocusOnValue
 */
function faces() {
    return new qualifiers_gravity_qualifiers_focusOn_FocusOnValue.FocusOnValue('faces');
}
/**
 * @summary qualifier
 * @memberOf Qualifiers.FocusOn
 * @description Detects all the faces in the asset and makes them the focus of the transformation.
 * @return {Qualifiers.FocusOn.FocusOnValue} FocusOnValue
 */
function background() {
    return new qualifiers_gravity_qualifiers_focusOn_FocusOnValue.FocusOnValue('background');
}
/**
 * @summary qualifier
 * @memberOf Qualifiers.FocusOn
 * @description Detects aeroplane
 * @return {Qualifiers.FocusOn.FocusOnValue} FocusOnValue
 */
function aeroplane() {
    return new qualifiers_gravity_qualifiers_focusOn_FocusOnValue.FocusOnValue('aeroplane');
}
/**
 * @summary qualifier
 * @memberOf Qualifiers.FocusOn
 * @description Detects bicycle
 * @return {Qualifiers.FocusOn.FocusOnValue} FocusOnValue
 */
function bicycle() {
    return new qualifiers_gravity_qualifiers_focusOn_FocusOnValue.FocusOnValue('bicycle');
}
/**
 * @summary qualifier
 * @memberOf Qualifiers.FocusOn
 * @description Detects boat
 * @return {Qualifiers.FocusOn.FocusOnValue} FocusOnValue
 */
function boat() {
    return new qualifiers_gravity_qualifiers_focusOn_FocusOnValue.FocusOnValue('boat');
}
/**
 * @summary qualifier
 * @memberOf Qualifiers.FocusOn
 * @description Detects bus
 * @return {Qualifiers.FocusOn.FocusOnValue} FocusOnValue
 */
function bus() {
    return new qualifiers_gravity_qualifiers_focusOn_FocusOnValue.FocusOnValue('bus');
}
/**
 * @summary qualifier
 * @memberOf Qualifiers.FocusOn
 * @description Detects car
 * @return {Qualifiers.FocusOn.FocusOnValue} FocusOnValue
 */
function car() {
    return new qualifiers_gravity_qualifiers_focusOn_FocusOnValue.FocusOnValue('car');
}
/**
 * @summary qualifier
 * @memberOf Qualifiers.FocusOn
 * @description Detects chair
 * @return {Qualifiers.FocusOn.FocusOnValue} FocusOnValue
 */
function chair() {
    return new qualifiers_gravity_qualifiers_focusOn_FocusOnValue.FocusOnValue('chair');
}
/**
 * @summary qualifier
 * @memberOf Qualifiers.FocusOn
 * @description Detects cow
 * @return {Qualifiers.FocusOn.FocusOnValue} FocusOnValue
 */
function cow() {
    return new qualifiers_gravity_qualifiers_focusOn_FocusOnValue.FocusOnValue('cow');
}
/**
 * @summary qualifier
 * @memberOf Qualifiers.FocusOn
 * @description Detects diningtable
 * @return {Qualifiers.FocusOn.FocusOnValue} FocusOnValue
 */
function diningtable() {
    return new qualifiers_gravity_qualifiers_focusOn_FocusOnValue.FocusOnValue('diningtable');
}
/**
 * @summary qualifier
 * @memberOf Qualifiers.FocusOn
 * @description Detects horse
 * @return {Qualifiers.FocusOn.FocusOnValue} FocusOnValue
 */
function horse() {
    return new qualifiers_gravity_qualifiers_focusOn_FocusOnValue.FocusOnValue('horse');
}
/**
 * @summary qualifier
 * @memberOf Qualifiers.FocusOn
 * @description Detects motorbike
 * @return {Qualifiers.FocusOn.FocusOnValue} FocusOnValue
 */
function motorbike() {
    return new qualifiers_gravity_qualifiers_focusOn_FocusOnValue.FocusOnValue('motorbike');
}
/**
 * @summary qualifier
 * @memberOf Qualifiers.FocusOn
 * @description Detects pottedplant
 * @return {Qualifiers.FocusOn.FocusOnValue} FocusOnValue
 */
function pottedplant() {
    return new qualifiers_gravity_qualifiers_focusOn_FocusOnValue.FocusOnValue('pottedplant');
}
/**
 * @summary qualifier
 * @memberOf Qualifiers.FocusOn
 * @description Detects sheep
 * @return {Qualifiers.FocusOn.FocusOnValue} FocusOnValue
 */
function sheep() {
    return new qualifiers_gravity_qualifiers_focusOn_FocusOnValue.FocusOnValue('sheep');
}
/**
 * @summary qualifier
 * @memberOf Qualifiers.FocusOn
 * @description Detects sofa
 * @return {Qualifiers.FocusOn.FocusOnValue} FocusOnValue
 */
function sofa() {
    return new qualifiers_gravity_qualifiers_focusOn_FocusOnValue.FocusOnValue('sofa');
}
/**
 * @summary qualifier
 * @memberOf Qualifiers.FocusOn
 * @description Detects train
 * @return {Qualifiers.FocusOn.FocusOnValue} FocusOnValue
 */
function train() {
    return new qualifiers_gravity_qualifiers_focusOn_FocusOnValue.FocusOnValue('train');
}
/**
 * @summary qualifier
 * @memberOf Qualifiers.FocusOn
 * @description Detects tvmonitor
 * @return {Qualifiers.FocusOn.FocusOnValue} FocusOnValue
 */
function tvmonitor() {
    return new qualifiers_gravity_qualifiers_focusOn_FocusOnValue.FocusOnValue('tvmonitor');
}
/**
 * @summary qualifier
 * @memberOf Qualifiers.FocusOn
 * @description Detect all text elements in an image using the {@link https://cloudinary.com/documentation/ocr_text_detection_and_extraction_addon|OCR Text Detection and Extraction add-on} and use the detected bounding box coordinates as the basis of the transformation.
 * @return {Qualifiers.FocusOn.FocusOnValue} FocusOnValue
 */
function ocr() {
    return new qualifiers_gravity_qualifiers_focusOn_FocusOnValue.FocusOnValue('ocr_text');
}
/**
 * @memberOf Qualifiers
 * @namespace FocusOn
 * @see Visit {@link Qualifiers.Gravity|Gravity} for an example
 */
var FocusOn = {
    person: person,
    cat: cat,
    microwave: microwave,
    refrigerator: refrigerator,
    skateboard: skateboard,
    bird: bird,
    bottle: bottle,
    dog: dog,
    sink: sink,
    face: face,
    train: train,
    sofa: sofa,
    sheep: sheep,
    pottedplant: pottedplant,
    horse: horse,
    faces: faces,
    cow: cow,
    bus: bus,
    boat: boat,
    advancedEyes: advancedEyes,
    advancedFace: advancedFace,
    advancedFaces: advancedFaces,
    aeroplane: aeroplane,
    background: background,
    bicycle: bicycle,
    car: car,
    chair: chair,
    diningtable: diningtable,
    tvmonitor: tvmonitor,
    motorbike: motorbike,
    ocr: ocr
};

exports.FocusOnValue = qualifiers_gravity_qualifiers_focusOn_FocusOnValue.FocusOnValue;
exports.FocusOn = FocusOn;
exports.advancedEyes = advancedEyes;
exports.advancedFace = advancedFace;
exports.advancedFaces = advancedFaces;
exports.aeroplane = aeroplane;
exports.background = background;
exports.bicycle = bicycle;
exports.bird = bird;
exports.boat = boat;
exports.bottle = bottle;
exports.bus = bus;
exports.car = car;
exports.cat = cat;
exports.chair = chair;
exports.cow = cow;
exports.diningtable = diningtable;
exports.dog = dog;
exports.face = face;
exports.faces = faces;
exports.horse = horse;
exports.microwave = microwave;
exports.motorbike = motorbike;
exports.ocr = ocr;
exports.person = person;
exports.pottedplant = pottedplant;
exports.refrigerator = refrigerator;
exports.sheep = sheep;
exports.sink = sink;
exports.skateboard = skateboard;
exports.sofa = sofa;
exports.train = train;
exports.tvmonitor = tvmonitor;
