'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

var qualifiers_gradientDirection_GradientDirectionQualifierValue = require('./gradientDirection/GradientDirectionQualifierValue.cjs');
require('../tslib.es6-7a681263.cjs');
require('../internal/qualifier/QualifierValue.cjs');

/**
 * @description Defines the direction for a background gradient fade effect.
 * @memberOf Qualifiers
 * @namespace GradientDirection
 */
/**
 * @summary qualifier
 * @description Blend the colors horizontally.
 * @memberOf Qualifiers.GradientDirection
 * @return {Qualifiers.GradientDirection.GradientDirectionQualifierValue}
 */
function horizontal() {
    return new qualifiers_gradientDirection_GradientDirectionQualifierValue.GradientDirectionQualifierValue('horizontal');
}
/**
 * @summary qualifier
 * @description Blend the colors vertically.
 * @memberOf Qualifiers.GradientDirection
 * @return {Qualifiers.GradientDirection.GradientDirectionQualifierValue}
 */
function vertical() {
    return new qualifiers_gradientDirection_GradientDirectionQualifierValue.GradientDirectionQualifierValue('vertical');
}
/**
 * @summary qualifier
 * @description Blend the colors diagonally from top-left to bottom-right.
 * @memberOf Qualifiers.GradientDirection
 * @return {Qualifiers.GradientDirection.GradientDirectionQualifierValue}
 */
function diagonalDesc() {
    return new qualifiers_gradientDirection_GradientDirectionQualifierValue.GradientDirectionQualifierValue('diagonal_desc');
}
/**
 * @summary qualifier
 * @description Blend the colors diagonally from bottom-left to top-right.
 * @memberOf Qualifiers.GradientDirection
 * @return {Qualifiers.GradientDirection.GradientDirectionQualifierValue}
 */
function diagonalAsc() {
    return new qualifiers_gradientDirection_GradientDirectionQualifierValue.GradientDirectionQualifierValue('diagonal_asc');
}
var GradientDirection = {
    horizontal: horizontal,
    vertical: vertical,
    diagonalDesc: diagonalDesc,
    diagonalAsc: diagonalAsc
};

exports.GradientDirection = GradientDirection;
exports.diagonalAsc = diagonalAsc;
exports.diagonalDesc = diagonalDesc;
exports.horizontal = horizontal;
exports.vertical = vertical;
