'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

var tslib_es6 = require('../tslib.es6-7a681263.cjs');
var qualifiers_flag_FlagQualifier = require('./flag/FlagQualifier.cjs');
require('../internal/qualifier/QualifierValue.cjs');
require('../internal/qualifier/Qualifier.cjs');
require('../internal/models/QualifierModel.cjs');
require('../internal/models/qualifierToJson.cjs');
require('../internal/utils/unsupportedError.cjs');

var ProgressiveQualifier = /** @class */ (function (_super) {
    tslib_es6.__extends(ProgressiveQualifier, _super);
    function ProgressiveQualifier(mode) {
        return _super.call(this, 'progressive', mode) || this;
    }
    return ProgressiveQualifier;
}(qualifiers_flag_FlagQualifier.FlagQualifier));
/**
 * @memberOf Qualifiers.Progressive
 */
function none() {
    return new ProgressiveQualifier('none');
}
/**
 * @memberOf Qualifiers.Progressive
 */
function semi() {
    return new ProgressiveQualifier('semi');
}
/**
 * @memberOf Qualifiers.Progressive
 */
function steep() {
    return new ProgressiveQualifier('steep');
}
/**
 * @memberOf Qualifiers.Progressive
 */
function progressive() {
    return new ProgressiveQualifier();
}
var Progressive = {
    semi: semi,
    none: none,
    steep: steep,
    progressive: progressive,
    ProgressiveQualifier: ProgressiveQualifier
};

exports.Progressive = Progressive;
exports.ProgressiveQualifier = ProgressiveQualifier;
exports.none = none;
exports.progressive = progressive;
exports.semi = semi;
exports.steep = steep;
