'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

/**
 * @description Qualifiers for applying an ordered dither filter to the image.
 * @namespace StreamingProfile
 * @memberOf Qualifiers
 * @see Visit {@link Actions
 */
/**
 * @summary qualifier
 * @memberOf Qualifiers.StreamingProfile
 * @return {string}
 */
function fullHd() {
    return 'full_hd';
}
/**
 * @summary qualifier
 * @memberOf Qualifiers.StreamingProfile
 * @return {string}
 */
function hd() {
    return 'hd';
}
/**
 * @summary qualifier
 * @memberOf Qualifiers.StreamingProfile
 * @return {string}
 */
function sd() {
    return 'sd';
}
/**
 * @summary qualifier
 * @memberOf Qualifiers.StreamingProfile
 * @return {string}
 */
function fullHdWifi() {
    return 'full_hd_wifi';
}
/**
 * @summary qualifier
 * @memberOf Qualifiers.StreamingProfile
 * @return {string}
 */
function fullHdLean() {
    return 'full_hd_lean';
}
/**
 * @summary qualifier
 * @memberOf Qualifiers.StreamingProfile
 * @return {string}
 */
function hdLean() {
    return 'hd_lean';
}
var StreamingProfile = {
    hd: hd,
    sd: sd,
    hdLean: hdLean,
    fullHd: fullHd,
    fullHdLean: fullHdLean,
    fullHdWifi: fullHdWifi
};

exports.StreamingProfile = StreamingProfile;
exports.fullHd = fullHd;
exports.fullHdLean = fullHdLean;
exports.fullHdWifi = fullHdWifi;
exports.hd = hd;
exports.hdLean = hdLean;
exports.sd = sd;
