'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

var qualifiers_video_TimelinePosition = require('./video/TimelinePosition.cjs');
require('../tslib.es6-7a681263.cjs');
require('../internal/Action.cjs');
require('./flag/FlagQualifier.cjs');
require('../internal/qualifier/QualifierValue.cjs');
require('../internal/qualifier/Qualifier.cjs');
require('../internal/models/QualifierModel.cjs');
require('../internal/models/qualifierToJson.cjs');
require('../internal/utils/unsupportedError.cjs');
require('../internal/utils/dataStructureUtils.cjs');
require('../internal/models/ActionModel.cjs');
require('../internal/models/actionToJson.cjs');

/**
 * @memberOf Qualifiers
 * @description When applying an overlay on a video, this qualifier controls when this overlay is attached
 * @namespace TimelinePosition
 * @see {@link Actions.Overlay| The overlay action}
 */
/**
 * @summary qualifier
 * @memberOf Qualifiers.TimelinePosition
 * @return {Qualifiers.TimelinePosition.TimelinePosition}
 */
function position() {
    return new qualifiers_video_TimelinePosition.TimelinePosition();
}
var Timeline = {
    position: position
};

exports.Timeline = Timeline;
exports.position = position;
