'use strict';

var BaseCommonBackground = require('./BaseCommonBackground-337b931a.cjs');

/**
 * @description Defines the gradient fade effect to use for the background when resizing with padding.
 * @memberOf Qualifiers.Background
 * @extends {Qualifiers.Background.BaseCommonBackground}
 */
class BaseGradientBackground extends BaseCommonBackground.BaseCommonBackground {
    /**
     *
     * @description Sets the number of predominant colors to use (2 or 4).
     * @param {number} num
     * @return {this}
     */
    gradientColors(num) {
        this._gradientColors = num;
        return this;
    }
    /**
     * @description Sets the direction for a background gradient fade effect.
     * @param {Qualifiers.GradientDirection | GradientDirectionType | string} direction Use one of these functions
     * provided by {@link Qualifiers.GradientDirection|GradientDirection}
     * @return {this}
     */
    gradientDirection(direction) {
        this._gradientDirection = direction;
        return this;
    }
}

exports.BaseGradientBackground = BaseGradientBackground;
