'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

var assets_CloudinaryImage = require('../assets/CloudinaryImage.cjs');
var assets_CloudinaryVideo = require('../assets/CloudinaryVideo.cjs');
require('../tslib.es6-2f2a8a72.cjs');
require('../ImageTransformation-8dbd3ea3.cjs');
require('../Transformation-6dd4b6ca.cjs');
require('../Action-34aa7481.cjs');
require('../FlagQualifier-0e14a6c3.cjs');
require('../QualifierValue-e770d619.cjs');
require('../Qualifier-6633a22f.cjs');
require('../QualifierModel-0923d819.cjs');
require('../unsupportedError-74070138.cjs');
require('../BackgroundColor-5a6755f9.cjs');
require('../prepareColor-c03e99eb.cjs');
require('../RawAction-d0d9c15d.cjs');
require('../DeliveryFormatAction-65b51037.cjs');
require('../flag-16e9dd5f.cjs');
require('../DeliveryAction-a40025b2.cjs');
require('../FormatQualifier-ffbb8eb3.cjs');
require('../internalConstants-81828646.cjs');
require('../progressive-47125d1f.cjs');
require('../assets/CloudinaryTransformable.cjs');
require('../assets/CloudinaryFile.cjs');
require('../internal/url/cloudinaryURL.cjs');
require('../internal/url/urlUtils/isUrl.cjs');
require('../internal/url/urlUtils/isFileName.cjs');
require('../internal/url/urlUtils/publicIDContainsVersion.cjs');
require('../config/URLConfig.cjs');
require('../config/BaseConfig.cjs');
require('../internal/internalConstants.cjs');
require('../sdkAnalytics/getSDKAnalyticsSignature.cjs');
require('../sdkAnalytics/encodeVersion.cjs');
require('../sdkAnalytics/base64Map.cjs');
require('../sdkAnalytics/stringPad.cjs');
require('../sdkAnalytics/reverseVersion.cjs');
require('../sdkAnalytics/getAnalyticsOptions.cjs');
require('../internal/utils/packageVersion.cjs');
require('../VideoTransformation-79c46873.cjs');

var Cloudinary = /** @class */ (function () {
    function Cloudinary(cloudinaryConfig) {
        if (cloudinaryConfig) {
            this.cloudinaryConfig = cloudinaryConfig;
        }
    }
    Cloudinary.prototype.image = function (publicID) {
        return new assets_CloudinaryImage.CloudinaryImage(publicID, this.cloudinaryConfig.cloud, this.cloudinaryConfig.url);
    };
    Cloudinary.prototype.video = function (publicID) {
        return new assets_CloudinaryVideo.CloudinaryVideo(publicID, this.cloudinaryConfig.cloud, this.cloudinaryConfig.url);
    };
    Cloudinary.prototype.setConfig = function (cloudinaryConfig) {
        this.cloudinaryConfig = cloudinaryConfig;
        return this;
    };
    Cloudinary.prototype.getConfig = function () {
        return this.cloudinaryConfig;
    };
    Cloudinary.prototype.extendConfig = function () {
        // Future implementation
    };
    return Cloudinary;
}());

exports.Cloudinary = Cloudinary;
