"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.withPreResponseHandler = exports.unsafeEjectStreamScope = exports.toWebHandlerRuntime = exports.toWebHandlerLayerWith = exports.toWebHandlerLayer = exports.toWebHandler = exports.toHandled = exports.ejectDefaultScopeClose = exports.currentPreResponseHandlers = exports.appendPreResponseHandler = void 0;
var Context = _interopRequireWildcard(require("effect/Context"));
var Effect = _interopRequireWildcard(require("effect/Effect"));
var Exit = _interopRequireWildcard(require("effect/Exit"));
var Fiber = _interopRequireWildcard(require("effect/Fiber"));
var GlobalValue = _interopRequireWildcard(require("effect/GlobalValue"));
var Layer = _interopRequireWildcard(require("effect/Layer"));
var Option = _interopRequireWildcard(require("effect/Option"));
var Runtime = _interopRequireWildcard(require("effect/Runtime"));
var Scope = _interopRequireWildcard(require("effect/Scope"));
var Stream = _interopRequireWildcard(require("effect/Stream"));
var _Unify = require("effect/Unify");
var HttpBody = _interopRequireWildcard(require("./HttpBody.js"));
var ServerError = _interopRequireWildcard(require("./HttpServerError.js"));
var ServerRequest = _interopRequireWildcard(require("./HttpServerRequest.js"));
var ServerResponse = _interopRequireWildcard(require("./HttpServerResponse.js"));
var internal = _interopRequireWildcard(require("./internal/httpApp.js"));
var internalMiddleware = _interopRequireWildcard(require("./internal/httpMiddleware.js"));
function _interopRequireWildcard(e, t) { if ("function" == typeof WeakMap) var r = new WeakMap(), n = new WeakMap(); return (_interopRequireWildcard = function (e, t) { if (!t && e && e.__esModule) return e; var o, i, f = { __proto__: null, default: e }; if (null === e || "object" != typeof e && "function" != typeof e) return f; if (o = t ? n : r) { if (o.has(e)) return o.get(e); o.set(e, f); } for (const t in e) "default" !== t && {}.hasOwnProperty.call(e, t) && ((i = (o = Object.defineProperty) && Object.getOwnPropertyDescriptor(e, t)) && (i.get || i.set) ? o(f, t, i) : f[t] = e[t]); return f; })(e, t); }
/**
 * @since 1.0.0
 */

const handledSymbol = /*#__PURE__*/Symbol.for("@effect/platform/HttpApp/handled");
/**
 * @since 1.0.0
 * @category combinators
 */
const toHandled = (self, handleResponse, middleware) => {
  const responded = Effect.withFiberRuntime(fiber => Effect.flatMap(self, response => {
    const request = Context.unsafeGet(fiber.currentContext, ServerRequest.HttpServerRequest);
    const handler = fiber.getFiberRef(currentPreResponseHandlers);
    if (handler._tag === "None") {
      ;
      request[handledSymbol] = true;
      return Effect.as(handleResponse(request, response), response);
    }
    return Effect.tap(handler.value(request, response), response => {
      ;
      request[handledSymbol] = true;
      return handleResponse(request, response);
    });
  }));
  const withErrorHandling = Effect.catchAllCause(responded, cause => Effect.withFiberRuntime(fiber => Effect.flatMap(ServerError.causeResponse(cause), ([response, cause]) => {
    const request = Context.unsafeGet(fiber.currentContext, ServerRequest.HttpServerRequest);
    const handler = fiber.getFiberRef(currentPreResponseHandlers);
    if (handler._tag === "None") {
      ;
      request[handledSymbol] = true;
      return Effect.zipRight(handleResponse(request, response), Effect.failCause(cause));
    }
    return Effect.zipRight(Effect.tap(handler.value(request, response), response => {
      ;
      request[handledSymbol] = true;
      return handleResponse(request, response);
    }), Effect.failCause(cause));
  })));
  const withMiddleware = (0, _Unify.unify)(middleware === undefined ? internalMiddleware.tracer(withErrorHandling) : Effect.matchCauseEffect(middleware(internalMiddleware.tracer(withErrorHandling)), {
    onFailure: cause => Effect.withFiberRuntime(fiber => {
      const request = Context.unsafeGet(fiber.currentContext, ServerRequest.HttpServerRequest);
      if (handledSymbol in request) {
        return Effect.void;
      }
      return Effect.matchCauseEffect(ServerError.causeResponse(cause), {
        onFailure: _cause => handleResponse(request, ServerResponse.empty({
          status: 500
        })),
        onSuccess: ([response]) => handleResponse(request, response)
      });
    }),
    onSuccess: response => Effect.withFiberRuntime(fiber => {
      const request = Context.unsafeGet(fiber.currentContext, ServerRequest.HttpServerRequest);
      return handledSymbol in request ? Effect.void : handleResponse(request, response);
    })
  }));
  return Effect.uninterruptible(scoped(withMiddleware));
};
/**
 * If you want to finalize the http request scope elsewhere, you can use this
 * function to eject from the default scope closure.
 *
 * @since 1.0.0
 * @category Scope
 */
exports.toHandled = toHandled;
const ejectDefaultScopeClose = scope => {
  ejectedScopes.add(scope);
};
/**
 * @since 1.0.0
 * @category Scope
 */
exports.ejectDefaultScopeClose = ejectDefaultScopeClose;
const unsafeEjectStreamScope = response => {
  if (response.body._tag !== "Stream") {
    return response;
  }
  const fiber = Option.getOrThrow(Fiber.getCurrentFiber());
  const scope = Context.unsafeGet(fiber.currentContext, Scope.Scope);
  ejectDefaultScopeClose(scope);
  return ServerResponse.setBody(response, HttpBody.stream(Stream.ensuring(response.body.stream, Scope.close(scope, Exit.void)), response.body.contentType, response.body.contentLength));
};
exports.unsafeEjectStreamScope = unsafeEjectStreamScope;
const ejectedScopes = /*#__PURE__*/GlobalValue.globalValue("@effect/platform/HttpApp/ejectedScopes", () => new WeakSet());
const scoped = effect => Effect.flatMap(Scope.make(), scope => Effect.onExit(Scope.extend(effect, scope), exit => {
  if (ejectedScopes.has(scope)) {
    return Effect.void;
  }
  return Scope.close(scope, exit);
}));
/**
 * @since 1.0.0
 * @category fiber refs
 */
const currentPreResponseHandlers = exports.currentPreResponseHandlers = internal.currentPreResponseHandlers;
/**
 * @since 1.0.0
 * @category fiber refs
 */
const appendPreResponseHandler = exports.appendPreResponseHandler = internal.appendPreResponseHandler;
/**
 * @since 1.0.0
 * @category fiber refs
 */
const withPreResponseHandler = exports.withPreResponseHandler = internal.withPreResponseHandler;
/**
 * @since 1.0.0
 * @category conversions
 */
const toWebHandlerRuntime = runtime => {
  const httpRuntime = Runtime.make(runtime);
  const run = Runtime.runFork(httpRuntime);
  return (self, middleware) => {
    const resolveSymbol = Symbol.for("@effect/platform/HttpApp/resolve");
    const httpApp = toHandled(self, (request, response) => {
      response = unsafeEjectStreamScope(response);
      request[resolveSymbol](ServerResponse.toWeb(response, {
        withoutBody: request.method === "HEAD",
        runtime
      }));
      return Effect.void;
    }, middleware);
    return (request, context) => new Promise(resolve => {
      const contextMap = new Map(runtime.context.unsafeMap);
      if (Context.isContext(context)) {
        for (const [key, value] of context.unsafeMap) {
          contextMap.set(key, value);
        }
      }
      const httpServerRequest = ServerRequest.fromWeb(request);
      contextMap.set(ServerRequest.HttpServerRequest.key, httpServerRequest);
      httpServerRequest[resolveSymbol] = resolve;
      httpRuntime.context = Context.unsafeMake(contextMap);
      const fiber = run(httpApp);
      request.signal?.addEventListener("abort", () => {
        fiber.unsafeInterruptAsFork(ServerError.clientAbortFiberId);
      }, {
        once: true
      });
    });
  };
};
/**
 * @since 1.0.0
 * @category conversions
 */
exports.toWebHandlerRuntime = toWebHandlerRuntime;
const toWebHandler = exports.toWebHandler = /*#__PURE__*/toWebHandlerRuntime(Runtime.defaultRuntime);
/**
 * @since 1.0.0
 * @category conversions
 */
const toWebHandlerLayerWith = (layer, options) => {
  const scope = Effect.runSync(Scope.make());
  const dispose = () => Effect.runPromise(Scope.close(scope, Exit.void));
  let handlerCache;
  let handlerPromise;
  function handler(request, context) {
    if (handlerCache) {
      return handlerCache(request, context);
    }
    handlerPromise ??= Effect.gen(function* () {
      const runtime = yield* options.memoMap ? Layer.toRuntimeWithMemoMap(layer, options.memoMap) : Layer.toRuntime(layer);
      return handlerCache = toWebHandlerRuntime(runtime)(yield* options.toHandler(runtime), options.middleware);
    }).pipe(Scope.extend(scope), Effect.runPromise);
    return handlerPromise.then(f => f(request, context));
  }
  return {
    dispose,
    handler
  };
};
/**
 * @since 1.0.0
 * @category conversions
 */
exports.toWebHandlerLayerWith = toWebHandlerLayerWith;
const toWebHandlerLayer = (self, layer, options) => toWebHandlerLayerWith(layer, {
  ...options,
  toHandler: () => Effect.succeed(self)
});
exports.toWebHandlerLayer = toWebHandlerLayer;
//# sourceMappingURL=HttpApp.js.map