/**
 * @since 1.0.0
 */
import * as Context from "effect/Context";
import { type Pipeable } from "effect/Pipeable";
import type { Redacted } from "effect/Redacted";
import type { Covariant } from "effect/Types";
/**
 * @since 1.0.0
 * @category type ids
 */
export declare const TypeId: unique symbol;
/**
 * @since 1.0.0
 * @category type ids
 */
export type TypeId = typeof TypeId;
/**
 * @since 1.0.0
 * @category models
 */
export type HttpApiSecurity = Bearer | ApiKey | Basic;
/**
 * @since 1.0.0
 * @category models
 */
export declare namespace HttpApiSecurity {
    /**
     * @since 1.0.0
     * @category models
     */
    interface Proto<out A> extends Pipeable {
        readonly [TypeId]: {
            readonly _A: Covariant<A>;
        };
        readonly annotations: Context.Context<never>;
    }
    /**
     * @since 1.0.0
     * @category models
     */
    type Type<A extends HttpApiSecurity> = A extends Proto<infer Out> ? Out : never;
}
/**
 * @since 1.0.0
 * @category models
 */
export interface Bearer extends HttpApiSecurity.Proto<Redacted> {
    readonly _tag: "Bearer";
}
/**
 * @since 1.0.0
 * @category models
 */
export interface ApiKey extends HttpApiSecurity.Proto<Redacted> {
    readonly _tag: "ApiKey";
    readonly in: "header" | "query" | "cookie";
    readonly key: string;
}
/**
 * @since 1.0.0
 * @category models
 */
export interface Basic extends HttpApiSecurity.Proto<Credentials> {
    readonly _tag: "Basic";
}
/**
 * @since 1.0.0
 * @category models
 */
export interface Credentials {
    readonly username: string;
    readonly password: Redacted;
}
/**
 * Create an Bearer token security scheme.
 *
 * You can implement some api middleware for this security scheme using
 * `HttpApiBuilder.middlewareSecurity`.
 *
 * @since 1.0.0
 * @category constructors
 */
export declare const bearer: Bearer;
/**
 * Create an API key security scheme.
 *
 * You can implement some api middleware for this security scheme using
 * `HttpApiBuilder.middlewareSecurity`.
 *
 * To set the correct cookie in a handler, you can use
 * `HttpApiBuilder.securitySetCookie`.
 *
 * The default value for `in` is "header".
 *
 * @since 1.0.0
 * @category constructors
 */
export declare const apiKey: (options: {
    readonly key: string;
    readonly in?: "header" | "query" | "cookie" | undefined;
}) => ApiKey;
/**
 * @since 1.0.0
 * @category constructors
 */
export declare const basic: Basic;
/**
 * @since 1.0.0
 * @category annotations
 */
export declare const annotateContext: {
    /**
     * @since 1.0.0
     * @category annotations
     */
    <I>(context: Context.Context<I>): <A extends HttpApiSecurity>(self: A) => A;
    /**
     * @since 1.0.0
     * @category annotations
     */
    <A extends HttpApiSecurity, I>(self: A, context: Context.Context<I>): A;
};
/**
 * @since 1.0.0
 * @category annotations
 */
export declare const annotate: {
    /**
     * @since 1.0.0
     * @category annotations
     */
    <I, S>(tag: Context.Tag<I, S>, value: S): <A extends HttpApiSecurity>(self: A) => A;
    /**
     * @since 1.0.0
     * @category annotations
     */
    <A extends HttpApiSecurity, I, S>(self: A, tag: Context.Tag<I, S>, value: S): A;
};
//# sourceMappingURL=HttpApiSecurity.d.ts.map