/**
 * @since 1.0.0
 */
import * as HttpServerRequest from "@effect/platform/HttpServerRequest";
import * as HttpServerResponse from "@effect/platform/HttpServerResponse";
import * as Context from "effect/Context";
import * as Effect from "effect/Effect";
import * as Layer from "effect/Layer";
import * as Option from "effect/Option";
import * as Scope from "effect/Scope";
import type * as Types from "effect/Types";
import * as FindMyWay from "find-my-way-ts";
import type * as Etag from "./Etag.js";
import type { FileSystem } from "./FileSystem.js";
import type * as HttpApi from "./HttpApi.js";
import type * as HttpApiGroup from "./HttpApiGroup.js";
import type * as HttpMethod from "./HttpMethod.js";
import type { HttpPlatform } from "./HttpPlatform.js";
import { RouteContext } from "./HttpRouter.js";
import * as HttpServer from "./HttpServer.js";
import * as HttpServerError from "./HttpServerError.js";
import type { Path } from "./Path.js";
/**
 * @since 1.0.0
 * @category Re-exports
 */
export * as FindMyWay from "find-my-way-ts";
/**
 * @since 1.0.0
 * @category HttpRouter
 */
export declare const TypeId: unique symbol;
/**
 * @since 1.0.0
 * @category HttpRouter
 */
export type TypeId = typeof TypeId;
/**
 * @since 1.0.0
 * @category HttpRouter
 */
export interface HttpRouter {
    readonly [TypeId]: TypeId;
    readonly prefixed: (prefix: string) => HttpRouter;
    readonly add: <E, R>(method: "*" | "GET" | "POST" | "PUT" | "PATCH" | "DELETE" | "OPTIONS", path: PathInput, handler: Effect.Effect<HttpServerResponse.HttpServerResponse, E, R> | ((request: HttpServerRequest.HttpServerRequest) => Effect.Effect<HttpServerResponse.HttpServerResponse, E, R>), options?: {
        readonly uninterruptible?: boolean | undefined;
    } | undefined) => Effect.Effect<void, never, Request.From<"Requires", Exclude<R, Provided>> | Request.From<"Error", E>>;
    readonly addAll: <const Routes extends ReadonlyArray<Route<any, any>>>(routes: Routes) => Effect.Effect<void, never, Request.From<"Requires", Exclude<Route.Context<Routes[number]>, Provided>> | Request.From<"Error", Route.Error<Routes[number]>>>;
    readonly addGlobalMiddleware: <E, R>(middleware: ((effect: Effect.Effect<HttpServerResponse.HttpServerResponse, unhandled>) => Effect.Effect<HttpServerResponse.HttpServerResponse, E, R>) & (unhandled extends E ? unknown : "You cannot handle any errors")) => Effect.Effect<void, never, Request.From<"GlobalRequires", Exclude<R, GlobalProvided>> | Request.From<"GlobalError", Exclude<E, unhandled>>>;
    readonly asHttpEffect: () => Effect.Effect<HttpServerResponse.HttpServerResponse, unknown, HttpServerRequest.HttpServerRequest | Scope.Scope>;
}
/**
 * @since 1.0.0
 * @category HttpRouter
 */
export declare const HttpRouter: Context.Tag<HttpRouter, HttpRouter>;
/**
 * @since 1.0.0
 * @category HttpRouter
 */
export declare const make: Effect.Effect<HttpRouter, never, never>;
declare const RouterConfig_base: Context.ReferenceClass<RouterConfig, "@effect/platform/HttpLayerRouter/RouterConfig", Partial<FindMyWay.RouterConfig>>;
/**
 * @since 1.0.0
 * @category Configuration
 */
export declare class RouterConfig extends RouterConfig_base {
}
export { 
/**
 * @since 1.0.0
 * @category Route context
 */
params, 
/**
 * @since 1.0.0
 * @category Route context
 */
RouteContext, 
/**
 * @since 1.0.0
 * @category Route context
 */
schemaJson, 
/**
 * @since 1.0.0
 * @category Route context
 */
schemaNoBody, 
/**
 * @since 1.0.0
 * @category Route context
 */
schemaParams, 
/**
 * @since 1.0.0
 * @category Route context
 */
schemaPathParams } from "./HttpRouter.js";
/**
 * A helper function that is the equivalent of:
 *
 * ```ts
 * import * as HttpLayerRouter from "@effect/platform/HttpLayerRouter"
 * import * as Effect from "effect/Effect"
 * import * as Layer from "effect/Layer"
 *
 * const MyRoute = Layer.scopedDiscard(Effect.gen(function*() {
 *   const router = yield* HttpLayerRouter.HttpRouter
 *
 *   // then use `yield* router.add(...)` to add a route
 * }))
 * ```
 *
 * @since 1.0.0
 * @category HttpRouter
 */
export declare const use: <A, E, R>(f: (router: HttpRouter) => Effect.Effect<A, E, R>) => Layer.Layer<never, E, HttpRouter | Exclude<R, Scope.Scope>>;
/**
 * Create a layer that adds a single route to the HTTP router.
 *
 * ```ts
 * import * as HttpLayerRouter from "@effect/platform/HttpLayerRouter"
 * import * as HttpServerResponse from "@effect/platform/HttpServerResponse"
 *
 * const Route = HttpLayerRouter.add("GET", "/hello", HttpServerResponse.text("Hello, World!"))
 * ```
 *
 * @since 1.0.0
 * @category HttpRouter
 */
export declare const add: <E, R>(method: "*" | "GET" | "POST" | "PUT" | "PATCH" | "DELETE" | "OPTIONS", path: PathInput, handler: Effect.Effect<HttpServerResponse.HttpServerResponse, E, R> | ((request: HttpServerRequest.HttpServerRequest) => Effect.Effect<HttpServerResponse.HttpServerResponse, E, R>), options?: {
    readonly uninterruptible?: boolean | undefined;
}) => Layer.Layer<never, never, HttpRouter | Request.From<"Requires", Exclude<R, Provided>> | Request.From<"Error", E>>;
/**
 * Create a layer that adds multiple routes to the HTTP router.
 *
 * ```ts
 * import * as HttpLayerRouter from "@effect/platform/HttpLayerRouter"
 * import * as HttpServerResponse from "@effect/platform/HttpServerResponse"
 *
 * const Routes = HttpLayerRouter.addAll([
 *   HttpLayerRouter.route("GET", "/hello", HttpServerResponse.text("Hello, World!"))
 * ])
 * ```
 *
 * @since 1.0.0
 * @category HttpRouter
 */
export declare const addAll: <Routes extends ReadonlyArray<Route<any, any>>, EX = never, RX = never>(routes: Routes | Effect.Effect<Routes, EX, RX>, options?: {
    readonly prefix?: string | undefined;
}) => Layer.Layer<never, EX, HttpRouter | Exclude<RX, Scope.Scope> | Request.From<"Requires", Exclude<Route.Context<Routes[number]>, Provided>> | Request.From<"Error", Route.Error<Routes[number]>>>;
/**
 * @since 1.0.0
 * @category HttpRouter
 */
export declare const layer: Layer.Layer<HttpRouter>;
/**
 * @since 1.0.0
 * @category HttpRouter
 */
export declare const toHttpEffect: <A, E, R>(appLayer: Layer.Layer<A, E, R>) => Effect.Effect<Effect.Effect<HttpServerResponse.HttpServerResponse, Request.Only<"Error", R> | Request.Only<"GlobalRequires", R> | HttpServerError.RouteNotFound, Scope.Scope | HttpServerRequest.HttpServerRequest | Request.Only<"Requires", R> | Request.Only<"GlobalRequires", R>>, Request.Without<E>, Exclude<Request.Without<R>, HttpRouter> | Scope.Scope>;
/**
 * @since 1.0.0
 * @category Route
 */
export declare const RouteTypeId: unique symbol;
/**
 * @since 1.0.0
 * @category Route
 */
export type RouteTypeId = typeof RouteTypeId;
/**
 * @since 1.0.0
 * @category Route
 */
export interface Route<E = never, R = never> {
    readonly [RouteTypeId]: RouteTypeId;
    readonly method: HttpMethod.HttpMethod | "*";
    readonly path: PathInput;
    readonly handler: Effect.Effect<HttpServerResponse.HttpServerResponse, E, R>;
    readonly uninterruptible: boolean;
    readonly prefix: Option.Option<string>;
}
/**
 * @since 1.0.0
 * @category Route
 */
export declare namespace Route {
    /**
     * @since 1.0.0
     * @category Route
     */
    type Error<R extends Route<any, any>> = R extends Route<infer E, infer _R> ? E : never;
    /**
     * @since 1.0.0
     * @category Route
     */
    type Context<T extends Route<any, any>> = T extends Route<infer _E, infer R> ? R : never;
}
/**
 * @since 1.0.0
 * @category Route
 */
export declare const route: <E, R>(method: "*" | "GET" | "POST" | "PUT" | "PATCH" | "DELETE" | "OPTIONS", path: PathInput, handler: Effect.Effect<HttpServerResponse.HttpServerResponse, E, R> | ((request: HttpServerRequest.HttpServerRequest) => Effect.Effect<HttpServerResponse.HttpServerResponse, E, R>), options?: {
    readonly uninterruptible?: boolean | undefined;
}) => Route<E, Exclude<R, Provided>>;
/**
 * @since 1.0.0
 * @category PathInput
 */
export type PathInput = `/${string}` | "*";
/**
 * @since 1.0.0
 * @category PathInput
 */
export declare const prefixPath: {
    /**
     * @since 1.0.0
     * @category PathInput
     */
    (prefix: string): (self: string) => string;
    /**
     * @since 1.0.0
     * @category PathInput
     */
    (self: string, prefix: string): string;
};
/**
 * @since 1.0.0
 * @category Route
 */
export declare const prefixRoute: {
    /**
     * @since 1.0.0
     * @category Route
     */
    (prefix: string): <E, R>(self: Route<E, R>) => Route<E, R>;
    /**
     * @since 1.0.0
     * @category Route
     */
    <E, R>(self: Route<E, R>, prefix: string): Route<E, R>;
};
/**
 * Represents a request-level dependency, that needs to be provided by
 * middleware.
 *
 * @since 1.0.0
 * @category Request types
 */
export interface Request<Kind extends string, T> {
    readonly _: unique symbol;
    readonly kind: Kind;
    readonly type: T;
}
/**
 * @since 1.0.0
 * @category Request types
 */
export declare namespace Request {
    /**
     * @since 1.0.0
     * @category Request types
     */
    type From<Kind extends string, R> = R extends infer T ? Request<Kind, T> : never;
    /**
     * @since 1.0.0
     * @category Request types
     */
    type Only<Kind extends string, A> = A extends Request<Kind, infer T> ? T : never;
    /**
     * @since 1.0.0
     * @category Request types
     */
    type Without<A> = A extends Request<infer _Kind, infer _> ? never : A;
}
/**
 * Services provided by the HTTP router, which are available in the
 * request context.
 *
 * @since 1.0.0
 * @category Request types
 */
export type Provided = HttpServerRequest.HttpServerRequest | Scope.Scope | HttpServerRequest.ParsedSearchParams | RouteContext;
/**
 * Services provided to global middleware.
 *
 * @since 1.0.0
 * @category Request types
 */
export type GlobalProvided = HttpServerRequest.HttpServerRequest | Scope.Scope;
/**
 * @since 1.0.0
 * @category Middleware
 */
export declare const MiddlewareTypeId: unique symbol;
/**
 * @since 1.0.0
 * @category Middleware
 */
export type MiddlewareTypeId = typeof MiddlewareTypeId;
/**
 * A pseudo-error type that represents an error that should be not handled by
 * the middleware.
 *
 * @since 1.0.0
 * @category Middleware
 */
export interface unhandled {
    readonly _: unique symbol;
}
/**
 * @since 1.0.0
 * @category Middleware
 */
export interface Middleware<Config extends {
    provides: any;
    handles: any;
    error: any;
    requires: any;
    layerError: any;
    layerRequires: any;
}> {
    readonly [MiddlewareTypeId]: Config;
    readonly layer: [Config["requires"]] extends [never] ? Layer.Layer<Request.From<"Requires", Config["provides"]>, Config["layerError"], Config["layerRequires"] | Request.From<"Requires", Config["requires"]> | Request.From<"Error", Config["error"]>> : "Need to .combine(middleware) that satisfy the missing request dependencies";
    readonly combine: <Config2 extends {
        provides: any;
        handles: any;
        error: any;
        requires: any;
        layerError: any;
        layerRequires: any;
    }>(other: Middleware<Config2>) => Middleware<{
        provides: Config2["provides"] | Config["provides"];
        handles: Config2["handles"] | Config["handles"];
        error: Config2["error"] | Exclude<Config["error"], Config2["handles"]>;
        requires: Exclude<Config["requires"], Config2["provides"]> | Config2["requires"];
        layerError: Config["layerError"] | Config2["layerError"];
        layerRequires: Config["layerRequires"] | Config2["layerRequires"];
    }>;
}
/**
 * Create a middleware layer that can be used to modify requests and responses.
 *
 * By default, the middleware only affects the routes that it is provided to.
 *
 * If you want to create a middleware that applies globally to all routes, pass
 * the `global` option as `true`.
 *
 * ```ts
 * import * as HttpLayerRouter from "@effect/platform/HttpLayerRouter"
 * import * as HttpMiddleware from "@effect/platform/HttpMiddleware"
 * import * as HttpServerResponse from "@effect/platform/HttpServerResponse"
 * import * as Context from "effect/Context"
 * import * as Effect from "effect/Effect"
 * import * as Layer from "effect/Layer"
 *
 * // Here we are defining a CORS middleware
 * const CorsMiddleware = HttpLayerRouter.middleware(HttpMiddleware.cors()).layer
 * // You can also use HttpLayerRouter.cors() to create a CORS middleware
 *
 * class CurrentSession extends Context.Tag("CurrentSession")<CurrentSession, {
 *   readonly token: string
 * }>() {}
 *
 * // You can create middleware that provides a service to the HTTP requests.
 * const SessionMiddleware = HttpLayerRouter.middleware<{
 *   provides: CurrentSession
 * }>()(
 *   Effect.gen(function*() {
 *     yield* Effect.log("SessionMiddleware initialized")
 *
 *     return (httpEffect) =>
 *       Effect.provideService(httpEffect, CurrentSession, {
 *         token: "dummy-token"
 *       })
 *   })
 * ).layer
 *
 * Effect.gen(function*() {
 *   const router = yield* HttpLayerRouter.HttpRouter
 *   yield* router.add(
 *     "GET",
 *     "/hello",
 *     Effect.gen(function*() {
 *       // Requests can now access the current session
 *       const session = yield* CurrentSession
 *       return HttpServerResponse.text(`Hello, World! Your token is ${session.token}`)
 *     })
 *   )
 * }).pipe(
 *   Layer.effectDiscard,
 *   // Provide the SessionMiddleware & CorsMiddleware to some routes
 *   Layer.provide([SessionMiddleware, CorsMiddleware])
 * )
 * ```
 *
 * @since 1.0.0
 * @category Middleware
 */
export declare const middleware: middleware.Make<never, never> & (<Config extends {
    provides?: any;
    handles?: any;
} = {}>() => middleware.Make<Config extends {
    provides: infer R;
} ? R : never, Config extends {
    handles: infer E;
} ? E : never>);
/**
 * @since 1.0.0
 * @category Middleware
 */
export declare namespace middleware {
    /**
     * @since 1.0.0
     * @category Middleware
     */
    type Make<Provides = never, Handles = never> = {
        <E, R, EX, RX, const Global extends boolean = false>(middleware: Effect.Effect<(effect: Effect.Effect<HttpServerResponse.HttpServerResponse, Types.NoInfer<Handles | unhandled>, Types.NoInfer<Provides>>) => Effect.Effect<HttpServerResponse.HttpServerResponse, E, R> & (unhandled extends E ? unknown : "You must only handle the configured errors"), EX, RX>, options?: {
            readonly global?: Global | undefined;
        }): Global extends true ? Layer.Layer<Request.From<"Requires", Provides> | Request.From<"Error", Handles> | Request.From<"GlobalRequires", Provides> | Request.From<"GlobalError", Handles>, EX, HttpRouter | Exclude<RX, Scope.Scope> | Request.From<"GlobalRequires", Exclude<R, GlobalProvided>> | Request.From<"GlobalError", Exclude<E, unhandled>>> : Middleware<{
            provides: Provides;
            handles: Handles;
            error: Exclude<E, unhandled>;
            requires: Exclude<R, Provided>;
            layerError: EX;
            layerRequires: Exclude<RX, Scope.Scope>;
        }>;
        <E, R, const Global extends boolean = false>(middleware: ((effect: Effect.Effect<HttpServerResponse.HttpServerResponse, Types.NoInfer<Handles | unhandled>, Types.NoInfer<Provides>>) => Effect.Effect<HttpServerResponse.HttpServerResponse, E, R>) & (unhandled extends E ? unknown : "You must only handle the configured errors"), options?: {
            readonly global?: Global | undefined;
        }): Global extends true ? Layer.Layer<Request.From<"Requires", Provides> | Request.From<"Error", Handles> | Request.From<"GlobalRequires", Provides> | Request.From<"GlobalError", Handles>, never, HttpRouter | Request.From<"GlobalRequires", Exclude<R, GlobalProvided>> | Request.From<"GlobalError", Exclude<E, unhandled>>> : Middleware<{
            provides: Provides;
            handles: Handles;
            error: Exclude<E, unhandled>;
            requires: Exclude<R, Provided>;
            layerError: never;
            layerRequires: never;
        }>;
    };
    /**
     * @since 1.0.0
     * @category Middleware
     */
    type Fn = (effect: Effect.Effect<HttpServerResponse.HttpServerResponse>) => Effect.Effect<HttpServerResponse.HttpServerResponse>;
}
/**
 * A middleware that applies CORS headers to the HTTP response.
 *
 * @since 1.0.0
 * @category Middleware
 */
export declare const cors: (options?: {
    readonly allowedOrigins?: ReadonlyArray<string> | undefined;
    readonly allowedMethods?: ReadonlyArray<string> | undefined;
    readonly allowedHeaders?: ReadonlyArray<string> | undefined;
    readonly exposedHeaders?: ReadonlyArray<string> | undefined;
    readonly maxAge?: number | undefined;
    readonly credentials?: boolean | undefined;
} | undefined) => Layer.Layer<never, never, HttpRouter>;
/**
 * A middleware that disables the logger for some routes.
 *
 * ```ts
 * import * as HttpLayerRouter from "@effect/platform/HttpLayerRouter"
 * import * as HttpServerResponse from "@effect/platform/HttpServerResponse"
 * import * as Layer from "effect/Layer"
 *
 * const Route = HttpLayerRouter.add("GET", "/hello", HttpServerResponse.text("Hello, World!")).pipe(
 *   // disable the logger for this route
 *   Layer.provide(HttpLayerRouter.disableLogger)
 * )
 * ```
 *
 * @since 1.0.0
 * @category Middleware
 */
export declare const disableLogger: Layer.Layer<never>;
/**
 * ```ts
 * import * as NodeHttpServer from "@effect/platform-node/NodeHttpServer"
 * import * as NodeRuntime from "@effect/platform-node/NodeRuntime"
 * import * as HttpApi from "@effect/platform/HttpApi"
 * import * as HttpApiBuilder from "@effect/platform/HttpApiBuilder"
 * import * as HttpApiEndpoint from "@effect/platform/HttpApiEndpoint"
 * import * as HttpApiGroup from "@effect/platform/HttpApiGroup"
 * import * as HttpApiScalar from "@effect/platform/HttpApiScalar"
 * import * as HttpLayerRouter from "@effect/platform/HttpLayerRouter"
 * import * as HttpMiddleware from "@effect/platform/HttpMiddleware"
 * import * as Effect from "effect/Effect"
 * import * as Layer from "effect/Layer"
 * import { createServer } from "http"
 *
 * // First, we define our HttpApi
 * class MyApi extends HttpApi.make("api").add(
 *   HttpApiGroup.make("users").add(
 *     HttpApiEndpoint.get("me", "/me")
 *   ).prefix("/users")
 * ) {}
 *
 * // Implement the handlers for the API
 * const UsersApiLayer = HttpApiBuilder.group(MyApi, "users", (handers) => handers.handle("me", () => Effect.void))
 *
 * // Use `HttpLayerRouter.addHttpApi` to register the API with the router
 * const HttpApiRoutes = HttpLayerRouter.addHttpApi(MyApi, {
 *   openapiPath: "/docs/openapi.json"
 * }).pipe(
 *   // Provide the api handlers layer
 *   Layer.provide(UsersApiLayer)
 * )
 *
 * // Create a /docs route for the API documentation
 * const DocsRoute = HttpApiScalar.layerHttpLayerRouter({
 *   api: MyApi,
 *   path: "/docs"
 * })
 *
 * const CorsMiddleware = HttpLayerRouter.middleware(HttpMiddleware.cors())
 * // You can also use HttpLayerRouter.cors() to create a CORS middleware
 *
 * // Finally, we merge all routes and serve them using the Node HTTP server
 * const AllRoutes = Layer.mergeAll(
 *   HttpApiRoutes,
 *   DocsRoute
 * ).pipe(
 *   Layer.provide(CorsMiddleware.layer)
 * )
 *
 * HttpLayerRouter.serve(AllRoutes).pipe(
 *   Layer.provide(NodeHttpServer.layer(createServer, { port: 3000 })),
 *   Layer.launch,
 *   NodeRuntime.runMain
 * )
 * ```
 *
 * @since 1.0.0
 * @category HttpApi
 */
export declare const addHttpApi: <Id extends string, Groups extends HttpApiGroup.HttpApiGroup.Any, E, R>(api: HttpApi.HttpApi<Id, Groups, E, R>, options?: {
    readonly openapiPath?: `/${string}` | undefined;
}) => Layer.Layer<never, never, Etag.Generator | HttpRouter | FileSystem | HttpPlatform | Path | R | HttpApiGroup.HttpApiGroup.ToService<Id, Groups> | HttpApiGroup.HttpApiGroup.ErrorContext<Groups>>;
/**
 * Serves the provided application layer as an HTTP server.
 *
 * @since 1.0.0
 * @category Server
 */
export declare const serve: <A, E, R, HE, HR = Request.Only<"Requires", R> | Request.Only<"GlobalRequires", R>>(appLayer: Layer.Layer<A, E, R>, options?: {
    readonly routerConfig?: Partial<FindMyWay.RouterConfig> | undefined;
    readonly disableLogger?: boolean | undefined;
    readonly disableListenLog?: boolean;
    /**
     * Middleware to apply to the HTTP server.
     *
     * NOTE: This middleware is applied to the entire HTTP server chain,
     * including the sending of the response. This means that modifications
     * to the response **WILL NOT** be reflected in the final response sent to the
     * client.
     *
     * Use HttpLayerRouter.middleware to create middleware that can modify the
     * response.
     */
    readonly middleware?: (effect: Effect.Effect<HttpServerResponse.HttpServerResponse, Request.Only<"Error", R> | Request.Only<"GlobalError", R> | HttpServerError.RouteNotFound, Scope.Scope | HttpServerRequest.HttpServerRequest | Request.Only<"Requires", R> | Request.Only<"GlobalRequires", R>>) => Effect.Effect<HttpServerResponse.HttpServerResponse, HE, HR>;
}) => Layer.Layer<never, Request.Without<E>, HttpServer.HttpServer | Exclude<Request.Without<R> | Exclude<HR, GlobalProvided>, HttpRouter>>;
/**
 * @since 1.0.0
 * @category Server
 */
export declare const toWebHandler: <A, E, R extends HttpRouter | Request<"Requires", any> | Request<"GlobalRequires", any> | Request<"Error", any> | Request<"GlobalError", any>, HE, HR = Request.Only<"Requires", R> | Request.Only<"GlobalRequires", R>>(appLayer: Layer.Layer<A, E, R>, options?: {
    readonly memoMap?: Layer.MemoMap | undefined;
    readonly routerConfig?: Partial<FindMyWay.RouterConfig> | undefined;
    readonly disableLogger?: boolean | undefined;
    /**
     * Middleware to apply to the HTTP server.
     *
     * NOTE: This middleware is applied to the entire HTTP server chain,
     * including the sending of the response. This means that modifications
     * to the response **WILL NOT** be reflected in the final response sent to the
     * client.
     *
     * Use HttpLayerRouter.middleware to create middleware that can modify the
     * response.
     */
    readonly middleware?: (effect: Effect.Effect<HttpServerResponse.HttpServerResponse, Request.Only<"Error", R> | Request.Only<"GlobalError", R> | HttpServerError.RouteNotFound, Scope.Scope | HttpServerRequest.HttpServerRequest | Request.Only<"Requires", R> | Request.Only<"GlobalRequires", R>>) => Effect.Effect<HttpServerResponse.HttpServerResponse, HE, HR>;
}) => {
    readonly handler: [HR] extends [never] ? ((request: globalThis.Request, context?: Context.Context<never> | undefined) => Promise<Response>) : ((request: globalThis.Request, context: Context.Context<HR>) => Promise<Response>);
    readonly dispose: () => Promise<void>;
};
//# sourceMappingURL=HttpLayerRouter.d.ts.map