import * as internal from "./internal/httpClientRequest.js";
/**
 * @since 1.0.0
 * @category type ids
 */
export const TypeId = /*#__PURE__*/Symbol.for("@effect/platform/HttpClientRequest");
/**
 * @since 1.0.0
 * @category constructors
 */
export const make = internal.make;
/**
 * @since 1.0.0
 * @category constructors
 */
export const get = internal.get;
/**
 * @since 1.0.0
 * @category constructors
 */
export const post = internal.post;
/**
 * @since 1.0.0
 * @category constructors
 */
export const patch = internal.patch;
/**
 * @since 1.0.0
 * @category constructors
 */
export const put = internal.put;
/**
 * @since 1.0.0
 * @category constructors
 */
export const del = internal.del;
/**
 * @since 1.0.0
 * @category constructors
 */
export const head = internal.head;
/**
 * @since 1.0.0
 * @category constructors
 */
export const options = internal.options;
/**
 * @since 1.0.0
 * @category combinators
 */
export const modify = internal.modify;
/**
 * @since 1.0.0
 * @category combinators
 */
export const setMethod = internal.setMethod;
/**
 * @since 1.0.0
 * @category combinators
 */
export const setHeader = internal.setHeader;
/**
 * @since 1.0.0
 * @category combinators
 */
export const setHeaders = internal.setHeaders;
/**
 * @since 1.0.0
 * @category combinators
 */
export const basicAuth = internal.basicAuth;
/**
 * @since 1.0.0
 * @category combinators
 */
export const bearerToken = internal.bearerToken;
/**
 * @since 1.0.0
 * @category combinators
 */
export const accept = internal.accept;
/**
 * @since 1.0.0
 * @category combinators
 */
export const acceptJson = internal.acceptJson;
/**
 * @since 1.0.0
 * @category combinators
 */
export const setUrl = internal.setUrl;
/**
 * @since 1.0.0
 * @category combinators
 */
export const prependUrl = internal.prependUrl;
/**
 * @since 1.0.0
 * @category combinators
 */
export const appendUrl = internal.appendUrl;
/**
 * @since 1.0.0
 * @category combinators
 */
export const updateUrl = internal.updateUrl;
/**
 * @since 1.0.0
 * @category combinators
 */
export const setUrlParam = internal.setUrlParam;
/**
 * @since 1.0.0
 * @category combinators
 */
export const setUrlParams = internal.setUrlParams;
/**
 * @since 1.0.0
 * @category combinators
 */
export const appendUrlParam = internal.appendUrlParam;
/**
 * @since 1.0.0
 * @category combinators
 */
export const appendUrlParams = internal.appendUrlParams;
/**
 * @since 1.0.0
 * @category combinators
 */
export const setHash = internal.setHash;
/**
 * @since 1.0.0
 * @category combinators
 */
export const removeHash = internal.removeHash;
/**
 * @since 1.0.0
 * @category combinators
 */
export const toUrl = internal.toUrl;
/**
 * @since 1.0.0
 * @category combinators
 */
export const setBody = internal.setBody;
/**
 * @since 1.0.0
 * @category combinators
 */
export const bodyUint8Array = internal.bodyUint8Array;
/**
 * @since 1.0.0
 * @category combinators
 */
export const bodyText = internal.bodyText;
/**
 * @since 1.0.0
 * @category combinators
 */
export const bodyJson = internal.bodyJson;
/**
 * @since 1.0.0
 * @category combinators
 */
export const bodyUnsafeJson = internal.bodyUnsafeJson;
/**
 * @since 1.0.0
 * @category combinators
 */
export const schemaBodyJson = internal.schemaBodyJson;
/**
 * @since 1.0.0
 * @category combinators
 */
export const bodyUrlParams = internal.bodyUrlParams;
/**
 * @since 1.0.0
 * @category combinators
 */
export const bodyFormData = internal.bodyFormData;
/**
 * @since 1.0.0
 * @category combinators
 */
export const bodyFormDataRecord = internal.bodyFormDataRecord;
/**
 * @since 1.0.0
 * @category combinators
 */
export const bodyStream = internal.bodyStream;
/**
 * @since 1.0.0
 * @category combinators
 */
export const bodyFile = internal.bodyFile;
/**
 * @since 1.0.0
 * @category combinators
 */
export const bodyFileWeb = internal.bodyFileWeb;
//# sourceMappingURL=HttpClientRequest.js.map