(function (global, factory) {
    typeof exports === 'object' && typeof module !== 'undefined' ? factory(exports, require('react')) :
    typeof define === 'function' && define.amd ? define(['exports', 'react'], factory) :
    (global = typeof globalThis !== 'undefined' ? globalThis : global || self, factory(global.ReactHookFormDevTools = {}, global.React));
})(this, (function (exports, React) { 'use strict';

    function _interopDefaultLegacy (e) { return e && typeof e === 'object' && 'default' in e ? e : { 'default': e }; }

    function _interopNamespace(e) {
        if (e && e.__esModule) return e;
        var n = Object.create(null);
        if (e) {
            Object.keys(e).forEach(function (k) {
                if (k !== 'default') {
                    var d = Object.getOwnPropertyDescriptor(e, k);
                    Object.defineProperty(n, k, d.get ? d : {
                        enumerable: true,
                        get: function () { return e[k]; }
                    });
                }
            });
        }
        n["default"] = e;
        return Object.freeze(n);
    }

    var React__namespace$1 = /*#__PURE__*/_interopNamespace(React);
    var React__default = /*#__PURE__*/_interopDefaultLegacy(React);

    var t=function(){var e={name:"__LSM__",middleWares:[],storageType:{},persist:""},t={};try{e.storageType="undefined"!=typeof sessionStorage?window.sessionStorage:{};}catch(e){}return {updateStore:function(n){try{t=JSON.parse(e.storageType.getItem(e.name)||"")||n;}catch(e){t=n;}},saveStore:function(){e.storageType.setItem(e.name,JSON.stringify(t));},get state(){return t},set state(e){t=e;},get options(){return e},set options(t){e=t;}}}(),n=React__namespace$1.createContext(void 0),o=function(o){var r=o.children,s=React__namespace$1.useState(t.state),a=s[0],i=s[1];return React__namespace$1.useEffect(function(){"beforeUnload"===t.options.persist&&(window.onbeforeunload=function(){return t.saveStore()},t.options.storageType.removeItem(t.options.name));},[]),React__namespace$1.createElement(n.Provider,{value:{state:a,setState:i}},r)};function r(){return r=Object.assign||function(e){for(var t=1;t<arguments.length;t++){var n=arguments[t];for(var o in n)Object.prototype.hasOwnProperty.call(n,o)&&(e[o]=n[o]);}return e},r.apply(this,arguments)}function s(e,n){n&&(t.options=r({},t.options,n)),"undefined"!=typeof window&&(window.__LSM_NAME__=t.options.name,window.__LSM_RESET__=function(){return t.options.storageType.removeItem(t.options.name)}),t.updateStore(e);}function a(o){var r=React__namespace$1.useContext(n),s=r.state,a=r.setState,i=React__namespace$1.useRef(Object.entries(o||{}).reduce(function(e,n){var o;return Object.assign({},e,((o={})[n[0]]=function(e,n){return function(o){(window.__LSM_NAME__=n.name),t.state=n(t.state,o),t.options.middleWares&&(t.state=t.options.middleWares.reduce(function(e,t){return t(e,n.name,o)||e},t.state)),e(t.state),"beforeUnload"!==t.options.persist&&t.saveStore();}}(a,n[1]),o))},{}));return {actions:i.current,state:s}}

    var isCheckBoxInput = (element) => element.type === 'checkbox';

    var isDateObject = (value) => value instanceof Date;

    var isNullOrUndefined = (value) => value == null;

    const isObjectType = (value) => typeof value === 'object';
    var isObject$1 = (value) => !isNullOrUndefined(value) &&
        !Array.isArray(value) &&
        isObjectType(value) &&
        !isDateObject(value);

    var getEventValue = (event) => isObject$1(event) && event.target
        ? isCheckBoxInput(event.target)
            ? event.target.checked
            : event.target.value
        : event;

    var getNodeParentName = (name) => name.substring(0, name.search(/\.\d+(\.|$)/)) || name;

    var isNameInFieldArray = (names, name) => names.has(getNodeParentName(name));

    var isPlainObject = (tempObject) => {
        const prototypeCopy = tempObject.constructor && tempObject.constructor.prototype;
        return (isObject$1(prototypeCopy) && prototypeCopy.hasOwnProperty('isPrototypeOf'));
    };

    var isWeb = typeof window !== 'undefined' &&
        typeof window.HTMLElement !== 'undefined' &&
        typeof document !== 'undefined';

    function cloneObject(data) {
        let copy;
        const isArray = Array.isArray(data);
        const isFileListInstance = typeof FileList !== 'undefined' ? data instanceof FileList : false;
        if (data instanceof Date) {
            copy = new Date(data);
        }
        else if (data instanceof Set) {
            copy = new Set(data);
        }
        else if (!(isWeb && (data instanceof Blob || isFileListInstance)) &&
            (isArray || isObject$1(data))) {
            copy = isArray ? [] : {};
            if (!isArray && !isPlainObject(data)) {
                copy = data;
            }
            else {
                for (const key in data) {
                    if (data.hasOwnProperty(key)) {
                        copy[key] = cloneObject(data[key]);
                    }
                }
            }
        }
        else {
            return data;
        }
        return copy;
    }

    var compact = (value) => Array.isArray(value) ? value.filter(Boolean) : [];

    var isUndefined$2 = (val) => val === undefined;

    var get$1 = (object, path, defaultValue) => {
        if (!path || !isObject$1(object)) {
            return defaultValue;
        }
        const result = compact(path.split(/[,[\].]+?/)).reduce((result, key) => isNullOrUndefined(result) ? result : result[key], object);
        return isUndefined$2(result) || result === object
            ? isUndefined$2(object[path])
                ? defaultValue
                : object[path]
            : result;
    };

    var isBoolean = (value) => typeof value === 'boolean';

    var isKey$1 = (value) => /^\w*$/.test(value);

    var stringToPath$1 = (input) => compact(input.replace(/["|']|\]/g, '').split(/\.|\[/));

    var set = (object, path, value) => {
        let index = -1;
        const tempPath = isKey$1(path) ? [path] : stringToPath$1(path);
        const length = tempPath.length;
        const lastIndex = length - 1;
        while (++index < length) {
            const key = tempPath[index];
            let newValue = value;
            if (index !== lastIndex) {
                const objValue = object[key];
                newValue =
                    isObject$1(objValue) || Array.isArray(objValue)
                        ? objValue
                        : !isNaN(+tempPath[index + 1])
                            ? []
                            : {};
            }
            if (key === '__proto__' || key === 'constructor' || key === 'prototype') {
                return;
            }
            object[key] = newValue;
            object = object[key];
        }
    };

    const EVENTS = {
        BLUR: 'blur',
        FOCUS_OUT: 'focusout',
        CHANGE: 'change',
    };
    const VALIDATION_MODE = {
        onBlur: 'onBlur',
        onChange: 'onChange',
        onSubmit: 'onSubmit',
        onTouched: 'onTouched',
        all: 'all',
    };
    const INPUT_VALIDATION_RULES = {
        max: 'max',
        min: 'min',
        maxLength: 'maxLength',
        minLength: 'minLength',
        pattern: 'pattern',
        required: 'required',
        validate: 'validate',
    };

    const HookFormContext = React__default["default"].createContext(null);
    /**
     * This custom hook allows you to access the form context. useFormContext is intended to be used in deeply nested structures, where it would become inconvenient to pass the context as a prop. To be used with {@link FormProvider}.
     *
     * @remarks
     * [API](https://react-hook-form.com/docs/useformcontext) • [Demo](https://codesandbox.io/s/react-hook-form-v7-form-context-ytudi)
     *
     * @returns return all useForm methods
     *
     * @example
     * ```tsx
     * function App() {
     *   const methods = useForm();
     *   const onSubmit = data => console.log(data);
     *
     *   return (
     *     <FormProvider {...methods} >
     *       <form onSubmit={methods.handleSubmit(onSubmit)}>
     *         <NestedInput />
     *         <input type="submit" />
     *       </form>
     *     </FormProvider>
     *   );
     * }
     *
     *  function NestedInput() {
     *   const { register } = useFormContext(); // retrieve all hook methods
     *   return <input {...register("test")} />;
     * }
     * ```
     */
    const useFormContext = () => React__default["default"].useContext(HookFormContext);

    var getProxyFormState = (formState, control, localProxyFormState, isRoot = true) => {
        const result = {
            defaultValues: control._defaultValues,
        };
        for (const key in formState) {
            Object.defineProperty(result, key, {
                get: () => {
                    const _key = key;
                    if (control._proxyFormState[_key] !== VALIDATION_MODE.all) {
                        control._proxyFormState[_key] = !isRoot || VALIDATION_MODE.all;
                    }
                    localProxyFormState && (localProxyFormState[_key] = true);
                    return formState[_key];
                },
            });
        }
        return result;
    };

    /**
     * This custom hook allows you to subscribe to each form state, and isolate the re-render at the custom hook level. It has its scope in terms of form state subscription, so it would not affect other useFormState and useForm. Using this hook can reduce the re-render impact on large and complex form application.
     *
     * @remarks
     * [API](https://react-hook-form.com/docs/useformstate) • [Demo](https://codesandbox.io/s/useformstate-75xly)
     *
     * @param props - include options on specify fields to subscribe. {@link UseFormStateReturn}
     *
     * @example
     * ```tsx
     * function App() {
     *   const { register, handleSubmit, control } = useForm({
     *     defaultValues: {
     *     firstName: "firstName"
     *   }});
     *   const { dirtyFields } = useFormState({
     *     control
     *   });
     *   const onSubmit = (data) => console.log(data);
     *
     *   return (
     *     <form onSubmit={handleSubmit(onSubmit)}>
     *       <input {...register("firstName")} placeholder="First Name" />
     *       {dirtyFields.firstName && <p>Field is dirty.</p>}
     *       <input type="submit" />
     *     </form>
     *   );
     * }
     * ```
     */
    function useFormState(props) {
        const methods = useFormContext();
        const { control = methods.control, disabled, name, exact } = props || {};
        const [formState, updateFormState] = React__default["default"].useState(control._formState);
        const _localProxyFormState = React__default["default"].useRef({
            isDirty: false,
            isLoading: false,
            dirtyFields: false,
            touchedFields: false,
            validatingFields: false,
            isValidating: false,
            isValid: false,
            errors: false,
        });
        const _name = React__default["default"].useRef(name);
        _name.current = name;
        React__default["default"].useEffect(() => control._subscribe({
            name: _name.current,
            formState: _localProxyFormState.current,
            exact,
            callback: (formState) => {
                !disabled &&
                    updateFormState({
                        ...control._formState,
                        ...formState,
                    });
            },
        }), [control, disabled, exact]);
        React__default["default"].useEffect(() => {
            _localProxyFormState.current.isValid && control._setValid(true);
        }, [control]);
        return React__default["default"].useMemo(() => getProxyFormState(formState, control, _localProxyFormState.current, false), [formState, control]);
    }

    var isString = (value) => typeof value === 'string';

    var generateWatchOutput = (names, _names, formValues, isGlobal, defaultValue) => {
        if (isString(names)) {
            isGlobal && _names.watch.add(names);
            return get$1(formValues, names, defaultValue);
        }
        if (Array.isArray(names)) {
            return names.map((fieldName) => (isGlobal && _names.watch.add(fieldName), get$1(formValues, fieldName)));
        }
        isGlobal && (_names.watchAll = true);
        return formValues;
    };

    /**
     * Custom hook to subscribe to field change and isolate re-rendering at the component level.
     *
     * @remarks
     *
     * [API](https://react-hook-form.com/docs/usewatch) • [Demo](https://codesandbox.io/s/react-hook-form-v7-ts-usewatch-h9i5e)
     *
     * @example
     * ```tsx
     * const { control } = useForm();
     * const values = useWatch({
     *   name: "fieldName"
     *   control,
     * })
     * ```
     */
    function useWatch(props) {
        const methods = useFormContext();
        const { control = methods.control, name, defaultValue, disabled, exact, } = props || {};
        const _name = React__default["default"].useRef(name);
        const _defaultValue = React__default["default"].useRef(defaultValue);
        _name.current = name;
        React__default["default"].useEffect(() => control._subscribe({
            name: _name.current,
            formState: {
                values: true,
            },
            exact,
            callback: (formState) => !disabled &&
                updateValue(generateWatchOutput(_name.current, control._names, formState.values || control._formValues, false, _defaultValue.current)),
        }), [control, disabled, exact]);
        const [value, updateValue] = React__default["default"].useState(control._getWatch(name, defaultValue));
        React__default["default"].useEffect(() => control._removeUnmounted());
        return value;
    }

    var appendErrors = (name, validateAllFieldCriteria, errors, type, message) => validateAllFieldCriteria
        ? {
            ...errors[name],
            types: {
                ...(errors[name] && errors[name].types ? errors[name].types : {}),
                [type]: message || true,
            },
        }
        : {};

    var convertToArrayPayload = (value) => (Array.isArray(value) ? value : [value]);

    var createSubject = () => {
        let _observers = [];
        const next = (value) => {
            for (const observer of _observers) {
                observer.next && observer.next(value);
            }
        };
        const subscribe = (observer) => {
            _observers.push(observer);
            return {
                unsubscribe: () => {
                    _observers = _observers.filter((o) => o !== observer);
                },
            };
        };
        const unsubscribe = () => {
            _observers = [];
        };
        return {
            get observers() {
                return _observers;
            },
            next,
            subscribe,
            unsubscribe,
        };
    };

    var isPrimitive$1 = (value) => isNullOrUndefined(value) || !isObjectType(value);

    function deepEqual(object1, object2) {
        if (isPrimitive$1(object1) || isPrimitive$1(object2)) {
            return object1 === object2;
        }
        if (isDateObject(object1) && isDateObject(object2)) {
            return object1.getTime() === object2.getTime();
        }
        const keys1 = Object.keys(object1);
        const keys2 = Object.keys(object2);
        if (keys1.length !== keys2.length) {
            return false;
        }
        for (const key of keys1) {
            const val1 = object1[key];
            if (!keys2.includes(key)) {
                return false;
            }
            if (key !== 'ref') {
                const val2 = object2[key];
                if ((isDateObject(val1) && isDateObject(val2)) ||
                    (isObject$1(val1) && isObject$1(val2)) ||
                    (Array.isArray(val1) && Array.isArray(val2))
                    ? !deepEqual(val1, val2)
                    : val1 !== val2) {
                    return false;
                }
            }
        }
        return true;
    }

    var isEmptyObject = (value) => isObject$1(value) && !Object.keys(value).length;

    var isFileInput = (element) => element.type === 'file';

    var isFunction$1 = (value) => typeof value === 'function';

    var isHTMLElement = (value) => {
        if (!isWeb) {
            return false;
        }
        const owner = value ? value.ownerDocument : 0;
        return (value instanceof
            (owner && owner.defaultView ? owner.defaultView.HTMLElement : HTMLElement));
    };

    var isMultipleSelect = (element) => element.type === `select-multiple`;

    var isRadioInput = (element) => element.type === 'radio';

    var isRadioOrCheckbox = (ref) => isRadioInput(ref) || isCheckBoxInput(ref);

    var live = (ref) => isHTMLElement(ref) && ref.isConnected;

    function baseGet$1(object, updatePath) {
        const length = updatePath.slice(0, -1).length;
        let index = 0;
        while (index < length) {
            object = isUndefined$2(object) ? index++ : object[updatePath[index++]];
        }
        return object;
    }
    function isEmptyArray(obj) {
        for (const key in obj) {
            if (obj.hasOwnProperty(key) && !isUndefined$2(obj[key])) {
                return false;
            }
        }
        return true;
    }
    function unset(object, path) {
        const paths = Array.isArray(path)
            ? path
            : isKey$1(path)
                ? [path]
                : stringToPath$1(path);
        const childObject = paths.length === 1 ? object : baseGet$1(object, paths);
        const index = paths.length - 1;
        const key = paths[index];
        if (childObject) {
            delete childObject[key];
        }
        if (index !== 0 &&
            ((isObject$1(childObject) && isEmptyObject(childObject)) ||
                (Array.isArray(childObject) && isEmptyArray(childObject)))) {
            unset(object, paths.slice(0, -1));
        }
        return object;
    }

    var objectHasFunction = (data) => {
        for (const key in data) {
            if (isFunction$1(data[key])) {
                return true;
            }
        }
        return false;
    };

    function markFieldsDirty(data, fields = {}) {
        const isParentNodeArray = Array.isArray(data);
        if (isObject$1(data) || isParentNodeArray) {
            for (const key in data) {
                if (Array.isArray(data[key]) ||
                    (isObject$1(data[key]) && !objectHasFunction(data[key]))) {
                    fields[key] = Array.isArray(data[key]) ? [] : {};
                    markFieldsDirty(data[key], fields[key]);
                }
                else if (!isNullOrUndefined(data[key])) {
                    fields[key] = true;
                }
            }
        }
        return fields;
    }
    function getDirtyFieldsFromDefaultValues(data, formValues, dirtyFieldsFromValues) {
        const isParentNodeArray = Array.isArray(data);
        if (isObject$1(data) || isParentNodeArray) {
            for (const key in data) {
                if (Array.isArray(data[key]) ||
                    (isObject$1(data[key]) && !objectHasFunction(data[key]))) {
                    if (isUndefined$2(formValues) ||
                        isPrimitive$1(dirtyFieldsFromValues[key])) {
                        dirtyFieldsFromValues[key] = Array.isArray(data[key])
                            ? markFieldsDirty(data[key], [])
                            : { ...markFieldsDirty(data[key]) };
                    }
                    else {
                        getDirtyFieldsFromDefaultValues(data[key], isNullOrUndefined(formValues) ? {} : formValues[key], dirtyFieldsFromValues[key]);
                    }
                }
                else {
                    dirtyFieldsFromValues[key] = !deepEqual(data[key], formValues[key]);
                }
            }
        }
        return dirtyFieldsFromValues;
    }
    var getDirtyFields = (defaultValues, formValues) => getDirtyFieldsFromDefaultValues(defaultValues, formValues, markFieldsDirty(formValues));

    const defaultResult = {
        value: false,
        isValid: false,
    };
    const validResult = { value: true, isValid: true };
    var getCheckboxValue = (options) => {
        if (Array.isArray(options)) {
            if (options.length > 1) {
                const values = options
                    .filter((option) => option && option.checked && !option.disabled)
                    .map((option) => option.value);
                return { value: values, isValid: !!values.length };
            }
            return options[0].checked && !options[0].disabled
                ? // @ts-expect-error expected to work in the browser
                    options[0].attributes && !isUndefined$2(options[0].attributes.value)
                        ? isUndefined$2(options[0].value) || options[0].value === ''
                            ? validResult
                            : { value: options[0].value, isValid: true }
                        : validResult
                : defaultResult;
        }
        return defaultResult;
    };

    var getFieldValueAs = (value, { valueAsNumber, valueAsDate, setValueAs }) => isUndefined$2(value)
        ? value
        : valueAsNumber
            ? value === ''
                ? NaN
                : value
                    ? +value
                    : value
            : valueAsDate && isString(value)
                ? new Date(value)
                : setValueAs
                    ? setValueAs(value)
                    : value;

    const defaultReturn = {
        isValid: false,
        value: null,
    };
    var getRadioValue = (options) => Array.isArray(options)
        ? options.reduce((previous, option) => option && option.checked && !option.disabled
            ? {
                isValid: true,
                value: option.value,
            }
            : previous, defaultReturn)
        : defaultReturn;

    function getFieldValue(_f) {
        const ref = _f.ref;
        if (isFileInput(ref)) {
            return ref.files;
        }
        if (isRadioInput(ref)) {
            return getRadioValue(_f.refs).value;
        }
        if (isMultipleSelect(ref)) {
            return [...ref.selectedOptions].map(({ value }) => value);
        }
        if (isCheckBoxInput(ref)) {
            return getCheckboxValue(_f.refs).value;
        }
        return getFieldValueAs(isUndefined$2(ref.value) ? _f.ref.value : ref.value, _f);
    }

    var getResolverOptions = (fieldsNames, _fields, criteriaMode, shouldUseNativeValidation) => {
        const fields = {};
        for (const name of fieldsNames) {
            const field = get$1(_fields, name);
            field && set(fields, name, field._f);
        }
        return {
            criteriaMode,
            names: [...fieldsNames],
            fields,
            shouldUseNativeValidation,
        };
    };

    var isRegex = (value) => value instanceof RegExp;

    var getRuleValue = (rule) => isUndefined$2(rule)
        ? rule
        : isRegex(rule)
            ? rule.source
            : isObject$1(rule)
                ? isRegex(rule.value)
                    ? rule.value.source
                    : rule.value
                : rule;

    var getValidationModes = (mode) => ({
        isOnSubmit: !mode || mode === VALIDATION_MODE.onSubmit,
        isOnBlur: mode === VALIDATION_MODE.onBlur,
        isOnChange: mode === VALIDATION_MODE.onChange,
        isOnAll: mode === VALIDATION_MODE.all,
        isOnTouch: mode === VALIDATION_MODE.onTouched,
    });

    const ASYNC_FUNCTION = 'AsyncFunction';
    var hasPromiseValidation = (fieldReference) => !!fieldReference &&
        !!fieldReference.validate &&
        !!((isFunction$1(fieldReference.validate) &&
            fieldReference.validate.constructor.name === ASYNC_FUNCTION) ||
            (isObject$1(fieldReference.validate) &&
                Object.values(fieldReference.validate).find((validateFunction) => validateFunction.constructor.name === ASYNC_FUNCTION)));

    var hasValidation = (options) => options.mount &&
        (options.required ||
            options.min ||
            options.max ||
            options.maxLength ||
            options.minLength ||
            options.pattern ||
            options.validate);

    var isWatched = (name, _names, isBlurEvent) => !isBlurEvent &&
        (_names.watchAll ||
            _names.watch.has(name) ||
            [..._names.watch].some((watchName) => name.startsWith(watchName) &&
                /^\.\w+/.test(name.slice(watchName.length))));

    const iterateFieldsByAction = (fields, action, fieldsNames, abortEarly) => {
        for (const key of fieldsNames || Object.keys(fields)) {
            const field = get$1(fields, key);
            if (field) {
                const { _f, ...currentField } = field;
                if (_f) {
                    if (_f.refs && _f.refs[0] && action(_f.refs[0], key) && !abortEarly) {
                        return true;
                    }
                    else if (_f.ref && action(_f.ref, _f.name) && !abortEarly) {
                        return true;
                    }
                    else {
                        if (iterateFieldsByAction(currentField, action)) {
                            break;
                        }
                    }
                }
                else if (isObject$1(currentField)) {
                    if (iterateFieldsByAction(currentField, action)) {
                        break;
                    }
                }
            }
        }
        return;
    };

    function schemaErrorLookup(errors, _fields, name) {
        const error = get$1(errors, name);
        if (error || isKey$1(name)) {
            return {
                error,
                name,
            };
        }
        const names = name.split('.');
        while (names.length) {
            const fieldName = names.join('.');
            const field = get$1(_fields, fieldName);
            const foundError = get$1(errors, fieldName);
            if (field && !Array.isArray(field) && name !== fieldName) {
                return { name };
            }
            if (foundError && foundError.type) {
                return {
                    name: fieldName,
                    error: foundError,
                };
            }
            names.pop();
        }
        return {
            name,
        };
    }

    var shouldRenderFormState = (formStateData, _proxyFormState, updateFormState, isRoot) => {
        updateFormState(formStateData);
        const { name, ...formState } = formStateData;
        return (isEmptyObject(formState) ||
            Object.keys(formState).length >= Object.keys(_proxyFormState).length ||
            Object.keys(formState).find((key) => _proxyFormState[key] ===
                (!isRoot || VALIDATION_MODE.all)));
    };

    var shouldSubscribeByName = (name, signalName, exact) => !name ||
        !signalName ||
        name === signalName ||
        convertToArrayPayload(name).some((currentName) => currentName &&
            (exact
                ? currentName === signalName
                : currentName.startsWith(signalName) ||
                    signalName.startsWith(currentName)));

    var skipValidation = (isBlurEvent, isTouched, isSubmitted, reValidateMode, mode) => {
        if (mode.isOnAll) {
            return false;
        }
        else if (!isSubmitted && mode.isOnTouch) {
            return !(isTouched || isBlurEvent);
        }
        else if (isSubmitted ? reValidateMode.isOnBlur : mode.isOnBlur) {
            return !isBlurEvent;
        }
        else if (isSubmitted ? reValidateMode.isOnChange : mode.isOnChange) {
            return isBlurEvent;
        }
        return true;
    };

    var unsetEmptyArray = (ref, name) => !compact(get$1(ref, name)).length && unset(ref, name);

    var updateFieldArrayRootError = (errors, error, name) => {
        const fieldArrayErrors = convertToArrayPayload(get$1(errors, name));
        set(fieldArrayErrors, 'root', error[name]);
        set(errors, name, fieldArrayErrors);
        return errors;
    };

    var isMessage = (value) => isString(value);

    function getValidateError(result, ref, type = 'validate') {
        if (isMessage(result) ||
            (Array.isArray(result) && result.every(isMessage)) ||
            (isBoolean(result) && !result)) {
            return {
                type,
                message: isMessage(result) ? result : '',
                ref,
            };
        }
    }

    var getValueAndMessage = (validationData) => isObject$1(validationData) && !isRegex(validationData)
        ? validationData
        : {
            value: validationData,
            message: '',
        };

    var validateField = async (field, disabledFieldNames, formValues, validateAllFieldCriteria, shouldUseNativeValidation, isFieldArray) => {
        const { ref, refs, required, maxLength, minLength, min, max, pattern, validate, name, valueAsNumber, mount, } = field._f;
        const inputValue = get$1(formValues, name);
        if (!mount || disabledFieldNames.has(name)) {
            return {};
        }
        const inputRef = refs ? refs[0] : ref;
        const setCustomValidity = (message) => {
            if (shouldUseNativeValidation && inputRef.reportValidity) {
                inputRef.setCustomValidity(isBoolean(message) ? '' : message || '');
                inputRef.reportValidity();
            }
        };
        const error = {};
        const isRadio = isRadioInput(ref);
        const isCheckBox = isCheckBoxInput(ref);
        const isRadioOrCheckbox = isRadio || isCheckBox;
        const isEmpty = ((valueAsNumber || isFileInput(ref)) &&
            isUndefined$2(ref.value) &&
            isUndefined$2(inputValue)) ||
            (isHTMLElement(ref) && ref.value === '') ||
            inputValue === '' ||
            (Array.isArray(inputValue) && !inputValue.length);
        const appendErrorsCurry = appendErrors.bind(null, name, validateAllFieldCriteria, error);
        const getMinMaxMessage = (exceedMax, maxLengthMessage, minLengthMessage, maxType = INPUT_VALIDATION_RULES.maxLength, minType = INPUT_VALIDATION_RULES.minLength) => {
            const message = exceedMax ? maxLengthMessage : minLengthMessage;
            error[name] = {
                type: exceedMax ? maxType : minType,
                message,
                ref,
                ...appendErrorsCurry(exceedMax ? maxType : minType, message),
            };
        };
        if (isFieldArray
            ? !Array.isArray(inputValue) || !inputValue.length
            : required &&
                ((!isRadioOrCheckbox && (isEmpty || isNullOrUndefined(inputValue))) ||
                    (isBoolean(inputValue) && !inputValue) ||
                    (isCheckBox && !getCheckboxValue(refs).isValid) ||
                    (isRadio && !getRadioValue(refs).isValid))) {
            const { value, message } = isMessage(required)
                ? { value: !!required, message: required }
                : getValueAndMessage(required);
            if (value) {
                error[name] = {
                    type: INPUT_VALIDATION_RULES.required,
                    message,
                    ref: inputRef,
                    ...appendErrorsCurry(INPUT_VALIDATION_RULES.required, message),
                };
                if (!validateAllFieldCriteria) {
                    setCustomValidity(message);
                    return error;
                }
            }
        }
        if (!isEmpty && (!isNullOrUndefined(min) || !isNullOrUndefined(max))) {
            let exceedMax;
            let exceedMin;
            const maxOutput = getValueAndMessage(max);
            const minOutput = getValueAndMessage(min);
            if (!isNullOrUndefined(inputValue) && !isNaN(inputValue)) {
                const valueNumber = ref.valueAsNumber ||
                    (inputValue ? +inputValue : inputValue);
                if (!isNullOrUndefined(maxOutput.value)) {
                    exceedMax = valueNumber > maxOutput.value;
                }
                if (!isNullOrUndefined(minOutput.value)) {
                    exceedMin = valueNumber < minOutput.value;
                }
            }
            else {
                const valueDate = ref.valueAsDate || new Date(inputValue);
                const convertTimeToDate = (time) => new Date(new Date().toDateString() + ' ' + time);
                const isTime = ref.type == 'time';
                const isWeek = ref.type == 'week';
                if (isString(maxOutput.value) && inputValue) {
                    exceedMax = isTime
                        ? convertTimeToDate(inputValue) > convertTimeToDate(maxOutput.value)
                        : isWeek
                            ? inputValue > maxOutput.value
                            : valueDate > new Date(maxOutput.value);
                }
                if (isString(minOutput.value) && inputValue) {
                    exceedMin = isTime
                        ? convertTimeToDate(inputValue) < convertTimeToDate(minOutput.value)
                        : isWeek
                            ? inputValue < minOutput.value
                            : valueDate < new Date(minOutput.value);
                }
            }
            if (exceedMax || exceedMin) {
                getMinMaxMessage(!!exceedMax, maxOutput.message, minOutput.message, INPUT_VALIDATION_RULES.max, INPUT_VALIDATION_RULES.min);
                if (!validateAllFieldCriteria) {
                    setCustomValidity(error[name].message);
                    return error;
                }
            }
        }
        if ((maxLength || minLength) &&
            !isEmpty &&
            (isString(inputValue) || (isFieldArray && Array.isArray(inputValue)))) {
            const maxLengthOutput = getValueAndMessage(maxLength);
            const minLengthOutput = getValueAndMessage(minLength);
            const exceedMax = !isNullOrUndefined(maxLengthOutput.value) &&
                inputValue.length > +maxLengthOutput.value;
            const exceedMin = !isNullOrUndefined(minLengthOutput.value) &&
                inputValue.length < +minLengthOutput.value;
            if (exceedMax || exceedMin) {
                getMinMaxMessage(exceedMax, maxLengthOutput.message, minLengthOutput.message);
                if (!validateAllFieldCriteria) {
                    setCustomValidity(error[name].message);
                    return error;
                }
            }
        }
        if (pattern && !isEmpty && isString(inputValue)) {
            const { value: patternValue, message } = getValueAndMessage(pattern);
            if (isRegex(patternValue) && !inputValue.match(patternValue)) {
                error[name] = {
                    type: INPUT_VALIDATION_RULES.pattern,
                    message,
                    ref,
                    ...appendErrorsCurry(INPUT_VALIDATION_RULES.pattern, message),
                };
                if (!validateAllFieldCriteria) {
                    setCustomValidity(message);
                    return error;
                }
            }
        }
        if (validate) {
            if (isFunction$1(validate)) {
                const result = await validate(inputValue, formValues);
                const validateError = getValidateError(result, inputRef);
                if (validateError) {
                    error[name] = {
                        ...validateError,
                        ...appendErrorsCurry(INPUT_VALIDATION_RULES.validate, validateError.message),
                    };
                    if (!validateAllFieldCriteria) {
                        setCustomValidity(validateError.message);
                        return error;
                    }
                }
            }
            else if (isObject$1(validate)) {
                let validationResult = {};
                for (const key in validate) {
                    if (!isEmptyObject(validationResult) && !validateAllFieldCriteria) {
                        break;
                    }
                    const validateError = getValidateError(await validate[key](inputValue, formValues), inputRef, key);
                    if (validateError) {
                        validationResult = {
                            ...validateError,
                            ...appendErrorsCurry(key, validateError.message),
                        };
                        setCustomValidity(validateError.message);
                        if (validateAllFieldCriteria) {
                            error[name] = validationResult;
                        }
                    }
                }
                if (!isEmptyObject(validationResult)) {
                    error[name] = {
                        ref: inputRef,
                        ...validationResult,
                    };
                    if (!validateAllFieldCriteria) {
                        return error;
                    }
                }
            }
        }
        setCustomValidity(true);
        return error;
    };

    const defaultOptions = {
        mode: VALIDATION_MODE.onSubmit,
        reValidateMode: VALIDATION_MODE.onChange,
        shouldFocusError: true,
    };
    function createFormControl(props = {}) {
        let _options = {
            ...defaultOptions,
            ...props,
        };
        let _formState = {
            submitCount: 0,
            isDirty: false,
            isLoading: isFunction$1(_options.defaultValues),
            isValidating: false,
            isSubmitted: false,
            isSubmitting: false,
            isSubmitSuccessful: false,
            isValid: false,
            touchedFields: {},
            dirtyFields: {},
            validatingFields: {},
            errors: _options.errors || {},
            disabled: _options.disabled || false,
        };
        const _fields = {};
        let _defaultValues = isObject$1(_options.defaultValues) || isObject$1(_options.values)
            ? cloneObject(_options.values || _options.defaultValues) || {}
            : {};
        let _formValues = _options.shouldUnregister
            ? {}
            : cloneObject(_defaultValues);
        let _state = {
            action: false,
            mount: false,
            watch: false,
        };
        let _names = {
            mount: new Set(),
            disabled: new Set(),
            unMount: new Set(),
            array: new Set(),
            watch: new Set(),
        };
        let delayErrorCallback;
        let timer = 0;
        const _proxyFormState = {
            isDirty: false,
            dirtyFields: false,
            validatingFields: false,
            touchedFields: false,
            isValidating: false,
            isValid: false,
            errors: false,
        };
        let _proxySubscribeFormState = {
            ..._proxyFormState,
        };
        const _subjects = {
            array: createSubject(),
            state: createSubject(),
        };
        const validationModeBeforeSubmit = getValidationModes(_options.mode);
        const validationModeAfterSubmit = getValidationModes(_options.reValidateMode);
        const shouldDisplayAllAssociatedErrors = _options.criteriaMode === VALIDATION_MODE.all;
        const debounce = (callback) => (wait) => {
            clearTimeout(timer);
            timer = setTimeout(callback, wait);
        };
        const _setValid = async (shouldUpdateValid) => {
            if (!_options.disabled &&
                (_proxyFormState.isValid ||
                    _proxySubscribeFormState.isValid ||
                    shouldUpdateValid)) {
                const isValid = _options.resolver
                    ? isEmptyObject((await _runSchema()).errors)
                    : await executeBuiltInValidation(_fields, true);
                if (isValid !== _formState.isValid) {
                    _subjects.state.next({
                        isValid,
                    });
                }
            }
        };
        const _updateIsValidating = (names, isValidating) => {
            if (!_options.disabled &&
                (_proxyFormState.isValidating ||
                    _proxyFormState.validatingFields ||
                    _proxySubscribeFormState.isValidating ||
                    _proxySubscribeFormState.validatingFields)) {
                (names || Array.from(_names.mount)).forEach((name) => {
                    if (name) {
                        isValidating
                            ? set(_formState.validatingFields, name, isValidating)
                            : unset(_formState.validatingFields, name);
                    }
                });
                _subjects.state.next({
                    validatingFields: _formState.validatingFields,
                    isValidating: !isEmptyObject(_formState.validatingFields),
                });
            }
        };
        const _setFieldArray = (name, values = [], method, args, shouldSetValues = true, shouldUpdateFieldsAndState = true) => {
            if (args && method && !_options.disabled) {
                _state.action = true;
                if (shouldUpdateFieldsAndState && Array.isArray(get$1(_fields, name))) {
                    const fieldValues = method(get$1(_fields, name), args.argA, args.argB);
                    shouldSetValues && set(_fields, name, fieldValues);
                }
                if (shouldUpdateFieldsAndState &&
                    Array.isArray(get$1(_formState.errors, name))) {
                    const errors = method(get$1(_formState.errors, name), args.argA, args.argB);
                    shouldSetValues && set(_formState.errors, name, errors);
                    unsetEmptyArray(_formState.errors, name);
                }
                if ((_proxyFormState.touchedFields ||
                    _proxySubscribeFormState.touchedFields) &&
                    shouldUpdateFieldsAndState &&
                    Array.isArray(get$1(_formState.touchedFields, name))) {
                    const touchedFields = method(get$1(_formState.touchedFields, name), args.argA, args.argB);
                    shouldSetValues && set(_formState.touchedFields, name, touchedFields);
                }
                if (_proxyFormState.dirtyFields || _proxySubscribeFormState.dirtyFields) {
                    _formState.dirtyFields = getDirtyFields(_defaultValues, _formValues);
                }
                _subjects.state.next({
                    name,
                    isDirty: _getDirty(name, values),
                    dirtyFields: _formState.dirtyFields,
                    errors: _formState.errors,
                    isValid: _formState.isValid,
                });
            }
            else {
                set(_formValues, name, values);
            }
        };
        const updateErrors = (name, error) => {
            set(_formState.errors, name, error);
            _subjects.state.next({
                errors: _formState.errors,
            });
        };
        const _setErrors = (errors) => {
            _formState.errors = errors;
            _subjects.state.next({
                errors: _formState.errors,
                isValid: false,
            });
        };
        const updateValidAndValue = (name, shouldSkipSetValueAs, value, ref) => {
            const field = get$1(_fields, name);
            if (field) {
                const defaultValue = get$1(_formValues, name, isUndefined$2(value) ? get$1(_defaultValues, name) : value);
                isUndefined$2(defaultValue) ||
                    (ref && ref.defaultChecked) ||
                    shouldSkipSetValueAs
                    ? set(_formValues, name, shouldSkipSetValueAs ? defaultValue : getFieldValue(field._f))
                    : setFieldValue(name, defaultValue);
                _state.mount && _setValid();
            }
        };
        const updateTouchAndDirty = (name, fieldValue, isBlurEvent, shouldDirty, shouldRender) => {
            let shouldUpdateField = false;
            let isPreviousDirty = false;
            const output = {
                name,
            };
            if (!_options.disabled) {
                if (!isBlurEvent || shouldDirty) {
                    if (_proxyFormState.isDirty || _proxySubscribeFormState.isDirty) {
                        isPreviousDirty = _formState.isDirty;
                        _formState.isDirty = output.isDirty = _getDirty();
                        shouldUpdateField = isPreviousDirty !== output.isDirty;
                    }
                    const isCurrentFieldPristine = deepEqual(get$1(_defaultValues, name), fieldValue);
                    isPreviousDirty = !!get$1(_formState.dirtyFields, name);
                    isCurrentFieldPristine
                        ? unset(_formState.dirtyFields, name)
                        : set(_formState.dirtyFields, name, true);
                    output.dirtyFields = _formState.dirtyFields;
                    shouldUpdateField =
                        shouldUpdateField ||
                            ((_proxyFormState.dirtyFields ||
                                _proxySubscribeFormState.dirtyFields) &&
                                isPreviousDirty !== !isCurrentFieldPristine);
                }
                if (isBlurEvent) {
                    const isPreviousFieldTouched = get$1(_formState.touchedFields, name);
                    if (!isPreviousFieldTouched) {
                        set(_formState.touchedFields, name, isBlurEvent);
                        output.touchedFields = _formState.touchedFields;
                        shouldUpdateField =
                            shouldUpdateField ||
                                ((_proxyFormState.touchedFields ||
                                    _proxySubscribeFormState.touchedFields) &&
                                    isPreviousFieldTouched !== isBlurEvent);
                    }
                }
                shouldUpdateField && shouldRender && _subjects.state.next(output);
            }
            return shouldUpdateField ? output : {};
        };
        const shouldRenderByError = (name, isValid, error, fieldState) => {
            const previousFieldError = get$1(_formState.errors, name);
            const shouldUpdateValid = (_proxyFormState.isValid || _proxySubscribeFormState.isValid) &&
                isBoolean(isValid) &&
                _formState.isValid !== isValid;
            if (_options.delayError && error) {
                delayErrorCallback = debounce(() => updateErrors(name, error));
                delayErrorCallback(_options.delayError);
            }
            else {
                clearTimeout(timer);
                delayErrorCallback = null;
                error
                    ? set(_formState.errors, name, error)
                    : unset(_formState.errors, name);
            }
            if ((error ? !deepEqual(previousFieldError, error) : previousFieldError) ||
                !isEmptyObject(fieldState) ||
                shouldUpdateValid) {
                const updatedFormState = {
                    ...fieldState,
                    ...(shouldUpdateValid && isBoolean(isValid) ? { isValid } : {}),
                    errors: _formState.errors,
                    name,
                };
                _formState = {
                    ..._formState,
                    ...updatedFormState,
                };
                _subjects.state.next(updatedFormState);
            }
        };
        const _runSchema = async (name) => {
            _updateIsValidating(name, true);
            const result = await _options.resolver(_formValues, _options.context, getResolverOptions(name || _names.mount, _fields, _options.criteriaMode, _options.shouldUseNativeValidation));
            _updateIsValidating(name);
            return result;
        };
        const executeSchemaAndUpdateState = async (names) => {
            const { errors } = await _runSchema(names);
            if (names) {
                for (const name of names) {
                    const error = get$1(errors, name);
                    error
                        ? set(_formState.errors, name, error)
                        : unset(_formState.errors, name);
                }
            }
            else {
                _formState.errors = errors;
            }
            return errors;
        };
        const executeBuiltInValidation = async (fields, shouldOnlyCheckValid, context = {
            valid: true,
        }) => {
            for (const name in fields) {
                const field = fields[name];
                if (field) {
                    const { _f, ...fieldValue } = field;
                    if (_f) {
                        const isFieldArrayRoot = _names.array.has(_f.name);
                        const isPromiseFunction = field._f && hasPromiseValidation(field._f);
                        if (isPromiseFunction && _proxyFormState.validatingFields) {
                            _updateIsValidating([name], true);
                        }
                        const fieldError = await validateField(field, _names.disabled, _formValues, shouldDisplayAllAssociatedErrors, _options.shouldUseNativeValidation && !shouldOnlyCheckValid, isFieldArrayRoot);
                        if (isPromiseFunction && _proxyFormState.validatingFields) {
                            _updateIsValidating([name]);
                        }
                        if (fieldError[_f.name]) {
                            context.valid = false;
                            if (shouldOnlyCheckValid) {
                                break;
                            }
                        }
                        !shouldOnlyCheckValid &&
                            (get$1(fieldError, _f.name)
                                ? isFieldArrayRoot
                                    ? updateFieldArrayRootError(_formState.errors, fieldError, _f.name)
                                    : set(_formState.errors, _f.name, fieldError[_f.name])
                                : unset(_formState.errors, _f.name));
                    }
                    !isEmptyObject(fieldValue) &&
                        (await executeBuiltInValidation(fieldValue, shouldOnlyCheckValid, context));
                }
            }
            return context.valid;
        };
        const _removeUnmounted = () => {
            for (const name of _names.unMount) {
                const field = get$1(_fields, name);
                field &&
                    (field._f.refs
                        ? field._f.refs.every((ref) => !live(ref))
                        : !live(field._f.ref)) &&
                    unregister(name);
            }
            _names.unMount = new Set();
        };
        const _getDirty = (name, data) => !_options.disabled &&
            (name && data && set(_formValues, name, data),
                !deepEqual(getValues(), _defaultValues));
        const _getWatch = (names, defaultValue, isGlobal) => generateWatchOutput(names, _names, {
            ...(_state.mount
                ? _formValues
                : isUndefined$2(defaultValue)
                    ? _defaultValues
                    : isString(names)
                        ? { [names]: defaultValue }
                        : defaultValue),
        }, isGlobal, defaultValue);
        const _getFieldArray = (name) => compact(get$1(_state.mount ? _formValues : _defaultValues, name, _options.shouldUnregister ? get$1(_defaultValues, name, []) : []));
        const setFieldValue = (name, value, options = {}) => {
            const field = get$1(_fields, name);
            let fieldValue = value;
            if (field) {
                const fieldReference = field._f;
                if (fieldReference) {
                    !fieldReference.disabled &&
                        set(_formValues, name, getFieldValueAs(value, fieldReference));
                    fieldValue =
                        isHTMLElement(fieldReference.ref) && isNullOrUndefined(value)
                            ? ''
                            : value;
                    if (isMultipleSelect(fieldReference.ref)) {
                        [...fieldReference.ref.options].forEach((optionRef) => (optionRef.selected = fieldValue.includes(optionRef.value)));
                    }
                    else if (fieldReference.refs) {
                        if (isCheckBoxInput(fieldReference.ref)) {
                            fieldReference.refs.length > 1
                                ? fieldReference.refs.forEach((checkboxRef) => (!checkboxRef.defaultChecked || !checkboxRef.disabled) &&
                                    (checkboxRef.checked = Array.isArray(fieldValue)
                                        ? !!fieldValue.find((data) => data === checkboxRef.value)
                                        : fieldValue === checkboxRef.value))
                                : fieldReference.refs[0] &&
                                    (fieldReference.refs[0].checked = !!fieldValue);
                        }
                        else {
                            fieldReference.refs.forEach((radioRef) => (radioRef.checked = radioRef.value === fieldValue));
                        }
                    }
                    else if (isFileInput(fieldReference.ref)) {
                        fieldReference.ref.value = '';
                    }
                    else {
                        fieldReference.ref.value = fieldValue;
                        if (!fieldReference.ref.type) {
                            _subjects.state.next({
                                name,
                                values: cloneObject(_formValues),
                            });
                        }
                    }
                }
            }
            (options.shouldDirty || options.shouldTouch) &&
                updateTouchAndDirty(name, fieldValue, options.shouldTouch, options.shouldDirty, true);
            options.shouldValidate && trigger(name);
        };
        const setValues = (name, value, options) => {
            for (const fieldKey in value) {
                const fieldValue = value[fieldKey];
                const fieldName = `${name}.${fieldKey}`;
                const field = get$1(_fields, fieldName);
                (_names.array.has(name) ||
                    isObject$1(fieldValue) ||
                    (field && !field._f)) &&
                    !isDateObject(fieldValue)
                    ? setValues(fieldName, fieldValue, options)
                    : setFieldValue(fieldName, fieldValue, options);
            }
        };
        const setValue = (name, value, options = {}) => {
            const field = get$1(_fields, name);
            const isFieldArray = _names.array.has(name);
            const cloneValue = cloneObject(value);
            set(_formValues, name, cloneValue);
            if (isFieldArray) {
                _subjects.array.next({
                    name,
                    values: cloneObject(_formValues),
                });
                if ((_proxyFormState.isDirty ||
                    _proxyFormState.dirtyFields ||
                    _proxySubscribeFormState.isDirty ||
                    _proxySubscribeFormState.dirtyFields) &&
                    options.shouldDirty) {
                    _subjects.state.next({
                        name,
                        dirtyFields: getDirtyFields(_defaultValues, _formValues),
                        isDirty: _getDirty(name, cloneValue),
                    });
                }
            }
            else {
                field && !field._f && !isNullOrUndefined(cloneValue)
                    ? setValues(name, cloneValue, options)
                    : setFieldValue(name, cloneValue, options);
            }
            isWatched(name, _names) && _subjects.state.next({ ..._formState });
            _subjects.state.next({
                name: _state.mount ? name : undefined,
                values: cloneObject(_formValues),
            });
        };
        const onChange = async (event) => {
            _state.mount = true;
            const target = event.target;
            let name = target.name;
            let isFieldValueUpdated = true;
            const field = get$1(_fields, name);
            const _updateIsFieldValueUpdated = (fieldValue) => {
                isFieldValueUpdated =
                    Number.isNaN(fieldValue) ||
                        (isDateObject(fieldValue) && isNaN(fieldValue.getTime())) ||
                        deepEqual(fieldValue, get$1(_formValues, name, fieldValue));
            };
            if (field) {
                let error;
                let isValid;
                const fieldValue = target.type
                    ? getFieldValue(field._f)
                    : getEventValue(event);
                const isBlurEvent = event.type === EVENTS.BLUR || event.type === EVENTS.FOCUS_OUT;
                const shouldSkipValidation = (!hasValidation(field._f) &&
                    !_options.resolver &&
                    !get$1(_formState.errors, name) &&
                    !field._f.deps) ||
                    skipValidation(isBlurEvent, get$1(_formState.touchedFields, name), _formState.isSubmitted, validationModeAfterSubmit, validationModeBeforeSubmit);
                const watched = isWatched(name, _names, isBlurEvent);
                set(_formValues, name, fieldValue);
                if (isBlurEvent) {
                    field._f.onBlur && field._f.onBlur(event);
                    delayErrorCallback && delayErrorCallback(0);
                }
                else if (field._f.onChange) {
                    field._f.onChange(event);
                }
                const fieldState = updateTouchAndDirty(name, fieldValue, isBlurEvent);
                const shouldRender = !isEmptyObject(fieldState) || watched;
                !isBlurEvent &&
                    _subjects.state.next({
                        name,
                        type: event.type,
                        values: cloneObject(_formValues),
                    });
                if (shouldSkipValidation) {
                    if (_proxyFormState.isValid || _proxySubscribeFormState.isValid) {
                        if (_options.mode === 'onBlur') {
                            if (isBlurEvent) {
                                _setValid();
                            }
                        }
                        else if (!isBlurEvent) {
                            _setValid();
                        }
                    }
                    return (shouldRender &&
                        _subjects.state.next({ name, ...(watched ? {} : fieldState) }));
                }
                !isBlurEvent && watched && _subjects.state.next({ ..._formState });
                if (_options.resolver) {
                    const { errors } = await _runSchema([name]);
                    _updateIsFieldValueUpdated(fieldValue);
                    if (isFieldValueUpdated) {
                        const previousErrorLookupResult = schemaErrorLookup(_formState.errors, _fields, name);
                        const errorLookupResult = schemaErrorLookup(errors, _fields, previousErrorLookupResult.name || name);
                        error = errorLookupResult.error;
                        name = errorLookupResult.name;
                        isValid = isEmptyObject(errors);
                    }
                }
                else {
                    _updateIsValidating([name], true);
                    error = (await validateField(field, _names.disabled, _formValues, shouldDisplayAllAssociatedErrors, _options.shouldUseNativeValidation))[name];
                    _updateIsValidating([name]);
                    _updateIsFieldValueUpdated(fieldValue);
                    if (isFieldValueUpdated) {
                        if (error) {
                            isValid = false;
                        }
                        else if (_proxyFormState.isValid ||
                            _proxySubscribeFormState.isValid) {
                            isValid = await executeBuiltInValidation(_fields, true);
                        }
                    }
                }
                if (isFieldValueUpdated) {
                    field._f.deps &&
                        trigger(field._f.deps);
                    shouldRenderByError(name, isValid, error, fieldState);
                }
            }
        };
        const _focusInput = (ref, key) => {
            if (get$1(_formState.errors, key) && ref.focus) {
                ref.focus();
                return 1;
            }
            return;
        };
        const trigger = async (name, options = {}) => {
            let isValid;
            let validationResult;
            const fieldNames = convertToArrayPayload(name);
            if (_options.resolver) {
                const errors = await executeSchemaAndUpdateState(isUndefined$2(name) ? name : fieldNames);
                isValid = isEmptyObject(errors);
                validationResult = name
                    ? !fieldNames.some((name) => get$1(errors, name))
                    : isValid;
            }
            else if (name) {
                validationResult = (await Promise.all(fieldNames.map(async (fieldName) => {
                    const field = get$1(_fields, fieldName);
                    return await executeBuiltInValidation(field && field._f ? { [fieldName]: field } : field);
                }))).every(Boolean);
                !(!validationResult && !_formState.isValid) && _setValid();
            }
            else {
                validationResult = isValid = await executeBuiltInValidation(_fields);
            }
            _subjects.state.next({
                ...(!isString(name) ||
                    ((_proxyFormState.isValid || _proxySubscribeFormState.isValid) &&
                        isValid !== _formState.isValid)
                    ? {}
                    : { name }),
                ...(_options.resolver || !name ? { isValid } : {}),
                errors: _formState.errors,
            });
            options.shouldFocus &&
                !validationResult &&
                iterateFieldsByAction(_fields, _focusInput, name ? fieldNames : _names.mount);
            return validationResult;
        };
        const getValues = (fieldNames) => {
            const values = {
                ...(_state.mount ? _formValues : _defaultValues),
            };
            return isUndefined$2(fieldNames)
                ? values
                : isString(fieldNames)
                    ? get$1(values, fieldNames)
                    : fieldNames.map((name) => get$1(values, name));
        };
        const getFieldState = (name, formState) => ({
            invalid: !!get$1((formState || _formState).errors, name),
            isDirty: !!get$1((formState || _formState).dirtyFields, name),
            error: get$1((formState || _formState).errors, name),
            isValidating: !!get$1(_formState.validatingFields, name),
            isTouched: !!get$1((formState || _formState).touchedFields, name),
        });
        const clearErrors = (name) => {
            name &&
                convertToArrayPayload(name).forEach((inputName) => unset(_formState.errors, inputName));
            _subjects.state.next({
                errors: name ? _formState.errors : {},
            });
        };
        const setError = (name, error, options) => {
            const ref = (get$1(_fields, name, { _f: {} })._f || {}).ref;
            const currentError = get$1(_formState.errors, name) || {};
            // Don't override existing error messages elsewhere in the object tree.
            const { ref: currentRef, message, type, ...restOfErrorTree } = currentError;
            set(_formState.errors, name, {
                ...restOfErrorTree,
                ...error,
                ref,
            });
            _subjects.state.next({
                name,
                errors: _formState.errors,
                isValid: false,
            });
            options && options.shouldFocus && ref && ref.focus && ref.focus();
        };
        const watch = (name, defaultValue) => isFunction$1(name)
            ? _subjects.state.subscribe({
                next: (payload) => name(_getWatch(undefined, defaultValue), payload),
            })
            : _getWatch(name, defaultValue, true);
        const _subscribe = (props) => _subjects.state.subscribe({
            next: (formState) => {
                if (shouldSubscribeByName(props.name, formState.name, props.exact) &&
                    shouldRenderFormState(formState, props.formState || _proxyFormState, _setFormState, props.reRenderRoot)) {
                    props.callback({
                        values: { ..._formValues },
                        ..._formState,
                        ...formState,
                    });
                }
            },
        }).unsubscribe;
        const subscribe = (props) => {
            _state.mount = true;
            _proxySubscribeFormState = {
                ..._proxySubscribeFormState,
                ...props.formState,
            };
            return _subscribe({
                ...props,
                formState: _proxySubscribeFormState,
            });
        };
        const unregister = (name, options = {}) => {
            for (const fieldName of name ? convertToArrayPayload(name) : _names.mount) {
                _names.mount.delete(fieldName);
                _names.array.delete(fieldName);
                if (!options.keepValue) {
                    unset(_fields, fieldName);
                    unset(_formValues, fieldName);
                }
                !options.keepError && unset(_formState.errors, fieldName);
                !options.keepDirty && unset(_formState.dirtyFields, fieldName);
                !options.keepTouched && unset(_formState.touchedFields, fieldName);
                !options.keepIsValidating &&
                    unset(_formState.validatingFields, fieldName);
                !_options.shouldUnregister &&
                    !options.keepDefaultValue &&
                    unset(_defaultValues, fieldName);
            }
            _subjects.state.next({
                values: cloneObject(_formValues),
            });
            _subjects.state.next({
                ..._formState,
                ...(!options.keepDirty ? {} : { isDirty: _getDirty() }),
            });
            !options.keepIsValid && _setValid();
        };
        const _setDisabledField = ({ disabled, name, }) => {
            if ((isBoolean(disabled) && _state.mount) ||
                !!disabled ||
                _names.disabled.has(name)) {
                disabled ? _names.disabled.add(name) : _names.disabled.delete(name);
            }
        };
        const register = (name, options = {}) => {
            let field = get$1(_fields, name);
            const disabledIsDefined = isBoolean(options.disabled) || isBoolean(_options.disabled);
            set(_fields, name, {
                ...(field || {}),
                _f: {
                    ...(field && field._f ? field._f : { ref: { name } }),
                    name,
                    mount: true,
                    ...options,
                },
            });
            _names.mount.add(name);
            if (field) {
                _setDisabledField({
                    disabled: isBoolean(options.disabled)
                        ? options.disabled
                        : _options.disabled,
                    name,
                });
            }
            else {
                updateValidAndValue(name, true, options.value);
            }
            return {
                ...(disabledIsDefined
                    ? { disabled: options.disabled || _options.disabled }
                    : {}),
                ...(_options.progressive
                    ? {
                        required: !!options.required,
                        min: getRuleValue(options.min),
                        max: getRuleValue(options.max),
                        minLength: getRuleValue(options.minLength),
                        maxLength: getRuleValue(options.maxLength),
                        pattern: getRuleValue(options.pattern),
                    }
                    : {}),
                name,
                onChange,
                onBlur: onChange,
                ref: (ref) => {
                    if (ref) {
                        register(name, options);
                        field = get$1(_fields, name);
                        const fieldRef = isUndefined$2(ref.value)
                            ? ref.querySelectorAll
                                ? ref.querySelectorAll('input,select,textarea')[0] || ref
                                : ref
                            : ref;
                        const radioOrCheckbox = isRadioOrCheckbox(fieldRef);
                        const refs = field._f.refs || [];
                        if (radioOrCheckbox
                            ? refs.find((option) => option === fieldRef)
                            : fieldRef === field._f.ref) {
                            return;
                        }
                        set(_fields, name, {
                            _f: {
                                ...field._f,
                                ...(radioOrCheckbox
                                    ? {
                                        refs: [
                                            ...refs.filter(live),
                                            fieldRef,
                                            ...(Array.isArray(get$1(_defaultValues, name)) ? [{}] : []),
                                        ],
                                        ref: { type: fieldRef.type, name },
                                    }
                                    : { ref: fieldRef }),
                            },
                        });
                        updateValidAndValue(name, false, undefined, fieldRef);
                    }
                    else {
                        field = get$1(_fields, name, {});
                        if (field._f) {
                            field._f.mount = false;
                        }
                        (_options.shouldUnregister || options.shouldUnregister) &&
                            !(isNameInFieldArray(_names.array, name) && _state.action) &&
                            _names.unMount.add(name);
                    }
                },
            };
        };
        const _focusError = () => _options.shouldFocusError &&
            iterateFieldsByAction(_fields, _focusInput, _names.mount);
        const _disableForm = (disabled) => {
            if (isBoolean(disabled)) {
                _subjects.state.next({ disabled });
                iterateFieldsByAction(_fields, (ref, name) => {
                    const currentField = get$1(_fields, name);
                    if (currentField) {
                        ref.disabled = currentField._f.disabled || disabled;
                        if (Array.isArray(currentField._f.refs)) {
                            currentField._f.refs.forEach((inputRef) => {
                                inputRef.disabled = currentField._f.disabled || disabled;
                            });
                        }
                    }
                }, 0, false);
            }
        };
        const handleSubmit = (onValid, onInvalid) => async (e) => {
            let onValidError = undefined;
            if (e) {
                e.preventDefault && e.preventDefault();
                e.persist &&
                    e.persist();
            }
            let fieldValues = cloneObject(_formValues);
            _subjects.state.next({
                isSubmitting: true,
            });
            if (_options.resolver) {
                const { errors, values } = await _runSchema();
                _formState.errors = errors;
                fieldValues = values;
            }
            else {
                await executeBuiltInValidation(_fields);
            }
            if (_names.disabled.size) {
                for (const name of _names.disabled) {
                    set(fieldValues, name, undefined);
                }
            }
            unset(_formState.errors, 'root');
            if (isEmptyObject(_formState.errors)) {
                _subjects.state.next({
                    errors: {},
                });
                try {
                    await onValid(fieldValues, e);
                }
                catch (error) {
                    onValidError = error;
                }
            }
            else {
                if (onInvalid) {
                    await onInvalid({ ..._formState.errors }, e);
                }
                _focusError();
                setTimeout(_focusError);
            }
            _subjects.state.next({
                isSubmitted: true,
                isSubmitting: false,
                isSubmitSuccessful: isEmptyObject(_formState.errors) && !onValidError,
                submitCount: _formState.submitCount + 1,
                errors: _formState.errors,
            });
            if (onValidError) {
                throw onValidError;
            }
        };
        const resetField = (name, options = {}) => {
            if (get$1(_fields, name)) {
                if (isUndefined$2(options.defaultValue)) {
                    setValue(name, cloneObject(get$1(_defaultValues, name)));
                }
                else {
                    setValue(name, options.defaultValue);
                    set(_defaultValues, name, cloneObject(options.defaultValue));
                }
                if (!options.keepTouched) {
                    unset(_formState.touchedFields, name);
                }
                if (!options.keepDirty) {
                    unset(_formState.dirtyFields, name);
                    _formState.isDirty = options.defaultValue
                        ? _getDirty(name, cloneObject(get$1(_defaultValues, name)))
                        : _getDirty();
                }
                if (!options.keepError) {
                    unset(_formState.errors, name);
                    _proxyFormState.isValid && _setValid();
                }
                _subjects.state.next({ ..._formState });
            }
        };
        const _reset = (formValues, keepStateOptions = {}) => {
            const updatedValues = formValues ? cloneObject(formValues) : _defaultValues;
            const cloneUpdatedValues = cloneObject(updatedValues);
            const isEmptyResetValues = isEmptyObject(formValues);
            const values = isEmptyResetValues ? _defaultValues : cloneUpdatedValues;
            if (!keepStateOptions.keepDefaultValues) {
                _defaultValues = updatedValues;
            }
            if (!keepStateOptions.keepValues) {
                if (keepStateOptions.keepDirtyValues) {
                    const fieldsToCheck = new Set([
                        ..._names.mount,
                        ...Object.keys(getDirtyFields(_defaultValues, _formValues)),
                    ]);
                    for (const fieldName of Array.from(fieldsToCheck)) {
                        get$1(_formState.dirtyFields, fieldName)
                            ? set(values, fieldName, get$1(_formValues, fieldName))
                            : setValue(fieldName, get$1(values, fieldName));
                    }
                }
                else {
                    if (isWeb && isUndefined$2(formValues)) {
                        for (const name of _names.mount) {
                            const field = get$1(_fields, name);
                            if (field && field._f) {
                                const fieldReference = Array.isArray(field._f.refs)
                                    ? field._f.refs[0]
                                    : field._f.ref;
                                if (isHTMLElement(fieldReference)) {
                                    const form = fieldReference.closest('form');
                                    if (form) {
                                        form.reset();
                                        break;
                                    }
                                }
                            }
                        }
                    }
                    for (const fieldName of _names.mount) {
                        setValue(fieldName, get$1(values, fieldName));
                    }
                }
                _formValues = cloneObject(values);
                _subjects.array.next({
                    values: { ...values },
                });
                _subjects.state.next({
                    values: { ...values },
                });
            }
            _names = {
                mount: keepStateOptions.keepDirtyValues ? _names.mount : new Set(),
                unMount: new Set(),
                array: new Set(),
                disabled: new Set(),
                watch: new Set(),
                watchAll: false,
                focus: '',
            };
            _state.mount =
                !_proxyFormState.isValid ||
                    !!keepStateOptions.keepIsValid ||
                    !!keepStateOptions.keepDirtyValues;
            _state.watch = !!_options.shouldUnregister;
            _subjects.state.next({
                submitCount: keepStateOptions.keepSubmitCount
                    ? _formState.submitCount
                    : 0,
                isDirty: isEmptyResetValues
                    ? false
                    : keepStateOptions.keepDirty
                        ? _formState.isDirty
                        : !!(keepStateOptions.keepDefaultValues &&
                            !deepEqual(formValues, _defaultValues)),
                isSubmitted: keepStateOptions.keepIsSubmitted
                    ? _formState.isSubmitted
                    : false,
                dirtyFields: isEmptyResetValues
                    ? {}
                    : keepStateOptions.keepDirtyValues
                        ? keepStateOptions.keepDefaultValues && _formValues
                            ? getDirtyFields(_defaultValues, _formValues)
                            : _formState.dirtyFields
                        : keepStateOptions.keepDefaultValues && formValues
                            ? getDirtyFields(_defaultValues, formValues)
                            : keepStateOptions.keepDirty
                                ? _formState.dirtyFields
                                : {},
                touchedFields: keepStateOptions.keepTouched
                    ? _formState.touchedFields
                    : {},
                errors: keepStateOptions.keepErrors ? _formState.errors : {},
                isSubmitSuccessful: keepStateOptions.keepIsSubmitSuccessful
                    ? _formState.isSubmitSuccessful
                    : false,
                isSubmitting: false,
            });
        };
        const reset = (formValues, keepStateOptions) => _reset(isFunction$1(formValues)
            ? formValues(_formValues)
            : formValues, keepStateOptions);
        const setFocus = (name, options = {}) => {
            const field = get$1(_fields, name);
            const fieldReference = field && field._f;
            if (fieldReference) {
                const fieldRef = fieldReference.refs
                    ? fieldReference.refs[0]
                    : fieldReference.ref;
                if (fieldRef.focus) {
                    fieldRef.focus();
                    options.shouldSelect &&
                        isFunction$1(fieldRef.select) &&
                        fieldRef.select();
                }
            }
        };
        const _setFormState = (updatedFormState) => {
            _formState = {
                ..._formState,
                ...updatedFormState,
            };
        };
        const _resetDefaultValues = () => isFunction$1(_options.defaultValues) &&
            _options.defaultValues().then((values) => {
                reset(values, _options.resetOptions);
                _subjects.state.next({
                    isLoading: false,
                });
            });
        const methods = {
            control: {
                register,
                unregister,
                getFieldState,
                handleSubmit,
                setError,
                _subscribe,
                _runSchema,
                _getWatch,
                _getDirty,
                _setValid,
                _setFieldArray,
                _setDisabledField,
                _setErrors,
                _getFieldArray,
                _reset,
                _resetDefaultValues,
                _removeUnmounted,
                _disableForm,
                _subjects,
                _proxyFormState,
                get _fields() {
                    return _fields;
                },
                get _formValues() {
                    return _formValues;
                },
                get _state() {
                    return _state;
                },
                set _state(value) {
                    _state = value;
                },
                get _defaultValues() {
                    return _defaultValues;
                },
                get _names() {
                    return _names;
                },
                set _names(value) {
                    _names = value;
                },
                get _formState() {
                    return _formState;
                },
                get _options() {
                    return _options;
                },
                set _options(value) {
                    _options = {
                        ..._options,
                        ...value,
                    };
                },
            },
            subscribe,
            trigger,
            register,
            handleSubmit,
            watch,
            setValue,
            getValues,
            reset,
            resetField,
            clearErrors,
            unregister,
            setError,
            setFocus,
            getFieldState,
        };
        return {
            ...methods,
            formControl: methods,
        };
    }

    /**
     * Custom hook to manage the entire form.
     *
     * @remarks
     * [API](https://react-hook-form.com/docs/useform) • [Demo](https://codesandbox.io/s/react-hook-form-get-started-ts-5ksmm) • [Video](https://www.youtube.com/watch?v=RkXv4AXXC_4)
     *
     * @param props - form configuration and validation parameters.
     *
     * @returns methods - individual functions to manage the form state. {@link UseFormReturn}
     *
     * @example
     * ```tsx
     * function App() {
     *   const { register, handleSubmit, watch, formState: { errors } } = useForm();
     *   const onSubmit = data => console.log(data);
     *
     *   console.log(watch("example"));
     *
     *   return (
     *     <form onSubmit={handleSubmit(onSubmit)}>
     *       <input defaultValue="test" {...register("example")} />
     *       <input {...register("exampleRequired", { required: true })} />
     *       {errors.exampleRequired && <span>This field is required</span>}
     *       <button>Submit</button>
     *     </form>
     *   );
     * }
     * ```
     */
    function useForm(props = {}) {
        const _formControl = React__default["default"].useRef(undefined);
        const _values = React__default["default"].useRef(undefined);
        const [formState, updateFormState] = React__default["default"].useState({
            isDirty: false,
            isValidating: false,
            isLoading: isFunction$1(props.defaultValues),
            isSubmitted: false,
            isSubmitting: false,
            isSubmitSuccessful: false,
            isValid: false,
            submitCount: 0,
            dirtyFields: {},
            touchedFields: {},
            validatingFields: {},
            errors: props.errors || {},
            disabled: props.disabled || false,
            defaultValues: isFunction$1(props.defaultValues)
                ? undefined
                : props.defaultValues,
        });
        if (!_formControl.current) {
            _formControl.current = {
                ...(props.formControl ? props.formControl : createFormControl(props)),
                formState,
            };
            if (props.formControl &&
                props.defaultValues &&
                !isFunction$1(props.defaultValues)) {
                props.formControl.reset(props.defaultValues, props.resetOptions);
            }
        }
        const control = _formControl.current.control;
        control._options = props;
        React__default["default"].useLayoutEffect(() => control._subscribe({
            formState: control._proxyFormState,
            callback: () => updateFormState({ ...control._formState }),
            reRenderRoot: true,
        }), [control]);
        React__default["default"].useEffect(() => control._disableForm(props.disabled), [control, props.disabled]);
        React__default["default"].useEffect(() => {
            if (control._proxyFormState.isDirty) {
                const isDirty = control._getDirty();
                if (isDirty !== formState.isDirty) {
                    control._subjects.state.next({
                        isDirty,
                    });
                }
            }
        }, [control, formState.isDirty]);
        React__default["default"].useEffect(() => {
            if (props.values && !deepEqual(props.values, _values.current)) {
                control._reset(props.values, control._options.resetOptions);
                _values.current = props.values;
                updateFormState((state) => ({ ...state }));
            }
            else {
                control._resetDefaultValues();
            }
        }, [props.values, control]);
        React__default["default"].useEffect(() => {
            if (props.errors && !isEmptyObject(props.errors)) {
                control._setErrors(props.errors);
            }
        }, [props.errors, control]);
        React__default["default"].useEffect(() => {
            if (!control._state.mount) {
                control._setValid();
                control._state.mount = true;
            }
            if (control._state.watch) {
                control._state.watch = false;
                control._subjects.state.next({ ...control._formState });
            }
            control._removeUnmounted();
        });
        React__default["default"].useEffect(() => {
            props.shouldUnregister &&
                control._subjects.state.next({
                    values: control._getWatch(),
                });
        }, [props.shouldUnregister, control]);
        _formControl.current.formState = getProxyFormState(formState, control);
        return _formControl.current;
    }

    // Unique ID creation requires a high quality random # generator. In the browser we therefore
    // require the crypto API and do not support built-in fallback to lower quality random number
    // generators (like Math.random()).
    var getRandomValues;
    var rnds8 = new Uint8Array(16);
    function rng() {
      // lazy load so that environments that need to polyfill have a chance to do so
      if (!getRandomValues) {
        // getRandomValues needs to be invoked in a context where "this" is a Crypto implementation. Also,
        // find the complete implementation of crypto (msCrypto) on IE11.
        getRandomValues = typeof crypto !== 'undefined' && crypto.getRandomValues && crypto.getRandomValues.bind(crypto) || typeof msCrypto !== 'undefined' && typeof msCrypto.getRandomValues === 'function' && msCrypto.getRandomValues.bind(msCrypto);

        if (!getRandomValues) {
          throw new Error('crypto.getRandomValues() not supported. See https://github.com/uuidjs/uuid#getrandomvalues-not-supported');
        }
      }

      return getRandomValues(rnds8);
    }

    var REGEX = /^(?:[0-9a-f]{8}-[0-9a-f]{4}-[1-5][0-9a-f]{3}-[89ab][0-9a-f]{3}-[0-9a-f]{12}|00000000-0000-0000-0000-000000000000)$/i;

    function validate(uuid) {
      return typeof uuid === 'string' && REGEX.test(uuid);
    }

    /**
     * Convert array of 16 byte values to UUID string format of the form:
     * XXXXXXXX-XXXX-XXXX-XXXX-XXXXXXXXXXXX
     */

    var byteToHex = [];

    for (var i = 0; i < 256; ++i) {
      byteToHex.push((i + 0x100).toString(16).substr(1));
    }

    function stringify$1(arr) {
      var offset = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 0;
      // Note: Be careful editing this code!  It's been tuned for performance
      // and works in ways you may not expect. See https://github.com/uuidjs/uuid/pull/434
      var uuid = (byteToHex[arr[offset + 0]] + byteToHex[arr[offset + 1]] + byteToHex[arr[offset + 2]] + byteToHex[arr[offset + 3]] + '-' + byteToHex[arr[offset + 4]] + byteToHex[arr[offset + 5]] + '-' + byteToHex[arr[offset + 6]] + byteToHex[arr[offset + 7]] + '-' + byteToHex[arr[offset + 8]] + byteToHex[arr[offset + 9]] + '-' + byteToHex[arr[offset + 10]] + byteToHex[arr[offset + 11]] + byteToHex[arr[offset + 12]] + byteToHex[arr[offset + 13]] + byteToHex[arr[offset + 14]] + byteToHex[arr[offset + 15]]).toLowerCase(); // Consistency check for valid UUID.  If this throws, it's likely due to one
      // of the following:
      // - One or more input array values don't map to a hex octet (leading to
      // "undefined" in the uuid)
      // - Invalid input values for the RFC `version` or `variant` fields

      if (!validate(uuid)) {
        throw TypeError('Stringified UUID is invalid');
      }

      return uuid;
    }

    function v4(options, buf, offset) {
      options = options || {};
      var rnds = options.random || (options.rng || rng)(); // Per 4.4, set bits for version and `clock_seq_hi_and_reserved`

      rnds[6] = rnds[6] & 0x0f | 0x40;
      rnds[8] = rnds[8] & 0x3f | 0x80; // Copy bytes to buffer, if provided

      if (buf) {
        offset = offset || 0;

        for (var i = 0; i < 16; ++i) {
          buf[offset + i] = rnds[i];
        }

        return buf;
      }

      return stringify$1(rnds);
    }

    function _interopNamespace$1(e) {
      if (e && e.__esModule) return e;
      var n = Object.create(null);
      if (e) {
        Object.keys(e).forEach(function (k) {
          if (k !== 'default') {
            var d = Object.getOwnPropertyDescriptor(e, k);
            Object.defineProperty(n, k, d.get ? d : {
              enumerable: true,
              get: function () { return e[k]; }
            });
          }
        });
      }
      n["default"] = e;
      return Object.freeze(n);
    }

    var React__namespace = /*#__PURE__*/_interopNamespace$1(React__default["default"]);

    const DEFAULT_DURATION = 0.3;
    const DEFAULT_EASE_TYPE = 'linear';
    const ALL = 'all';

    var isUndefined$1 = (val) => val === undefined;

    function getSequenceId(sequenceIndex, sequenceId, defaultValue) {
        if (isUndefined$1(sequenceId) && isUndefined$1(sequenceIndex)) {
            return defaultValue || 0;
        }
        if (sequenceIndex && sequenceIndex >= 0) {
            return sequenceIndex;
        }
        if (sequenceId) {
            return sequenceId;
        }
        return 0;
    }

    const AnimateContext = React__namespace.createContext({
        animationStates: {},
        register: () => { },
    });

    var secToMs = (ms) => (ms || 0) * 1000;

    function Animate(props) {
        const { play, children, render, start, end, complete = '', onComplete, delay = 0, duration = DEFAULT_DURATION, easeType = DEFAULT_EASE_TYPE, sequenceId, sequenceIndex, } = props;
        const onCompleteTimeRef = React__namespace.useRef();
        const [style, setStyle] = React__namespace.useState(start || {});
        const { register, animationStates = {} } = React__namespace.useContext(AnimateContext);
        const id = getSequenceId(sequenceIndex, sequenceId);
        React__namespace.useEffect(() => {
            if ((!isUndefined$1(sequenceIndex) && sequenceIndex >= 0) || sequenceId) {
                register(props);
            }
            // eslint-disable-next-line react-hooks/exhaustive-deps
        }, []);
        React__namespace.useEffect(() => {
            const animationState = animationStates[id] || {};
            setStyle({
                ...(play || animationState.play ? end : start),
                transition: `${ALL} ${duration}s ${easeType} ${animationState.delay || delay}s`,
            });
            if (play && (complete || onComplete)) {
                onCompleteTimeRef.current = setTimeout(() => {
                    complete && setStyle(complete);
                    onComplete && onComplete();
                }, secToMs((animationState.delay || delay) + duration));
            }
            return () => onCompleteTimeRef.current && clearTimeout(onCompleteTimeRef.current);
        }, [
            id,
            animationStates,
            play,
            duration,
            easeType,
            delay,
            onComplete,
            start,
            end,
            complete,
        ]);
        return render ? render({ style }) : React__namespace.createElement("div", { style: style }, children);
    }

    var Animate_1 = Animate;

    var colors = {
        primary: '#0e101c',
        secondary: '#bf1650',
        lightBlue: '#516391',
        blue: '#1e2a4a',
        lightPink: '#ec5990',
        errorPink: '#fbecf2',
        buttonBlue: '#191d3a',
        link: '#ff7aa8',
        green: '#1bda2b',
    };

    function _extends() {
      _extends = Object.assign ? Object.assign.bind() : function (target) {
        for (var i = 1; i < arguments.length; i++) {
          var source = arguments[i];

          for (var key in source) {
            if (Object.prototype.hasOwnProperty.call(source, key)) {
              target[key] = source[key];
            }
          }
        }

        return target;
      };
      return _extends.apply(this, arguments);
    }

    function memoize$1(fn) {
      var cache = Object.create(null);
      return function (arg) {
        if (cache[arg] === undefined) cache[arg] = fn(arg);
        return cache[arg];
      };
    }

    var reactPropsRegex = /^((children|dangerouslySetInnerHTML|key|ref|autoFocus|defaultValue|defaultChecked|innerHTML|suppressContentEditableWarning|suppressHydrationWarning|valueLink|abbr|accept|acceptCharset|accessKey|action|allow|allowUserMedia|allowPaymentRequest|allowFullScreen|allowTransparency|alt|async|autoComplete|autoPlay|capture|cellPadding|cellSpacing|challenge|charSet|checked|cite|classID|className|cols|colSpan|content|contentEditable|contextMenu|controls|controlsList|coords|crossOrigin|data|dateTime|decoding|default|defer|dir|disabled|disablePictureInPicture|download|draggable|encType|enterKeyHint|form|formAction|formEncType|formMethod|formNoValidate|formTarget|frameBorder|headers|height|hidden|high|href|hrefLang|htmlFor|httpEquiv|id|inputMode|integrity|is|keyParams|keyType|kind|label|lang|list|loading|loop|low|marginHeight|marginWidth|max|maxLength|media|mediaGroup|method|min|minLength|multiple|muted|name|nonce|noValidate|open|optimum|pattern|placeholder|playsInline|poster|preload|profile|radioGroup|readOnly|referrerPolicy|rel|required|reversed|role|rows|rowSpan|sandbox|scope|scoped|scrolling|seamless|selected|shape|size|sizes|slot|span|spellCheck|src|srcDoc|srcLang|srcSet|start|step|style|summary|tabIndex|target|title|translate|type|useMap|value|width|wmode|wrap|about|datatype|inlist|prefix|property|resource|typeof|vocab|autoCapitalize|autoCorrect|autoSave|color|incremental|fallback|inert|itemProp|itemScope|itemType|itemID|itemRef|on|option|results|security|unselectable|accentHeight|accumulate|additive|alignmentBaseline|allowReorder|alphabetic|amplitude|arabicForm|ascent|attributeName|attributeType|autoReverse|azimuth|baseFrequency|baselineShift|baseProfile|bbox|begin|bias|by|calcMode|capHeight|clip|clipPathUnits|clipPath|clipRule|colorInterpolation|colorInterpolationFilters|colorProfile|colorRendering|contentScriptType|contentStyleType|cursor|cx|cy|d|decelerate|descent|diffuseConstant|direction|display|divisor|dominantBaseline|dur|dx|dy|edgeMode|elevation|enableBackground|end|exponent|externalResourcesRequired|fill|fillOpacity|fillRule|filter|filterRes|filterUnits|floodColor|floodOpacity|focusable|fontFamily|fontSize|fontSizeAdjust|fontStretch|fontStyle|fontVariant|fontWeight|format|from|fr|fx|fy|g1|g2|glyphName|glyphOrientationHorizontal|glyphOrientationVertical|glyphRef|gradientTransform|gradientUnits|hanging|horizAdvX|horizOriginX|ideographic|imageRendering|in|in2|intercept|k|k1|k2|k3|k4|kernelMatrix|kernelUnitLength|kerning|keyPoints|keySplines|keyTimes|lengthAdjust|letterSpacing|lightingColor|limitingConeAngle|local|markerEnd|markerMid|markerStart|markerHeight|markerUnits|markerWidth|mask|maskContentUnits|maskUnits|mathematical|mode|numOctaves|offset|opacity|operator|order|orient|orientation|origin|overflow|overlinePosition|overlineThickness|panose1|paintOrder|pathLength|patternContentUnits|patternTransform|patternUnits|pointerEvents|points|pointsAtX|pointsAtY|pointsAtZ|preserveAlpha|preserveAspectRatio|primitiveUnits|r|radius|refX|refY|renderingIntent|repeatCount|repeatDur|requiredExtensions|requiredFeatures|restart|result|rotate|rx|ry|scale|seed|shapeRendering|slope|spacing|specularConstant|specularExponent|speed|spreadMethod|startOffset|stdDeviation|stemh|stemv|stitchTiles|stopColor|stopOpacity|strikethroughPosition|strikethroughThickness|string|stroke|strokeDasharray|strokeDashoffset|strokeLinecap|strokeLinejoin|strokeMiterlimit|strokeOpacity|strokeWidth|surfaceScale|systemLanguage|tableValues|targetX|targetY|textAnchor|textDecoration|textRendering|textLength|to|transform|u1|u2|underlinePosition|underlineThickness|unicode|unicodeBidi|unicodeRange|unitsPerEm|vAlphabetic|vHanging|vIdeographic|vMathematical|values|vectorEffect|version|vertAdvY|vertOriginX|vertOriginY|viewBox|viewTarget|visibility|widths|wordSpacing|writingMode|x|xHeight|x1|x2|xChannelSelector|xlinkActuate|xlinkArcrole|xlinkHref|xlinkRole|xlinkShow|xlinkTitle|xlinkType|xmlBase|xmlns|xmlnsXlink|xmlLang|xmlSpace|y|y1|y2|yChannelSelector|z|zoomAndPan|for|class|autofocus)|(([Dd][Aa][Tt][Aa]|[Aa][Rr][Ii][Aa]|x)-.*))$/; // https://esbench.com/bench/5bfee68a4cd7e6009ef61d23

    var isPropValid = /* #__PURE__ */memoize$1(function (prop) {
      return reactPropsRegex.test(prop) || prop.charCodeAt(0) === 111
      /* o */
      && prop.charCodeAt(1) === 110
      /* n */
      && prop.charCodeAt(2) < 91;
    }
    /* Z+1 */
    );

    /*

    Based off glamor's StyleSheet, thanks Sunil ❤️

    high performance StyleSheet for css-in-js systems

    - uses multiple style tags behind the scenes for millions of rules
    - uses `insertRule` for appending in production for *much* faster performance

    // usage

    import { StyleSheet } from '@emotion/sheet'

    let styleSheet = new StyleSheet({ key: '', container: document.head })

    styleSheet.insert('#box { border: 1px solid red; }')
    - appends a css rule into the stylesheet

    styleSheet.flush()
    - empties the stylesheet of all its contents

    */
    // $FlowFixMe
    function sheetForTag(tag) {
      if (tag.sheet) {
        // $FlowFixMe
        return tag.sheet;
      } // this weirdness brought to you by firefox

      /* istanbul ignore next */


      for (var i = 0; i < document.styleSheets.length; i++) {
        if (document.styleSheets[i].ownerNode === tag) {
          // $FlowFixMe
          return document.styleSheets[i];
        }
      }
    }

    function createStyleElement(options) {
      var tag = document.createElement('style');
      tag.setAttribute('data-emotion', options.key);

      if (options.nonce !== undefined) {
        tag.setAttribute('nonce', options.nonce);
      }

      tag.appendChild(document.createTextNode(''));
      tag.setAttribute('data-s', '');
      return tag;
    }

    var StyleSheet = /*#__PURE__*/function () {
      // Using Node instead of HTMLElement since container may be a ShadowRoot
      function StyleSheet(options) {
        var _this = this;

        this._insertTag = function (tag) {
          var before;

          if (_this.tags.length === 0) {
            if (_this.insertionPoint) {
              before = _this.insertionPoint.nextSibling;
            } else if (_this.prepend) {
              before = _this.container.firstChild;
            } else {
              before = _this.before;
            }
          } else {
            before = _this.tags[_this.tags.length - 1].nextSibling;
          }

          _this.container.insertBefore(tag, before);

          _this.tags.push(tag);
        };

        this.isSpeedy = options.speedy === undefined ? "development" === 'production' : options.speedy;
        this.tags = [];
        this.ctr = 0;
        this.nonce = options.nonce; // key is the value of the data-emotion attribute, it's used to identify different sheets

        this.key = options.key;
        this.container = options.container;
        this.prepend = options.prepend;
        this.insertionPoint = options.insertionPoint;
        this.before = null;
      }

      var _proto = StyleSheet.prototype;

      _proto.hydrate = function hydrate(nodes) {
        nodes.forEach(this._insertTag);
      };

      _proto.insert = function insert(rule) {
        // the max length is how many rules we have per style tag, it's 65000 in speedy mode
        // it's 1 in dev because we insert source maps that map a single rule to a location
        // and you can only have one source map per style tag
        if (this.ctr % (this.isSpeedy ? 65000 : 1) === 0) {
          this._insertTag(createStyleElement(this));
        }

        var tag = this.tags[this.tags.length - 1];

        {
          var isImportRule = rule.charCodeAt(0) === 64 && rule.charCodeAt(1) === 105;

          if (isImportRule && this._alreadyInsertedOrderInsensitiveRule) {
            // this would only cause problem in speedy mode
            // but we don't want enabling speedy to affect the observable behavior
            // so we report this error at all times
            console.error("You're attempting to insert the following rule:\n" + rule + '\n\n`@import` rules must be before all other types of rules in a stylesheet but other rules have already been inserted. Please ensure that `@import` rules are before all other rules.');
          }
          this._alreadyInsertedOrderInsensitiveRule = this._alreadyInsertedOrderInsensitiveRule || !isImportRule;
        }

        if (this.isSpeedy) {
          var sheet = sheetForTag(tag);

          try {
            // this is the ultrafast version, works across browsers
            // the big drawback is that the css won't be editable in devtools
            sheet.insertRule(rule, sheet.cssRules.length);
          } catch (e) {
            if (!/:(-moz-placeholder|-moz-focus-inner|-moz-focusring|-ms-input-placeholder|-moz-read-write|-moz-read-only|-ms-clear){/.test(rule)) {
              console.error("There was a problem inserting the following rule: \"" + rule + "\"", e);
            }
          }
        } else {
          tag.appendChild(document.createTextNode(rule));
        }

        this.ctr++;
      };

      _proto.flush = function flush() {
        // $FlowFixMe
        this.tags.forEach(function (tag) {
          return tag.parentNode && tag.parentNode.removeChild(tag);
        });
        this.tags = [];
        this.ctr = 0;

        {
          this._alreadyInsertedOrderInsensitiveRule = false;
        }
      };

      return StyleSheet;
    }();

    var MS = '-ms-';
    var MOZ = '-moz-';
    var WEBKIT = '-webkit-';

    var COMMENT = 'comm';
    var RULESET = 'rule';
    var DECLARATION = 'decl';
    var IMPORT = '@import';
    var KEYFRAMES = '@keyframes';

    /**
     * @param {number}
     * @return {number}
     */
    var abs = Math.abs;

    /**
     * @param {number}
     * @return {string}
     */
    var from = String.fromCharCode;

    /**
     * @param {object}
     * @return {object}
     */
    var assign = Object.assign;

    /**
     * @param {string} value
     * @param {number} length
     * @return {number}
     */
    function hash (value, length) {
    	return (((((((length << 2) ^ charat(value, 0)) << 2) ^ charat(value, 1)) << 2) ^ charat(value, 2)) << 2) ^ charat(value, 3)
    }

    /**
     * @param {string} value
     * @return {string}
     */
    function trim (value) {
    	return value.trim()
    }

    /**
     * @param {string} value
     * @param {RegExp} pattern
     * @return {string?}
     */
    function match (value, pattern) {
    	return (value = pattern.exec(value)) ? value[0] : value
    }

    /**
     * @param {string} value
     * @param {(string|RegExp)} pattern
     * @param {string} replacement
     * @return {string}
     */
    function replace (value, pattern, replacement) {
    	return value.replace(pattern, replacement)
    }

    /**
     * @param {string} value
     * @param {string} search
     * @return {number}
     */
    function indexof (value, search) {
    	return value.indexOf(search)
    }

    /**
     * @param {string} value
     * @param {number} index
     * @return {number}
     */
    function charat (value, index) {
    	return value.charCodeAt(index) | 0
    }

    /**
     * @param {string} value
     * @param {number} begin
     * @param {number} end
     * @return {string}
     */
    function substr (value, begin, end) {
    	return value.slice(begin, end)
    }

    /**
     * @param {string} value
     * @return {number}
     */
    function strlen (value) {
    	return value.length
    }

    /**
     * @param {any[]} value
     * @return {number}
     */
    function sizeof (value) {
    	return value.length
    }

    /**
     * @param {any} value
     * @param {any[]} array
     * @return {any}
     */
    function append (value, array) {
    	return array.push(value), value
    }

    /**
     * @param {string[]} array
     * @param {function} callback
     * @return {string}
     */
    function combine (array, callback) {
    	return array.map(callback).join('')
    }

    var line = 1;
    var column = 1;
    var length = 0;
    var position = 0;
    var character = 0;
    var characters = '';

    /**
     * @param {string} value
     * @param {object | null} root
     * @param {object | null} parent
     * @param {string} type
     * @param {string[] | string} props
     * @param {object[] | string} children
     * @param {number} length
     */
    function node (value, root, parent, type, props, children, length) {
    	return {value: value, root: root, parent: parent, type: type, props: props, children: children, line: line, column: column, length: length, return: ''}
    }

    /**
     * @param {object} root
     * @param {object} props
     * @return {object}
     */
    function copy (root, props) {
    	return assign(node('', null, null, '', null, null, 0), root, {length: -root.length}, props)
    }

    /**
     * @return {number}
     */
    function char () {
    	return character
    }

    /**
     * @return {number}
     */
    function prev () {
    	character = position > 0 ? charat(characters, --position) : 0;

    	if (column--, character === 10)
    		column = 1, line--;

    	return character
    }

    /**
     * @return {number}
     */
    function next () {
    	character = position < length ? charat(characters, position++) : 0;

    	if (column++, character === 10)
    		column = 1, line++;

    	return character
    }

    /**
     * @return {number}
     */
    function peek () {
    	return charat(characters, position)
    }

    /**
     * @return {number}
     */
    function caret () {
    	return position
    }

    /**
     * @param {number} begin
     * @param {number} end
     * @return {string}
     */
    function slice (begin, end) {
    	return substr(characters, begin, end)
    }

    /**
     * @param {number} type
     * @return {number}
     */
    function token (type) {
    	switch (type) {
    		// \0 \t \n \r \s whitespace token
    		case 0: case 9: case 10: case 13: case 32:
    			return 5
    		// ! + , / > @ ~ isolate token
    		case 33: case 43: case 44: case 47: case 62: case 64: case 126:
    		// ; { } breakpoint token
    		case 59: case 123: case 125:
    			return 4
    		// : accompanied token
    		case 58:
    			return 3
    		// " ' ( [ opening delimit token
    		case 34: case 39: case 40: case 91:
    			return 2
    		// ) ] closing delimit token
    		case 41: case 93:
    			return 1
    	}

    	return 0
    }

    /**
     * @param {string} value
     * @return {any[]}
     */
    function alloc (value) {
    	return line = column = 1, length = strlen(characters = value), position = 0, []
    }

    /**
     * @param {any} value
     * @return {any}
     */
    function dealloc (value) {
    	return characters = '', value
    }

    /**
     * @param {number} type
     * @return {string}
     */
    function delimit (type) {
    	return trim(slice(position - 1, delimiter(type === 91 ? type + 2 : type === 40 ? type + 1 : type)))
    }

    /**
     * @param {number} type
     * @return {string}
     */
    function whitespace (type) {
    	while (character = peek())
    		if (character < 33)
    			next();
    		else
    			break

    	return token(type) > 2 || token(character) > 3 ? '' : ' '
    }

    /**
     * @param {number} index
     * @param {number} count
     * @return {string}
     */
    function escaping (index, count) {
    	while (--count && next())
    		// not 0-9 A-F a-f
    		if (character < 48 || character > 102 || (character > 57 && character < 65) || (character > 70 && character < 97))
    			break

    	return slice(index, caret() + (count < 6 && peek() == 32 && next() == 32))
    }

    /**
     * @param {number} type
     * @return {number}
     */
    function delimiter (type) {
    	while (next())
    		switch (character) {
    			// ] ) " '
    			case type:
    				return position
    			// " '
    			case 34: case 39:
    				if (type !== 34 && type !== 39)
    					delimiter(character);
    				break
    			// (
    			case 40:
    				if (type === 41)
    					delimiter(type);
    				break
    			// \
    			case 92:
    				next();
    				break
    		}

    	return position
    }

    /**
     * @param {number} type
     * @param {number} index
     * @return {number}
     */
    function commenter (type, index) {
    	while (next())
    		// //
    		if (type + character === 47 + 10)
    			break
    		// /*
    		else if (type + character === 42 + 42 && peek() === 47)
    			break

    	return '/*' + slice(index, position - 1) + '*' + from(type === 47 ? type : next())
    }

    /**
     * @param {number} index
     * @return {string}
     */
    function identifier (index) {
    	while (!token(peek()))
    		next();

    	return slice(index, position)
    }

    /**
     * @param {string} value
     * @return {object[]}
     */
    function compile (value) {
    	return dealloc(parse('', null, null, null, [''], value = alloc(value), 0, [0], value))
    }

    /**
     * @param {string} value
     * @param {object} root
     * @param {object?} parent
     * @param {string[]} rule
     * @param {string[]} rules
     * @param {string[]} rulesets
     * @param {number[]} pseudo
     * @param {number[]} points
     * @param {string[]} declarations
     * @return {object}
     */
    function parse (value, root, parent, rule, rules, rulesets, pseudo, points, declarations) {
    	var index = 0;
    	var offset = 0;
    	var length = pseudo;
    	var atrule = 0;
    	var property = 0;
    	var previous = 0;
    	var variable = 1;
    	var scanning = 1;
    	var ampersand = 1;
    	var character = 0;
    	var type = '';
    	var props = rules;
    	var children = rulesets;
    	var reference = rule;
    	var characters = type;

    	while (scanning)
    		switch (previous = character, character = next()) {
    			// (
    			case 40:
    				if (previous != 108 && characters.charCodeAt(length - 1) == 58) {
    					if (indexof(characters += replace(delimit(character), '&', '&\f'), '&\f') != -1)
    						ampersand = -1;
    					break
    				}
    			// " ' [
    			case 34: case 39: case 91:
    				characters += delimit(character);
    				break
    			// \t \n \r \s
    			case 9: case 10: case 13: case 32:
    				characters += whitespace(previous);
    				break
    			// \
    			case 92:
    				characters += escaping(caret() - 1, 7);
    				continue
    			// /
    			case 47:
    				switch (peek()) {
    					case 42: case 47:
    						append(comment(commenter(next(), caret()), root, parent), declarations);
    						break
    					default:
    						characters += '/';
    				}
    				break
    			// {
    			case 123 * variable:
    				points[index++] = strlen(characters) * ampersand;
    			// } ; \0
    			case 125 * variable: case 59: case 0:
    				switch (character) {
    					// \0 }
    					case 0: case 125: scanning = 0;
    					// ;
    					case 59 + offset:
    						if (property > 0 && (strlen(characters) - length))
    							append(property > 32 ? declaration(characters + ';', rule, parent, length - 1) : declaration(replace(characters, ' ', '') + ';', rule, parent, length - 2), declarations);
    						break
    					// @ ;
    					case 59: characters += ';';
    					// { rule/at-rule
    					default:
    						append(reference = ruleset(characters, root, parent, index, offset, rules, points, type, props = [], children = [], length), rulesets);

    						if (character === 123)
    							if (offset === 0)
    								parse(characters, root, reference, reference, props, rulesets, length, points, children);
    							else
    								switch (atrule) {
    									// d m s
    									case 100: case 109: case 115:
    										parse(value, reference, reference, rule && append(ruleset(value, reference, reference, 0, 0, rules, points, type, rules, props = [], length), children), rules, children, length, points, rule ? props : children);
    										break
    									default:
    										parse(characters, reference, reference, reference, [''], children, 0, points, children);
    								}
    				}

    				index = offset = property = 0, variable = ampersand = 1, type = characters = '', length = pseudo;
    				break
    			// :
    			case 58:
    				length = 1 + strlen(characters), property = previous;
    			default:
    				if (variable < 1)
    					if (character == 123)
    						--variable;
    					else if (character == 125 && variable++ == 0 && prev() == 125)
    						continue

    				switch (characters += from(character), character * variable) {
    					// &
    					case 38:
    						ampersand = offset > 0 ? 1 : (characters += '\f', -1);
    						break
    					// ,
    					case 44:
    						points[index++] = (strlen(characters) - 1) * ampersand, ampersand = 1;
    						break
    					// @
    					case 64:
    						// -
    						if (peek() === 45)
    							characters += delimit(next());

    						atrule = peek(), offset = length = strlen(type = characters += identifier(caret())), character++;
    						break
    					// -
    					case 45:
    						if (previous === 45 && strlen(characters) == 2)
    							variable = 0;
    				}
    		}

    	return rulesets
    }

    /**
     * @param {string} value
     * @param {object} root
     * @param {object?} parent
     * @param {number} index
     * @param {number} offset
     * @param {string[]} rules
     * @param {number[]} points
     * @param {string} type
     * @param {string[]} props
     * @param {string[]} children
     * @param {number} length
     * @return {object}
     */
    function ruleset (value, root, parent, index, offset, rules, points, type, props, children, length) {
    	var post = offset - 1;
    	var rule = offset === 0 ? rules : [''];
    	var size = sizeof(rule);

    	for (var i = 0, j = 0, k = 0; i < index; ++i)
    		for (var x = 0, y = substr(value, post + 1, post = abs(j = points[i])), z = value; x < size; ++x)
    			if (z = trim(j > 0 ? rule[x] + ' ' + y : replace(y, /&\f/g, rule[x])))
    				props[k++] = z;

    	return node(value, root, parent, offset === 0 ? RULESET : type, props, children, length)
    }

    /**
     * @param {number} value
     * @param {object} root
     * @param {object?} parent
     * @return {object}
     */
    function comment (value, root, parent) {
    	return node(value, root, parent, COMMENT, from(char()), substr(value, 2, -2), 0)
    }

    /**
     * @param {string} value
     * @param {object} root
     * @param {object?} parent
     * @param {number} length
     * @return {object}
     */
    function declaration (value, root, parent, length) {
    	return node(value, root, parent, DECLARATION, substr(value, 0, length), substr(value, length + 1, -1), length)
    }

    /**
     * @param {string} value
     * @param {number} length
     * @return {string}
     */
    function prefix (value, length) {
    	switch (hash(value, length)) {
    		// color-adjust
    		case 5103:
    			return WEBKIT + 'print-' + value + value
    		// animation, animation-(delay|direction|duration|fill-mode|iteration-count|name|play-state|timing-function)
    		case 5737: case 4201: case 3177: case 3433: case 1641: case 4457: case 2921:
    		// text-decoration, filter, clip-path, backface-visibility, column, box-decoration-break
    		case 5572: case 6356: case 5844: case 3191: case 6645: case 3005:
    		// mask, mask-image, mask-(mode|clip|size), mask-(repeat|origin), mask-position, mask-composite,
    		case 6391: case 5879: case 5623: case 6135: case 4599: case 4855:
    		// background-clip, columns, column-(count|fill|gap|rule|rule-color|rule-style|rule-width|span|width)
    		case 4215: case 6389: case 5109: case 5365: case 5621: case 3829:
    			return WEBKIT + value + value
    		// appearance, user-select, transform, hyphens, text-size-adjust
    		case 5349: case 4246: case 4810: case 6968: case 2756:
    			return WEBKIT + value + MOZ + value + MS + value + value
    		// flex, flex-direction
    		case 6828: case 4268:
    			return WEBKIT + value + MS + value + value
    		// order
    		case 6165:
    			return WEBKIT + value + MS + 'flex-' + value + value
    		// align-items
    		case 5187:
    			return WEBKIT + value + replace(value, /(\w+).+(:[^]+)/, WEBKIT + 'box-$1$2' + MS + 'flex-$1$2') + value
    		// align-self
    		case 5443:
    			return WEBKIT + value + MS + 'flex-item-' + replace(value, /flex-|-self/, '') + value
    		// align-content
    		case 4675:
    			return WEBKIT + value + MS + 'flex-line-pack' + replace(value, /align-content|flex-|-self/, '') + value
    		// flex-shrink
    		case 5548:
    			return WEBKIT + value + MS + replace(value, 'shrink', 'negative') + value
    		// flex-basis
    		case 5292:
    			return WEBKIT + value + MS + replace(value, 'basis', 'preferred-size') + value
    		// flex-grow
    		case 6060:
    			return WEBKIT + 'box-' + replace(value, '-grow', '') + WEBKIT + value + MS + replace(value, 'grow', 'positive') + value
    		// transition
    		case 4554:
    			return WEBKIT + replace(value, /([^-])(transform)/g, '$1' + WEBKIT + '$2') + value
    		// cursor
    		case 6187:
    			return replace(replace(replace(value, /(zoom-|grab)/, WEBKIT + '$1'), /(image-set)/, WEBKIT + '$1'), value, '') + value
    		// background, background-image
    		case 5495: case 3959:
    			return replace(value, /(image-set\([^]*)/, WEBKIT + '$1' + '$`$1')
    		// justify-content
    		case 4968:
    			return replace(replace(value, /(.+:)(flex-)?(.*)/, WEBKIT + 'box-pack:$3' + MS + 'flex-pack:$3'), /s.+-b[^;]+/, 'justify') + WEBKIT + value + value
    		// (margin|padding)-inline-(start|end)
    		case 4095: case 3583: case 4068: case 2532:
    			return replace(value, /(.+)-inline(.+)/, WEBKIT + '$1$2') + value
    		// (min|max)?(width|height|inline-size|block-size)
    		case 8116: case 7059: case 5753: case 5535:
    		case 5445: case 5701: case 4933: case 4677:
    		case 5533: case 5789: case 5021: case 4765:
    			// stretch, max-content, min-content, fill-available
    			if (strlen(value) - 1 - length > 6)
    				switch (charat(value, length + 1)) {
    					// (m)ax-content, (m)in-content
    					case 109:
    						// -
    						if (charat(value, length + 4) !== 45)
    							break
    					// (f)ill-available, (f)it-content
    					case 102:
    						return replace(value, /(.+:)(.+)-([^]+)/, '$1' + WEBKIT + '$2-$3' + '$1' + MOZ + (charat(value, length + 3) == 108 ? '$3' : '$2-$3')) + value
    					// (s)tretch
    					case 115:
    						return ~indexof(value, 'stretch') ? prefix(replace(value, 'stretch', 'fill-available'), length) + value : value
    				}
    			break
    		// position: sticky
    		case 4949:
    			// (s)ticky?
    			if (charat(value, length + 1) !== 115)
    				break
    		// display: (flex|inline-flex)
    		case 6444:
    			switch (charat(value, strlen(value) - 3 - (~indexof(value, '!important') && 10))) {
    				// stic(k)y
    				case 107:
    					return replace(value, ':', ':' + WEBKIT) + value
    				// (inline-)?fl(e)x
    				case 101:
    					return replace(value, /(.+:)([^;!]+)(;|!.+)?/, '$1' + WEBKIT + (charat(value, 14) === 45 ? 'inline-' : '') + 'box$3' + '$1' + WEBKIT + '$2$3' + '$1' + MS + '$2box$3') + value
    			}
    			break
    		// writing-mode
    		case 5936:
    			switch (charat(value, length + 11)) {
    				// vertical-l(r)
    				case 114:
    					return WEBKIT + value + MS + replace(value, /[svh]\w+-[tblr]{2}/, 'tb') + value
    				// vertical-r(l)
    				case 108:
    					return WEBKIT + value + MS + replace(value, /[svh]\w+-[tblr]{2}/, 'tb-rl') + value
    				// horizontal(-)tb
    				case 45:
    					return WEBKIT + value + MS + replace(value, /[svh]\w+-[tblr]{2}/, 'lr') + value
    			}

    			return WEBKIT + value + MS + value + value
    	}

    	return value
    }

    /**
     * @param {object[]} children
     * @param {function} callback
     * @return {string}
     */
    function serialize (children, callback) {
    	var output = '';
    	var length = sizeof(children);

    	for (var i = 0; i < length; i++)
    		output += callback(children[i], i, children, callback) || '';

    	return output
    }

    /**
     * @param {object} element
     * @param {number} index
     * @param {object[]} children
     * @param {function} callback
     * @return {string}
     */
    function stringify (element, index, children, callback) {
    	switch (element.type) {
    		case IMPORT: case DECLARATION: return element.return = element.return || element.value
    		case COMMENT: return ''
    		case KEYFRAMES: return element.return = element.value + '{' + serialize(element.children, callback) + '}'
    		case RULESET: element.value = element.props.join(',');
    	}

    	return strlen(children = serialize(element.children, callback)) ? element.return = element.value + '{' + children + '}' : ''
    }

    /**
     * @param {function[]} collection
     * @return {function}
     */
    function middleware (collection) {
    	var length = sizeof(collection);

    	return function (element, index, children, callback) {
    		var output = '';

    		for (var i = 0; i < length; i++)
    			output += collection[i](element, index, children, callback) || '';

    		return output
    	}
    }

    /**
     * @param {object} element
     * @param {number} index
     * @param {object[]} children
     * @param {function} callback
     */
    function prefixer (element, index, children, callback) {
    	if (element.length > -1)
    		if (!element.return)
    			switch (element.type) {
    				case DECLARATION: element.return = prefix(element.value, element.length);
    					break
    				case KEYFRAMES:
    					return serialize([copy(element, {value: replace(element.value, '@', '@' + WEBKIT)})], callback)
    				case RULESET:
    					if (element.length)
    						return combine(element.props, function (value) {
    							switch (match(value, /(::plac\w+|:read-\w+)/)) {
    								// :read-(only|write)
    								case ':read-only': case ':read-write':
    									return serialize([copy(element, {props: [replace(value, /:(read-\w+)/, ':' + MOZ + '$1')]})], callback)
    								// :placeholder
    								case '::placeholder':
    									return serialize([
    										copy(element, {props: [replace(value, /:(plac\w+)/, ':' + WEBKIT + 'input-$1')]}),
    										copy(element, {props: [replace(value, /:(plac\w+)/, ':' + MOZ + '$1')]}),
    										copy(element, {props: [replace(value, /:(plac\w+)/, MS + 'input-$1')]})
    									], callback)
    							}

    							return ''
    						})
    			}
    }

    var weakMemoize = function weakMemoize(func) {
      // $FlowFixMe flow doesn't include all non-primitive types as allowed for weakmaps
      var cache = new WeakMap();
      return function (arg) {
        if (cache.has(arg)) {
          // $FlowFixMe
          return cache.get(arg);
        }

        var ret = func(arg);
        cache.set(arg, ret);
        return ret;
      };
    };

    var last = function last(arr) {
      return arr.length ? arr[arr.length - 1] : null;
    }; // based on https://github.com/thysultan/stylis.js/blob/e6843c373ebcbbfade25ebcc23f540ed8508da0a/src/Tokenizer.js#L239-L244


    var identifierWithPointTracking = function identifierWithPointTracking(begin, points, index) {
      var previous = 0;
      var character = 0;

      while (true) {
        previous = character;
        character = peek(); // &\f

        if (previous === 38 && character === 12) {
          points[index] = 1;
        }

        if (token(character)) {
          break;
        }

        next();
      }

      return slice(begin, position);
    };

    var toRules = function toRules(parsed, points) {
      // pretend we've started with a comma
      var index = -1;
      var character = 44;

      do {
        switch (token(character)) {
          case 0:
            // &\f
            if (character === 38 && peek() === 12) {
              // this is not 100% correct, we don't account for literal sequences here - like for example quoted strings
              // stylis inserts \f after & to know when & where it should replace this sequence with the context selector
              // and when it should just concatenate the outer and inner selectors
              // it's very unlikely for this sequence to actually appear in a different context, so we just leverage this fact here
              points[index] = 1;
            }

            parsed[index] += identifierWithPointTracking(position - 1, points, index);
            break;

          case 2:
            parsed[index] += delimit(character);
            break;

          case 4:
            // comma
            if (character === 44) {
              // colon
              parsed[++index] = peek() === 58 ? '&\f' : '';
              points[index] = parsed[index].length;
              break;
            }

          // fallthrough

          default:
            parsed[index] += from(character);
        }
      } while (character = next());

      return parsed;
    };

    var getRules = function getRules(value, points) {
      return dealloc(toRules(alloc(value), points));
    }; // WeakSet would be more appropriate, but only WeakMap is supported in IE11


    var fixedElements = /* #__PURE__ */new WeakMap();
    var compat = function compat(element) {
      if (element.type !== 'rule' || !element.parent || // positive .length indicates that this rule contains pseudo
      // negative .length indicates that this rule has been already prefixed
      element.length < 1) {
        return;
      }

      var value = element.value,
          parent = element.parent;
      var isImplicitRule = element.column === parent.column && element.line === parent.line;

      while (parent.type !== 'rule') {
        parent = parent.parent;
        if (!parent) return;
      } // short-circuit for the simplest case


      if (element.props.length === 1 && value.charCodeAt(0) !== 58
      /* colon */
      && !fixedElements.get(parent)) {
        return;
      } // if this is an implicitly inserted rule (the one eagerly inserted at the each new nested level)
      // then the props has already been manipulated beforehand as they that array is shared between it and its "rule parent"


      if (isImplicitRule) {
        return;
      }

      fixedElements.set(element, true);
      var points = [];
      var rules = getRules(value, points);
      var parentRules = parent.props;

      for (var i = 0, k = 0; i < rules.length; i++) {
        for (var j = 0; j < parentRules.length; j++, k++) {
          element.props[k] = points[i] ? rules[i].replace(/&\f/g, parentRules[j]) : parentRules[j] + " " + rules[i];
        }
      }
    };
    var removeLabel = function removeLabel(element) {
      if (element.type === 'decl') {
        var value = element.value;

        if ( // charcode for l
        value.charCodeAt(0) === 108 && // charcode for b
        value.charCodeAt(2) === 98) {
          // this ignores label
          element["return"] = '';
          element.value = '';
        }
      }
    };
    var ignoreFlag = 'emotion-disable-server-rendering-unsafe-selector-warning-please-do-not-use-this-the-warning-exists-for-a-reason';

    var isIgnoringComment = function isIgnoringComment(element) {
      return !!element && element.type === 'comm' && element.children.indexOf(ignoreFlag) > -1;
    };

    var createUnsafeSelectorsAlarm = function createUnsafeSelectorsAlarm(cache) {
      return function (element, index, children) {
        if (element.type !== 'rule') return;
        var unsafePseudoClasses = element.value.match(/(:first|:nth|:nth-last)-child/g);

        if (unsafePseudoClasses && cache.compat !== true) {
          var prevElement = index > 0 ? children[index - 1] : null;

          if (prevElement && isIgnoringComment(last(prevElement.children))) {
            return;
          }

          unsafePseudoClasses.forEach(function (unsafePseudoClass) {
            console.error("The pseudo class \"" + unsafePseudoClass + "\" is potentially unsafe when doing server-side rendering. Try changing it to \"" + unsafePseudoClass.split('-child')[0] + "-of-type\".");
          });
        }
      };
    };

    var isImportRule = function isImportRule(element) {
      return element.type.charCodeAt(1) === 105 && element.type.charCodeAt(0) === 64;
    };

    var isPrependedWithRegularRules = function isPrependedWithRegularRules(index, children) {
      for (var i = index - 1; i >= 0; i--) {
        if (!isImportRule(children[i])) {
          return true;
        }
      }

      return false;
    }; // use this to remove incorrect elements from further processing
    // so they don't get handed to the `sheet` (or anything else)
    // as that could potentially lead to additional logs which in turn could be overhelming to the user


    var nullifyElement = function nullifyElement(element) {
      element.type = '';
      element.value = '';
      element["return"] = '';
      element.children = '';
      element.props = '';
    };

    var incorrectImportAlarm = function incorrectImportAlarm(element, index, children) {
      if (!isImportRule(element)) {
        return;
      }

      if (element.parent) {
        console.error("`@import` rules can't be nested inside other rules. Please move it to the top level and put it before regular rules. Keep in mind that they can only be used within global styles.");
        nullifyElement(element);
      } else if (isPrependedWithRegularRules(index, children)) {
        console.error("`@import` rules can't be after other rules. Please put your `@import` rules before your other rules.");
        nullifyElement(element);
      }
    };

    var isBrowser$4 = typeof document !== 'undefined';
    var getServerStylisCache = isBrowser$4 ? undefined : weakMemoize(function () {
      return memoize$1(function () {
        var cache = {};
        return function (name) {
          return cache[name];
        };
      });
    });
    var defaultStylisPlugins = [prefixer];

    var createCache = function createCache(options) {
      var key = options.key;

      if (!key) {
        throw new Error("You have to configure `key` for your cache. Please make sure it's unique (and not equal to 'css') as it's used for linking styles to your cache.\n" + "If multiple caches share the same key they might \"fight\" for each other's style elements.");
      }

      if (isBrowser$4 && key === 'css') {
        var ssrStyles = document.querySelectorAll("style[data-emotion]:not([data-s])"); // get SSRed styles out of the way of React's hydration
        // document.head is a safe place to move them to(though note document.head is not necessarily the last place they will be)
        // note this very very intentionally targets all style elements regardless of the key to ensure
        // that creating a cache works inside of render of a React component

        Array.prototype.forEach.call(ssrStyles, function (node) {
          // we want to only move elements which have a space in the data-emotion attribute value
          // because that indicates that it is an Emotion 11 server-side rendered style elements
          // while we will already ignore Emotion 11 client-side inserted styles because of the :not([data-s]) part in the selector
          // Emotion 10 client-side inserted styles did not have data-s (but importantly did not have a space in their data-emotion attributes)
          // so checking for the space ensures that loading Emotion 11 after Emotion 10 has inserted some styles
          // will not result in the Emotion 10 styles being destroyed
          var dataEmotionAttribute = node.getAttribute('data-emotion');

          if (dataEmotionAttribute.indexOf(' ') === -1) {
            return;
          }
          document.head.appendChild(node);
          node.setAttribute('data-s', '');
        });
      }

      var stylisPlugins = options.stylisPlugins || defaultStylisPlugins;

      {
        // $FlowFixMe
        if (/[^a-z-]/.test(key)) {
          throw new Error("Emotion key must only contain lower case alphabetical characters and - but \"" + key + "\" was passed");
        }
      }

      var inserted = {};
      var container;
      var nodesToHydrate = [];

      if (isBrowser$4) {
        container = options.container || document.head;
        Array.prototype.forEach.call( // this means we will ignore elements which don't have a space in them which
        // means that the style elements we're looking at are only Emotion 11 server-rendered style elements
        document.querySelectorAll("style[data-emotion^=\"" + key + " \"]"), function (node) {
          var attrib = node.getAttribute("data-emotion").split(' '); // $FlowFixMe

          for (var i = 1; i < attrib.length; i++) {
            inserted[attrib[i]] = true;
          }

          nodesToHydrate.push(node);
        });
      }

      var _insert;

      var omnipresentPlugins = [compat, removeLabel];

      {
        omnipresentPlugins.push(createUnsafeSelectorsAlarm({
          get compat() {
            return cache.compat;
          }

        }), incorrectImportAlarm);
      }

      if (isBrowser$4) {
        var currentSheet;
        var finalizingPlugins = [stringify, function (element) {
          if (!element.root) {
            if (element["return"]) {
              currentSheet.insert(element["return"]);
            } else if (element.value && element.type !== COMMENT) {
              // insert empty rule in non-production environments
              // so @emotion/jest can grab `key` from the (JS)DOM for caches without any rules inserted yet
              currentSheet.insert(element.value + "{}");
            }
          }
        } ];
        var serializer = middleware(omnipresentPlugins.concat(stylisPlugins, finalizingPlugins));

        var stylis = function stylis(styles) {
          return serialize(compile(styles), serializer);
        };

        _insert = function insert(selector, serialized, sheet, shouldCache) {
          currentSheet = sheet;

          if (serialized.map !== undefined) {
            currentSheet = {
              insert: function insert(rule) {
                sheet.insert(rule + serialized.map);
              }
            };
          }

          stylis(selector ? selector + "{" + serialized.styles + "}" : serialized.styles);

          if (shouldCache) {
            cache.inserted[serialized.name] = true;
          }
        };
      } else {
        var _finalizingPlugins = [stringify];

        var _serializer = middleware(omnipresentPlugins.concat(stylisPlugins, _finalizingPlugins));

        var _stylis = function _stylis(styles) {
          return serialize(compile(styles), _serializer);
        }; // $FlowFixMe


        var serverStylisCache = getServerStylisCache(stylisPlugins)(key);

        var getRules = function getRules(selector, serialized) {
          var name = serialized.name;

          if (serverStylisCache[name] === undefined) {
            serverStylisCache[name] = _stylis(selector ? selector + "{" + serialized.styles + "}" : serialized.styles);
          }

          return serverStylisCache[name];
        };

        _insert = function _insert(selector, serialized, sheet, shouldCache) {
          var name = serialized.name;
          var rules = getRules(selector, serialized);

          if (cache.compat === undefined) {
            // in regular mode, we don't set the styles on the inserted cache
            // since we don't need to and that would be wasting memory
            // we return them so that they are rendered in a style tag
            if (shouldCache) {
              cache.inserted[name] = true;
            }

            if ( // using === development instead of !== production
            // because if people do ssr in tests, the source maps showing up would be annoying
            serialized.map !== undefined) {
              return rules + serialized.map;
            }

            return rules;
          } else {
            // in compat mode, we put the styles on the inserted cache so
            // that emotion-server can pull out the styles
            // except when we don't want to cache it which was in Global but now
            // is nowhere but we don't want to do a major right now
            // and just in case we're going to leave the case here
            // it's also not affecting client side bundle size
            // so it's really not a big deal
            if (shouldCache) {
              cache.inserted[name] = rules;
            } else {
              return rules;
            }
          }
        };
      }

      var cache = {
        key: key,
        sheet: new StyleSheet({
          key: key,
          container: container,
          nonce: options.nonce,
          speedy: options.speedy,
          prepend: options.prepend,
          insertionPoint: options.insertionPoint
        }),
        nonce: options.nonce,
        inserted: inserted,
        registered: {},
        insert: _insert
      };
      cache.sheet.hydrate(nodesToHydrate);
      return cache;
    };

    var commonjsGlobal = typeof globalThis !== 'undefined' ? globalThis : typeof window !== 'undefined' ? window : typeof global !== 'undefined' ? global : typeof self !== 'undefined' ? self : {};

    var isBrowser$3 = typeof document !== 'undefined';
    function getRegisteredStyles(registered, registeredStyles, classNames) {
      var rawClassName = '';
      classNames.split(' ').forEach(function (className) {
        if (registered[className] !== undefined) {
          registeredStyles.push(registered[className] + ";");
        } else {
          rawClassName += className + " ";
        }
      });
      return rawClassName;
    }
    var registerStyles = function registerStyles(cache, serialized, isStringTag) {
      var className = cache.key + "-" + serialized.name;

      if ( // we only need to add the styles to the registered cache if the
      // class name could be used further down
      // the tree but if it's a string tag, we know it won't
      // so we don't have to add it to registered cache.
      // this improves memory usage since we can avoid storing the whole style string
      (isStringTag === false || // we need to always store it if we're in compat mode and
      // in node since emotion-server relies on whether a style is in
      // the registered cache to know whether a style is global or not
      // also, note that this check will be dead code eliminated in the browser
      isBrowser$3 === false && cache.compat !== undefined) && cache.registered[className] === undefined) {
        cache.registered[className] = serialized.styles;
      }
    };
    var insertStyles = function insertStyles(cache, serialized, isStringTag) {
      registerStyles(cache, serialized, isStringTag);
      var className = cache.key + "-" + serialized.name;

      if (cache.inserted[serialized.name] === undefined) {
        var stylesForSSR = '';
        var current = serialized;

        do {
          var maybeStyles = cache.insert(serialized === current ? "." + className : '', current, cache.sheet, true);

          if (!isBrowser$3 && maybeStyles !== undefined) {
            stylesForSSR += maybeStyles;
          }

          current = current.next;
        } while (current !== undefined);

        if (!isBrowser$3 && stylesForSSR.length !== 0) {
          return stylesForSSR;
        }
      }
    };

    /* eslint-disable */
    // Inspired by https://github.com/garycourt/murmurhash-js
    // Ported from https://github.com/aappleby/smhasher/blob/61a0530f28277f2e850bfc39600ce61d02b518de/src/MurmurHash2.cpp#L37-L86
    function murmur2(str) {
      // 'm' and 'r' are mixing constants generated offline.
      // They're not really 'magic', they just happen to work well.
      // const m = 0x5bd1e995;
      // const r = 24;
      // Initialize the hash
      var h = 0; // Mix 4 bytes at a time into the hash

      var k,
          i = 0,
          len = str.length;

      for (; len >= 4; ++i, len -= 4) {
        k = str.charCodeAt(i) & 0xff | (str.charCodeAt(++i) & 0xff) << 8 | (str.charCodeAt(++i) & 0xff) << 16 | (str.charCodeAt(++i) & 0xff) << 24;
        k =
        /* Math.imul(k, m): */
        (k & 0xffff) * 0x5bd1e995 + ((k >>> 16) * 0xe995 << 16);
        k ^=
        /* k >>> r: */
        k >>> 24;
        h =
        /* Math.imul(k, m): */
        (k & 0xffff) * 0x5bd1e995 + ((k >>> 16) * 0xe995 << 16) ^
        /* Math.imul(h, m): */
        (h & 0xffff) * 0x5bd1e995 + ((h >>> 16) * 0xe995 << 16);
      } // Handle the last few bytes of the input array


      switch (len) {
        case 3:
          h ^= (str.charCodeAt(i + 2) & 0xff) << 16;

        case 2:
          h ^= (str.charCodeAt(i + 1) & 0xff) << 8;

        case 1:
          h ^= str.charCodeAt(i) & 0xff;
          h =
          /* Math.imul(h, m): */
          (h & 0xffff) * 0x5bd1e995 + ((h >>> 16) * 0xe995 << 16);
      } // Do a few final mixes of the hash to ensure the last few
      // bytes are well-incorporated.


      h ^= h >>> 13;
      h =
      /* Math.imul(h, m): */
      (h & 0xffff) * 0x5bd1e995 + ((h >>> 16) * 0xe995 << 16);
      return ((h ^ h >>> 15) >>> 0).toString(36);
    }

    var unitlessKeys = {
      animationIterationCount: 1,
      borderImageOutset: 1,
      borderImageSlice: 1,
      borderImageWidth: 1,
      boxFlex: 1,
      boxFlexGroup: 1,
      boxOrdinalGroup: 1,
      columnCount: 1,
      columns: 1,
      flex: 1,
      flexGrow: 1,
      flexPositive: 1,
      flexShrink: 1,
      flexNegative: 1,
      flexOrder: 1,
      gridRow: 1,
      gridRowEnd: 1,
      gridRowSpan: 1,
      gridRowStart: 1,
      gridColumn: 1,
      gridColumnEnd: 1,
      gridColumnSpan: 1,
      gridColumnStart: 1,
      msGridRow: 1,
      msGridRowSpan: 1,
      msGridColumn: 1,
      msGridColumnSpan: 1,
      fontWeight: 1,
      lineHeight: 1,
      opacity: 1,
      order: 1,
      orphans: 1,
      tabSize: 1,
      widows: 1,
      zIndex: 1,
      zoom: 1,
      WebkitLineClamp: 1,
      // SVG-related properties
      fillOpacity: 1,
      floodOpacity: 1,
      stopOpacity: 1,
      strokeDasharray: 1,
      strokeDashoffset: 1,
      strokeMiterlimit: 1,
      strokeOpacity: 1,
      strokeWidth: 1
    };

    var ILLEGAL_ESCAPE_SEQUENCE_ERROR$1 = "You have illegal escape sequence in your template literal, most likely inside content's property value.\nBecause you write your CSS inside a JavaScript string you actually have to do double escaping, so for example \"content: '\\00d7';\" should become \"content: '\\\\00d7';\".\nYou can read more about this here:\nhttps://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Template_literals#ES2018_revision_of_illegal_escape_sequences";
    var UNDEFINED_AS_OBJECT_KEY_ERROR = "You have passed in falsy value as style object's key (can happen when in example you pass unexported component as computed key).";
    var hyphenateRegex = /[A-Z]|^ms/g;
    var animationRegex = /_EMO_([^_]+?)_([^]*?)_EMO_/g;

    var isCustomProperty = function isCustomProperty(property) {
      return property.charCodeAt(1) === 45;
    };

    var isProcessableValue = function isProcessableValue(value) {
      return value != null && typeof value !== 'boolean';
    };

    var processStyleName = /* #__PURE__ */memoize$1(function (styleName) {
      return isCustomProperty(styleName) ? styleName : styleName.replace(hyphenateRegex, '-$&').toLowerCase();
    });

    var processStyleValue = function processStyleValue(key, value) {
      switch (key) {
        case 'animation':
        case 'animationName':
          {
            if (typeof value === 'string') {
              return value.replace(animationRegex, function (match, p1, p2) {
                cursor = {
                  name: p1,
                  styles: p2,
                  next: cursor
                };
                return p1;
              });
            }
          }
      }

      if (unitlessKeys[key] !== 1 && !isCustomProperty(key) && typeof value === 'number' && value !== 0) {
        return value + 'px';
      }

      return value;
    };

    {
      var contentValuePattern = /(var|attr|counters?|url|(((repeating-)?(linear|radial))|conic)-gradient)\(|(no-)?(open|close)-quote/;
      var contentValues = ['normal', 'none', 'initial', 'inherit', 'unset'];
      var oldProcessStyleValue = processStyleValue;
      var msPattern = /^-ms-/;
      var hyphenPattern = /-(.)/g;
      var hyphenatedCache = {};

      processStyleValue = function processStyleValue(key, value) {
        if (key === 'content') {
          if (typeof value !== 'string' || contentValues.indexOf(value) === -1 && !contentValuePattern.test(value) && (value.charAt(0) !== value.charAt(value.length - 1) || value.charAt(0) !== '"' && value.charAt(0) !== "'")) {
            throw new Error("You seem to be using a value for 'content' without quotes, try replacing it with `content: '\"" + value + "\"'`");
          }
        }

        var processed = oldProcessStyleValue(key, value);

        if (processed !== '' && !isCustomProperty(key) && key.indexOf('-') !== -1 && hyphenatedCache[key] === undefined) {
          hyphenatedCache[key] = true;
          console.error("Using kebab-case for css properties in objects is not supported. Did you mean " + key.replace(msPattern, 'ms-').replace(hyphenPattern, function (str, _char) {
            return _char.toUpperCase();
          }) + "?");
        }

        return processed;
      };
    }

    var noComponentSelectorMessage = 'Component selectors can only be used in conjunction with ' + '@emotion/babel-plugin, the swc Emotion plugin, or another Emotion-aware ' + 'compiler transform.';

    function handleInterpolation(mergedProps, registered, interpolation) {
      if (interpolation == null) {
        return '';
      }

      if (interpolation.__emotion_styles !== undefined) {
        if (interpolation.toString() === 'NO_COMPONENT_SELECTOR') {
          throw new Error(noComponentSelectorMessage);
        }

        return interpolation;
      }

      switch (typeof interpolation) {
        case 'boolean':
          {
            return '';
          }

        case 'object':
          {
            if (interpolation.anim === 1) {
              cursor = {
                name: interpolation.name,
                styles: interpolation.styles,
                next: cursor
              };
              return interpolation.name;
            }

            if (interpolation.styles !== undefined) {
              var next = interpolation.next;

              if (next !== undefined) {
                // not the most efficient thing ever but this is a pretty rare case
                // and there will be very few iterations of this generally
                while (next !== undefined) {
                  cursor = {
                    name: next.name,
                    styles: next.styles,
                    next: cursor
                  };
                  next = next.next;
                }
              }

              var styles = interpolation.styles + ";";

              if (interpolation.map !== undefined) {
                styles += interpolation.map;
              }

              return styles;
            }

            return createStringFromObject(mergedProps, registered, interpolation);
          }

        case 'function':
          {
            if (mergedProps !== undefined) {
              var previousCursor = cursor;
              var result = interpolation(mergedProps);
              cursor = previousCursor;
              return handleInterpolation(mergedProps, registered, result);
            } else {
              console.error('Functions that are interpolated in css calls will be stringified.\n' + 'If you want to have a css call based on props, create a function that returns a css call like this\n' + 'let dynamicStyle = (props) => css`color: ${props.color}`\n' + 'It can be called directly with props or interpolated in a styled call like this\n' + "let SomeComponent = styled('div')`${dynamicStyle}`");
            }

            break;
          }

        case 'string':
          {
            var matched = [];
            var replaced = interpolation.replace(animationRegex, function (match, p1, p2) {
              var fakeVarName = "animation" + matched.length;
              matched.push("const " + fakeVarName + " = keyframes`" + p2.replace(/^@keyframes animation-\w+/, '') + "`");
              return "${" + fakeVarName + "}";
            });

            if (matched.length) {
              console.error('`keyframes` output got interpolated into plain string, please wrap it with `css`.\n\n' + 'Instead of doing this:\n\n' + [].concat(matched, ["`" + replaced + "`"]).join('\n') + '\n\nYou should wrap it with `css` like this:\n\n' + ("css`" + replaced + "`"));
            }
          }

          break;
      } // finalize string values (regular strings and functions interpolated into css calls)


      if (registered == null) {
        return interpolation;
      }

      var cached = registered[interpolation];
      return cached !== undefined ? cached : interpolation;
    }

    function createStringFromObject(mergedProps, registered, obj) {
      var string = '';

      if (Array.isArray(obj)) {
        for (var i = 0; i < obj.length; i++) {
          string += handleInterpolation(mergedProps, registered, obj[i]) + ";";
        }
      } else {
        for (var _key in obj) {
          var value = obj[_key];

          if (typeof value !== 'object') {
            if (registered != null && registered[value] !== undefined) {
              string += _key + "{" + registered[value] + "}";
            } else if (isProcessableValue(value)) {
              string += processStyleName(_key) + ":" + processStyleValue(_key, value) + ";";
            }
          } else {
            if (_key === 'NO_COMPONENT_SELECTOR' && "development" !== 'production') {
              throw new Error(noComponentSelectorMessage);
            }

            if (Array.isArray(value) && typeof value[0] === 'string' && (registered == null || registered[value[0]] === undefined)) {
              for (var _i = 0; _i < value.length; _i++) {
                if (isProcessableValue(value[_i])) {
                  string += processStyleName(_key) + ":" + processStyleValue(_key, value[_i]) + ";";
                }
              }
            } else {
              var interpolated = handleInterpolation(mergedProps, registered, value);

              switch (_key) {
                case 'animation':
                case 'animationName':
                  {
                    string += processStyleName(_key) + ":" + interpolated + ";";
                    break;
                  }

                default:
                  {
                    if (_key === 'undefined') {
                      console.error(UNDEFINED_AS_OBJECT_KEY_ERROR);
                    }

                    string += _key + "{" + interpolated + "}";
                  }
              }
            }
          }
        }
      }

      return string;
    }

    var labelPattern = /label:\s*([^\s;\n{]+)\s*(;|$)/g;
    var sourceMapPattern;

    {
      sourceMapPattern = /\/\*#\ssourceMappingURL=data:application\/json;\S+\s+\*\//g;
    } // this is the cursor for keyframes
    // keyframes are stored on the SerializedStyles object as a linked list


    var cursor;
    var serializeStyles = function serializeStyles(args, registered, mergedProps) {
      if (args.length === 1 && typeof args[0] === 'object' && args[0] !== null && args[0].styles !== undefined) {
        return args[0];
      }

      var stringMode = true;
      var styles = '';
      cursor = undefined;
      var strings = args[0];

      if (strings == null || strings.raw === undefined) {
        stringMode = false;
        styles += handleInterpolation(mergedProps, registered, strings);
      } else {
        if (strings[0] === undefined) {
          console.error(ILLEGAL_ESCAPE_SEQUENCE_ERROR$1);
        }

        styles += strings[0];
      } // we start at 1 since we've already handled the first arg


      for (var i = 1; i < args.length; i++) {
        styles += handleInterpolation(mergedProps, registered, args[i]);

        if (stringMode) {
          if (strings[i] === undefined) {
            console.error(ILLEGAL_ESCAPE_SEQUENCE_ERROR$1);
          }

          styles += strings[i];
        }
      }

      var sourceMap;

      {
        styles = styles.replace(sourceMapPattern, function (match) {
          sourceMap = match;
          return '';
        });
      } // using a global regex with .exec is stateful so lastIndex has to be reset each time


      labelPattern.lastIndex = 0;
      var identifierName = '';
      var match; // https://esbench.com/bench/5b809c2cf2949800a0f61fb5

      while ((match = labelPattern.exec(styles)) !== null) {
        identifierName += '-' + // $FlowFixMe we know it's not null
        match[1];
      }

      var name = murmur2(styles) + identifierName;

      {
        // $FlowFixMe SerializedStyles type doesn't have toString property (and we don't want to add it)
        return {
          name: name,
          styles: styles,
          map: sourceMap,
          next: cursor,
          toString: function toString() {
            return "You have tried to stringify object returned from `css` function. It isn't supposed to be used directly (e.g. as value of the `className` prop), but rather handed to emotion so it can handle it (e.g. as value of `css` prop).";
          }
        };
      }
    };

    var isBrowser$2 = typeof document !== 'undefined';
    var hasOwnProperty$4 = {}.hasOwnProperty;

    var EmotionCacheContext = /* #__PURE__ */React.createContext( // we're doing this to avoid preconstruct's dead code elimination in this one case
    // because this module is primarily intended for the browser and node
    // but it's also required in react native and similar environments sometimes
    // and we could have a special build just for that
    // but this is much easier and the native packages
    // might use a different theme context in the future anyway
    typeof HTMLElement !== 'undefined' ? /* #__PURE__ */createCache({
      key: 'css'
    }) : null);

    {
      EmotionCacheContext.displayName = 'EmotionCacheContext';
    }

    EmotionCacheContext.Provider;

    var withEmotionCache = function withEmotionCache(func) {
      // $FlowFixMe
      return /*#__PURE__*/React.forwardRef(function (props, ref) {
        // the cache will never be null in the browser
        var cache = React.useContext(EmotionCacheContext);
        return func(props, cache, ref);
      });
    };

    if (!isBrowser$2) {
      withEmotionCache = function withEmotionCache(func) {
        return function (props) {
          var cache = React.useContext(EmotionCacheContext);

          if (cache === null) {
            // yes, we're potentially creating this on every render
            // it doesn't actually matter though since it's only on the server
            // so there will only every be a single render
            // that could change in the future because of suspense and etc. but for now,
            // this works and i don't want to optimise for a future thing that we aren't sure about
            cache = createCache({
              key: 'css'
            });
            return /*#__PURE__*/React.createElement(EmotionCacheContext.Provider, {
              value: cache
            }, func(props, cache));
          } else {
            return func(props, cache);
          }
        };
      };
    }

    var ThemeContext = /* #__PURE__ */React.createContext({});

    {
      ThemeContext.displayName = 'EmotionThemeContext';
    }

    var isBrowser$1$1 = typeof document !== 'undefined';
    var useInsertionEffect$1 = React__namespace$1['useInsertion' + 'Effect'] ? React__namespace$1['useInsertion' + 'Effect'] : function useInsertionEffect(create) {
      create();
    };
    function useInsertionEffectMaybe$1(create) {
      if (!isBrowser$1$1) {
        return create();
      }

      useInsertionEffect$1(create);
    }

    var typePropName = '__EMOTION_TYPE_PLEASE_DO_NOT_USE__';
    var labelPropName = '__EMOTION_LABEL_PLEASE_DO_NOT_USE__';

    var Insertion$1 = function Insertion(_ref) {
      var cache = _ref.cache,
          serialized = _ref.serialized,
          isStringTag = _ref.isStringTag;
      registerStyles(cache, serialized, isStringTag);
      var rules = useInsertionEffectMaybe$1(function () {
        return insertStyles(cache, serialized, isStringTag);
      });

      if (!isBrowser$2 && rules !== undefined) {
        var _ref2;

        var serializedNames = serialized.name;
        var next = serialized.next;

        while (next !== undefined) {
          serializedNames += ' ' + next.name;
          next = next.next;
        }

        return /*#__PURE__*/React.createElement("style", (_ref2 = {}, _ref2["data-emotion"] = cache.key + " " + serializedNames, _ref2.dangerouslySetInnerHTML = {
          __html: rules
        }, _ref2.nonce = cache.sheet.nonce, _ref2));
      }

      return null;
    };

    var Emotion = /* #__PURE__ */withEmotionCache(function (props, cache, ref) {
      var cssProp = props.css; // so that using `css` from `emotion` and passing the result to the css prop works
      // not passing the registered cache to serializeStyles because it would
      // make certain babel optimisations not possible

      if (typeof cssProp === 'string' && cache.registered[cssProp] !== undefined) {
        cssProp = cache.registered[cssProp];
      }

      var WrappedComponent = props[typePropName];
      var registeredStyles = [cssProp];
      var className = '';

      if (typeof props.className === 'string') {
        className = getRegisteredStyles(cache.registered, registeredStyles, props.className);
      } else if (props.className != null) {
        className = props.className + " ";
      }

      var serialized = serializeStyles(registeredStyles, undefined, React.useContext(ThemeContext));

      if (serialized.name.indexOf('-') === -1) {
        var labelFromStack = props[labelPropName];

        if (labelFromStack) {
          serialized = serializeStyles([serialized, 'label:' + labelFromStack + ';']);
        }
      }

      className += cache.key + "-" + serialized.name;
      var newProps = {};

      for (var key in props) {
        if (hasOwnProperty$4.call(props, key) && key !== 'css' && key !== typePropName && (key !== labelPropName)) {
          newProps[key] = props[key];
        }
      }

      newProps.ref = ref;
      newProps.className = className;
      return /*#__PURE__*/React.createElement(React.Fragment, null, /*#__PURE__*/React.createElement(Insertion$1, {
        cache: cache,
        serialized: serialized,
        isStringTag: typeof WrappedComponent === 'string'
      }), /*#__PURE__*/React.createElement(WrappedComponent, newProps));
    });

    {
      Emotion.displayName = 'EmotionCssPropInternal';
    }

    var testOmitPropsOnStringTag = isPropValid;

    var testOmitPropsOnComponent = function testOmitPropsOnComponent(key) {
      return key !== 'theme';
    };

    var getDefaultShouldForwardProp = function getDefaultShouldForwardProp(tag) {
      return typeof tag === 'string' && // 96 is one less than the char code
      // for "a" so this is checking that
      // it's a lowercase character
      tag.charCodeAt(0) > 96 ? testOmitPropsOnStringTag : testOmitPropsOnComponent;
    };
    var composeShouldForwardProps = function composeShouldForwardProps(tag, options, isReal) {
      var shouldForwardProp;

      if (options) {
        var optionsShouldForwardProp = options.shouldForwardProp;
        shouldForwardProp = tag.__emotion_forwardProp && optionsShouldForwardProp ? function (propName) {
          return tag.__emotion_forwardProp(propName) && optionsShouldForwardProp(propName);
        } : optionsShouldForwardProp;
      }

      if (typeof shouldForwardProp !== 'function' && isReal) {
        shouldForwardProp = tag.__emotion_forwardProp;
      }

      return shouldForwardProp;
    };

    var isBrowser = typeof document !== 'undefined';
    var useInsertionEffect = React__namespace$1['useInsertion' + 'Effect'] ? React__namespace$1['useInsertion' + 'Effect'] : function useInsertionEffect(create) {
      create();
    };
    function useInsertionEffectMaybe(create) {
      if (!isBrowser) {
        return create();
      }

      useInsertionEffect(create);
    }

    var ILLEGAL_ESCAPE_SEQUENCE_ERROR = "You have illegal escape sequence in your template literal, most likely inside content's property value.\nBecause you write your CSS inside a JavaScript string you actually have to do double escaping, so for example \"content: '\\00d7';\" should become \"content: '\\\\00d7';\".\nYou can read more about this here:\nhttps://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Template_literals#ES2018_revision_of_illegal_escape_sequences";
    var isBrowser$1 = typeof document !== 'undefined';

    var Insertion = function Insertion(_ref) {
      var cache = _ref.cache,
          serialized = _ref.serialized,
          isStringTag = _ref.isStringTag;
      registerStyles(cache, serialized, isStringTag);
      var rules = useInsertionEffectMaybe(function () {
        return insertStyles(cache, serialized, isStringTag);
      });

      if (!isBrowser$1 && rules !== undefined) {
        var _ref2;

        var serializedNames = serialized.name;
        var next = serialized.next;

        while (next !== undefined) {
          serializedNames += ' ' + next.name;
          next = next.next;
        }

        return /*#__PURE__*/React.createElement("style", (_ref2 = {}, _ref2["data-emotion"] = cache.key + " " + serializedNames, _ref2.dangerouslySetInnerHTML = {
          __html: rules
        }, _ref2.nonce = cache.sheet.nonce, _ref2));
      }

      return null;
    };

    var createStyled = function createStyled(tag, options) {
      {
        if (tag === undefined) {
          throw new Error('You are trying to create a styled element with an undefined component.\nYou may have forgotten to import it.');
        }
      }

      var isReal = tag.__emotion_real === tag;
      var baseTag = isReal && tag.__emotion_base || tag;
      var identifierName;
      var targetClassName;

      if (options !== undefined) {
        identifierName = options.label;
        targetClassName = options.target;
      }

      var shouldForwardProp = composeShouldForwardProps(tag, options, isReal);
      var defaultShouldForwardProp = shouldForwardProp || getDefaultShouldForwardProp(baseTag);
      var shouldUseAs = !defaultShouldForwardProp('as');
      return function () {
        var args = arguments;
        var styles = isReal && tag.__emotion_styles !== undefined ? tag.__emotion_styles.slice(0) : [];

        if (identifierName !== undefined) {
          styles.push("label:" + identifierName + ";");
        }

        if (args[0] == null || args[0].raw === undefined) {
          styles.push.apply(styles, args);
        } else {
          if (args[0][0] === undefined) {
            console.error(ILLEGAL_ESCAPE_SEQUENCE_ERROR);
          }

          styles.push(args[0][0]);
          var len = args.length;
          var i = 1;

          for (; i < len; i++) {
            if (args[0][i] === undefined) {
              console.error(ILLEGAL_ESCAPE_SEQUENCE_ERROR);
            }

            styles.push(args[i], args[0][i]);
          }
        } // $FlowFixMe: we need to cast StatelessFunctionalComponent to our PrivateStyledComponent class


        var Styled = withEmotionCache(function (props, cache, ref) {
          var FinalTag = shouldUseAs && props.as || baseTag;
          var className = '';
          var classInterpolations = [];
          var mergedProps = props;

          if (props.theme == null) {
            mergedProps = {};

            for (var key in props) {
              mergedProps[key] = props[key];
            }

            mergedProps.theme = React.useContext(ThemeContext);
          }

          if (typeof props.className === 'string') {
            className = getRegisteredStyles(cache.registered, classInterpolations, props.className);
          } else if (props.className != null) {
            className = props.className + " ";
          }

          var serialized = serializeStyles(styles.concat(classInterpolations), cache.registered, mergedProps);
          className += cache.key + "-" + serialized.name;

          if (targetClassName !== undefined) {
            className += " " + targetClassName;
          }

          var finalShouldForwardProp = shouldUseAs && shouldForwardProp === undefined ? getDefaultShouldForwardProp(FinalTag) : defaultShouldForwardProp;
          var newProps = {};

          for (var _key in props) {
            if (shouldUseAs && _key === 'as') continue;

            if ( // $FlowFixMe
            finalShouldForwardProp(_key)) {
              newProps[_key] = props[_key];
            }
          }

          newProps.className = className;
          newProps.ref = ref;
          return /*#__PURE__*/React.createElement(React.Fragment, null, /*#__PURE__*/React.createElement(Insertion, {
            cache: cache,
            serialized: serialized,
            isStringTag: typeof FinalTag === 'string'
          }), /*#__PURE__*/React.createElement(FinalTag, newProps));
        });
        Styled.displayName = identifierName !== undefined ? identifierName : "Styled(" + (typeof baseTag === 'string' ? baseTag : baseTag.displayName || baseTag.name || 'Component') + ")";
        Styled.defaultProps = tag.defaultProps;
        Styled.__emotion_real = Styled;
        Styled.__emotion_base = baseTag;
        Styled.__emotion_styles = styles;
        Styled.__emotion_forwardProp = shouldForwardProp;
        Object.defineProperty(Styled, 'toString', {
          value: function value() {
            if (targetClassName === undefined && "development" !== 'production') {
              return 'NO_COMPONENT_SELECTOR';
            } // $FlowFixMe: coerce undefined to string


            return "." + targetClassName;
          }
        });

        Styled.withComponent = function (nextTag, nextOptions) {
          return createStyled(nextTag, _extends({}, options, nextOptions, {
            shouldForwardProp: composeShouldForwardProps(Styled, nextOptions, true)
          })).apply(void 0, styles);
        };

        return Styled;
      };
    };

    var tags = ['a', 'abbr', 'address', 'area', 'article', 'aside', 'audio', 'b', 'base', 'bdi', 'bdo', 'big', 'blockquote', 'body', 'br', 'button', 'canvas', 'caption', 'cite', 'code', 'col', 'colgroup', 'data', 'datalist', 'dd', 'del', 'details', 'dfn', 'dialog', 'div', 'dl', 'dt', 'em', 'embed', 'fieldset', 'figcaption', 'figure', 'footer', 'form', 'h1', 'h2', 'h3', 'h4', 'h5', 'h6', 'head', 'header', 'hgroup', 'hr', 'html', 'i', 'iframe', 'img', 'input', 'ins', 'kbd', 'keygen', 'label', 'legend', 'li', 'link', 'main', 'map', 'mark', 'marquee', 'menu', 'menuitem', 'meta', 'meter', 'nav', 'noscript', 'object', 'ol', 'optgroup', 'option', 'output', 'p', 'param', 'picture', 'pre', 'progress', 'q', 'rp', 'rt', 'ruby', 's', 'samp', 'script', 'section', 'select', 'small', 'source', 'span', 'strong', 'style', 'sub', 'summary', 'sup', 'table', 'tbody', 'td', 'textarea', 'tfoot', 'th', 'thead', 'time', 'title', 'tr', 'track', 'u', 'ul', 'var', 'video', 'wbr', // SVG
    'circle', 'clipPath', 'defs', 'ellipse', 'foreignObject', 'g', 'image', 'line', 'linearGradient', 'mask', 'path', 'pattern', 'polygon', 'polyline', 'radialGradient', 'rect', 'stop', 'svg', 'text', 'tspan'];

    var newStyled = createStyled.bind();
    tags.forEach(function (tagName) {
      // $FlowFixMe: we can ignore this because its exposed type is defined by the CreateStyled type
      newStyled[tagName] = newStyled(tagName);
    });

    const paraGraphDefaultStyle = {
        fontSize: 13,
        lineHeight: '20px',
    };
    const Button = newStyled.button `
  appearance: none;
  margin: 0;
  border: 0;
  color: white;
  padding: 5px !important;
  border-radius: 0 !important;
  background: ${(props) => props.hideBackground ? `` : `${colors.blue} !important`};
  transition: 0.2s all;

  &:hover {
    background: ${colors.lightBlue};
  }
`;
    const CircleButton = newStyled(Button) `
  font-size: 14px;
  font-weight: bold;
  margin: 0 4px 0 auto;
  background: none !important;
  display: flex;
  width: 25px;
  height: 25px;
  justify-content: center;
  line-height: 14px !important;
  border-radius: 50% !important;
  padding: 0 !important;
  transition: 0.2s all;

  &:hover {
    background: ${colors.lightBlue};
  }

  &:active {
    background: black;
  }
`;
    const Input = newStyled.input `
  &::placeholder {
    color: #b3b3b3;
  }

  &:focus::placeholder {
    color: white;
  }
`;
    const Table = newStyled.table `
  transition: 0.3s all;

  &:hover {
    background: ${colors.primary};
  }
`;

    const Header = ({ setVisible, control }) => {
        const { isValid } = useFormState({
            control,
        });
        return (React__namespace$1.createElement("header", { style: {
                display: 'flex',
                alignItems: 'center',
                paddingLeft: 10,
                backgroundColor: 'transparent',
            } },
            React__namespace$1.createElement("p", { style: Object.assign(Object.assign({}, paraGraphDefaultStyle), { margin: 0, padding: 0, fontWeight: 400, fontSize: 12 }) },
                React__namespace$1.createElement("span", { style: {
                        transition: '0.5s all',
                        color: isValid ? colors.green : colors.lightPink,
                    } }, "\u25A0"),
                ' ',
                "React Hook Form"),
            React__namespace$1.createElement(CircleButton, { title: "Close dev panel", onClick: () => setVisible(false) }, "\u2715")));
    };

    /**
     * Checks if `value` is `undefined`.
     *
     * @static
     * @since 0.1.0
     * @memberOf _
     * @category Lang
     * @param {*} value The value to check.
     * @returns {boolean} Returns `true` if `value` is `undefined`, else `false`.
     * @example
     *
     * _.isUndefined(void 0);
     * // => true
     *
     * _.isUndefined(null);
     * // => false
     */
    function isUndefined(value) {
      return value === undefined;
    }

    var isUndefined_1 = isUndefined;

    /**
     * Checks if `value` is the
     * [language type](http://www.ecma-international.org/ecma-262/7.0/#sec-ecmascript-language-types)
     * of `Object`. (e.g. arrays, functions, objects, regexes, `new Number(0)`, and `new String('')`)
     *
     * @static
     * @memberOf _
     * @since 0.1.0
     * @category Lang
     * @param {*} value The value to check.
     * @returns {boolean} Returns `true` if `value` is an object, else `false`.
     * @example
     *
     * _.isObject({});
     * // => true
     *
     * _.isObject([1, 2, 3]);
     * // => true
     *
     * _.isObject(_.noop);
     * // => true
     *
     * _.isObject(null);
     * // => false
     */
    function isObject(value) {
      var type = typeof value;
      return value != null && (type == 'object' || type == 'function');
    }

    var isObject_1 = isObject;

    const PanelTable = ({ refObject, hasError, isDirty, fieldsValues, isNative, errorMessage, errorType, type, isTouched, name, collapseAll, }) => {
        const [collapse, setCollapse] = React__namespace$1.useState(false);
        React__namespace$1.useEffect(() => {
            setCollapse(!collapseAll);
        }, [collapseAll]);
        let value = fieldsValues ? get$1(fieldsValues, name) : '';
        let isValueWrappedInPre = false;
        if (!isUndefined_1(value)) {
            if (isObject_1(value)) {
                try {
                    value = (React__namespace$1.createElement("pre", { style: { margin: 0 } },
                        React__namespace$1.createElement("code", { style: { fontSize: 12 } }, JSON.stringify(value, null, 2))));
                    isValueWrappedInPre = true;
                }
                catch (_a) {
                    value = React__namespace$1.createElement("span", null, "[Nested Object]");
                }
            }
            else if (typeof value !== 'string') {
                value = String(value);
            }
        }
        return (React__namespace$1.createElement(Table, { style: {
                padding: '5px 8px',
                width: '100%',
                transition: '.3s all',
                borderLeft: `2px solid ${hasError ? colors.secondary : colors.buttonBlue}`,
                background: 'none',
            } },
            React__namespace$1.createElement("thead", null,
                React__namespace$1.createElement("tr", null,
                    React__namespace$1.createElement("td", { valign: "top", style: { width: 85, lineHeight: '22px' } },
                        React__namespace$1.createElement(Button, { onClick: () => setCollapse(!collapse), title: "Toggle field table", style: {
                                border: `1px solid ${colors.lightBlue}`,
                                borderRadius: 2,
                                padding: '3px 5px',
                                display: 'inline-block',
                                fontSize: 9,
                                lineHeight: '13px',
                                width: 20,
                                textAlign: 'center',
                                marginRight: 8,
                            }, type: "button" }, collapse ? '+' : '-'),
                        React__namespace$1.createElement(Button, { onClick: () => {
                                if (refObject.scrollIntoView) {
                                    refObject.scrollIntoView({ behavior: 'smooth' });
                                }
                            }, title: "Scroll into view", style: Object.assign({ border: `1px solid ${colors.lightBlue}`, borderRadius: 2, padding: '3px 5px', display: 'inline-block', fontSize: 9, lineHeight: '13px', textAlign: 'center', width: 'calc(100% - 30px)' }, (isNative
                                ? {}
                                : { cursor: 'not-allowed', background: colors.lightBlue })), type: "button" }, isNative ? 'Native' : 'Custom')),
                    React__namespace$1.createElement("td", { style: {
                            display: 'block',
                            maxWidth: 140,
                        } },
                        React__namespace$1.createElement("p", { style: Object.assign(Object.assign({ margin: 0, padding: 0, top: 0, position: 'relative', whiteSpace: 'nowrap', overflow: 'hidden', textOverflow: 'ellipsis' }, paraGraphDefaultStyle), { lineHeight: '24px' }), title: name }, name)))),
            !collapse && (React__namespace$1.createElement("tbody", null,
                type && (React__namespace$1.createElement("tr", null,
                    React__namespace$1.createElement("td", { align: "right", style: Object.assign({ paddingRight: 5, fontWeight: 500, verticalAlign: 'top' }, paraGraphDefaultStyle) }, "Type:"),
                    React__namespace$1.createElement("td", { style: Object.assign({ display: 'block', maxWidth: 100 }, paraGraphDefaultStyle) }, type))),
                errorType && (React__namespace$1.createElement("tr", null,
                    React__namespace$1.createElement("td", { align: "right", style: Object.assign({ paddingRight: 5, fontWeight: 500, verticalAlign: 'top' }, paraGraphDefaultStyle) }, "ERROR Type:"),
                    React__namespace$1.createElement("td", { style: Object.assign({ display: 'block', maxWidth: 100 }, paraGraphDefaultStyle) }, errorType))),
                errorMessage && (React__namespace$1.createElement("tr", null,
                    React__namespace$1.createElement("td", { align: "right", style: Object.assign({ paddingRight: 5, fontWeight: 500, verticalAlign: 'top' }, paraGraphDefaultStyle) }, "MESSAGE:"),
                    React__namespace$1.createElement("td", { style: Object.assign({ display: 'block', maxWidth: 100 }, paraGraphDefaultStyle) }, typeof errorMessage === 'string'
                        ? errorMessage.trim()
                        : JSON.stringify(errorMessage)))),
                !isUndefined_1(value) && (React__namespace$1.createElement("tr", null,
                    React__namespace$1.createElement("td", { align: "right", style: Object.assign({ paddingRight: 5, fontWeight: 500, verticalAlign: 'top' }, paraGraphDefaultStyle) }, "Value:"),
                    React__namespace$1.createElement("td", { "data-testid": `${name}-field-value`, style: Object.assign({ display: 'block', maxWidth: 100 }, paraGraphDefaultStyle) },
                        !isValueWrappedInPre && (React__namespace$1.createElement("p", { title: value, style: Object.assign(Object.assign({}, paraGraphDefaultStyle), { margin: 0, padding: 0 }) }, value)),
                        isValueWrappedInPre && (React__namespace$1.createElement("div", { style: Object.assign(Object.assign({}, paraGraphDefaultStyle), { margin: 0, padding: 0 }) }, value))))),
                React__namespace$1.createElement("tr", null,
                    React__namespace$1.createElement("td", { align: "right", style: Object.assign({ paddingRight: 5, fontWeight: 500, verticalAlign: 'top' }, paraGraphDefaultStyle) }, "Touched:"),
                    React__namespace$1.createElement("td", null,
                        React__namespace$1.createElement("code", { style: Object.assign(Object.assign({ color: isTouched ? colors.green : colors.lightPink }, paraGraphDefaultStyle), { fontSize: 12 }) }, isTouched ? 'true' : 'false'))),
                React__namespace$1.createElement("tr", null,
                    React__namespace$1.createElement("td", { align: "right", style: Object.assign({ paddingRight: 5, fontWeight: 500, verticalAlign: 'top' }, paraGraphDefaultStyle) }, "Dirty:"),
                    React__namespace$1.createElement("td", null,
                        React__namespace$1.createElement("code", { style: Object.assign(Object.assign({ color: isDirty ? colors.green : colors.lightPink }, paraGraphDefaultStyle), { fontSize: 12 }) }, isDirty ? 'true' : 'false')))))));
    };

    const FormStateTable = ({ formState, showFormState, setShowFormState, }) => (React__namespace$1.createElement("div", { style: {
            alignSelf: 'end',
        } },
        React__namespace$1.createElement(Animate_1, { play: showFormState, start: { opacity: 0 }, end: { opacity: 1 }, render: ({ style }) => (React__namespace$1.createElement("table", { style: Object.assign({ padding: '5px 10px', display: 'block', background: 'black', borderTop: `1px solid ${colors.lightPink}`, pointerEvents: 'none' }, style) },
                React__namespace$1.createElement("tbody", null,
                    React__namespace$1.createElement("tr", null,
                        React__namespace$1.createElement("td", { align: "right", style: Object.assign({ width: 90 }, paraGraphDefaultStyle) }, "Valid:"),
                        React__namespace$1.createElement("td", { style: Object.assign({ color: formState.isValid ? colors.green : colors.lightPink }, paraGraphDefaultStyle) }, formState.isValid ? 'true' : 'false')),
                    React__namespace$1.createElement("tr", null,
                        React__namespace$1.createElement("td", { align: "right", style: Object.assign({}, paraGraphDefaultStyle) }, "Dirty:"),
                        React__namespace$1.createElement("td", { style: Object.assign({ color: formState.isDirty ? colors.green : colors.lightPink }, paraGraphDefaultStyle) }, formState.isDirty ? 'true' : 'false')),
                    React__namespace$1.createElement("tr", null,
                        React__namespace$1.createElement("td", { align: "right", style: Object.assign({}, paraGraphDefaultStyle) }, "Submitted:"),
                        React__namespace$1.createElement("td", { style: Object.assign({ color: formState.isSubmitted
                                    ? colors.green
                                    : colors.lightPink }, paraGraphDefaultStyle) }, formState.isSubmitted ? 'true' : 'false')),
                    React__namespace$1.createElement("tr", null,
                        React__namespace$1.createElement("td", { align: "right", style: Object.assign({}, paraGraphDefaultStyle) }, "Count:"),
                        React__namespace$1.createElement("td", { style: Object.assign({ color: formState.submitCount
                                    ? colors.green
                                    : colors.lightPink }, paraGraphDefaultStyle) }, formState.submitCount)),
                    React__namespace$1.createElement("tr", null,
                        React__namespace$1.createElement("td", { align: "right", style: Object.assign({}, paraGraphDefaultStyle) }, "Submitting:"),
                        React__namespace$1.createElement("td", { style: Object.assign({ color: formState.isSubmitting
                                    ? colors.green
                                    : colors.lightPink }, paraGraphDefaultStyle) }, formState.isSubmitting ? 'true' : 'false'))))) }),
        React__namespace$1.createElement(Button, { style: {
                margin: 0,
                width: '100%',
                padding: '8px 10px',
                textTransform: 'none',
                fontSize: 12,
                lineHeight: '14px',
                cursor: 'pointer',
            }, title: "Toggle form state panel", onClick: () => {
                setShowFormState(!showFormState);
            }, type: "button" },
            React__namespace$1.createElement("span", { style: {
                    transition: '0.5s all',
                    color: formState.isValid ? colors.green : colors.lightPink,
                } }, "\u25A0"),
            ' ',
            "Form State: ",
            showFormState ? 'OFF' : 'ON')));

    function setVisible(state, payload) {
        return Object.assign(Object.assign({}, state), { visible: payload });
    }
    function setCollapse(state, payload) {
        return Object.assign(Object.assign({}, state), { isCollapse: payload });
    }

    let childIndex = 0;
    function PanelChildren({ fields, searchTerm, touchedFields, errors, dirtyFields, state, fieldsValues, }) {
        return (React__namespace$1.createElement(React__namespace$1.Fragment, null, fields &&
            Object.entries(fields)
                .filter(([name]) => ((name &&
                name.toLowerCase &&
                name.toLowerCase().includes(searchTerm)) ||
                (!name && !searchTerm) ||
                searchTerm === '') &&
                name)
                .map(([name, value], index) => {
                childIndex++;
                if (!(value === null || value === void 0 ? void 0 : value._f)) {
                    return (React__namespace$1.createElement(PanelChildren, Object.assign({ key: name + childIndex }, {
                        fields: value,
                        searchTerm,
                        touchedFields,
                        errors,
                        dirtyFields,
                        state,
                        fieldsValues,
                    })));
                }
                else {
                    const error = get$1(errors, value._f.name);
                    const errorMessage = get$1(error, 'message', undefined);
                    const errorType = get$1(error, 'type', undefined);
                    const type = get$1(value, 'ref.type', undefined);
                    const isTouched = !!get$1(touchedFields, value._f.name);
                    const isNative = !!(value && value._f.ref.type);
                    const isDirty = !!get$1(dirtyFields, value._f.name);
                    const hasError = !!error;
                    const ref = get$1(value, '_f.ref');
                    return (React__namespace$1.createElement("section", { key: (value === null || value === void 0 ? void 0 : value._f.name) + childIndex, style: {
                            borderBottom: `1px dashed ${colors.secondary}`,
                            margin: 0,
                        } },
                        React__namespace$1.createElement(PanelTable, { refObject: ref, index: index, collapseAll: state.isCollapse, name: value === null || value === void 0 ? void 0 : value._f.name, isTouched: isTouched, type: type, hasError: hasError, isNative: isNative, errorMessage: errorMessage, errorType: errorType, isDirty: isDirty, fieldsValues: fieldsValues })));
                }
            })));
    }
    const Panel = ({ control, control: { _fields } }) => {
        const formState = useFormState({
            control,
        });
        const { dirtyFields, touchedFields, errors } = formState;
        formState.isDirty;
        const { state, actions } = a({
            setCollapse,
        });
        const [, setData] = React__namespace$1.useState({});
        const [showFormState, setShowFormState] = React__namespace$1.useState(false);
        const fieldsValues = useWatch({
            control,
        });
        const { register, watch } = useForm();
        const searchTerm = watch('search', '');
        React.useEffect(() => {
            setData({});
        }, []);
        return (React__namespace$1.createElement("div", { style: {
                display: 'grid',
                gridTemplateRows: '56px auto',
                height: 'calc(100vh - 40px)',
            } },
            React__namespace$1.createElement("div", { style: {
                    display: 'grid',
                    gridTemplateColumns: `1fr 1fr`,
                    gridTemplateRows: '28px 28px',
                } },
                React__namespace$1.createElement(Button, { style: {
                        borderRight: `1px solid ${colors.primary}`,
                        textTransform: 'none',
                        fontSize: 11,
                        lineHeight: 1,
                    }, title: "Update values and state the form", onClick: () => setData({}), type: "button" }, "\u267A REFRESH"),
                React__namespace$1.createElement(Button, { style: {
                        borderRight: `1px solid ${colors.primary}`,
                        textTransform: 'none',
                        fontSize: 11,
                        lineHeight: 1,
                    }, title: "Toggle entire fields", onClick: () => {
                        actions.setCollapse(!state.isCollapse);
                    }, type: "button" }, state.isCollapse ? '[-] COLLAPSE' : '[+] EXPAND'),
                React__namespace$1.createElement(Input, Object.assign({ style: {
                        display: 'inline-block',
                        borderRadius: 0,
                        width: '100%',
                        margin: 0,
                        padding: '5px 10px',
                        WebkitAppearance: 'none',
                        appearance: 'none',
                        fontSize: 14,
                        border: 0,
                        color: 'white',
                        gridColumnStart: 1,
                        gridColumnEnd: 4,
                        background: 'black',
                    } }, register('search'), { placeholder: "Filter name...", type: "search" }))),
            React__namespace$1.createElement("div", { style: {
                    overflow: 'auto',
                } },
                React__namespace$1.createElement(PanelChildren, { fields: _fields, searchTerm: searchTerm, errors: errors, touchedFields: touchedFields, dirtyFields: dirtyFields, fieldsValues: fieldsValues, state: state })),
            React__namespace$1.createElement(FormStateTable, { formState: formState, showFormState: showFormState, setShowFormState: setShowFormState })));
    };

    const Logo = ({ style, actions, }) => {
        return (React__namespace$1.createElement("svg", { fill: "white", viewBox: "0 0 100 100", style: Object.assign({ height: 14, padding: 3, borderRadius: 2, background: colors.lightPink }, style), onClick: () => {
                actions.setVisible(true);
            }, "aria-label": "React Hook Form Logo" },
            React__namespace$1.createElement("path", { d: "M73.56,13.32H58.14a8.54,8.54,0,0,0-16.27,0H26.44a11,11,0,0,0-11,11V81.63a11,11,0,0,0,11,11H73.56a11,11,0,0,0,11-11V24.32A11,11,0,0,0,73.56,13.32Zm-30.92,2a1,1,0,0,0,1-.79,6.54,6.54,0,0,1,12.78,0,1,1,0,0,0,1,.79h5.38v6.55a3,3,0,0,1-3,3H40.25a3,3,0,0,1-3-3V15.32ZM82.56,81.63a9,9,0,0,1-9,9H26.44a9,9,0,0,1-9-9V24.32a9,9,0,0,1,9-9h8.81v6.55a5,5,0,0,0,5,5h19.5a5,5,0,0,0,5-5V15.32h8.81a9,9,0,0,1,9,9Z" }),
            React__namespace$1.createElement("path", { style: { transform: 'translateX(-25px)' }, d: "M71.6,45.92H54a1,1,0,0,0,0,2H71.6a1,1,0,0,0,0-2Z" }),
            React__namespace$1.createElement("path", { d: "M71.6,45.92H54a1,1,0,0,0,0,2H71.6a1,1,0,0,0,0-2Z" }),
            React__namespace$1.createElement("path", { style: { transform: 'translateX(-25px)' }, d: "M71.1,69.49H53.45a1,1,0,1,0,0,2H71.1a1,1,0,0,0,0-2Z" }),
            React__namespace$1.createElement("path", { d: "M71.1,69.49H53.45a1,1,0,1,0,0,2H71.1a1,1,0,0,0,0-2Z" })));
    };

    function getPositionByPlacement(placement, defaultX = 0, defaultY = 0) {
        const [x, y] = placement.split('-');
        return {
            [x]: defaultX,
            [y]: defaultY,
        };
    }

    const DevToolUI = ({ control, placement = 'top-right', styles, }) => {
        const { state, actions } = a({
            setVisible,
        });
        const position = getPositionByPlacement(placement, 0, 0);
        return (React__namespace$1.createElement(React__namespace$1.Fragment, null,
            React__namespace$1.createElement(Animate_1, { play: state.visible, duration: 0.2, start: Object.assign(Object.assign({}, position), { position: 'fixed', transform: placement.includes('right')
                        ? 'translateX(280px)'
                        : 'translateX(-280px)', zIndex: 99999 }), end: Object.assign(Object.assign({}, position), { position: 'fixed', transform: 'translateX(0)', zIndex: 99999 }) },
                React__namespace$1.createElement("div", { style: Object.assign(Object.assign(Object.assign({}, position), { position: 'fixed', height: '100vh', width: 250, zIndex: 99999, background: colors.buttonBlue, display: 'grid', textAlign: 'left', color: 'white', fontSize: 14, gridTemplateRows: '40px auto', fontFamily: "-apple-system, BlinkMacSystemFont, 'Segoe UI', 'Roboto', 'Oxygen', 'Ubuntu', 'Cantarell', 'Fira Sans', 'Droid Sans', 'Helvetica Neue', sans-serif" }), styles === null || styles === void 0 ? void 0 : styles.panel) },
                    React__namespace$1.createElement(Header, { setVisible: actions.setVisible, control: control }),
                    React__namespace$1.createElement(Panel, { control: control }))),
            !state.visible && (React__namespace$1.createElement(Button, { title: "Show dev panel", hideBackground: true, style: Object.assign(Object.assign(Object.assign({ position: 'fixed', zIndex: 99999 }, getPositionByPlacement(placement, 3, 3)), { padding: 3, margin: 0, background: 'none' }), styles === null || styles === void 0 ? void 0 : styles.button), type: "button" },
                React__namespace$1.createElement(Logo, { actions: actions })))));
    };

    /*! *****************************************************************************
    Copyright (c) Microsoft Corporation.

    Permission to use, copy, modify, and/or distribute this software for any
    purpose with or without fee is hereby granted.

    THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES WITH
    REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY
    AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY SPECIAL, DIRECT,
    INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM
    LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR
    OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
    PERFORMANCE OF THIS SOFTWARE.
    ***************************************************************************** */

    function __rest(s, e) {
        var t = {};
        for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
            t[p] = s[p];
        if (s != null && typeof Object.getOwnPropertySymbols === "function")
            for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
                if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                    t[p[i]] = s[p[i]];
            }
        return t;
    }

    /**
     * Checks if `value` is classified as an `Array` object.
     *
     * @static
     * @memberOf _
     * @since 0.1.0
     * @category Lang
     * @param {*} value The value to check.
     * @returns {boolean} Returns `true` if `value` is an array, else `false`.
     * @example
     *
     * _.isArray([1, 2, 3]);
     * // => true
     *
     * _.isArray(document.body.children);
     * // => false
     *
     * _.isArray('abc');
     * // => false
     *
     * _.isArray(_.noop);
     * // => false
     */
    var isArray = Array.isArray;

    var isArray_1 = isArray;

    /** Detect free variable `global` from Node.js. */

    var freeGlobal = typeof commonjsGlobal == 'object' && commonjsGlobal && commonjsGlobal.Object === Object && commonjsGlobal;

    var _freeGlobal = freeGlobal;

    /** Detect free variable `self`. */
    var freeSelf = typeof self == 'object' && self && self.Object === Object && self;

    /** Used as a reference to the global object. */
    var root = _freeGlobal || freeSelf || Function('return this')();

    var _root = root;

    /** Built-in value references. */
    var Symbol = _root.Symbol;

    var _Symbol = Symbol;

    /** Used for built-in method references. */
    var objectProto$4 = Object.prototype;

    /** Used to check objects for own properties. */
    var hasOwnProperty$3 = objectProto$4.hasOwnProperty;

    /**
     * Used to resolve the
     * [`toStringTag`](http://ecma-international.org/ecma-262/7.0/#sec-object.prototype.tostring)
     * of values.
     */
    var nativeObjectToString$1 = objectProto$4.toString;

    /** Built-in value references. */
    var symToStringTag$1 = _Symbol ? _Symbol.toStringTag : undefined;

    /**
     * A specialized version of `baseGetTag` which ignores `Symbol.toStringTag` values.
     *
     * @private
     * @param {*} value The value to query.
     * @returns {string} Returns the raw `toStringTag`.
     */
    function getRawTag(value) {
      var isOwn = hasOwnProperty$3.call(value, symToStringTag$1),
          tag = value[symToStringTag$1];

      try {
        value[symToStringTag$1] = undefined;
        var unmasked = true;
      } catch (e) {}

      var result = nativeObjectToString$1.call(value);
      if (unmasked) {
        if (isOwn) {
          value[symToStringTag$1] = tag;
        } else {
          delete value[symToStringTag$1];
        }
      }
      return result;
    }

    var _getRawTag = getRawTag;

    /** Used for built-in method references. */
    var objectProto$3 = Object.prototype;

    /**
     * Used to resolve the
     * [`toStringTag`](http://ecma-international.org/ecma-262/7.0/#sec-object.prototype.tostring)
     * of values.
     */
    var nativeObjectToString = objectProto$3.toString;

    /**
     * Converts `value` to a string using `Object.prototype.toString`.
     *
     * @private
     * @param {*} value The value to convert.
     * @returns {string} Returns the converted string.
     */
    function objectToString(value) {
      return nativeObjectToString.call(value);
    }

    var _objectToString = objectToString;

    /** `Object#toString` result references. */
    var nullTag = '[object Null]',
        undefinedTag = '[object Undefined]';

    /** Built-in value references. */
    var symToStringTag = _Symbol ? _Symbol.toStringTag : undefined;

    /**
     * The base implementation of `getTag` without fallbacks for buggy environments.
     *
     * @private
     * @param {*} value The value to query.
     * @returns {string} Returns the `toStringTag`.
     */
    function baseGetTag(value) {
      if (value == null) {
        return value === undefined ? undefinedTag : nullTag;
      }
      return (symToStringTag && symToStringTag in Object(value))
        ? _getRawTag(value)
        : _objectToString(value);
    }

    var _baseGetTag = baseGetTag;

    /**
     * Checks if `value` is object-like. A value is object-like if it's not `null`
     * and has a `typeof` result of "object".
     *
     * @static
     * @memberOf _
     * @since 4.0.0
     * @category Lang
     * @param {*} value The value to check.
     * @returns {boolean} Returns `true` if `value` is object-like, else `false`.
     * @example
     *
     * _.isObjectLike({});
     * // => true
     *
     * _.isObjectLike([1, 2, 3]);
     * // => true
     *
     * _.isObjectLike(_.noop);
     * // => false
     *
     * _.isObjectLike(null);
     * // => false
     */
    function isObjectLike(value) {
      return value != null && typeof value == 'object';
    }

    var isObjectLike_1 = isObjectLike;

    /** `Object#toString` result references. */
    var symbolTag = '[object Symbol]';

    /**
     * Checks if `value` is classified as a `Symbol` primitive or object.
     *
     * @static
     * @memberOf _
     * @since 4.0.0
     * @category Lang
     * @param {*} value The value to check.
     * @returns {boolean} Returns `true` if `value` is a symbol, else `false`.
     * @example
     *
     * _.isSymbol(Symbol.iterator);
     * // => true
     *
     * _.isSymbol('abc');
     * // => false
     */
    function isSymbol(value) {
      return typeof value == 'symbol' ||
        (isObjectLike_1(value) && _baseGetTag(value) == symbolTag);
    }

    var isSymbol_1 = isSymbol;

    /** Used to match property names within property paths. */
    var reIsDeepProp = /\.|\[(?:[^[\]]*|(["'])(?:(?!\1)[^\\]|\\.)*?\1)\]/,
        reIsPlainProp = /^\w*$/;

    /**
     * Checks if `value` is a property name and not a property path.
     *
     * @private
     * @param {*} value The value to check.
     * @param {Object} [object] The object to query keys on.
     * @returns {boolean} Returns `true` if `value` is a property name, else `false`.
     */
    function isKey(value, object) {
      if (isArray_1(value)) {
        return false;
      }
      var type = typeof value;
      if (type == 'number' || type == 'symbol' || type == 'boolean' ||
          value == null || isSymbol_1(value)) {
        return true;
      }
      return reIsPlainProp.test(value) || !reIsDeepProp.test(value) ||
        (object != null && value in Object(object));
    }

    var _isKey = isKey;

    /** `Object#toString` result references. */
    var asyncTag = '[object AsyncFunction]',
        funcTag = '[object Function]',
        genTag = '[object GeneratorFunction]',
        proxyTag = '[object Proxy]';

    /**
     * Checks if `value` is classified as a `Function` object.
     *
     * @static
     * @memberOf _
     * @since 0.1.0
     * @category Lang
     * @param {*} value The value to check.
     * @returns {boolean} Returns `true` if `value` is a function, else `false`.
     * @example
     *
     * _.isFunction(_);
     * // => true
     *
     * _.isFunction(/abc/);
     * // => false
     */
    function isFunction(value) {
      if (!isObject_1(value)) {
        return false;
      }
      // The use of `Object#toString` avoids issues with the `typeof` operator
      // in Safari 9 which returns 'object' for typed arrays and other constructors.
      var tag = _baseGetTag(value);
      return tag == funcTag || tag == genTag || tag == asyncTag || tag == proxyTag;
    }

    var isFunction_1 = isFunction;

    /** Used to detect overreaching core-js shims. */
    var coreJsData = _root['__core-js_shared__'];

    var _coreJsData = coreJsData;

    /** Used to detect methods masquerading as native. */
    var maskSrcKey = (function() {
      var uid = /[^.]+$/.exec(_coreJsData && _coreJsData.keys && _coreJsData.keys.IE_PROTO || '');
      return uid ? ('Symbol(src)_1.' + uid) : '';
    }());

    /**
     * Checks if `func` has its source masked.
     *
     * @private
     * @param {Function} func The function to check.
     * @returns {boolean} Returns `true` if `func` is masked, else `false`.
     */
    function isMasked(func) {
      return !!maskSrcKey && (maskSrcKey in func);
    }

    var _isMasked = isMasked;

    /** Used for built-in method references. */
    var funcProto$1 = Function.prototype;

    /** Used to resolve the decompiled source of functions. */
    var funcToString$1 = funcProto$1.toString;

    /**
     * Converts `func` to its source code.
     *
     * @private
     * @param {Function} func The function to convert.
     * @returns {string} Returns the source code.
     */
    function toSource(func) {
      if (func != null) {
        try {
          return funcToString$1.call(func);
        } catch (e) {}
        try {
          return (func + '');
        } catch (e) {}
      }
      return '';
    }

    var _toSource = toSource;

    /**
     * Used to match `RegExp`
     * [syntax characters](http://ecma-international.org/ecma-262/7.0/#sec-patterns).
     */
    var reRegExpChar = /[\\^$.*+?()[\]{}|]/g;

    /** Used to detect host constructors (Safari). */
    var reIsHostCtor = /^\[object .+?Constructor\]$/;

    /** Used for built-in method references. */
    var funcProto = Function.prototype,
        objectProto$2 = Object.prototype;

    /** Used to resolve the decompiled source of functions. */
    var funcToString = funcProto.toString;

    /** Used to check objects for own properties. */
    var hasOwnProperty$2 = objectProto$2.hasOwnProperty;

    /** Used to detect if a method is native. */
    var reIsNative = RegExp('^' +
      funcToString.call(hasOwnProperty$2).replace(reRegExpChar, '\\$&')
      .replace(/hasOwnProperty|(function).*?(?=\\\()| for .+?(?=\\\])/g, '$1.*?') + '$'
    );

    /**
     * The base implementation of `_.isNative` without bad shim checks.
     *
     * @private
     * @param {*} value The value to check.
     * @returns {boolean} Returns `true` if `value` is a native function,
     *  else `false`.
     */
    function baseIsNative(value) {
      if (!isObject_1(value) || _isMasked(value)) {
        return false;
      }
      var pattern = isFunction_1(value) ? reIsNative : reIsHostCtor;
      return pattern.test(_toSource(value));
    }

    var _baseIsNative = baseIsNative;

    /**
     * Gets the value at `key` of `object`.
     *
     * @private
     * @param {Object} [object] The object to query.
     * @param {string} key The key of the property to get.
     * @returns {*} Returns the property value.
     */
    function getValue(object, key) {
      return object == null ? undefined : object[key];
    }

    var _getValue = getValue;

    /**
     * Gets the native function at `key` of `object`.
     *
     * @private
     * @param {Object} object The object to query.
     * @param {string} key The key of the method to get.
     * @returns {*} Returns the function if it's native, else `undefined`.
     */
    function getNative(object, key) {
      var value = _getValue(object, key);
      return _baseIsNative(value) ? value : undefined;
    }

    var _getNative = getNative;

    /* Built-in method references that are verified to be native. */
    var nativeCreate = _getNative(Object, 'create');

    var _nativeCreate = nativeCreate;

    /**
     * Removes all key-value entries from the hash.
     *
     * @private
     * @name clear
     * @memberOf Hash
     */
    function hashClear() {
      this.__data__ = _nativeCreate ? _nativeCreate(null) : {};
      this.size = 0;
    }

    var _hashClear = hashClear;

    /**
     * Removes `key` and its value from the hash.
     *
     * @private
     * @name delete
     * @memberOf Hash
     * @param {Object} hash The hash to modify.
     * @param {string} key The key of the value to remove.
     * @returns {boolean} Returns `true` if the entry was removed, else `false`.
     */
    function hashDelete(key) {
      var result = this.has(key) && delete this.__data__[key];
      this.size -= result ? 1 : 0;
      return result;
    }

    var _hashDelete = hashDelete;

    /** Used to stand-in for `undefined` hash values. */
    var HASH_UNDEFINED$1 = '__lodash_hash_undefined__';

    /** Used for built-in method references. */
    var objectProto$1 = Object.prototype;

    /** Used to check objects for own properties. */
    var hasOwnProperty$1 = objectProto$1.hasOwnProperty;

    /**
     * Gets the hash value for `key`.
     *
     * @private
     * @name get
     * @memberOf Hash
     * @param {string} key The key of the value to get.
     * @returns {*} Returns the entry value.
     */
    function hashGet(key) {
      var data = this.__data__;
      if (_nativeCreate) {
        var result = data[key];
        return result === HASH_UNDEFINED$1 ? undefined : result;
      }
      return hasOwnProperty$1.call(data, key) ? data[key] : undefined;
    }

    var _hashGet = hashGet;

    /** Used for built-in method references. */
    var objectProto = Object.prototype;

    /** Used to check objects for own properties. */
    var hasOwnProperty = objectProto.hasOwnProperty;

    /**
     * Checks if a hash value for `key` exists.
     *
     * @private
     * @name has
     * @memberOf Hash
     * @param {string} key The key of the entry to check.
     * @returns {boolean} Returns `true` if an entry for `key` exists, else `false`.
     */
    function hashHas(key) {
      var data = this.__data__;
      return _nativeCreate ? (data[key] !== undefined) : hasOwnProperty.call(data, key);
    }

    var _hashHas = hashHas;

    /** Used to stand-in for `undefined` hash values. */
    var HASH_UNDEFINED = '__lodash_hash_undefined__';

    /**
     * Sets the hash `key` to `value`.
     *
     * @private
     * @name set
     * @memberOf Hash
     * @param {string} key The key of the value to set.
     * @param {*} value The value to set.
     * @returns {Object} Returns the hash instance.
     */
    function hashSet(key, value) {
      var data = this.__data__;
      this.size += this.has(key) ? 0 : 1;
      data[key] = (_nativeCreate && value === undefined) ? HASH_UNDEFINED : value;
      return this;
    }

    var _hashSet = hashSet;

    /**
     * Creates a hash object.
     *
     * @private
     * @constructor
     * @param {Array} [entries] The key-value pairs to cache.
     */
    function Hash(entries) {
      var index = -1,
          length = entries == null ? 0 : entries.length;

      this.clear();
      while (++index < length) {
        var entry = entries[index];
        this.set(entry[0], entry[1]);
      }
    }

    // Add methods to `Hash`.
    Hash.prototype.clear = _hashClear;
    Hash.prototype['delete'] = _hashDelete;
    Hash.prototype.get = _hashGet;
    Hash.prototype.has = _hashHas;
    Hash.prototype.set = _hashSet;

    var _Hash = Hash;

    /**
     * Removes all key-value entries from the list cache.
     *
     * @private
     * @name clear
     * @memberOf ListCache
     */
    function listCacheClear() {
      this.__data__ = [];
      this.size = 0;
    }

    var _listCacheClear = listCacheClear;

    /**
     * Performs a
     * [`SameValueZero`](http://ecma-international.org/ecma-262/7.0/#sec-samevaluezero)
     * comparison between two values to determine if they are equivalent.
     *
     * @static
     * @memberOf _
     * @since 4.0.0
     * @category Lang
     * @param {*} value The value to compare.
     * @param {*} other The other value to compare.
     * @returns {boolean} Returns `true` if the values are equivalent, else `false`.
     * @example
     *
     * var object = { 'a': 1 };
     * var other = { 'a': 1 };
     *
     * _.eq(object, object);
     * // => true
     *
     * _.eq(object, other);
     * // => false
     *
     * _.eq('a', 'a');
     * // => true
     *
     * _.eq('a', Object('a'));
     * // => false
     *
     * _.eq(NaN, NaN);
     * // => true
     */
    function eq(value, other) {
      return value === other || (value !== value && other !== other);
    }

    var eq_1 = eq;

    /**
     * Gets the index at which the `key` is found in `array` of key-value pairs.
     *
     * @private
     * @param {Array} array The array to inspect.
     * @param {*} key The key to search for.
     * @returns {number} Returns the index of the matched value, else `-1`.
     */
    function assocIndexOf(array, key) {
      var length = array.length;
      while (length--) {
        if (eq_1(array[length][0], key)) {
          return length;
        }
      }
      return -1;
    }

    var _assocIndexOf = assocIndexOf;

    /** Used for built-in method references. */
    var arrayProto = Array.prototype;

    /** Built-in value references. */
    var splice = arrayProto.splice;

    /**
     * Removes `key` and its value from the list cache.
     *
     * @private
     * @name delete
     * @memberOf ListCache
     * @param {string} key The key of the value to remove.
     * @returns {boolean} Returns `true` if the entry was removed, else `false`.
     */
    function listCacheDelete(key) {
      var data = this.__data__,
          index = _assocIndexOf(data, key);

      if (index < 0) {
        return false;
      }
      var lastIndex = data.length - 1;
      if (index == lastIndex) {
        data.pop();
      } else {
        splice.call(data, index, 1);
      }
      --this.size;
      return true;
    }

    var _listCacheDelete = listCacheDelete;

    /**
     * Gets the list cache value for `key`.
     *
     * @private
     * @name get
     * @memberOf ListCache
     * @param {string} key The key of the value to get.
     * @returns {*} Returns the entry value.
     */
    function listCacheGet(key) {
      var data = this.__data__,
          index = _assocIndexOf(data, key);

      return index < 0 ? undefined : data[index][1];
    }

    var _listCacheGet = listCacheGet;

    /**
     * Checks if a list cache value for `key` exists.
     *
     * @private
     * @name has
     * @memberOf ListCache
     * @param {string} key The key of the entry to check.
     * @returns {boolean} Returns `true` if an entry for `key` exists, else `false`.
     */
    function listCacheHas(key) {
      return _assocIndexOf(this.__data__, key) > -1;
    }

    var _listCacheHas = listCacheHas;

    /**
     * Sets the list cache `key` to `value`.
     *
     * @private
     * @name set
     * @memberOf ListCache
     * @param {string} key The key of the value to set.
     * @param {*} value The value to set.
     * @returns {Object} Returns the list cache instance.
     */
    function listCacheSet(key, value) {
      var data = this.__data__,
          index = _assocIndexOf(data, key);

      if (index < 0) {
        ++this.size;
        data.push([key, value]);
      } else {
        data[index][1] = value;
      }
      return this;
    }

    var _listCacheSet = listCacheSet;

    /**
     * Creates an list cache object.
     *
     * @private
     * @constructor
     * @param {Array} [entries] The key-value pairs to cache.
     */
    function ListCache(entries) {
      var index = -1,
          length = entries == null ? 0 : entries.length;

      this.clear();
      while (++index < length) {
        var entry = entries[index];
        this.set(entry[0], entry[1]);
      }
    }

    // Add methods to `ListCache`.
    ListCache.prototype.clear = _listCacheClear;
    ListCache.prototype['delete'] = _listCacheDelete;
    ListCache.prototype.get = _listCacheGet;
    ListCache.prototype.has = _listCacheHas;
    ListCache.prototype.set = _listCacheSet;

    var _ListCache = ListCache;

    /* Built-in method references that are verified to be native. */
    var Map$1 = _getNative(_root, 'Map');

    var _Map = Map$1;

    /**
     * Removes all key-value entries from the map.
     *
     * @private
     * @name clear
     * @memberOf MapCache
     */
    function mapCacheClear() {
      this.size = 0;
      this.__data__ = {
        'hash': new _Hash,
        'map': new (_Map || _ListCache),
        'string': new _Hash
      };
    }

    var _mapCacheClear = mapCacheClear;

    /**
     * Checks if `value` is suitable for use as unique object key.
     *
     * @private
     * @param {*} value The value to check.
     * @returns {boolean} Returns `true` if `value` is suitable, else `false`.
     */
    function isKeyable(value) {
      var type = typeof value;
      return (type == 'string' || type == 'number' || type == 'symbol' || type == 'boolean')
        ? (value !== '__proto__')
        : (value === null);
    }

    var _isKeyable = isKeyable;

    /**
     * Gets the data for `map`.
     *
     * @private
     * @param {Object} map The map to query.
     * @param {string} key The reference key.
     * @returns {*} Returns the map data.
     */
    function getMapData(map, key) {
      var data = map.__data__;
      return _isKeyable(key)
        ? data[typeof key == 'string' ? 'string' : 'hash']
        : data.map;
    }

    var _getMapData = getMapData;

    /**
     * Removes `key` and its value from the map.
     *
     * @private
     * @name delete
     * @memberOf MapCache
     * @param {string} key The key of the value to remove.
     * @returns {boolean} Returns `true` if the entry was removed, else `false`.
     */
    function mapCacheDelete(key) {
      var result = _getMapData(this, key)['delete'](key);
      this.size -= result ? 1 : 0;
      return result;
    }

    var _mapCacheDelete = mapCacheDelete;

    /**
     * Gets the map value for `key`.
     *
     * @private
     * @name get
     * @memberOf MapCache
     * @param {string} key The key of the value to get.
     * @returns {*} Returns the entry value.
     */
    function mapCacheGet(key) {
      return _getMapData(this, key).get(key);
    }

    var _mapCacheGet = mapCacheGet;

    /**
     * Checks if a map value for `key` exists.
     *
     * @private
     * @name has
     * @memberOf MapCache
     * @param {string} key The key of the entry to check.
     * @returns {boolean} Returns `true` if an entry for `key` exists, else `false`.
     */
    function mapCacheHas(key) {
      return _getMapData(this, key).has(key);
    }

    var _mapCacheHas = mapCacheHas;

    /**
     * Sets the map `key` to `value`.
     *
     * @private
     * @name set
     * @memberOf MapCache
     * @param {string} key The key of the value to set.
     * @param {*} value The value to set.
     * @returns {Object} Returns the map cache instance.
     */
    function mapCacheSet(key, value) {
      var data = _getMapData(this, key),
          size = data.size;

      data.set(key, value);
      this.size += data.size == size ? 0 : 1;
      return this;
    }

    var _mapCacheSet = mapCacheSet;

    /**
     * Creates a map cache object to store key-value pairs.
     *
     * @private
     * @constructor
     * @param {Array} [entries] The key-value pairs to cache.
     */
    function MapCache(entries) {
      var index = -1,
          length = entries == null ? 0 : entries.length;

      this.clear();
      while (++index < length) {
        var entry = entries[index];
        this.set(entry[0], entry[1]);
      }
    }

    // Add methods to `MapCache`.
    MapCache.prototype.clear = _mapCacheClear;
    MapCache.prototype['delete'] = _mapCacheDelete;
    MapCache.prototype.get = _mapCacheGet;
    MapCache.prototype.has = _mapCacheHas;
    MapCache.prototype.set = _mapCacheSet;

    var _MapCache = MapCache;

    /** Error message constants. */
    var FUNC_ERROR_TEXT = 'Expected a function';

    /**
     * Creates a function that memoizes the result of `func`. If `resolver` is
     * provided, it determines the cache key for storing the result based on the
     * arguments provided to the memoized function. By default, the first argument
     * provided to the memoized function is used as the map cache key. The `func`
     * is invoked with the `this` binding of the memoized function.
     *
     * **Note:** The cache is exposed as the `cache` property on the memoized
     * function. Its creation may be customized by replacing the `_.memoize.Cache`
     * constructor with one whose instances implement the
     * [`Map`](http://ecma-international.org/ecma-262/7.0/#sec-properties-of-the-map-prototype-object)
     * method interface of `clear`, `delete`, `get`, `has`, and `set`.
     *
     * @static
     * @memberOf _
     * @since 0.1.0
     * @category Function
     * @param {Function} func The function to have its output memoized.
     * @param {Function} [resolver] The function to resolve the cache key.
     * @returns {Function} Returns the new memoized function.
     * @example
     *
     * var object = { 'a': 1, 'b': 2 };
     * var other = { 'c': 3, 'd': 4 };
     *
     * var values = _.memoize(_.values);
     * values(object);
     * // => [1, 2]
     *
     * values(other);
     * // => [3, 4]
     *
     * object.a = 2;
     * values(object);
     * // => [1, 2]
     *
     * // Modify the result cache.
     * values.cache.set(object, ['a', 'b']);
     * values(object);
     * // => ['a', 'b']
     *
     * // Replace `_.memoize.Cache`.
     * _.memoize.Cache = WeakMap;
     */
    function memoize(func, resolver) {
      if (typeof func != 'function' || (resolver != null && typeof resolver != 'function')) {
        throw new TypeError(FUNC_ERROR_TEXT);
      }
      var memoized = function() {
        var args = arguments,
            key = resolver ? resolver.apply(this, args) : args[0],
            cache = memoized.cache;

        if (cache.has(key)) {
          return cache.get(key);
        }
        var result = func.apply(this, args);
        memoized.cache = cache.set(key, result) || cache;
        return result;
      };
      memoized.cache = new (memoize.Cache || _MapCache);
      return memoized;
    }

    // Expose `MapCache`.
    memoize.Cache = _MapCache;

    var memoize_1 = memoize;

    /** Used as the maximum memoize cache size. */
    var MAX_MEMOIZE_SIZE = 500;

    /**
     * A specialized version of `_.memoize` which clears the memoized function's
     * cache when it exceeds `MAX_MEMOIZE_SIZE`.
     *
     * @private
     * @param {Function} func The function to have its output memoized.
     * @returns {Function} Returns the new memoized function.
     */
    function memoizeCapped(func) {
      var result = memoize_1(func, function(key) {
        if (cache.size === MAX_MEMOIZE_SIZE) {
          cache.clear();
        }
        return key;
      });

      var cache = result.cache;
      return result;
    }

    var _memoizeCapped = memoizeCapped;

    /** Used to match property names within property paths. */
    var rePropName = /[^.[\]]+|\[(?:(-?\d+(?:\.\d+)?)|(["'])((?:(?!\2)[^\\]|\\.)*?)\2)\]|(?=(?:\.|\[\])(?:\.|\[\]|$))/g;

    /** Used to match backslashes in property paths. */
    var reEscapeChar = /\\(\\)?/g;

    /**
     * Converts `string` to a property path array.
     *
     * @private
     * @param {string} string The string to convert.
     * @returns {Array} Returns the property path array.
     */
    var stringToPath = _memoizeCapped(function(string) {
      var result = [];
      if (string.charCodeAt(0) === 46 /* . */) {
        result.push('');
      }
      string.replace(rePropName, function(match, number, quote, subString) {
        result.push(quote ? subString.replace(reEscapeChar, '$1') : (number || match));
      });
      return result;
    });

    var _stringToPath = stringToPath;

    /**
     * A specialized version of `_.map` for arrays without support for iteratee
     * shorthands.
     *
     * @private
     * @param {Array} [array] The array to iterate over.
     * @param {Function} iteratee The function invoked per iteration.
     * @returns {Array} Returns the new mapped array.
     */
    function arrayMap(array, iteratee) {
      var index = -1,
          length = array == null ? 0 : array.length,
          result = Array(length);

      while (++index < length) {
        result[index] = iteratee(array[index], index, array);
      }
      return result;
    }

    var _arrayMap = arrayMap;

    /** Used as references for various `Number` constants. */
    var INFINITY$1 = 1 / 0;

    /** Used to convert symbols to primitives and strings. */
    var symbolProto = _Symbol ? _Symbol.prototype : undefined,
        symbolToString = symbolProto ? symbolProto.toString : undefined;

    /**
     * The base implementation of `_.toString` which doesn't convert nullish
     * values to empty strings.
     *
     * @private
     * @param {*} value The value to process.
     * @returns {string} Returns the string.
     */
    function baseToString(value) {
      // Exit early for strings to avoid a performance hit in some environments.
      if (typeof value == 'string') {
        return value;
      }
      if (isArray_1(value)) {
        // Recursively convert values (susceptible to call stack limits).
        return _arrayMap(value, baseToString) + '';
      }
      if (isSymbol_1(value)) {
        return symbolToString ? symbolToString.call(value) : '';
      }
      var result = (value + '');
      return (result == '0' && (1 / value) == -INFINITY$1) ? '-0' : result;
    }

    var _baseToString = baseToString;

    /**
     * Converts `value` to a string. An empty string is returned for `null`
     * and `undefined` values. The sign of `-0` is preserved.
     *
     * @static
     * @memberOf _
     * @since 4.0.0
     * @category Lang
     * @param {*} value The value to convert.
     * @returns {string} Returns the converted string.
     * @example
     *
     * _.toString(null);
     * // => ''
     *
     * _.toString(-0);
     * // => '-0'
     *
     * _.toString([1, 2, 3]);
     * // => '1,2,3'
     */
    function toString(value) {
      return value == null ? '' : _baseToString(value);
    }

    var toString_1 = toString;

    /**
     * Casts `value` to a path array if it's not one.
     *
     * @private
     * @param {*} value The value to inspect.
     * @param {Object} [object] The object to query keys on.
     * @returns {Array} Returns the cast property path array.
     */
    function castPath(value, object) {
      if (isArray_1(value)) {
        return value;
      }
      return _isKey(value, object) ? [value] : _stringToPath(toString_1(value));
    }

    var _castPath = castPath;

    /** Used as references for various `Number` constants. */
    var INFINITY = 1 / 0;

    /**
     * Converts `value` to a string key if it's not a string or symbol.
     *
     * @private
     * @param {*} value The value to inspect.
     * @returns {string|symbol} Returns the key.
     */
    function toKey(value) {
      if (typeof value == 'string' || isSymbol_1(value)) {
        return value;
      }
      var result = (value + '');
      return (result == '0' && (1 / value) == -INFINITY) ? '-0' : result;
    }

    var _toKey = toKey;

    /**
     * The base implementation of `_.get` without support for default values.
     *
     * @private
     * @param {Object} object The object to query.
     * @param {Array|string} path The path of the property to get.
     * @returns {*} Returns the resolved value.
     */
    function baseGet(object, path) {
      path = _castPath(path, object);

      var index = 0,
          length = path.length;

      while (object != null && index < length) {
        object = object[_toKey(path[index++])];
      }
      return (index && index == length) ? object : undefined;
    }

    var _baseGet = baseGet;

    /**
     * Gets the value at `path` of `object`. If the resolved value is
     * `undefined`, the `defaultValue` is returned in its place.
     *
     * @static
     * @memberOf _
     * @since 3.7.0
     * @category Object
     * @param {Object} object The object to query.
     * @param {Array|string} path The path of the property to get.
     * @param {*} [defaultValue] The value returned for `undefined` resolved values.
     * @returns {*} Returns the resolved value.
     * @example
     *
     * var object = { 'a': [{ 'b': { 'c': 3 } }] };
     *
     * _.get(object, 'a[0].b.c');
     * // => 3
     *
     * _.get(object, ['a', '0', 'b', 'c']);
     * // => 3
     *
     * _.get(object, 'a.b.c', 'default');
     * // => 'default'
     */
    function get(object, path, defaultValue) {
      var result = object == null ? undefined : _baseGet(object, path);
      return result === undefined ? defaultValue : result;
    }

    var get_1 = get;

    var has = Object.prototype.hasOwnProperty;

    function find(iter, tar, key) {
    	for (key of iter.keys()) {
    		if (dequal(key, tar)) return key;
    	}
    }

    function dequal(foo, bar) {
    	var ctor, len, tmp;
    	if (foo === bar) return true;

    	if (foo && bar && (ctor=foo.constructor) === bar.constructor) {
    		if (ctor === Date) return foo.getTime() === bar.getTime();
    		if (ctor === RegExp) return foo.toString() === bar.toString();

    		if (ctor === Array) {
    			if ((len=foo.length) === bar.length) {
    				while (len-- && dequal(foo[len], bar[len]));
    			}
    			return len === -1;
    		}

    		if (ctor === Set) {
    			if (foo.size !== bar.size) {
    				return false;
    			}
    			for (len of foo) {
    				tmp = len;
    				if (tmp && typeof tmp === 'object') {
    					tmp = find(bar, tmp);
    					if (!tmp) return false;
    				}
    				if (!bar.has(tmp)) return false;
    			}
    			return true;
    		}

    		if (ctor === Map) {
    			if (foo.size !== bar.size) {
    				return false;
    			}
    			for (len of foo) {
    				tmp = len[0];
    				if (tmp && typeof tmp === 'object') {
    					tmp = find(bar, tmp);
    					if (!tmp) return false;
    				}
    				if (!dequal(len[1], bar.get(tmp))) {
    					return false;
    				}
    			}
    			return true;
    		}

    		if (ctor === ArrayBuffer) {
    			foo = new Uint8Array(foo);
    			bar = new Uint8Array(bar);
    		} else if (ctor === DataView) {
    			if ((len=foo.byteLength) === bar.byteLength) {
    				while (len-- && foo.getInt8(len) === bar.getInt8(len));
    			}
    			return len === -1;
    		}

    		if (ArrayBuffer.isView(foo)) {
    			if ((len=foo.byteLength) === bar.byteLength) {
    				while (len-- && foo[len] === bar[len]);
    			}
    			return len === -1;
    		}

    		if (!ctor || typeof foo === 'object') {
    			len = 0;
    			for (ctor in foo) {
    				if (has.call(foo, ctor) && ++len && !has.call(bar, ctor)) return false;
    				if (!(ctor in bar) || !dequal(foo[ctor], bar[ctor])) return false;
    			}
    			return Object.keys(bar).length === len;
    		}
    	}

    	return foo !== foo && bar !== bar;
    }

    function checkDeps(deps) {
      if (!deps || !deps.length) {
        throw new Error('useDeepCompareEffect should not be used with no dependencies. Use React.useEffect instead.');
      }

      if (deps.every(isPrimitive)) {
        throw new Error('useDeepCompareEffect should not be used with dependencies that are all primitive values. Use React.useEffect instead.');
      }
    }

    function isPrimitive(val) {
      return val == null || /^[sbn]/.test(typeof val);
    }
    /**
     * @param value the value to be memoized (usually a dependency list)
     * @returns a momoized version of the value as long as it remains deeply equal
     */


    function useDeepCompareMemoize(value) {
      var ref = React__namespace$1.useRef(value);
      var signalRef = React__namespace$1.useRef(0);

      if (!dequal(value, ref.current)) {
        ref.current = value;
        signalRef.current += 1;
      } // eslint-disable-next-line react-hooks/exhaustive-deps


      return React__namespace$1.useMemo(function () {
        return ref.current;
      }, [signalRef.current]);
    }

    function useDeepCompareEffect(callback, dependencies) {
      {
        checkDeps(dependencies);
      } // eslint-disable-next-line react-hooks/exhaustive-deps


      return React__namespace$1.useEffect(callback, useDeepCompareMemoize(dependencies));
    }

    function proxyToObject(proxy) {
        return Reflect.ownKeys(proxy).reduce((prev, key) => {
            prev[key] = proxy[key];
            return prev;
        }, {});
    }
    function nestToFlat(flatKeys, obj, defaultValue) {
        return flatKeys.reduce((prev, name) => {
            // nested field may be `undefined`
            prev[name] = get_1(obj, name) || defaultValue;
            return prev;
        }, {});
    }

    function useExportControlToExtension({ id, control, }) {
        const nestedFormValues = useWatch({ control });
        const formState = useFormState({ control });
        const [isExtensionEnabled, setIsExtensionEnabled] = React.useState(false);
        const handleInitMessage = (message) => {
            if (message.data.source !== 'react-hook-form-bridge' ||
                message.data.type !== 'INIT') {
                return;
            }
            window.postMessage({
                source: 'react-hook-form-bridge',
                type: 'WELCOME',
            });
            setIsExtensionEnabled(true);
        };
        React.useEffect(() => {
            window.addEventListener('message', handleInitMessage);
            return () => window.removeEventListener('message', handleInitMessage);
        }, []);
        useDeepCompareEffect(() => {
            if (!isExtensionEnabled) {
                return;
            }
            const _a = proxyToObject(formState), { errors: nestedErrors, dirtyFields: nestedDirtyFields, touchedFields: nestedTouchedFields } = _a, formStatus = __rest(_a, ["errors", "dirtyFields", "touchedFields"]);
            const flatFieldNames = [...control._names.mount];
            const formValues = nestToFlat(flatFieldNames, nestedFormValues, '');
            const dirtyFields = nestToFlat(flatFieldNames, nestedDirtyFields, false);
            const touchedFields = nestToFlat(flatFieldNames, nestedTouchedFields, false);
            const flatErrors = nestToFlat(flatFieldNames, nestedErrors);
            const errors = Object.entries(flatErrors).reduce((prev, [key, value]) => {
                prev[key] = {
                    type: value === null || value === void 0 ? void 0 : value.type,
                    message: value === null || value === void 0 ? void 0 : value.message,
                };
                return prev;
            }, {});
            const nativeFields = flatFieldNames.reduce((prev, name) => {
                var _a, _b;
                const field = (_a = get_1(control._fields, name)) === null || _a === void 0 ? void 0 : _a._f;
                prev[name] = (_b = get_1(field, 'ref')) === null || _b === void 0 ? void 0 : _b.type;
                return prev;
            }, {});
            const updateMessagePayload = {
                id,
                data: {
                    formValues,
                    formState: Object.assign({ errors,
                        dirtyFields,
                        touchedFields,
                        nativeFields }, formStatus),
                },
            };
            window.postMessage({
                source: 'react-hook-form-bridge',
                type: 'UPDATE',
                payload: updateMessagePayload,
            });
        }, [isExtensionEnabled, nestedFormValues, proxyToObject(formState)]);
        return { isExtensionEnabled };
    }

    if (typeof window !== 'undefined') {
        s({
            visible: false,
            isCollapse: false,
            filterName: '',
        }, {
            name: '__REACT_HOOK_FORM_DEVTOOLS__',
            middleWares: [],
            storageType: window.localStorage,
        });
    }
    const DevTool = (props) => {
        var _a, _b, _c;
        const methods = useFormContext();
        const uuid = React__namespace$1.useRef('');
        React__namespace$1.useEffect(() => {
            uuid.current = v4();
        }, []);
        const { isExtensionEnabled } = useExportControlToExtension({
            id: (_a = props === null || props === void 0 ? void 0 : props.id) !== null && _a !== void 0 ? _a : uuid.current,
            control: (_b = props === null || props === void 0 ? void 0 : props.control) !== null && _b !== void 0 ? _b : methods.control,
        });
        if (isExtensionEnabled) {
            return null;
        }
        return (React__namespace$1.createElement(o, null,
            React__namespace$1.createElement(DevToolUI, { control: (_c = props === null || props === void 0 ? void 0 : props.control) !== null && _c !== void 0 ? _c : methods.control, placement: props === null || props === void 0 ? void 0 : props.placement, styles: props === null || props === void 0 ? void 0 : props.styles })));
    };

    exports.DevTool = DevTool;

    Object.defineProperty(exports, '__esModule', { value: true });

}));
//# sourceMappingURL=index.umd.development.js.map
