import { CreateEnv, StrictOptions, ServerClientOptions } from '@t3-oss/env-core';
import { ZodType } from 'zod';

declare const CLIENT_PREFIX: "NEXT_PUBLIC_";
type ClientPrefix = typeof CLIENT_PREFIX;
type Options<TServer extends Record<string, ZodType>, TClient extends Record<`${ClientPrefix}${string}`, ZodType>, TShared extends Record<string, ZodType>, TExtends extends Array<Record<string, unknown>>> = Omit<StrictOptions<ClientPrefix, TServer, TClient, TShared, TExtends> & ServerClientOptions<ClientPrefix, TServer, TClient>, "runtimeEnvStrict" | "runtimeEnv" | "clientPrefix"> & ({
    /**
     * Manual destruction of `process.env`. Required for Next.js < 13.4.4.
     */
    runtimeEnv: StrictOptions<ClientPrefix, TServer, TClient, TShared, TExtends>["runtimeEnvStrict"];
    experimental__runtimeEnv?: never;
} | {
    runtimeEnv?: never;
    /**
     * Can be used for Next.js ^13.4.4 since they stopped static analysis of server side `process.env`.
     * Only client side `process.env` is statically analyzed and needs to be manually destructured.
     */
    experimental__runtimeEnv: Record<{
        [TKey in keyof TClient]: TKey extends `${ClientPrefix}${string}` ? TKey : never;
    }[keyof TClient] | {
        [TKey in keyof TShared]: TKey extends string ? TKey : never;
    }[keyof TShared], string | boolean | number | undefined>;
});
declare function createEnv<TServer extends Record<string, ZodType> = NonNullable<unknown>, TClient extends Record<`${ClientPrefix}${string}`, ZodType> = NonNullable<unknown>, TShared extends Record<string, ZodType> = NonNullable<unknown>, const TExtends extends Array<Record<string, unknown>> = []>(opts: Options<TServer, TClient, TShared, TExtends>): CreateEnv<TServer, TClient, TShared, TExtends>;

export { createEnv };
