"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
// code-narrator.config.ts
const ConfigurationBuilder_1 = __importDefault(require("./src/documentation/plugins/builders/Configuration/ConfigurationBuilder"));
const FilesBuilder_1 = __importDefault(require("./src/documentation/plugins/builders/Files/FilesBuilder"));
const FoldersBuilder_1 = __importDefault(require("./src/documentation/plugins/builders/Folders/FoldersBuilder"));
const ReadMeBuilder_1 = __importDefault(require("./src/documentation/plugins/builders/ReadMe/ReadMeBuilder"));
const BehaviourBuilder_1 = __importDefault(require("./src/documentation/plugins/builders/Behaviour/BehaviourBuilder"));
const DocusaurusGenerator_1 = __importDefault(require("./src/documentation/plugins/generators/Docusaurus/DocusaurusGenerator"));
const PrerequisitesBuilder_1 = __importDefault(require("./src/documentation/plugins/builders/Prerequisites/PrerequisitesBuilder"));
const UsageBuilder_1 = __importDefault(require("./src/documentation/plugins/builders/Usage/UsageBuilder"));
exports.default = {
    projects: [{
            project_file: "package.json",
            config_file: "code-narrator.config.ts",
            entry_file: "./src/App.ts",
            cli_file: "./src/cli.ts",
            project_path: "./",
            source_path: "./src",
            documentation_path: "./docs",
            test_path: "./test",
            exclude: ['ReadMe.md', '/node_modules', '/docs', '/test', '/__test__/**', '.env', '/.idea', '/.git',
                '.gitignore', '/.code-narrator', '/classic', '/build', 'package-lock.json'],
            readmeRoot: true
        }],
    //Order of plugins matter, ConfigurationGenerator runs first to get overview of the project.
    builderPlugins: [
        ConfigurationBuilder_1.default, PrerequisitesBuilder_1.default, UsageBuilder_1.default, FilesBuilder_1.default, FoldersBuilder_1.default, ReadMeBuilder_1.default, BehaviourBuilder_1.default
    ],
    generatorPlugin: [
        DocusaurusGenerator_1.default
    ],
    gptSystemCommands: [
        'If there is :::note, :::info, :::caution, :::tip, :::danger in the text, extract that from its location and format it correctly',
        `Return your answer in {DocumentationType} format`,
        `If you notice any secret information, replace it with ***** in your response`
    ],
    documentation_type: 'md',
    document_file_extension: ".md",
    cache_file: '.code-narrator/cache.json' //location of the cache file. :::warning '.code-narrator/cache.json' should be committed into git.
};
//# sourceMappingURL=code-narrator.config.js.map