"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const DocumentationBuilder_1 = __importDefault(require("./documentation/DocumentationBuilder"));
const DocumentationCache_1 = __importDefault(require("./documentation/DocumentationCache"));
const DocumentationGenerator_1 = __importDefault(require("./documentation/DocumentationGenerator"));
const ConfigHelper_1 = __importDefault(require("./config/ConfigHelper"));
/*
About code-narrator
This application is installed with "npm i code-narrator", and executed either by npm run start or by using cli.
When starting it will load up the configuration and cached documentation.
Then it will go through the project code, reading the file & folder structure
if the file or folder does not exist in the cache or the file has changed since last cached
code-narrator will send the code to GPT and ask for documentation in an .md format.
When it receives the documentation, it writes it to the cache.
When all files and folders have been parsed, then code-narrator creates the documentation from the cache

There are few rules to follow
- Write description about the project in the project file (e.g. package.json)
- If GPT generates wrong documentation, the code is probably not clear for humans either. Try adjusting code or adding one line comment to make code clearer
- You can use :::tip or :::danger in you comments in your code files.
 */
class App {
    async run(config) {
        await ConfigHelper_1.default.load(config);
        DocumentationCache_1.default.load();
        let builder = new DocumentationBuilder_1.default();
        await builder.build();
        let generator = new DocumentationGenerator_1.default();
        generator.make();
        console.log('Done generating documents');
    }
}
exports.default = App;
App.StartTime = new Date();
//# sourceMappingURL=App.js.map
