"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const DefaultSettings_1 = __importDefault(require("./DefaultSettings"));
const ConfigQuestion_1 = __importDefault(require("./ConfigQuestion"));
const ConfigHelper_1 = __importDefault(require("./ConfigHelper"));
const ConfigFileSerializer_1 = __importDefault(require("./ConfigFileSerializer"));
class ConfigGenerator {
    static async generate(projectConfig = {}) {
        console.log('Understanding project and auto generating code-narrator.config.js');
        let config = {
            ...DefaultSettings_1.default.get(),
            ...projectConfig,
        };
        let configQuestion = new ConfigQuestion_1.default(config);
        let result = await configQuestion.getProjectSetup();
        config.gptModel = DefaultSettings_1.default.gptModel;
        config.project_file = result.project_file ?? config.project_file;
        config.source_path = result.source_path ?? config.source_path;
        config.documentation_path = this.getDocPath(config, result);
        config.test_path = result.test_path ?? config.test_path;
        try {
            result = await configQuestion.getProjectDetails(config);
            config.entry_file = result.entry_file ?? config.entry_file;
            config.cli_file = result.cli_file ?? config.cli_file;
            config.project_name = result.project_name ?? config.project_name;
            config.config_files = result.config_files ?? config.config_files;
            config.repository_url = result.repository_url ?? config.repository_url;
        }
        catch (e) {
        }
        config.include = [...config.config_files, config.source_path + "/**/*"];
        config.builders = ConfigHelper_1.default.getUserDefinedExamples(config);
        let serializer = new ConfigFileSerializer_1.default();
        await serializer.serialize(config);
        return config;
    }
    static getDocPath(config, json) {
        if (json.documentation_path?.indexOf('.') != -1)
            return config.documentation_path;
        return json.documentation_path ?? config.documentation_path;
    }
}
exports.default = ConfigGenerator;
//# sourceMappingURL=ConfigGenerator.js.map
