"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const dotnet = __importStar(require("dotenv"));
const DefaultSettings_1 = __importDefault(require("./DefaultSettings"));
const ConfigGenerator_1 = __importDefault(require("./ConfigGenerator"));
const OpenAIService_1 = __importDefault(require("../services/OpenAIService"));
/*
ref: src/config/ICodeNarratorConfig.ts
 */
class ConfigHelper {
    static async load(projectConfig = {}) {
        dotnet.config();
        ConfigHelper.env = process.env;
        ConfigHelper.OpenAiKey = ConfigHelper.env['OPENAI_API_KEY'];
        if (!ConfigHelper.OpenAiKey) {
            console.error('Missing OPENAI_API_KEY in .env file. Make sure to create .env file in your root and include OPENAI_API_KEY=Your_OpenAI_Key');
            throw new Error('Missing OpenAI API key');
        }
        if (!projectConfig.fromFile) {
            projectConfig = await ConfigGenerator_1.default.generate(projectConfig);
            console.log(`
============ Config generated =====================================
Config file has been generated in project root, code-narrator.config.js. 
            
Please read through it and see if it maps correctly to your project. You can modify it. 
The important properties to look at are "source_path", "include" and "config_files" if you have some app specific config files.

Next time you will run the CLI it will start generating documentation
===================================================================`);
            process.exit(1);
        }
        this.config = {
            ...DefaultSettings_1.default.get(),
            ...projectConfig,
        };
        if (!this.config.exclude.includes(`*${this.config.document_file_extension}`)) {
            this.config.exclude.push(`*${this.config.document_file_extension}`);
        }
        ConfigHelper.DocumentingProject = this.config.documentation_path;
        ConfigHelper.BuilderPlugins = this.config.builderPlugins;
        ConfigHelper.DocumentExtension = this.config.document_file_extension ?? '.md';
        ConfigHelper.DocumentationType = this.config.documentation_type ?? 'md';
        if (ConfigHelper.DocumentExtension.indexOf('.') != 0)
            ConfigHelper.DocumentExtension = '.' + ConfigHelper.DocumentExtension;
        if (projectConfig.aiService) {
            this.config.aiService = new projectConfig.aiService();
        }
        else {
            this.config.aiService = new OpenAIService_1.default();
        }
        ConfigHelper.CacheFilePath = this.config.cache_file ?? '.code-narrator/cache.json';
    }
    static getUserDefinedExamples(config) {
        let readMeBuilder = {
            name: "README",
            type: "README",
            template: "README",
            sidebarPosition: 1,
            args: {
                entryFileContent: `content(${config.project_file ?? ''})`
            }
        };
        let howToPage = {
            name: "HowTo Example",
            type: "howto",
            template: "howto_create_howto"
        };
        let howToBuilder = {
            name: "HowTo Overview",
            type: "README",
            template: 'overview_readme',
            path: 'howto',
            files: [
                {
                    path: 'howto/*.md'
                }
            ],
            pages: [
                howToPage
            ]
        };
        return [readMeBuilder, howToBuilder];
    }
}
exports.default = ConfigHelper;
ConfigHelper.BuilderPlugins = [];
ConfigHelper.DocumentationType = 'md';
ConfigHelper.DocumentExtension = '.md';
ConfigHelper.CacheFilePath = '.code-narrator/cache.json';
//# sourceMappingURL=ConfigHelper.js.map
