"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const FolderStructure_1 = __importDefault(require("../utils/FolderStructure"));
const process_1 = __importDefault(require("process"));
const Helper_1 = __importDefault(require("../utils/Helper"));
const FileStructure_1 = __importDefault(require("../utils/FileStructure"));
class ConfigQuestion {
    constructor(config) {
        this.aiService = config.aiService;
    }
    async getProjectSetup() {
        let foldersAndFiles = FolderStructure_1.default.getFoldersAndFiles(process_1.default.cwd()).join('\n');
        let question = `From the folder & file structure define for the project file, source path (where code is located), documentation folder path, test folder path. 
        DO NOT makeup value for JSON property 
        Return JSON scheme
        {
        project_file: string,
        source_path: string,
        documentation_path: string
        test_path: string
        }
        Folders structure and files in root folder are
        ###
        ${foldersAndFiles}
        ###
        `;
        let response = await this.aiService.query([question]);
        let jsons = Helper_1.default.getJsons(response.answer);
        if (jsons.length == 0) {
            throw new Error('Could not determine the project. You should set the config when calling ConfigHelper.load');
        }
        return jsons[0];
    }
    async getProjectDetails(config) {
        let foldersAndFiles = FolderStructure_1.default.getFoldersAndFiles(process_1.default.cwd()).join('\n');
        let projectFile = FileStructure_1.default.getContent(config.project_file);
        let projectDetailQuestion = `Following is the project file (${config.project_file}). 
From the file determine the project name, entry file, cli file, repository url.

        ### project file starts ###
        ${projectFile}
        ### project file ends ###       
         
From project name, try to identify app-specific config files from the file list.
This does NOT include project config files(e.g. package.json), environment files or configs for dependencies. 
The app-specific config file should be something like project_name.config, project_name.json, project_name.xml. 
DO NOT makeup value for JSON property, set the value as empty if you cannot determine it
           
        ### folders and files starts ###
        ${foldersAndFiles}
        ### folders and files ends ###
        
        Return json 
        {
        project_name: string,
        entry_file: string,
        cli_file: string,
        config_files: string[]
        repository_url : string
        }
        `;
        let projectDetailAnswer = await this.aiService.query([projectDetailQuestion]);
        let jsons = Helper_1.default.getJsons(projectDetailAnswer.answer);
        if (jsons.length == 0) {
            throw new Error(`Could not get project info. GPT answer:
            ${projectDetailAnswer.answer}`);
        }
        return jsons[0];
    }
}
exports.default = ConfigQuestion;
//# sourceMappingURL=ConfigQuestion.js.map
