"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const ConfigurationBuilder_1 = __importDefault(require("../documentation/plugins/builders/Configuration/ConfigurationBuilder"));
const FilesBuilder_1 = __importDefault(require("../documentation/plugins/builders/Files/FilesBuilder"));
const FoldersBuilder_1 = __importDefault(require("../documentation/plugins/builders/Folders/FoldersBuilder"));
const UserDefinedBuilder_1 = __importDefault(require("../documentation/plugins/builders/UserDefined/UserDefinedBuilder"));
const FileStructure_1 = __importDefault(require("../utils/FileStructure"));
const path_1 = __importDefault(require("path"));
const OpenAIService_1 = __importDefault(require("../services/OpenAIService"));
class DefaultSettings {
    static get() {
        return {
            config_files: ["code-narrator.config.ts"],
            project_file: "package.json",
            entry_file: "./src/App.ts",
            cli_file: "./src/cli.ts",
            project_path: "./",
            source_path: "./src",
            documentation_path: "./docs",
            test_path: "./test",
            exclude: this.getFilesToExclude(),
            readmeRoot: true,
            repository_url: "https://github.com/ingig/code-narrator",
            //Order of plugins matter, ConfigurationGenerator runs first to get overview of the project.
            builderPlugins: [
                ConfigurationBuilder_1.default, FilesBuilder_1.default, FoldersBuilder_1.default, UserDefinedBuilder_1.default
            ],
            gptSystemCommands: [
                'Act as a documentation expert for software',
                'If there is :::note, :::info, :::caution, :::tip, :::danger in the text, extract that from its location and format it correctly',
                `Return your answer in {DocumentationType} format`,
                `If you notice any secret information, replace it with ***** in your response`
            ],
            documentation_type: 'md',
            document_file_extension: ".md",
            folderRootFileName: 'README',
            cache_file: '.code-narrator/cache.json',
            gptModel: this.gptModel,
            aiService: new OpenAIService_1.default()
        };
    }
    static getFilesToExclude() {
        let gitIgnore = FileStructure_1.default.getContent(path_1.default.join(process.cwd(), '.gitignore')).trim().split('\n');
        gitIgnore = gitIgnore.map(item => item.trim()).filter(item => item !== '');
        let defaults = ['/node_modules', '.env', '/.idea', '/.git',
            '.gitignore', '/.code-narrator', '/dist', '/build', 'package-lock.json'];
        const uniqueArray = [...new Set([...gitIgnore, ...defaults])];
        return uniqueArray;
    }
}
exports.default = DefaultSettings;
DefaultSettings.gptModel = 'gpt-4';
//# sourceMappingURL=DefaultSettings.js.map
