"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const fs_1 = __importDefault(require("fs"));
const Helper_1 = __importDefault(require("../utils/Helper"));
const path = __importStar(require("path"));
class Document {
    constructor(name, filePath, folderPath, updated, sidebar_position, sidebar_label) {
        this.name = '';
        this.path = '';
        this.folderPath = '';
        this.fileContent = '';
        this.documentation = '';
        this.isFolder = false;
        this.updated = new Date();
        this.sidebar_position = undefined;
        this.sidebar_label = undefined;
        this.init = false;
        this.postInit = false;
        this.generator = '';
        this.saveToPath = '';
        this.documentation_type = 'md';
        this.question = '';
        this.requestMessages = [];
        this.name = name;
        let project_path = process.cwd();
        this.path = path.relative(project_path, filePath);
        this.saveToPath = this.path;
        this.id = (this.path) ? Document.getId(this.path) : Document.getId(name);
        this.folderPath = folderPath;
        this.isFolder = (filePath == folderPath);
        this.updated = updated;
        this.sidebar_position = sidebar_position;
        this.sidebar_label = sidebar_label ?? Helper_1.default.upperFirstLetter(name);
        if (!this.isFolder && fs_1.default.existsSync(filePath)) {
            this.fileContent = fs_1.default.readFileSync(filePath).toString();
        }
        this.lastTouch = new Date();
    }
    static getId(path) {
        return path;
    }
}
exports.default = Document;
//# sourceMappingURL=Document.js.map
