"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const ConfigHelper_1 = __importDefault(require("../config/ConfigHelper"));
class DocumentationBuilder {
    constructor() {
        this.aiService = ConfigHelper_1.default.config.aiService;
        this.projectPath = __dirname;
    }
    async build() {
        let plugins = ConfigHelper_1.default.BuilderPlugins;
        for (let i = 0; i < plugins.length; i++) {
            let generator;
            if (plugins[i].default) {
                generator = new plugins[i].default();
            }
            else {
                generator = new plugins[i]();
            }
            let userDefined = ConfigHelper_1.default.config?.userDefined;
            if (userDefined && generator.generator != 'UserDefined') {
                continue;
            }
            await generator.generateUsingPlugin();
        }
    }
}
exports.default = DocumentationBuilder;
//# sourceMappingURL=DocumentationBuilder.js.map
