"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const fs_1 = __importDefault(require("fs"));
const Document_1 = __importDefault(require("../documentation/Document"));
const path_1 = __importDefault(require("path"));
const App_1 = __importDefault(require("../App"));
const ConfigHelper_1 = __importDefault(require("../config/ConfigHelper"));
/*
:::danger Make sure to add the cache file (default is .codenarrator\cache.json) to git, so you don't have to query GPT on each run.
 */
class DocumentationCache {
    constructor() {
        if (fs_1.default.existsSync(ConfigHelper_1.default.CacheFilePath)) {
            let str = fs_1.default.readFileSync(ConfigHelper_1.default.CacheFilePath).toString();
            DocumentationCache.Documents = JSON.parse(str);
        }
        else {
            fs_1.default.mkdirSync(path_1.default.dirname(ConfigHelper_1.default.CacheFilePath), { recursive: true });
            fs_1.default.writeFileSync(ConfigHelper_1.default.CacheFilePath, "[]");
            DocumentationCache.Documents = [];
        }
    }
    static load() {
        new DocumentationCache();
    }
    static getIndex(id) {
        for (let i = 0; DocumentationCache.Documents && i < DocumentationCache.Documents.length; i++) {
            if (DocumentationCache.Documents[i] && DocumentationCache.Documents[i].id == id) {
                return i;
            }
        }
        return -1;
    }
    static get(path) {
        let id = Document_1.default.getId(path);
        let idx = this.getIndex(id);
        if (!DocumentationCache.Documents || idx == -1)
            return;
        let doc = DocumentationCache.Documents[idx];
        doc.lastTouch = App_1.default.StartTime;
        DocumentationCache.set(doc);
        return doc;
    }
    static remove(document) {
        let idx = DocumentationCache.getIndex(Document_1.default.getId(document.path));
        if (idx != -1 && DocumentationCache.Documents) {
            delete DocumentationCache.Documents[idx];
        }
        let docPath = ConfigHelper_1.default.config.documentation_path;
        let filePath = path_1.default.join(docPath, document.path);
        if (fs_1.default.existsSync(filePath)) {
            fs_1.default.rmSync(filePath);
        }
    }
    static set(document) {
        let idx = this.getIndex(document.id);
        if (idx == -1) {
            DocumentationCache.Documents?.push(document);
        }
        else {
            DocumentationCache.Documents[idx] = document;
        }
        let content = JSON.stringify(DocumentationCache.Documents, null, '\t');
        fs_1.default.writeFileSync(ConfigHelper_1.default.CacheFilePath, content);
    }
    static getByFolderPath(path) {
        let suggestions = [];
        for (let i = 0; DocumentationCache.Documents && i < DocumentationCache.Documents.length; i++) {
            if (DocumentationCache.Documents[i] && DocumentationCache.Documents[i].folderPath == path) {
                suggestions.push(DocumentationCache.Documents[i]);
            }
        }
        return suggestions;
    }
    static getFolderByFolderPath(path) {
        for (let i = 0; DocumentationCache.Documents && i < DocumentationCache.Documents.length; i++) {
            if (DocumentationCache.Documents[i] && DocumentationCache.Documents[i].generator == 'Folders'
                && DocumentationCache.Documents[i].folderPath == path) {
                return DocumentationCache.Documents[i];
            }
        }
    }
}
exports.default = DocumentationCache;
DocumentationCache.Documents = null;
//# sourceMappingURL=DocumentationCache.js.map
