"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const fs_1 = __importDefault(require("fs"));
const DocumentationCache_1 = __importDefault(require("./DocumentationCache"));
const path_1 = __importDefault(require("path"));
const ConfigHelper_1 = __importDefault(require("../config/ConfigHelper"));
const App_1 = __importDefault(require("../App"));
class DocumentationGenerator {
    make(document) {
        let documents = [];
        if (document) {
            documents.push(document);
        }
        else {
            documents = DocumentationCache_1.default.Documents;
        }
        if (!documents)
            return;
        let config = ConfigHelper_1.default.config;
        if (config.readmeRoot && !document) {
            let documents = DocumentationCache_1.default.getByFolderPath('');
            documents = documents.filter(doc => doc.name.toUpperCase() == 'README');
            if (documents.length > 0) {
                fs_1.default.writeFileSync(path_1.default.join(config.project_path, 'README.md'), documents[0].documentation);
            }
        }
        let project_path = process.cwd();
        let plugins = config.generatorPlugin;
        for (let i = 0; i < documents.length; i++) {
            let document = documents[i];
            if (!document)
                continue;
            for (let i = 0; plugins && i < plugins.length; i++) {
                let tmp = new plugins[i].default();
                tmp.process(document);
            }
            let folderPath = document.folderPath.replace(project_path, '');
            if (folderPath == '.\\' || folderPath == './')
                folderPath = '';
            let fileName = documents[i].name;
            if (fileName.toLowerCase() == 'readme')
                fileName = ConfigHelper_1.default.config.folderRootFileName;
            let filePath = path_1.default.join(config.documentation_path, documents[i].saveToPath, fileName + ConfigHelper_1.default.config.document_file_extension);
            if (document.lastTouch < App_1.default.StartTime) {
                fs_1.default.rmSync(filePath);
                DocumentationCache_1.default.remove(document);
                continue;
            }
            fs_1.default.mkdirSync(path_1.default.join(config.documentation_path, documents[i].saveToPath), { recursive: true });
            fs_1.default.writeFileSync(filePath, document.documentation);
        }
    }
}
exports.default = DocumentationGenerator;
//# sourceMappingURL=DocumentationGenerator.js.map
