import IGenericAIService from "../../../services/OpenAIService";
import Document from "../../Document";
import { GenerateOptions } from "../GenerateOptions";
import ICodeNarratorConfig from "../../../config/ICodeNarratorConfig";
import GenericAIResponse from "../../../model/GenericAIResponse";
export default abstract class BaseBuilder {
    aiService: IGenericAIService;
    generator: string;
    config: ICodeNarratorConfig;
    protected constructor(generator: string);
    generateUsingPlugin(): Promise<void>;
    abstract generate(): Promise<any>;
    getAnswer(name: string, args?: any, template?: string, assistantMessages?: string[]): Promise<GenericAIResponse>;
    generateDocumentation({ args, template, name, pathToFile, folderPath, sidebarPosition, assistantMessages, sidebarLabel, saveToPath, data }: GenerateOptions): Promise<Document>;
    generateDocumentationAndCache({ args, template, name, pathToFile, folderPath, sidebarPosition, sidebarLabel, saveToPath, assistantMessages, data, prevDocument }: GenerateOptions): Promise<void>;
    hasChanged(document?: Document): boolean;
}
