"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const Document_1 = __importDefault(require("../../Document"));
const DocumentationCache_1 = __importDefault(require("../../DocumentationCache"));
const liquidjs_1 = require("liquidjs");
const path_1 = __importDefault(require("path"));
const fs_1 = __importDefault(require("fs"));
const ConfigHelper_1 = __importDefault(require("../../../config/ConfigHelper"));
const process = __importStar(require("process"));
const DocumentationGenerator_1 = __importDefault(require("../../DocumentationGenerator"));
/*
This is the Base class for Builder plugins. Builder plugins are used to generate questions for GPT
and then parse the response and loading it into the document object that is later cached.
 */
class BaseBuilder {
    constructor(generator) {
        this.aiService = ConfigHelper_1.default.config.aiService;
        this.generator = generator;
        this.config = ConfigHelper_1.default.config;
    }
    async generateUsingPlugin() {
        await this.generate();
    }
    async getAnswer(name, args = {}, template = 'template', assistantMessages) {
        const engine = new liquidjs_1.Liquid({
            extname: '.liquid'
        });
        if (!args.projectName) {
            args.projectName = ConfigHelper_1.default.config.project_name;
        }
        if (!args.fileName && name) {
            args.fileName = name;
        }
        let template_path = path_1.default.join(__dirname, `${this.generator}/${template}`);
        if (this.generator == 'UserDefined') {
            template_path = path_1.default.join(process.cwd(), template);
        }
        if (!fs_1.default.existsSync(template_path + '.liquid')) {
            throw new Error(`Cannot find path ${template_path}`);
        }
        let question = await engine.renderFile(template_path, args);
        console.log(`${new Date().toLocaleTimeString()} - Asking about ${name} using template ${template} for builder ${this.generator}`);
        let response = await this.aiService.query([question], assistantMessages);
        console.log(`${new Date().toLocaleTimeString()} - Received answer for ${name}`);
        return response;
    }
    async generateDocumentation({ args = {}, template = 'gpt_question', name, pathToFile, folderPath, sidebarPosition, assistantMessages, sidebarLabel, saveToPath, data }) {
        if (!name) {
            throw new Error(`name is missing when trying to generate ${template} for ${pathToFile}`);
        }
        let response = await this.getAnswer(name, args, template, assistantMessages);
        let document = new Document_1.default(name, pathToFile, folderPath, new Date(), sidebarPosition, sidebarLabel);
        document.documentation = response.answer;
        document.requestMessages = response.requestMessages;
        document.documentation_type = ConfigHelper_1.default.DocumentationType;
        document.generator = this.generator;
        document.saveToPath = (saveToPath) ? saveToPath : path_1.default.dirname(pathToFile);
        document.data = data;
        return document;
    }
    /*
        This is where the magic happens. Retrieve the question from liquid file, input the args, ask GPT, create the document and store it in cache
    */
    async generateDocumentationAndCache({ args = {}, template = 'gpt_question', name, pathToFile, folderPath, sidebarPosition, sidebarLabel, saveToPath, assistantMessages, data, prevDocument }) {
        let document = await this.generateDocumentation({
            args,
            template,
            name,
            pathToFile,
            folderPath,
            sidebarPosition,
            assistantMessages,
            sidebarLabel, saveToPath, data
        });
        DocumentationCache_1.default.set(document);
        let documentGenerator = new DocumentationGenerator_1.default();
        documentGenerator.make(document);
    }
    hasChanged(document) {
        if (!document)
            return true;
        let project_path = process.cwd();
        let filePath = path_1.default.join(project_path, document.path);
        if (!fs_1.default.existsSync(filePath)) {
            DocumentationCache_1.default.remove(document);
            return false;
        }
        if (document.documentation_type && document.documentation_type != ConfigHelper_1.default.DocumentationType)
            return true;
        let stats = fs_1.default.statSync(filePath);
        return (stats.mtime.getTime() >= new Date(document.updated.toString()).getTime());
    }
}
exports.default = BaseBuilder;
//# sourceMappingURL=BaseBuilder.js.map
