"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const path_1 = __importDefault(require("path"));
const BaseBuilder_1 = __importDefault(require("../BaseBuilder"));
const DocumentationCache_1 = __importDefault(require("../../../DocumentationCache"));
const FileStructure_1 = __importDefault(require("../../../../utils/FileStructure"));
const ConfigHelper_1 = __importDefault(require("../../../../config/ConfigHelper"));
class BehaviourBuilder extends BaseBuilder_1.default {
    constructor() {
        super('Behaviour');
    }
    async generate() {
        let document = DocumentationCache_1.default.get('Behaviour');
        if (document)
            return;
        let project_path = process.cwd();
        let entry_file = ConfigHelper_1.default.config.entry_file;
        const entryFile = FileStructure_1.default.getContent(path_1.default.join(project_path, entry_file));
        if (entryFile == '')
            return;
        let args = { entryFile };
        await super.generateDocumentationAndCache({
            args,
            name: "Behaviour",
            pathToFile: './',
            folderPath: './',
            sidebarPosition: 2,
            sidebarLabel: 'Behaviour'
        });
    }
    async render(document) {
        return document.documentation;
    }
}
exports.default = BehaviourBuilder;
//# sourceMappingURL=BehaviourBuilder.js.map