"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const FileStructure_1 = __importDefault(require("../../../../utils/FileStructure"));
const BaseBuilder_1 = __importDefault(require("../BaseBuilder"));
const ConfigHelper_1 = __importDefault(require("../../../../config/ConfigHelper"));
const GenerateAppConfigFiles_1 = __importDefault(require("./GenerateAppConfigFiles"));
const PrepareSummary_1 = __importDefault(require("./PrepareSummary"));
const GenerateGeneralConfigFiles_1 = __importDefault(require("./GenerateGeneralConfigFiles"));
class ConfigurationBuilder extends BaseBuilder_1.default {
    constructor() {
        super('Configuration');
        this.configFiles = [];
        this.appSpecificConfigFiles = [];
        this.updateSummary = false;
    }
    async generate() {
        if (ConfigHelper_1.default.config.config_files?.length == 0)
            return;
        let prepareSummary = new PrepareSummary_1.default(this);
        await prepareSummary.prepareSummary();
        let generateAppConfigFiles = new GenerateAppConfigFiles_1.default(this);
        await generateAppConfigFiles.generateAppConfigFiles();
        let generateGeneralConfigFiles = new GenerateGeneralConfigFiles_1.default(this);
        await generateGeneralConfigFiles.generateGeneralConfigFiles();
        await this.generateSummary();
    }
    async generateSummary() {
        if (!this.updateSummary) {
            return;
        }
        let data = {
            appSpecificConfigFiles: this.appSpecificConfigFiles,
            configFiles: this.configFiles,
            has_children: true
        };
        let appSpecificConfigContent = '';
        for (let i = 0; i < this.appSpecificConfigFiles.length; i++) {
            appSpecificConfigContent += `--- Start ${this.appSpecificConfigFiles[0]} ---
            ${FileStructure_1.default.getContent(this.appSpecificConfigFiles[0])}
            --- End ${this.appSpecificConfigFiles[0]} ---
            `;
        }
        let args = {
            appSpecificConfigFiles: this.appSpecificConfigFiles.join('\n'),
            appSpecificConfigContent,
            configFiles: this.configFiles.join('\n')
        };
        await super.generateDocumentationAndCache({
            args: args, name: 'Configuration', saveToPath: './Configuration',
            pathToFile: './Configuration', folderPath: './Configuration',
            sidebarPosition: 3, data: data
        });
    }
}
exports.default = ConfigurationBuilder;
//# sourceMappingURL=ConfigurationBuilder.js.map
