"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const DocumentationCache_1 = __importDefault(require("../../../DocumentationCache"));
const FileStructure_1 = __importDefault(require("../../../../utils/FileStructure"));
class GenerateAppConfigFiles {
    constructor(configurationBuilder) {
        this.configurationBuilder = configurationBuilder;
    }
    async generateAppConfigFiles() {
        for (let i = 0; i < this.configurationBuilder.appSpecificConfigFiles.length; i++) {
            let document = DocumentationCache_1.default.get(this.configurationBuilder.appSpecificConfigFiles[i]);
            if (!this.configurationBuilder.hasChanged(document)) {
                continue;
            }
            this.configurationBuilder.updateSummary = true;
            let content = FileStructure_1.default.getContent(this.configurationBuilder.appSpecificConfigFiles[i]);
            if (content == '')
                continue;
            let data = {
                parent: 'Configuration'
            };
            let args = { configFile: content, fileName: this.configurationBuilder.appSpecificConfigFiles[i] };
            await this.configurationBuilder.generateDocumentationAndCache({
                args: args,
                template: 'app_config',
                name: this.configurationBuilder.appSpecificConfigFiles[i],
                pathToFile: './' + this.configurationBuilder.appSpecificConfigFiles[i],
                folderPath: './',
                sidebarPosition: i,
                saveToPath: './Configuration/',
                data: data,
                prevDocument: document
            });
        }
    }
}
exports.default = GenerateAppConfigFiles;
//# sourceMappingURL=GenerateAppConfigFiles.js.map
