"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const DocumentationCache_1 = __importDefault(require("../../../DocumentationCache"));
const FileStructure_1 = __importDefault(require("../../../../utils/FileStructure"));
class GenerateGeneralConfigFiles {
    constructor(configurationBuilder) {
        this.configurationBuilder = configurationBuilder;
    }
    async generateGeneralConfigFiles() {
        for (let i = 0; i < this.configurationBuilder.configFiles.length; i++) {
            let document = DocumentationCache_1.default.get(this.configurationBuilder.configFiles[i]);
            if (!this.configurationBuilder.hasChanged(document)) {
                continue;
            }
            this.configurationBuilder.updateSummary = true;
            let content = FileStructure_1.default.getContent(this.configurationBuilder.configFiles[i]);
            let args = { configFile: content };
            await this.configurationBuilder.generateDocumentationAndCache({
                args: args,
                template: 'general_config',
                name: this.configurationBuilder.configFiles[i], pathToFile: './' + this.configurationBuilder.configFiles[i], folderPath: './', sidebarPosition: i,
                saveToPath: './Configuration/'
            });
        }
    }
}
exports.default = GenerateGeneralConfigFiles;
//# sourceMappingURL=GenerateGeneralConfigFiles.js.map
