"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const DocumentationCache_1 = __importDefault(require("../../../DocumentationCache"));
const ConfigHelper_1 = __importDefault(require("../../../../config/ConfigHelper"));
const FolderStructure_1 = __importDefault(require("../../../../utils/FolderStructure"));
const path_1 = __importDefault(require("path"));
const Helper_1 = __importDefault(require("../../../../utils/Helper"));
class PrepareSummary {
    constructor(configurationBuilder) {
        this.configurationBuilder = configurationBuilder;
    }
    async prepareSummary() {
        let document = DocumentationCache_1.default.get('Configuration');
        if (document) {
            if (document.data && this.appSpecificConfigAndCacheSameSize(document)) {
                if (document.data.appSpecificConfigFiles)
                    this.configurationBuilder.appSpecificConfigFiles = document.data.appSpecificConfigFiles;
                if (document.data.configFiles)
                    this.configurationBuilder.configFiles = document.data.configFiles;
            }
        }
        if (document && !this.haveConfigFilesChanged()) {
            return;
        }
        this.configurationBuilder.updateSummary = true;
        let config = ConfigHelper_1.default.config;
        let appName = config.project_name;
        let listOfFilesAndFolders = '';
        let project_path = process.cwd();
        let files = FolderStructure_1.default.getFiles(project_path, 0);
        let configPath = path_1.default.join(project_path, 'config');
        if (FolderStructure_1.default.exists(configPath)) {
            let configFiles = FolderStructure_1.default.getFiles(configPath, 0);
            configFiles.forEach(configFile => {
                files.push(configFile);
            });
        }
        files.forEach(file => {
            if (file.path.indexOf('/config') != -1) {
                listOfFilesAndFolders += 'config/' + file.name + '\n';
            }
            else {
                listOfFilesAndFolders += file.name + '\n';
            }
        });
        let response = await this.configurationBuilder.getAnswer('Configuration', {
            appName,
            listOfFilesAndFolders
        }, 'what_are_config_files');
        let jsons = Helper_1.default.getJsons(response.answer);
        if (jsons.length > 0) {
            let fileResults = jsons[0];
            this.configurationBuilder.appSpecificConfigFiles = [];
            this.configurationBuilder.configFiles = [];
            fileResults.forEach((file) => {
                if (file.isAppSpecific) {
                    this.configurationBuilder.appSpecificConfigFiles.push(file.path);
                }
                else if (file.isConfig) {
                    this.configurationBuilder.configFiles.push(file.path);
                }
            });
        }
    }
    haveConfigFilesChanged() {
        let needsUpdate = false;
        if (this.configurationBuilder.appSpecificConfigFiles.length != ConfigHelper_1.default.config.config_files.length)
            return true;
        for (let i = 0; i < this.configurationBuilder.appSpecificConfigFiles.length; i++) {
            let configDoc = DocumentationCache_1.default.get(this.configurationBuilder.appSpecificConfigFiles[i]);
            if (this.configurationBuilder.hasChanged(configDoc)) {
                needsUpdate = true;
                i = this.configurationBuilder.appSpecificConfigFiles.length;
            }
        }
        for (let i = 0; !needsUpdate && i < this.configurationBuilder.configFiles.length; i++) {
            let configDoc = DocumentationCache_1.default.get(this.configurationBuilder.configFiles[i]);
            if (this.configurationBuilder.hasChanged(configDoc)) {
                needsUpdate = true;
                i = this.configurationBuilder.configFiles.length;
            }
        }
        return needsUpdate;
    }
    appSpecificConfigAndCacheSameSize(document) {
        if (!document.data)
            return false;
        return (document.data.appSpecificConfigFiles?.length == ConfigHelper_1.default.config.config_files.length);
    }
}
exports.default = PrepareSummary;
//# sourceMappingURL=PrepareSummary.js.map
