"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const FileStructure_1 = __importDefault(require("../../../../utils/FileStructure"));
const BaseBuilder_1 = __importDefault(require("../BaseBuilder"));
const DocumentationCache_1 = __importDefault(require("../../../DocumentationCache"));
const ProjectStructure_1 = __importDefault(require("../../../../utils/ProjectStructure"));
const ConfigHelper_1 = __importDefault(require("../../../../config/ConfigHelper"));
const ignore_1 = __importDefault(require("ignore"));
class FilesBuilder extends BaseBuilder_1.default {
    constructor() {
        super('Files');
    }
    async generate() {
        let structure = new ProjectStructure_1.default();
        let folder = await structure.getStructure();
        await this.queryForFolder(folder);
    }
    async queryForFolder(folder) {
        this.cleanDeletedFilesFromCache(folder);
        let files = folder.files;
        for (let i = 0; i < files.length; i++) {
            let file = files[i];
            if (!this.shouldDocument(file)) {
                continue;
            }
            let document = DocumentationCache_1.default.get(file.path);
            if (document && document.generator != "Files")
                continue;
            if (!this.hasChanged(document)) {
                continue;
            }
            let fileName = file.name;
            let fileContent = FileStructure_1.default.getContent(file.path);
            let assistantMessages = [];
            let regex = /ref:\s*([A-Z0-9a-z\.\/]*)/gm;
            let match;
            while ((match = regex.exec(fileContent)) !== null) {
                let content = FileStructure_1.default.getContent(match[1]);
                let assistantFiles = 'These files might help with documentation.';
                if (content != '') {
                    assistantFiles += `
                    ## ${match[1]} start ##
                    ${content}
                    ## ${match[1]} ends ##`;
                }
                assistantMessages.push(assistantFiles);
            }
            let args = { fileName, fileContent };
            await super.generateDocumentationAndCache({
                args: args,
                name: fileName,
                pathToFile: file.path,
                folderPath: folder.path,
                sidebarPosition: i,
                sidebarLabel: fileName,
                assistantMessages: assistantMessages,
                data: { parent: folder.name },
                prevDocument: document
            });
        }
        for (let i = 0; i < folder.folders.length; i++) {
            await this.queryForFolder(folder.folders[i]);
        }
    }
    cleanDeletedFilesFromCache(folder) {
        let cachedFiles = DocumentationCache_1.default.getByFolderPath(folder.path);
        for (let i = 0; i < cachedFiles.length; i++) {
            if (cachedFiles[i].isFolder && cachedFiles[i].generator != "Files")
                continue;
            let fileExists = false;
            for (let b = 0; b < folder.files.length; b++) {
                if (cachedFiles[i].path == folder.files[b].path) {
                    b = folder.files.length;
                    fileExists = true;
                }
            }
            if (!fileExists) {
                //console.warn(`Remove file ${cachedFiles[i].path} from cache`)
                //DocumentationCache.remove(cachedFiles[i]);
            }
        }
    }
    shouldDocument(file) {
        if (!this.config.include)
            return true;
        const ignore = (0, ignore_1.default)();
        const includePatterns = ConfigHelper_1.default.config.include;
        ignore.add(includePatterns);
        return ignore.ignores(file.path);
    }
}
exports.default = FilesBuilder;
//# sourceMappingURL=FilesBuilder.js.map
