"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const DocumentationCache_1 = __importDefault(require("../../../DocumentationCache"));
const BaseBuilder_1 = __importDefault(require("../Base/../BaseBuilder"));
const ProjectStructure_1 = __importDefault(require("../../../../utils/ProjectStructure"));
const ConfigHelper_1 = __importDefault(require("../../../../config/ConfigHelper"));
class FoldersBuilder extends BaseBuilder_1.default {
    constructor() {
        super('Folders');
    }
    async generate() {
        let structure = new ProjectStructure_1.default();
        let folder = await structure.getStructure();
        await this.queryForFolder(folder, 30);
    }
    async queryForFolder(folder, position) {
        //start on the last folder, so we can later build summary of each folder
        for (let i = 0; i < folder.folders.length; i++) {
            await this.queryForFolder(folder.folders[i], i + 30);
        }
        let folderName = folder.name;
        if (folder.name == '') {
            return;
        }
        let document = DocumentationCache_1.default.get(folder.path);
        if (!document) {
            let fileAndFolderInfo = [];
            folder.files.map(file => {
                fileAndFolderInfo.push({
                    name: file.name,
                    path: file.path,
                    fileOrFolder: 'file',
                    summary: this.getFileSummary(file)
                });
            });
            folder.folders.map((folder) => {
                fileAndFolderInfo.push({
                    name: folder.name,
                    path: folder.path,
                    fileOrFolder: 'folder',
                    summary: this.getFolderSummary(folder)
                });
            });
            let args = {
                folderName,
                repositoryUrl: ConfigHelper_1.default.config.repository_url,
                path: folder.path.replaceAll('\\', '/'),
                fileAndFolderInfo: JSON.stringify(fileAndFolderInfo)
            };
            await super.generateDocumentationAndCache({
                args: args,
                name: "README",
                pathToFile: folder.path,
                folderPath: folder.path,
                saveToPath: folder.path,
                sidebarPosition: position,
                sidebarLabel: folderName,
                data: { has_children: true },
                prevDocument: document
            });
        }
    }
    getFileSummary(file) {
        let cache = DocumentationCache_1.default.get(file.path);
        if (!cache)
            return '';
        const regex = /^# .+[\s\S]*?^## .+/m;
        const match = regex.exec(cache.documentation);
        if (match && match[0]) {
            return match[0].trim();
        }
        if (cache.documentation.length > 350) {
            return cache.documentation.substring(0, 350) + '...';
        }
        return cache.documentation;
    }
    getFolderSummary(folder) {
        let cache = DocumentationCache_1.default.get(folder.path);
        if (!cache)
            return '';
        const regex = /^# .+[\s\S]*?^## .+/m;
        const match = regex.exec(cache.documentation);
        if (match && match[0]) {
            return match[0].trim();
        }
        return '';
    }
}
exports.default = FoldersBuilder;
//# sourceMappingURL=FoldersBuilder.js.map
