"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const FileStructure_1 = __importDefault(require("../../../../utils/FileStructure"));
const BaseBuilder_1 = __importDefault(require("../BaseBuilder"));
const ProjectStructure_1 = __importDefault(require("../../../../utils/ProjectStructure"));
const fs_1 = __importDefault(require("fs"));
const DocumentationCache_1 = __importDefault(require("../../../DocumentationCache"));
const path_1 = __importDefault(require("path"));
class HowToBuilder extends BaseBuilder_1.default {
    constructor() {
        super('HowTo');
    }
    async generate() {
        const regex = /:::\s*howto\s+(.*)/;
        let projectStructure = new ProjectStructure_1.default();
        let files = projectStructure.getAllFiles();
        for (let i = 0; i < files.length; i++) {
            let content = fs_1.default.readFileSync(files[i].path).toString();
            const match = content.match(regex);
            if (match) {
                await this.makeHowTo(files[i], content, match[1]);
            }
        }
    }
    async makeHowTo(fileStructure, content, name) {
        let document = DocumentationCache_1.default.get(path_1.default.join('howto', name));
        if (document)
            return;
        let regex = /ref:\s*([A-Z0-9a-z\.\/]*)/gm;
        let match;
        let assistantMessages = [];
        while ((match = regex.exec(content)) !== null) {
            let content = FileStructure_1.default.getContent(match[1]);
            let assistantFiles = `This is the ref document. ${match[1]}`;
            if (content != '') {
                assistantFiles += `
                    ## ${match[1]} start ##
                    ${content}
                    ## ${match[1]} ends ##`;
            }
            assistantMessages.push(assistantFiles);
        }
        await super.generateDocumentationAndCache({
            args: { fileContent: content },
            name: name,
            pathToFile: `howto/${name}`,
            folderPath: `howto`,
            saveToPath: `howto/`,
            assistantMessages: assistantMessages,
            prevDocument: document
        });
    }
}
exports.default = HowToBuilder;
//# sourceMappingURL=HowToBuilder.js.map
