"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const path_1 = __importDefault(require("path"));
const BaseBuilder_1 = __importDefault(require("../BaseBuilder"));
const DocumentationCache_1 = __importDefault(require("../../../DocumentationCache"));
const FileStructure_1 = __importDefault(require("../../../../utils/FileStructure"));
const ConfigHelper_1 = __importDefault(require("../../../../config/ConfigHelper"));
class PrerequisitesBuilder extends BaseBuilder_1.default {
    constructor() {
        super('Prerequisites');
    }
    async generate() {
        let document = DocumentationCache_1.default.get('Prerequisites');
        if (document)
            return;
        let project_path = process.cwd();
        let config = ConfigHelper_1.default.config;
        const projectFile = FileStructure_1.default.getContent(path_1.default.join(project_path, config.project_file));
        let args = { projectName: config.project_name, projectFile };
        await super.generateDocumentationAndCache({
            args,
            name: "Prerequisites",
            pathToFile: './',
            folderPath: './',
            sidebarPosition: 4,
        });
    }
    async render(document) {
        return document.documentation;
    }
}
exports.default = PrerequisitesBuilder;
//# sourceMappingURL=PrerequisitesBuilder.js.map