"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const path_1 = __importDefault(require("path"));
const BaseBuilder_1 = __importDefault(require("../BaseBuilder"));
const DocumentationCache_1 = __importDefault(require("../../../DocumentationCache"));
const FileStructure_1 = __importDefault(require("../../../../utils/FileStructure"));
const ConfigHelper_1 = __importDefault(require("../../../../config/ConfigHelper"));
class ReadMeBuilder extends BaseBuilder_1.default {
    constructor() {
        super('ReadMe');
    }
    async generate() {
        let document = DocumentationCache_1.default.get('ReadMe');
        if (document) {
            return;
        }
        let projectPath = process.cwd();
        let config = ConfigHelper_1.default.config;
        let projectFilePath = config.project_file;
        const projectFile = FileStructure_1.default.getContent(path_1.default.join(projectPath, projectFilePath));
        const projectName = ConfigHelper_1.default.config.project_name;
        let configFile = '';
        if (config.config_files.length > 0) {
            configFile = FileStructure_1.default.getContent((path_1.default.join(projectPath), config.config_files[0]));
        }
        let entryFile = config.entry_file;
        const entryFileContent = FileStructure_1.default.getContent((path_1.default.join(projectPath), entryFile));
        let args = { projectName, projectFile, entryFileContent, configFile, repositoryUrl: config.repository_url };
        await super.generateDocumentationAndCache({
            args: args,
            name: 'ReadMe',
            pathToFile: './',
            folderPath: './',
            sidebarPosition: 1,
            sidebarLabel: 'Read Me'
        });
    }
    async render(document) {
        return document.documentation;
    }
}
exports.default = ReadMeBuilder;
//# sourceMappingURL=ReadMeBuilder.js.map