"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const path_1 = __importDefault(require("path"));
const BaseBuilder_1 = __importDefault(require("../BaseBuilder"));
const DocumentationCache_1 = __importDefault(require("../../../DocumentationCache"));
const FileStructure_1 = __importDefault(require("../../../../utils/FileStructure"));
const ConfigHelper_1 = __importDefault(require("../../../../config/ConfigHelper"));
class UsageBuilder extends BaseBuilder_1.default {
    constructor() {
        super('Usage');
    }
    async generate() {
        let document = DocumentationCache_1.default.get('Usage');
        if (document)
            return;
        let project_path = process.cwd();
        let config = ConfigHelper_1.default.config;
        const projectFile = FileStructure_1.default.getContent(path_1.default.join(project_path, config.project_file));
        const cliFile = FileStructure_1.default.getContent(path_1.default.join(project_path, config.cli_file ?? config.entry_file));
        let configFile = '';
        if (config.config_files.length > 0) {
            configFile = FileStructure_1.default.getContent(path_1.default.join(project_path, config.config_files[0]));
        }
        let args = { projectName: config.project_name, projectFile, cliFile, configFile };
        await super.generateDocumentationAndCache({
            args,
            name: "Usage",
            pathToFile: './',
            folderPath: './',
            sidebarPosition: 5,
            sidebarLabel: 'Usage'
        });
    }
    async render(document) {
        return document.documentation;
    }
}
exports.default = UsageBuilder;
//# sourceMappingURL=UsageBuilder.js.map