"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const path_1 = __importDefault(require("path"));
const BaseBuilder_1 = __importDefault(require("../BaseBuilder"));
const DocumentationCache_1 = __importDefault(require("../../../DocumentationCache"));
const ConfigHelper_1 = __importDefault(require("../../../../config/ConfigHelper"));
const fs_1 = __importDefault(require("fs"));
const UserDefinedBuilderHelper_1 = __importDefault(require("./UserDefinedBuilderHelper"));
class UserDefinedBuilder extends BaseBuilder_1.default {
    constructor() {
        super('UserDefined');
    }
    extractPathFromContent(input) {
        if (!input)
            return null;
        const regex = /content\(([^)]+)\)/;
        const match = input.match(regex);
        return match ? match[1] : null;
    }
    async generate() {
        for (let i = 0; this.config.builders && i < this.config.builders.length; i++) {
            let builder = this.config.builders[i];
            let saveToPath = builder.path ?? '';
            if (saveToPath == '' && builder.type == 'howto') {
                saveToPath = 'howto';
            }
            for (let b = 0; builder.pages && b < builder.pages.length; b++) {
                await this.generateFromBuilder(builder.pages[b], saveToPath, (b + 2), { parent: builder.name });
            }
            await this.generateFromBuilder(builder, saveToPath, 1, { has_children: true });
        }
    }
    async generateFromBuilder(builder, saveToPath, position, data) {
        let project_path = process.cwd();
        let templatePath = builder.template;
        templatePath = `.code-narrator/gpt_questions/${templatePath}`;
        if (!fs_1.default.existsSync(path_1.default.join(process.cwd(), `${templatePath}.liquid`))) {
            console.log(path_1.default.join(process.cwd(), templatePath));
            throw new Error(`Could not find ${builder.template}.liquid template. You can create it at ${templatePath}.liquid`);
        }
        let docId = path_1.default.join(saveToPath, builder.template);
        let document = DocumentationCache_1.default.get(docId);
        if (!document) {
            docId = docId + ConfigHelper_1.default.config.document_file_extension;
            document = DocumentationCache_1.default.get(docId);
        }
        if (!this.hasTemplateChanged(document, builder, templatePath))
            return;
        let helper = new UserDefinedBuilderHelper_1.default();
        helper.loadArgs(builder, project_path);
        let assistantMessages = await helper.getAssistantMessages(builder);
        await super.generateDocumentationAndCache({
            args: builder.args ?? {},
            name: builder.name,
            template: templatePath,
            pathToFile: path_1.default.join(saveToPath, builder.template + ConfigHelper_1.default.config.document_file_extension),
            folderPath: saveToPath,
            saveToPath: saveToPath,
            sidebarPosition: builder.sidebarPosition ?? (position + 10),
            sidebarLabel: builder.sidebarLabel ?? builder.name,
            assistantMessages: assistantMessages,
            data: data,
            prevDocument: document
        });
    }
    hasTemplateChanged(document, builder, templatePath) {
        if (!document)
            return true;
        let filePaths = this.getAffectedFilePaths(builder) ?? [];
        filePaths.push(templatePath + '.liquid');
        for (let i = 0; i < filePaths.length; i++) {
            let stats = fs_1.default.statSync(templatePath + '.liquid');
            if (stats.mtime.getTime() >= new Date(document.updated.toString()).getTime())
                return true;
        }
        return false;
    }
    getAffectedFilePaths(builder) {
        let filePaths = [];
        if (builder.args) {
            let argKeys = Object.getOwnPropertyNames(builder.args);
            for (let i = 0; i < argKeys.length; i++) {
                filePaths.push(this.extractPathFromContent(builder.args[argKeys[i]]));
            }
        }
        for (let i = 0; builder.files && i < builder.files.length; i++) {
            filePaths.push(path_1.default.join(process.cwd(), builder.files[i].path));
        }
        return filePaths;
    }
}
exports.default = UserDefinedBuilder;
//# sourceMappingURL=UserDefinedBuilder.js.map
