"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const FileStructure_1 = __importDefault(require("../../../../utils/FileStructure"));
const path_1 = __importDefault(require("path"));
const jsonpath_1 = __importDefault(require("jsonpath"));
const ConfigHelper_1 = __importDefault(require("../../../../config/ConfigHelper"));
const Helper_1 = __importDefault(require("../../../../utils/Helper"));
const DocumentationCache_1 = __importDefault(require("../../../DocumentationCache"));
class UserDefinedBuilderHelper {
    constructor() {
        this.aiService = ConfigHelper_1.default.config.aiService;
    }
    extractPathFromContent(input) {
        if (!input)
            return null;
        const regex = /content\(([^)]+)\)/;
        const match = input.match(regex);
        return match ? match[1] : null;
    }
    loadArgs(build, project_path) {
        if (build.args) {
            let argKeys = Object.getOwnPropertyNames(build.args);
            for (let i = 0; i < argKeys.length; i++) {
                let filePath = this.extractPathFromContent(build.args[argKeys[i]]);
                if (filePath) {
                    let content = FileStructure_1.default.getContent(path_1.default.join(project_path, filePath));
                    if (content == '') {
                        console.warn(`Content is empty for file ${filePath}`);
                    }
                    build.args[argKeys[i]] = content;
                }
            }
        }
    }
    async getAssistantMessages(builder) {
        let assistantMessages = [];
        let predefinedQuestions = this.getPredefinedQuestion(builder.type);
        if (predefinedQuestions)
            assistantMessages.push(predefinedQuestions);
        let files = builder.files ?? [];
        for (let i = 0; i < files.length; i++) {
            let content = FileStructure_1.default.getContent(path_1.default.join(process.cwd(), files[i].path));
            let extraInfo = '';
            if (files[i].path.indexOf('.json') != -1) {
                if (files[i].JSONPath) {
                    let obj = JSON.parse(content);
                    files[i].JSONPath?.forEach((path) => {
                        jsonpath_1.default.query(obj, path).forEach((result) => {
                            extraInfo += `${path}:${JSON.stringify(result)}\n`;
                        });
                    });
                }
                else {
                    extraInfo += `\n### start ${path_1.default.basename(files[i].path)} ###\n${content}\n### end file ###\n`;
                }
            }
            else if (files[i].extract) {
                let extractContent = Array.isArray(files[i].extract) ? files[i].extract.join(', ') : files[i].extract;
                let question = `Extract following from file content. You MUST return as JSON:
                     ${extractContent} 
                     This is the file:
                     ${content}`;
                let result = await this.aiService.query([question], ['Return JSON format']);
                let jsons = Helper_1.default.getJsons(result.answer);
                if (jsons.length > 0) {
                    extraInfo += `Content to help:\n`;
                    for (let b = 0; b < jsons.length; b++) {
                        extraInfo += `${JSON.stringify(jsons[b])}\n`;
                    }
                }
            }
            else if (files[i].path.indexOf(ConfigHelper_1.default.config.document_file_extension) != -1) {
                builder.args = builder.args ?? {};
                builder.args.directoryName = path_1.default.dirname(files[i].path);
                if (files[i].path.indexOf('*') != -1) {
                    let dirFiles = this.findFiles(files[i].path);
                    dirFiles.forEach(file => {
                        if (file.name.toLowerCase() != 'readme') {
                            let overview = this.extractContentBetweenHeaders(file.documentation);
                            extraInfo += `
### 1st paragraph of "${file.name}" ###
${overview}
### file ends ###
                         `;
                        }
                    });
                }
                else {
                    let overview = this.extractContentBetweenHeaders(content);
                    extraInfo = `### 1st paragraph of "${files[i].path}" ### \n${overview}\n### file ends ###`;
                }
            }
            else {
                extraInfo = `File Content for ${files[i].path}\n${content}`;
            }
            if (extraInfo) {
                assistantMessages.push(extraInfo);
            }
        }
        return assistantMessages;
    }
    getPredefinedQuestion(type) {
        type = type.toLowerCase();
        if (type == 'howto') {
            return `I want you to create a detailed How To guide from the user input.
            It should have Title, Introduction, Step-by-Step Instructions`;
        }
        else if (type == 'readme') {
            return `I want you to create a detailed README file for the project ${ConfigHelper_1.default.config.project_name}. 
            Include the sections Title, Description with link to homepage (add paragraphs), Getting started, Usage, Repository link, Documentation, Report Issues, Authors, Version, License. If you do not have data for section then DO NOT create that section.`;
        }
        else if (type == 'tutorial') {
            return `I want you to create a detailed Tutorial from the user input.
            Define the target audience, Set clear learning objectives,Provide a brief introduction,Prerequisites and system requirements,Step-by-step instructions,Include code samples`;
        }
        else if (type == 'faq') {
            return 'Write a FAQ document from users answers. Do not create questions you cannot answer. DO NOT hallucinate answers.';
        }
    }
    extractContentBetweenHeaders(markdown) {
        let regex = new RegExp(/^(?!#).*$/gm);
        let match = markdown.match(regex);
        for (let i = 0; match && i < match.length; i++) {
            if (match[i].trim() != '')
                return match[i];
        }
        if (markdown.length < 350)
            return markdown;
        return markdown.substring(0, 350) + "...";
    }
    findFiles(patternString) {
        const dir = patternString.split('/')[0];
        return DocumentationCache_1.default.getByFolderPath(dir);
    }
}
exports.default = UserDefinedBuilderHelper;
//# sourceMappingURL=UserDefinedBuilderHelper.js.map
