"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const BaseGenerator_1 = __importDefault(require("./BaseGenerator"));
class DocusaurusGenerator extends BaseGenerator_1.default {
    process(document) {
        //docusaurus does not like to have Promise<> in its headers, so let's remove them
        document.documentation = document.documentation
            .replaceAll(/: Promise<[a-zA-Z]*>/gm, '')
            .replaceAll(/: Partial<[a-zA-Z]*>/gm, '')
            .trim();
        let sidebar_label = (document.sidebar_label) ? document.sidebar_label : document.name;
        let position = document.sidebar_position ?? 1;
        document.documentation = `---
sidebar_position: ${position}
sidebar_label: ${sidebar_label}
---

` + document.documentation;
        return document;
    }
}
exports.default = DocusaurusGenerator;
//# sourceMappingURL=DocusaurusGenerator.js.map
