"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const BaseGenerator_1 = __importDefault(require("./BaseGenerator"));
const ConfigHelper_1 = __importDefault(require("../../../config/ConfigHelper"));
const DocumentationCache_1 = __importDefault(require("../../DocumentationCache"));
class JekyllGenerator extends BaseGenerator_1.default {
    process(document) {
        let sidebar_label = (document.sidebar_label) ? document.sidebar_label : document.name;
        let position = document.sidebar_position ?? 1;
        let parent = '';
        let has_children = '';
        if (document.name != 'README') {
            let parentName = (document.data && document.data.parent) ? document.data.parent : '';
            if (parentName == '') {
                let folderDocument = DocumentationCache_1.default.getFolderByFolderPath(document.folderPath);
                if (folderDocument) {
                    parentName = folderDocument.path;
                }
            }
            if (parentName != '') {
                parent = `parent: ${parentName}`;
            }
        }
        else if (document.name == 'README' && document.folderPath != '') {
            has_children = 'has_children: true';
        }
        if (document.data && document.data.has_children) {
            has_children = 'has_children: true';
        }
        let permalink = '';
        if (document.isFolder && document.folderPath != '') {
            let fileName = `${ConfigHelper_1.default.config.folderRootFileName}${ConfigHelper_1.default.config.document_file_extension}`;
            permalink = `permalink: ${document.folderPath.replaceAll('\\', '/')}/${fileName}`;
        }
        else if (!document.isFolder && document.folderPath != '') {
            permalink = `permalink: ${document.path.replaceAll('\\', '/')}${ConfigHelper_1.default.config.document_file_extension}`;
        }
        document.documentation = `---
nav_order: ${position}
title: ${sidebar_label}
${parent}
${has_children}
${permalink}
---

` + document.documentation;
        return document;
    }
}
exports.default = JekyllGenerator;
//# sourceMappingURL=JekyllGenerator.js.map
