"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const yargs_1 = __importDefault(require("yargs"));
const fs_1 = __importDefault(require("fs"));
const path_1 = __importDefault(require("path"));
const process_1 = __importDefault(require("process"));
class CliHelper {
    async getArgv() {
        return yargs_1.default
            .option('c', {
            type: 'string',
            describe: 'Path to configuration file (JSON or JavaScript)',
            alias: 'config',
            demandOption: false,
        })
            .option('i', {
            type: 'array',
            description: 'Only include specific files or folders in the documentation process',
            alias: 'include'
        }).option('g', {
            type: 'string',
            description: `GPT model. Default is gpt-4, if you do not have access, next best is gpt-3.5-turbo, but it isn't not so good`,
            alias: 'gpt'
        }).option('u', {
            type: 'string',
            description: 'Runs only update on userDefined builder from config matching template name',
            alias: 'userDefined'
        })
            .help()
            .alias('help', 'h').argv;
    }
    async getConfig(argv) {
        var _a;
        let configPath = argv.config;
        let userConfig = {};
        if (fs_1.default.existsSync(path_1.default.join(process_1.default.cwd(), 'code-narrator.config.ts'))) {
            configPath = path_1.default.join(process_1.default.cwd(), 'code-narrator.config.ts');
        }
        else if (fs_1.default.existsSync(path_1.default.join(process_1.default.cwd(), 'code-narrator.config.js'))) {
            configPath = path_1.default.join(process_1.default.cwd(), 'code-narrator.config.js');
        }
        else if (fs_1.default.existsSync(path_1.default.join(process_1.default.cwd(), 'code-narrator.json'))) {
            configPath = path_1.default.join(process_1.default.cwd(), 'code-narrator.json');
        }
        if (configPath) {
            if (configPath.endsWith('.js') || configPath.endsWith('.ts')) {
                userConfig = await (_a = configPath, Promise.resolve().then(() => __importStar(require(_a))));
            }
            else if (configPath.endsWith('.json')) {
                userConfig = JSON.parse((await fs_1.default.readFileSync(configPath)).toString());
            }
            userConfig.fromFile = true;
        }
        if (argv.include) {
            userConfig.include = argv.include;
        }
        if (argv.gpt) {
            userConfig.gptModel = argv.gpt;
        }
        if (argv.userDefined) {
            userConfig.userDefined = argv.userDefined;
        }
        return userConfig;
    }
}
exports.default = CliHelper;
//# sourceMappingURL=CliHelper.js.map
