"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const dotnet = __importStar(require("dotenv"));
const fs_1 = __importDefault(require("fs"));
const path_1 = __importDefault(require("path"));
const App_1 = __importDefault(require("../App"));
class ConfigHelper {
    static async load(config, project = App_1.default.Project) {
        dotnet.config();
        ConfigHelper.env = process.env;
        if (!ConfigHelper.env['OPENAI_API_KEY']) {
            console.error('Missing OPENAI_API_KEY in .env file. Make sure to create .env file in your root and include OPENAI_API_KEY=Your_OpenAI_Key');
            throw new Error('Missing OpenAI API key');
        }
        ConfigHelper.cn = project;
        ConfigHelper.BuilderPlugins = config.builderPlugins;
        ConfigHelper.DocumentExtension = config.document_file_extension ?? '.md';
        ConfigHelper.DocumentationType = config.documentation_type ?? 'md';
        if (ConfigHelper.DocumentExtension.indexOf('.') != 0)
            ConfigHelper.DocumentExtension = '.' + ConfigHelper.DocumentExtension;
        ConfigHelper.CacheFilePath = config.cache_file ?? '.code-narrator/cache.json';
        let projectFile = ConfigHelper.get('project_file');
        const projectFileRaw = fs_1.default.readFileSync(path_1.default.join(process.cwd(), projectFile));
        ConfigHelper.projectFile = JSON.parse(projectFileRaw.toString());
        if (ConfigHelper.projectFile['repository']) {
            App_1.default.repositoryUrl = ConfigHelper.projectFile['repository']['url'];
        }
    }
    static get(key) {
        let value = ConfigHelper.env[key];
        if (value)
            return value;
        value = ConfigHelper.cn[key] ?? '';
        if (value)
            return value;
        return ConfigHelper.projectFile[key] ?? '';
    }
}
exports.default = ConfigHelper;
ConfigHelper.BuilderPlugins = [];
ConfigHelper.DocumentationType = 'md';
ConfigHelper.DocumentExtension = '.md';
ConfigHelper.CacheFilePath = '.code-narrator/cache.json';
//# sourceMappingURL=ConfigHelper.js.map