"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const path_1 = __importStar(require("path"));
const fs_1 = __importDefault(require("fs"));
class FileStructure {
    constructor(dir, entry, depth) {
        this.name = '';
        this.path = '';
        this.name = entry.name;
        let project_path = process.cwd();
        this.path = path_1.default.relative(project_path, (0, path_1.resolve)(dir, entry.name));
        this.entry = entry;
        this.depth = depth;
    }
    static getContent(path) {
        if (path.indexOf(',') != -1) {
            let from = 0;
            let to = 999999;
            let lineNumbers = path.split(',')[1].trim();
            if (lineNumbers.indexOf('-') != -1) {
                from = parseInt(lineNumbers.split('-')[0].trim());
                to = parseInt(lineNumbers.split('-')[1].trim());
            }
            else {
                from = parseInt(lineNumbers);
            }
            path = path.split(',')[0];
            if (!fs_1.default.existsSync(path)) {
                console.warn(`path:${path} not found, returning empty string`);
                return '';
            }
            return this.readFileFromLine(path, from, to);
        }
        if (!fs_1.default.existsSync(path)) {
            console.warn(`path:${path} not found, returning empty string`);
            return '';
        }
        let stat = fs_1.default.statSync(path);
        if (stat.isDirectory())
            return '';
        return fs_1.default.readFileSync(path).toString();
    }
    static readFileFromLine(filename, startLine, endLine) {
        const content = fs_1.default.readFileSync(filename, 'utf-8');
        const lines = content.split('\n');
        if (endLine > lines.length)
            endLine = lines.length;
        return lines.slice(startLine - 1, endLine).join('\n');
    }
}
exports.default = FileStructure;
//# sourceMappingURL=FileStructure.js.map
