"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const fs_1 = __importStar(require("fs"));
const FileStructure_1 = __importDefault(require("./FileStructure"));
const path_1 = __importStar(require("path"));
const ConfigHelper_1 = __importDefault(require("../config/ConfigHelper"));
const fg = __importStar(require("fast-glob"));
class FolderStructure {
    constructor(folderPath, depth = 0) {
        this.name = '';
        this.path = '';
        let project_path = process.cwd();
        this.path = path_1.default.relative(project_path, folderPath);
        this.name = path_1.default.basename(this.path);
        this.files = this.getFiles(folderPath, depth);
        this.folders = this.getStructure(folderPath, ++depth);
        this.depth = depth;
    }
    getHierarchicalTree() {
        let str = ' '.repeat(this.depth) + '+' + this.path + '\n';
        for (let i = 0; i < this.folders.length; i++) {
            str += this.folders[i].getHierarchicalTree() + '\n';
        }
        for (let i = 0; i < this.files.length; i++) {
            str += ' '.repeat(this.depth) + '-' + this.files[i].name + '\n';
        }
        return str;
    }
    static getFiles(dir, depth) {
        const entries = (0, fs_1.readdirSync)(dir, { withFileTypes: true });
        let files = [];
        for (const entry of entries) {
            if (!entry.isDirectory() && FolderStructure.shouldDocument(path_1.default.join(dir, entry.name), entry.isDirectory())) {
                files.push(new FileStructure_1.default(dir, entry, depth));
            }
        }
        return files;
    }
    static exists(dir) {
        return (0, fs_1.existsSync)(dir);
    }
    getFiles(dir, depth) {
        return FolderStructure.getFiles(dir, depth);
    }
    getStructure(folderPath, depth) {
        let folders = [];
        const entries = (0, fs_1.readdirSync)(folderPath, { withFileTypes: true });
        for (const entry of entries) {
            const res = (0, path_1.resolve)(folderPath, entry.name);
            if (entry.isDirectory() && FolderStructure.shouldDocument(path_1.default.join(folderPath, entry.name), entry.isDirectory())) {
                folders.push(new FolderStructure(res, depth));
            }
        }
        return folders;
    }
    static shouldDocument(fileOrFolderPath, isDirectory) {
        let include = ConfigHelper_1.default.config.include ?? ['*/**'];
        // Concatenate exclude patterns with a '!' prefix to indicate exclusion
        const patterns = [
            ...include,
            ...ConfigHelper_1.default.config.exclude.map((pattern) => `!${pattern}`)
        ];
        // If the path is absolute, make it relative to the current working directory
        const relativePath = path_1.default.isAbsolute(fileOrFolderPath)
            ? path_1.default.relative(process.cwd(), fileOrFolderPath)
            : fileOrFolderPath;
        // Find all matching paths for the patterns
        const allMatches = fg.sync(patterns, { onlyFiles: false });
        // Filter the matches to only include paths that match the input fileOrFolderPath
        const matches = allMatches.filter((match) => {
            if (isDirectory) {
                return path_1.default.dirname(match) === relativePath.replaceAll('\\', '/');
            }
            return path_1.default.normalize(match) === path_1.default.normalize(relativePath);
        });
        let isIncluded = matches.length > 0;
        return isIncluded;
    }
    static isAncestorOrParentPath(parentPath, childPath) {
        const relativePath = path_1.default.relative(parentPath, childPath);
        return (relativePath &&
            !relativePath.startsWith('..') &&
            !path_1.default.isAbsolute(relativePath));
    }
    static searchForStringInFiles(root, search) {
        const files = fs_1.default.readdirSync(root);
        for (const file of files) {
            const fullPath = path_1.default.join(root, file);
            const stats = fs_1.default.statSync(fullPath);
            if (stats.isDirectory()) {
                return FolderStructure.searchForStringInFiles(fullPath, search);
            }
            else {
                if (path_1.default.extname(fullPath) === '.ts' || path_1.default.extname(fullPath) === '.js') {
                    const content = fs_1.default.readFileSync(fullPath, 'utf-8');
                    if (content.includes(search)) {
                        console.log(`${fullPath} contains the search string '${search}'`);
                        return content;
                    }
                }
            }
        }
        return '';
    }
    static getFoldersAndFiles(path) {
        return fs_1.default.readdirSync(path);
    }
}
exports.default = FolderStructure;
//# sourceMappingURL=FolderStructure.js.map
